/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.testcontainers.spring.mssql;

import com.infobip.testcontainers.InitializerBase;
import com.infobip.testcontainers.spring.mssql.DatabaseCreator;
import com.infobip.testcontainers.spring.mssql.MSSQLServerContainerWrapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.MSSQLServerContainer;
import org.testcontainers.lifecycle.Startable;

public class MSSQLServerContainerInitializer
extends InitializerBase<MSSQLServerContainerWrapper> {
    private static final List<String> DEFAULT_PROPERTY_NAMES = Arrays.asList("spring.datasource.url", "spring.flyway.url", "spring.r2dbc.url");

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        List<String> urlPropertyNames = this.getUrlPropertyNames((Environment)environment);
        Map<String, String> urlPropertyNameToValue = this.getUrlPropertyNameToValue((Environment)environment, urlPropertyNames);
        MSSQLServerContainerWrapper wrapper = Optional.ofNullable(environment.getProperty("testcontainers.mssql.docker.image")).map(MSSQLServerContainerWrapper::new).orElseGet(MSSQLServerContainerWrapper::new);
        MSSQLServerContainerWrapper container = (MSSQLServerContainerWrapper)this.handleReusable((GenericContainer)wrapper);
        Optional<MSSQLServerContainerWrapper> initScript = Optional.ofNullable(environment.getProperty("testcontainers.mssql.init-script")).map(arg_0 -> ((MSSQLServerContainerWrapper)container).withInitScript(arg_0));
        this.resolveStaticPort(urlPropertyNameToValue.values(), GENERIC_URL_WITH_PORT_GROUP_PATTERN).ifPresent(staticPort -> this.bindPort((Container)container, (Integer)staticPort, MSSQLServerContainer.MS_SQL_SERVER_PORT));
        this.start((Startable)container);
        Map<String, String> replacedNameToValue = this.replaceHostAndPort(urlPropertyNameToValue, container);
        Map<String, String> testPropertyValues = this.addMissingUsernameAndPassword(replacedNameToValue, container);
        TestPropertyValues values = TestPropertyValues.of(testPropertyValues);
        values.applyTo(applicationContext);
        if (initScript.isEmpty()) {
            String url = replacedNameToValue.getOrDefault("spring.datasource.url", replacedNameToValue.get("spring.flyway.url"));
            DatabaseCreator creator = new DatabaseCreator(url, container.getUsername(), container.getPassword());
            creator.createDatabaseIfItDoesNotExist();
        }
        this.registerContainerAsBean(applicationContext);
    }

    private List<String> getUrlPropertyNames(Environment environment) {
        String name = environment.getProperty("testcontainers.mssql.datasource.url.property.name");
        if (Objects.nonNull(name)) {
            return Collections.singletonList(name);
        }
        String[] names = (String[])environment.getProperty("testcontainers.mssql.datasource.url.property.names", String[].class);
        if (Objects.nonNull(names)) {
            return Arrays.asList(names);
        }
        return DEFAULT_PROPERTY_NAMES;
    }

    private Map<String, String> getUrlPropertyNameToValue(Environment environment, List<String> names) {
        HashMap<String, String> propertyNameToValue = new HashMap<String, String>();
        for (String name : names) {
            String value = environment.getProperty(name);
            if (!Objects.nonNull(value)) continue;
            propertyNameToValue.put(name, value);
        }
        return propertyNameToValue;
    }

    private Map<String, String> replaceHostAndPort(Map<String, String> urlPropertyNameToValue, MSSQLServerContainerWrapper container) {
        return urlPropertyNameToValue.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.replaceHostAndPortPlaceholders((String)entry.getValue(), (Container)container, MSSQLServerContainer.MS_SQL_SERVER_PORT)));
    }

    private Map<String, String> addMissingUsernameAndPassword(Map<String, String> urlPropertyNameToValue, MSSQLServerContainerWrapper container) {
        String username = container.getUsername();
        String password = container.getPassword();
        HashMap<String, String> testPropertyValues = new HashMap<String, String>(urlPropertyNameToValue);
        for (Map.Entry<String, String> entry : urlPropertyNameToValue.entrySet()) {
            String name = entry.getKey();
            if (!DEFAULT_PROPERTY_NAMES.contains(name)) continue;
            String root = name.substring(0, name.indexOf(".url"));
            testPropertyValues.put(root + ".username", username);
            testPropertyValues.put(root + ".password", password);
        }
        return testPropertyValues;
    }
}

