/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.spring.data.jdbc.annotation.processor;

import com.google.common.base.CaseFormat;
import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.SerializerConfig;
import com.querydsl.codegen.TypeMappings;
import com.querydsl.codegen.utils.CodeWriter;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.codegen.MetaDataSerializer;
import com.querydsl.sql.codegen.NamingStrategy;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.inject.Inject;
import javax.inject.Named;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.springframework.data.relational.core.mapping.Column;

public class CustomMetaDataSerializer
extends MetaDataSerializer {
    private final ProcessingEnvironment processingEnvironment;
    private final CaseFormat columnCaseFormat;

    @Inject
    public CustomMetaDataSerializer(TypeMappings typeMappings, NamingStrategy namingStrategy, ProcessingEnvironment processingEnvironment, CaseFormat columnCaseFormat, @Named(value="innerClassesForKeys") boolean innerClassesForKeys, @Named(value="imports") Set<String> imports, @Named(value="columnComparator") Comparator<Property> columnComparator, @Named(value="entityPathType") Class<?> entityPathType, @Named(value="generatedAnnotationClass") Class<? extends Annotation> generatedAnnotationClass) {
        super(typeMappings, namingStrategy, innerClassesForKeys, imports, columnComparator, entityPathType, generatedAnnotationClass);
        this.processingEnvironment = processingEnvironment;
        this.columnCaseFormat = columnCaseFormat;
    }

    protected void serializeProperties(EntityType model, SerializerConfig config, CodeWriter writer) throws IOException {
        CustomPropertiesEntityType newModel = this.withFieldOrderedProperties(model);
        super.serializeProperties((EntityType)newModel, config, writer);
    }

    protected void outro(EntityType model, CodeWriter writer) throws IOException {
        CustomPropertiesEntityType newModel = this.withFieldOrderedProperties(model);
        super.outro((EntityType)newModel, writer);
    }

    public CustomPropertiesEntityType withFieldOrderedProperties(EntityType entityType) {
        Set properties = entityType.getProperties();
        Map propertyNameToProperty = properties.stream().collect(Collectors.toMap(Property::getName, Function.identity()));
        TypeElement typeElement = this.processingEnvironment.getElementUtils().getTypeElement(entityType.getFullName());
        LinkedHashSet orderedProperties = ElementFilter.fieldsIn(new ArrayList<Element>(typeElement.getEnclosedElements())).stream().map(field -> (Property)propertyNameToProperty.get(field.getSimpleName().toString())).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        properties.stream().filter(property -> !orderedProperties.contains(property)).forEach(orderedProperties::add);
        this.addMetaData(orderedProperties);
        return new CustomPropertiesEntityType(entityType, orderedProperties);
    }

    private void addMetaData(LinkedHashSet<Property> orderedProperties) {
        ArrayList<Property> orderedPropertiesList = new ArrayList<Property>(orderedProperties);
        for (int i = 0; i < orderedPropertiesList.size(); ++i) {
            Property property = (Property)orderedPropertiesList.get(i);
            property.getData().put("COLUMN", ColumnMetadata.named((String)this.getColumnName(property)).withIndex(i));
        }
    }

    protected String getColumnName(Property property) {
        TypeElement parentType = this.processingEnvironment.getElementUtils().getTypeElement(property.getDeclaringType().getFullName());
        return parentType.getEnclosedElements().stream().filter(element -> element instanceof VariableElement).map(element -> (VariableElement)element).filter(element -> element.getSimpleName().toString().equals(property.getName())).filter(element -> element.getAnnotation(Column.class) != null).map(element -> element.getAnnotation(Column.class).value()).findAny().orElseGet(() -> CaseFormat.LOWER_CAMEL.to(this.columnCaseFormat, property.getName()));
    }

    static class CustomPropertiesEntityType
    extends EntityType {
        private final Set<Property> fieldOrderedProperties;

        CustomPropertiesEntityType(EntityType entityType, Set<Property> fieldOrderedProperties) {
            super((Type)entityType);
            this.fieldOrderedProperties = fieldOrderedProperties;
        }

        public Set<Property> getProperties() {
            return this.fieldOrderedProperties;
        }
    }
}

