/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.spring.data.jdbc.annotation.processor;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSet;
import com.infobip.spring.data.jdbc.annotation.processor.CustomExtendedTypeFactory;
import com.infobip.spring.data.jdbc.annotation.processor.DefaultTypeElementHandlerFactory;
import com.infobip.spring.data.jdbc.annotation.processor.ProjectColumnCaseFormat;
import com.infobip.spring.data.jdbc.annotation.processor.ProjectTableCaseFormat;
import com.infobip.spring.data.jdbc.annotation.processor.SpringDataJdbcConfiguration;
import com.infobip.spring.data.jdbc.annotation.processor.TypeElementHandlerFactory;
import com.querydsl.apt.AbstractQuerydslProcessor;
import com.querydsl.apt.Configuration;
import com.querydsl.apt.TypeElementHandler;
import com.querydsl.codegen.CodegenModule;
import com.querydsl.codegen.JavaTypeMappings;
import com.querydsl.codegen.QueryTypeFactory;
import com.querydsl.codegen.QueryTypeFactoryImpl;
import com.querydsl.codegen.TypeMappings;
import com.querydsl.sql.codegen.NamingStrategy;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.relational.core.mapping.Embedded;

public abstract class SpringDataJdbcAnnotationProcessorBase
extends AbstractQuerydslProcessor {
    private RoundEnvironment roundEnv;
    private CustomExtendedTypeFactory typeFactory;
    private Configuration conf;
    private final NamingStrategy namingStrategy;
    private final TypeElementHandlerFactory typeElementHandlerFactory;
    private CaseFormat projectTableCaseFormat;
    private CaseFormat projectColumnCaseFormat;

    public SpringDataJdbcAnnotationProcessorBase(Class<? extends NamingStrategy> namingStrategyClass) {
        try {
            this.namingStrategy = namingStrategyClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Failed to create new instance of " + namingStrategyClass, e);
        }
        this.typeElementHandlerFactory = new DefaultTypeElementHandlerFactory();
    }

    public SpringDataJdbcAnnotationProcessorBase(NamingStrategy namingStrategy, TypeElementHandlerFactory typeElementHandlerFactory, CaseFormat projectTableCaseFormat, CaseFormat projectColumnCaseFormat) {
        this.namingStrategy = namingStrategy;
        this.typeElementHandlerFactory = typeElementHandlerFactory;
        this.projectTableCaseFormat = projectTableCaseFormat;
        this.projectColumnCaseFormat = projectColumnCaseFormat;
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.projectTableCaseFormat = this.getProjectCaseFormat(roundEnv, ProjectTableCaseFormat.class, ProjectTableCaseFormat::value);
        this.projectColumnCaseFormat = this.getProjectCaseFormat(roundEnv, ProjectColumnCaseFormat.class, ProjectColumnCaseFormat::value);
        return super.process(annotations, roundEnv);
    }

    private <A extends Annotation> CaseFormat getProjectCaseFormat(RoundEnvironment roundEnv, Class<A> annotation, Function<A, CaseFormat> valueExtractor) {
        return Optional.ofNullable(roundEnv.getElementsAnnotatedWith(annotation)).filter(elements -> elements.size() == 1).map(elements -> (Element)elements.iterator().next()).map(element -> element.getAnnotation(annotation)).map(valueExtractor).orElse(CaseFormat.UPPER_CAMEL);
    }

    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)Id.class.getName());
    }

    protected Configuration createConfiguration(RoundEnvironment roundEnv) {
        Class<Id> entity = Id.class;
        this.roundEnv = roundEnv;
        CodegenModule codegenModule = new CodegenModule();
        JavaTypeMappings typeMappings = new JavaTypeMappings();
        codegenModule.bind(TypeMappings.class, (Object)typeMappings);
        codegenModule.bind(QueryTypeFactory.class, (Object)new QueryTypeFactoryImpl("Q", "", ""));
        SpringDataJdbcConfiguration springDataJdbcConfiguration = new SpringDataJdbcConfiguration(roundEnv, this.processingEnv, this.projectColumnCaseFormat, entity, null, null, Embedded.class, Transient.class, (TypeMappings)typeMappings, codegenModule, this.namingStrategy);
        this.conf = springDataJdbcConfiguration;
        return springDataJdbcConfiguration;
    }

    protected TypeElementHandler createElementHandler(TypeMappings typeMappings, QueryTypeFactory queryTypeFactory) {
        return this.typeElementHandlerFactory.createElementHandler(this.conf, this.typeFactory, typeMappings, queryTypeFactory, this.processingEnv.getElementUtils(), this.roundEnv, this.projectTableCaseFormat, this.projectColumnCaseFormat);
    }

    protected CustomExtendedTypeFactory createTypeFactory(Set<Class<? extends Annotation>> entityAnnotations, TypeMappings typeMappings, QueryTypeFactory queryTypeFactory) {
        CustomExtendedTypeFactory customExtendedTypeFactory;
        this.typeFactory = customExtendedTypeFactory = new CustomExtendedTypeFactory(this.roundEnv, this.processingEnv, entityAnnotations, typeMappings, queryTypeFactory, this.conf, this.processingEnv.getElementUtils(), this.projectTableCaseFormat);
        return customExtendedTypeFactory;
    }

    protected Set<TypeElement> collectElements() {
        Set entityElements = this.roundEnv.getElementsAnnotatedWith(this.conf.getEntityAnnotation()).stream().map(Element::getEnclosingElement).filter(element -> element instanceof TypeElement).map(element -> (TypeElement)element).collect(Collectors.toSet());
        return entityElements.stream().flatMap(this::getEntityElementWithEmbeddedEntities).collect(Collectors.toSet());
    }

    private Stream<TypeElement> getEntityElementWithEmbeddedEntities(TypeElement entityElement) {
        Types types = this.processingEnv.getTypeUtils();
        Set embeddedElements = ElementFilter.fieldsIn(entityElement.getEnclosedElements()).stream().filter(enclosedElement -> Objects.nonNull(enclosedElement.getAnnotation(this.conf.getEmbeddedAnnotation()))).map(element -> types.asElement(element.asType())).filter(element -> element instanceof TypeElement).map(element -> (TypeElement)element).collect(Collectors.toSet());
        return Stream.concat(Stream.of(entityElement), embeddedElements.stream());
    }
}

