/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.spring.data.jdbc.annotation.processor;

import com.google.common.base.CaseFormat;
import com.infobip.spring.data.jdbc.annotation.processor.DefaultSchema;
import com.infobip.spring.data.jdbc.annotation.processor.Embeddeds;
import com.infobip.spring.data.jdbc.annotation.processor.Schema;
import com.querydsl.apt.Configuration;
import com.querydsl.apt.ExtendedTypeFactory;
import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.QueryTypeFactory;
import com.querydsl.codegen.TypeMappings;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.TypeCategory;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.springframework.data.relational.core.mapping.Table;
import org.springframework.util.StringUtils;

public class CustomExtendedTypeFactory
extends ExtendedTypeFactory {
    public static final String IS_EMBEDDED_DATA_KEY = "isEmbedded";
    private final Configuration configuration;
    private final Elements elements;
    private final String defaultSchema;
    private final CaseFormat tableCaseFormat;
    private final Types types;

    public CustomExtendedTypeFactory(RoundEnvironment roundEnv, ProcessingEnvironment env, Set<Class<? extends Annotation>> annotations, TypeMappings typeMappings, QueryTypeFactory queryTypeFactory, Configuration configuration, Elements elements, CaseFormat tableCaseFormat) {
        super(env, annotations, typeMappings, queryTypeFactory, configuration.getVariableNameFunction());
        this.types = env.getTypeUtils();
        this.configuration = configuration;
        this.elements = elements;
        this.defaultSchema = this.getDefaultSchema(roundEnv);
        this.tableCaseFormat = tableCaseFormat;
    }

    public boolean isSimpleTypeEntity(TypeElement typeElement, Class<? extends Annotation> entityAnn) {
        return typeElement.getAnnotation(entityAnn) != null || typeElement.getEnclosedElements().stream().anyMatch(element -> element.getAnnotation(entityAnn) != null);
    }

    public EntityType getEntityType(TypeMirror typeMirror, boolean deep) {
        Element element = this.types.asElement(typeMirror);
        EntityType entityType = super.getEntityType(typeMirror, deep);
        List embeddedlessProperties = entityType.getProperties().stream().flatMap(property -> {
            if (Embeddeds.isEmbedded(this.configuration, element, property)) {
                return this.flattenEmbeddedProperty((Property)property);
            }
            return Stream.of(property);
        }).toList();
        entityType.getProperties().clear();
        entityType.getProperties().addAll(embeddedlessProperties);
        entityType.getPropertyNames().clear();
        entityType.getPropertyNames().addAll(embeddedlessProperties.stream().map(Property::getName).toList());
        this.updateModel(element, entityType);
        return entityType;
    }

    protected String getDefaultSchema(RoundEnvironment roundEnv) {
        Set<? extends Element> defaultSchemaElements = roundEnv.getElementsAnnotatedWith(DefaultSchema.class);
        if (defaultSchemaElements.isEmpty()) {
            return null;
        }
        if (defaultSchemaElements.size() > 1) {
            throw new IllegalArgumentException("found multiple elements with DefaultSchema " + String.valueOf(defaultSchemaElements));
        }
        return defaultSchemaElements.iterator().next().getAnnotation(DefaultSchema.class).value();
    }

    private Stream<Property> flattenEmbeddedProperty(Property property) {
        Type type = property.getType();
        if (!type.getCategory().equals((Object)TypeCategory.ENTITY)) {
            return Stream.of(property);
        }
        return ((EntityType)type).getProperties().stream();
    }

    private void updateModel(Element element, EntityType type) {
        Map data = type.getData();
        data.put("table", this.getTableName(type));
        this.getSchema(element).ifPresent(schema -> data.put("schema", schema));
        AtomicInteger counter = new AtomicInteger();
        type.getProperties().forEach(property -> this.addMetaData(element, counter, (Property)property));
    }

    private void addMetaData(Element element, AtomicInteger counter, Property property) {
        if (Embeddeds.isEmbedded(this.configuration, element, property)) {
            property.getData().put(IS_EMBEDDED_DATA_KEY, true);
        }
    }

    protected Optional<String> getSchema(Element element) {
        Schema elementSchema = element.getAnnotation(Schema.class);
        if (Objects.isNull(elementSchema)) {
            return Optional.ofNullable(this.defaultSchema);
        }
        return Optional.of(elementSchema.value());
    }

    protected String getTableName(EntityType model) {
        String simpleName = model.getSimpleName();
        String className = model.getPackageName() + "." + simpleName;
        String tableName = CaseFormat.UPPER_CAMEL.to(this.tableCaseFormat, simpleName);
        return Optional.ofNullable(this.elements.getTypeElement(className).getAnnotation(Table.class)).map(this::getTableName).filter(StringUtils::hasText).orElse(tableName);
    }

    private String getTableName(Table table) {
        if (table.value().isEmpty()) {
            return table.name();
        }
        return table.value();
    }

    private Stream<? extends Element> getFields(Element element) {
        return element.getEnclosedElements().stream().filter(enclosedElement -> enclosedElement.getKind().equals((Object)ElementKind.FIELD));
    }
}

