/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.spring.data.jpa;

import com.infobip.spring.data.jpa.ExtendedQuerydslJpaRepositoryFactory;
import com.infobip.spring.data.jpa.JPASQLQueryFactory;
import com.querydsl.jpa.impl.JPAQueryFactory;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.Serializable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaQueryMethodFactory;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.lang.Nullable;

public class ExtendedQuerydslJpaRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends JpaRepositoryFactoryBean<T, S, ID> {
    private EntityManager entityManager;
    private EntityPathResolver entityPathResolver;
    private EscapeCharacter escapeCharacter;
    private JpaQueryMethodFactory queryMethodFactory;
    private JPAQueryFactory jpaQueryFactory;
    private JPASQLQueryFactory jpaSqlQueryFactory;

    public ExtendedQuerydslJpaRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        super.setEntityManager(entityManager);
        this.entityManager = entityManager;
    }

    @Autowired
    public void setEntityPathResolver(ObjectProvider<EntityPathResolver> resolver) {
        super.setEntityPathResolver(resolver);
        this.entityPathResolver = (EntityPathResolver)resolver.getIfAvailable(() -> SimpleEntityPathResolver.INSTANCE);
    }

    @Autowired
    public void setQueryMethodFactory(@Nullable JpaQueryMethodFactory factory) {
        super.setQueryMethodFactory(factory);
        if (factory != null) {
            this.queryMethodFactory = factory;
        }
    }

    @Autowired
    public void setJPAQueryFactory(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }

    @Autowired
    public void setJpaSqlQueryFactory(JPASQLQueryFactory jpaSqlQueryFactory) {
        this.jpaSqlQueryFactory = jpaSqlQueryFactory;
    }

    protected RepositoryFactorySupport doCreateRepositoryFactory() {
        ExtendedQuerydslJpaRepositoryFactory factory = new ExtendedQuerydslJpaRepositoryFactory(this.entityManager, this.jpaSqlQueryFactory, this.entityPathResolver, this.jpaQueryFactory);
        factory.setEntityPathResolver(this.entityPathResolver);
        factory.setEscapeCharacter(this.escapeCharacter);
        if (this.queryMethodFactory != null) {
            factory.setQueryMethodFactory(this.queryMethodFactory);
        }
        return factory;
    }

    public void setEscapeCharacter(char escapeCharacter) {
        super.setEscapeCharacter(escapeCharacter);
        this.escapeCharacter = EscapeCharacter.of((char)escapeCharacter);
    }
}

