/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.spring.data.jpa;

import com.querydsl.core.types.Path;
import jakarta.persistence.EntityManager;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.StoredProcedureQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class StoredProcedureQueryBuilder {
    private final String name;
    private final List<Parameter> inParameters;
    private final EntityManager entityManager;
    private Class<?>[] resultClasses;

    StoredProcedureQueryBuilder(String name, EntityManager entityManager) {
        this.name = name;
        this.entityManager = entityManager;
        this.inParameters = new ArrayList<Parameter>();
    }

    public <T> List<T> getResultList() {
        return this.build().getResultList();
    }

    public StoredProcedureQuery build() {
        StoredProcedureQuery storedProcedureQuery = this.createStoredProcedureQuery();
        this.inParameters.forEach(parameter -> {
            storedProcedureQuery.registerStoredProcedureParameter(parameter.name, parameter.type, ParameterMode.IN);
            storedProcedureQuery.setParameter(parameter.name, parameter.value);
        });
        return storedProcedureQuery;
    }

    private StoredProcedureQuery createStoredProcedureQuery() {
        if (this.resultClasses == null) {
            return this.entityManager.createStoredProcedureQuery(this.name);
        }
        return this.entityManager.createStoredProcedureQuery(this.name, (Class[])this.resultClasses);
    }

    public <T> StoredProcedureQueryBuilder addInParameter(Path<T> parameter, T value) {
        Class type = parameter.getType();
        this.inParameters.add(new Parameter(type, parameter.getMetadata().getName(), value));
        return this;
    }

    public StoredProcedureQueryBuilder addInParameter(String name, Object value) {
        this.inParameters.add(new Parameter(value.getClass(), name, value));
        return this;
    }

    public StoredProcedureQueryBuilder setResultClasses(Class<?> ... resultClasses) {
        this.resultClasses = resultClasses;
        return this;
    }

    private record Parameter(Class<?> type, String name, Object value) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            return Objects.equals(this.type, parameter.type) && Objects.equals(this.name, parameter.name) && Objects.equals(this.value, parameter.value);
        }

        @Override
        public String toString() {
            return "Parameter{type=" + String.valueOf(this.type) + ", name='" + this.name + "', value=" + String.valueOf(this.value) + "}";
        }
    }
}

