/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.spring.data.r2dbc;

import com.querydsl.sql.MySQLTemplates;
import com.querydsl.sql.SQLTemplates;
import io.r2dbc.spi.Parameters;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.r2dbc.core.binding.BindMarker;
import org.springframework.r2dbc.core.binding.BindMarkers;
import org.springframework.r2dbc.core.binding.BindMarkersFactory;

class QuerydslParameterBinder {
    private final BindMarkersFactory bindMarkersFactory;
    private final boolean useNumberedBindParameters;

    QuerydslParameterBinder(BindMarkersFactory bindMarkersFactory, SQLTemplates sqlTemplates) {
        this.bindMarkersFactory = bindMarkersFactory;
        this.useNumberedBindParameters = this.resolve(sqlTemplates);
    }

    private boolean resolve(SQLTemplates sqlTemplates) {
        return sqlTemplates instanceof MySQLTemplates;
    }

    DatabaseClient.GenericExecuteSpec bind(DatabaseClient databaseClient, List<Object> bindings, String sql) {
        if (this.useNumberedBindParameters) {
            DatabaseClient.GenericExecuteSpec spec = databaseClient.sql(sql);
            int index = 0;
            for (Object binding : bindings) {
                spec = spec.bind(index++, binding);
            }
            return spec;
        }
        LinkedHashMap<String, Object> parameterNameToParameterValue = this.parameterNameToParameterValue(bindings);
        String sqlWithParameterNames = this.getSqlWithParameterNames(parameterNameToParameterValue, sql);
        DatabaseClient.GenericExecuteSpec spec = databaseClient.sql(sqlWithParameterNames);
        for (Map.Entry<String, Object> entry : parameterNameToParameterValue.entrySet()) {
            spec = spec.bind(entry.getKey(), (Object)Parameters.in((Object)entry.getValue()));
        }
        return spec;
    }

    private LinkedHashMap<String, Object> parameterNameToParameterValue(List<Object> bindings) {
        BindMarkers bindMarkers = this.bindMarkersFactory.create();
        LinkedHashMap<String, Object> parameterNameToParameterValue = new LinkedHashMap<String, Object>();
        for (int i = 0; i < bindings.size(); ++i) {
            BindMarker marker = bindMarkers.next(String.valueOf(i));
            parameterNameToParameterValue.put(marker.getPlaceholder(), bindings.get(i));
        }
        return parameterNameToParameterValue;
    }

    private String getSqlWithParameterNames(LinkedHashMap<String, Object> parameterNameToParameterValue, String sql) {
        String sqlWithParameterNames = sql;
        for (String parameterName : parameterNameToParameterValue.keySet()) {
            String paramName = this.escape(parameterName);
            sqlWithParameterNames = sqlWithParameterNames.replaceFirst("\\?", paramName);
        }
        return sqlWithParameterNames;
    }

    private String escape(String parameterName) {
        if (parameterName.startsWith("$")) {
            return parameterName.replace("$", "\\$");
        }
        return parameterName;
    }
}

