/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.spring.data.r2dbc;

import com.infobip.spring.data.common.Querydsl;
import com.infobip.spring.data.common.QuerydslExpressionFactory;
import com.infobip.spring.data.r2dbc.QuerydslParameterBinder;
import com.infobip.spring.data.r2dbc.QuerydslR2dbcFragment;
import com.infobip.spring.data.r2dbc.ReactiveQuerydslR2dbcPredicateExecutor;
import com.infobip.spring.data.r2dbc.SimpleQuerydslR2dbcFragment;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.SQLTemplates;
import io.r2dbc.spi.ConnectionFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.core.R2dbcEntityOperations;
import org.springframework.data.r2dbc.repository.support.R2dbcRepositoryFactory;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.r2dbc.core.binding.BindMarkersFactoryResolver;

public class QuerydslR2dbcRepositoryFactory
extends R2dbcRepositoryFactory {
    private final Class<?> REPOSITORY_TARGET_TYPE = QuerydslR2dbcFragment.class;
    private final SQLQueryFactory sqlQueryFactory;
    private final DatabaseClient databaseClient;
    private final R2dbcConverter converter;
    private final QuerydslExpressionFactory querydslExpressionFactory = new QuerydslExpressionFactory(this.REPOSITORY_TARGET_TYPE);
    private final QuerydslParameterBinder querydslParameterBinder;

    public QuerydslR2dbcRepositoryFactory(R2dbcEntityOperations operations, SQLQueryFactory sqlQueryFactory, DatabaseClient databaseClient, SQLTemplates sqlTemplates) {
        super(operations);
        this.sqlQueryFactory = sqlQueryFactory;
        this.converter = operations.getConverter();
        this.databaseClient = databaseClient;
        this.querydslParameterBinder = new QuerydslParameterBinder(BindMarkersFactoryResolver.resolve((ConnectionFactory)databaseClient.getConnectionFactory()), sqlTemplates);
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata) {
        RepositoryComposition.RepositoryFragments fragments = super.getRepositoryFragments(metadata);
        Class repositoryInterface = metadata.getRepositoryInterface();
        if (!this.REPOSITORY_TARGET_TYPE.isAssignableFrom(repositoryInterface)) {
            return fragments;
        }
        RelationalPathBase path = this.querydslExpressionFactory.getRelationalPathBaseFromQueryRepositoryClass(repositoryInterface);
        Class type = metadata.getDomainType();
        ConstructorExpression constructorExpression = this.querydslExpressionFactory.getConstructorExpression(type, (RelationalPath)path);
        RepositoryFragment<Object> simpleQuerydslJdbcFragment = this.createSimpleQuerydslR2dbcFragment((RelationalPath<?>)path, (ConstructorExpression<?>)constructorExpression);
        RepositoryFragment<Object> querydslJdbcPredicateExecutor = this.createQuerydslJdbcPredicateExecutor(constructorExpression, path);
        return fragments.append(simpleQuerydslJdbcFragment).append(querydslJdbcPredicateExecutor);
    }

    private RepositoryFragment<Object> createSimpleQuerydslR2dbcFragment(RelationalPath<?> path, ConstructorExpression<?> constructor) {
        Object simpleJPAQuerydslFragment = this.getTargetRepositoryViaReflection(SimpleQuerydslR2dbcFragment.class, new Object[]{this.sqlQueryFactory, constructor, path, this.databaseClient, this.converter, this.querydslParameterBinder});
        return RepositoryFragment.implemented((Object)simpleJPAQuerydslFragment);
    }

    private RepositoryFragment<Object> createQuerydslJdbcPredicateExecutor(ConstructorExpression<?> constructorExpression, RelationalPathBase<?> path) {
        MappingContext context = this.converter.getMappingContext();
        RelationalPersistentEntity entity = (RelationalPersistentEntity)context.getRequiredPersistentEntity(constructorExpression.getType());
        Querydsl querydsl = new Querydsl(this.sqlQueryFactory, entity);
        Object querydslJdbcPredicateExecutor = this.getTargetRepositoryViaReflection(ReactiveQuerydslR2dbcPredicateExecutor.class, new Object[]{constructorExpression, path, this.sqlQueryFactory, querydsl, this.databaseClient, this.converter, this.querydslParameterBinder});
        return RepositoryFragment.implemented((Object)querydslJdbcPredicateExecutor);
    }
}

