/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.spring.data.r2dbc;

import com.querydsl.sql.SQLServer2012Templates;
import com.querydsl.sql.SQLServerTemplates;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.SQLTemplatesRegistry;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnClass(value={Flyway.class})
@Configuration
public class R2dbcSQLTemplatesConfiguration {
    @ConditionalOnBean(value={Flyway.class})
    @Bean
    public SQLTemplates sqlTemplates(Flyway flyway) throws SQLException {
        SQLTemplatesRegistry sqlTemplatesRegistry = new SQLTemplatesRegistry();
        JdbcConnectionFactory jdbcConnectionFactory = new JdbcConnectionFactory(flyway.getConfiguration().getDataSource(), flyway.getConfiguration(), null);
        DatabaseMetaData metaData = jdbcConnectionFactory.openConnection().getMetaData();
        SQLTemplates templates = sqlTemplatesRegistry.getTemplates(metaData);
        if (templates instanceof SQLServerTemplates && metaData.getDatabaseMajorVersion() > 11) {
            return new SQLServer2012Templates();
        }
        return templates;
    }
}

