/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.spring.data.r2dbc;

import com.infobip.spring.data.common.Querydsl;
import com.infobip.spring.data.r2dbc.QuerydslParameterBinder;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLBindings;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Sort;
import org.springframework.data.querydsl.QSort;
import org.springframework.data.querydsl.ReactiveQuerydslPredicateExecutor;
import org.springframework.data.r2dbc.convert.EntityRowMapper;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.r2dbc.core.RowsFetchSpec;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Transactional(readOnly=true)
public class ReactiveQuerydslR2dbcPredicateExecutor<T>
implements ReactiveQuerydslPredicateExecutor<T> {
    private final ConstructorExpression<T> constructorExpression;
    private final RelationalPath<T> path;
    private final SQLQueryFactory sqlQueryFactory;
    private final Querydsl querydsl;
    private final DatabaseClient databaseClient;
    private final R2dbcConverter converter;
    private final QuerydslParameterBinder querydslParameterBinder;

    public ReactiveQuerydslR2dbcPredicateExecutor(ConstructorExpression<T> constructorExpression, RelationalPath<T> path, SQLQueryFactory sqlQueryFactory, Querydsl querydsl, DatabaseClient databaseClient, R2dbcConverter converter, QuerydslParameterBinder querydslParameterBinder) {
        this.constructorExpression = constructorExpression;
        this.path = path;
        this.sqlQueryFactory = sqlQueryFactory;
        this.querydsl = querydsl;
        this.databaseClient = databaseClient;
        this.converter = converter;
        this.querydslParameterBinder = querydslParameterBinder;
    }

    public Mono<T> findOne(Predicate predicate) {
        SQLQuery sqlQuery = (SQLQuery)((SQLQuery)this.sqlQueryFactory.query().select(this.constructorExpression).where(predicate)).from(this.path);
        return this.query(sqlQuery).one();
    }

    public Flux<T> findAll(Predicate predicate) {
        SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.query().select(this.constructorExpression).from(this.path)).where(predicate);
        return this.query(query).all();
    }

    public Flux<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        Assert.notNull(orders, (String)"Order specifiers must not be null!");
        return this.executeSorted(this.createQuery(predicate).select(this.constructorExpression), orders);
    }

    public Flux<T> findAll(Predicate predicate, Sort sort) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        return this.executeSorted(this.createQuery(predicate).select(this.constructorExpression), sort);
    }

    public Flux<T> findAll(OrderSpecifier<?> ... orders) {
        Assert.notNull(orders, (String)"Order specifiers must not be null!");
        return this.executeSorted(this.createQuery(new Predicate[0]).select(this.constructorExpression), orders);
    }

    public Mono<Long> count(Predicate predicate) {
        NumberExpression count = ((SimpleExpression)this.constructorExpression.getArgs().get(0)).count();
        SQLQuery sqlQuery = (SQLQuery)((SQLQuery)this.sqlQueryFactory.query().select((Expression)count).where(predicate)).from(this.path);
        return this.query(sqlQuery).one();
    }

    public Mono<Boolean> exists(Predicate predicate) {
        return this.count(predicate).map(result -> result > 0L);
    }

    public <S extends T, R, P extends Publisher<R>> P findBy(Predicate predicate, Function<FluentQuery.ReactiveFluentQuery<S>, P> queryFunction) {
        throw new UnsupportedOperationException();
    }

    protected SQLQuery<?> createQuery(Predicate ... predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        return this.doCreateQuery(predicate);
    }

    private SQLQuery<?> doCreateQuery(Predicate ... predicate) {
        SQLQuery query = this.querydsl.createQuery(new EntityPath[]{this.path});
        if (predicate != null) {
            query = (SQLQuery)query.where(predicate);
        }
        return query;
    }

    private Flux<T> executeSorted(SQLQuery<T> query, OrderSpecifier<?> ... orders) {
        return this.executeSorted(query, (Sort)new QSort(orders));
    }

    private Flux<T> executeSorted(SQLQuery<T> query, Sort sort) {
        SQLQuery sqlQuery = this.querydsl.applySorting(sort, query);
        return this.query(sqlQuery).all();
    }

    private <O> RowsFetchSpec<O> query(SQLQuery<O> query) {
        EntityRowMapper mapper = new EntityRowMapper(query.getType(), this.converter);
        SQLBindings sql = query.getSQL();
        return this.querydslParameterBinder.bind(this.databaseClient, sql.getNullFriendlyBindings(), sql.getSQL()).map((BiFunction)mapper);
    }
}

