/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.spring.data.r2dbc;

import com.infobip.spring.data.r2dbc.QuerydslParameterBinder;
import com.infobip.spring.data.r2dbc.QuerydslR2dbcFragment;
import com.infobip.spring.data.r2dbc.SimpleRowsFetchSpec;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLBindings;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.r2dbc.convert.EntityRowMapper;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.r2dbc.core.RowsFetchSpec;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Mono;

public class SimpleQuerydslR2dbcFragment<T>
implements QuerydslR2dbcFragment<T> {
    private final SQLQueryFactory sqlQueryFactory;
    private final ConstructorExpression<T> constructorExpression;
    private final RelationalPath<T> path;
    private final DatabaseClient databaseClient;
    private final R2dbcConverter converter;
    private final QuerydslParameterBinder querydslParameterBinder;

    public SimpleQuerydslR2dbcFragment(SQLQueryFactory sqlQueryFactory, ConstructorExpression<T> constructorExpression, RelationalPath<?> path, DatabaseClient databaseClient, R2dbcConverter converter, QuerydslParameterBinder querydslParameterBinder) {
        this.sqlQueryFactory = sqlQueryFactory;
        this.constructorExpression = constructorExpression;
        this.path = path;
        this.databaseClient = databaseClient;
        this.converter = converter;
        this.querydslParameterBinder = querydslParameterBinder;
    }

    @Override
    public <O> RowsFetchSpec<O> query(Function<SQLQuery<?>, SQLQuery<O>> query) {
        return this.createQuery(query);
    }

    @Override
    @Transactional
    public Mono<Long> update(Function<SQLUpdateClause, SQLUpdateClause> update) {
        SQLUpdateClause clause = this.sqlQueryFactory.update(this.path);
        List sqlBindings = update.apply(clause).getSQL();
        List<Object> bindings = this.getBindings(sqlBindings);
        String sql = sqlBindings.stream().map(SQLBindings::getSQL).collect(Collectors.joining("\n"));
        return this.querydslParameterBinder.bind(this.databaseClient, bindings, sql).fetch().rowsUpdated();
    }

    @Override
    @Transactional
    public Mono<Long> deleteWhere(Predicate predicate) {
        SQLDeleteClause clause = (SQLDeleteClause)this.sqlQueryFactory.delete(this.path).where(predicate);
        List sqlBindings = clause.getSQL();
        List<Object> bindings = this.getBindings(sqlBindings);
        String sql = sqlBindings.stream().map(SQLBindings::getSQL).collect(Collectors.joining("\n"));
        return this.querydslParameterBinder.bind(this.databaseClient, bindings, sql).fetch().rowsUpdated();
    }

    @Override
    public Expression<T> entityProjection() {
        return this.constructorExpression;
    }

    private <O> RowsFetchSpec<O> createQuery(Function<SQLQuery<?>, SQLQuery<O>> query) {
        SQLQuery<O> result = query.apply(this.sqlQueryFactory.query());
        EntityRowMapper mapper = new EntityRowMapper(result.getType(), this.converter);
        SQLBindings sql = result.getSQL();
        return new SimpleRowsFetchSpec(this.querydslParameterBinder.bind(this.databaseClient, sql.getNullFriendlyBindings(), sql.getSQL()).map((BiFunction)mapper));
    }

    private List<Object> getBindings(List<SQLBindings> sqlBindings) {
        return sqlBindings.stream().flatMap(bindings -> bindings.getNullFriendlyBindings().stream()).toList();
    }
}

