/*
 * Decompiled with CFR 0.152.
 */
package com.infradna.tool.bridge_method_injector;

import com.infradna.tool.bridge_method_injector.MethodInjector;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class ProcessMojo
extends AbstractMojo {
    private File classesDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File index = new File(this.classesDirectory, "META-INF/annotations/" + WithBridgeMethods.class.getName());
        if (!index.exists()) {
            this.getLog().debug((CharSequence)("Skipping because there's no " + index));
            return;
        }
        BufferedReader r = null;
        try {
            String line;
            r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(index), "UTF-8"));
            while ((line = r.readLine()) != null) {
                File classFile = new File(this.classesDirectory, line.replace('.', '/') + ".class");
                this.getLog().debug((CharSequence)("Processing " + line));
                new MethodInjector().handle(classFile);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to process @WithBridgeMethods", (Exception)e);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

