/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.dam.MsgConn;
import com.ingres.gcf.dam.MsgConst;
import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvConst;
import com.ingres.gcf.jdbc.DrvTrace;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.SqlWarn;
import com.ingres.gcf.util.XaEx;
import java.sql.SQLException;
import java.sql.SQLWarning;

class DrvObj
implements DrvConst,
MsgConst,
GcfErr {
    protected DrvConn conn = null;
    protected MsgConn msg = null;
    protected DrvTrace trace = null;
    protected String title = null;
    protected String tr_id = null;
    protected int inst_id = 0;
    protected int rslt_flags = 0;
    protected int rslt_items = 0;
    protected static final int RSLT_PREFETCH = 1;
    protected static final int RSLT_ROW_STAT = 2;
    protected static final int RSLT_ROW_POS = 4;
    protected static final int RSLT_ROW_CNT = 8;
    protected static final int RSLT_STMT_ID = 16;
    protected static final int RSLT_PROC_VAL = 32;
    protected static final int RSLT_TBLKEY = 64;
    protected static final int RSLT_OBJKEY = 128;
    protected int rslt_val_fetch = 0;
    protected int rslt_val_rowstat = 0;
    protected int rslt_val_rowpos = 0;
    protected int rslt_val_rowcnt = 0;
    protected long rslt_val_stmt = 0L;
    protected int rslt_val_proc = 0;
    protected byte[] rslt_val_tblkey = null;
    protected byte[] rslt_val_objkey = null;
    protected SQLWarning warnings = null;
    private static int inst_count = 0;

    protected DrvObj(DrvConn drvConn) {
        this.conn = drvConn;
        this.msg = drvConn.msg;
        this.trace = drvConn.trace;
        this.inst_id = inst_count++;
        this.title = this.trace.getTraceName() + "[" + this.inst_id + "]";
        this.tr_id = "Jdbc[" + this.inst_id + "]";
    }

    public String toString() {
        return this.title;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getWarnings()");
        }
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".clearWarnings()");
        }
        this.warnings = null;
    }

    protected void setWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            this.warnings.setNextWarning(sQLWarning);
        }
    }

    protected void writeQueryText(String string) throws SQLException {
        int n;
        byte[] byArray;
        try {
            byArray = this.msg.getCharSet().getBytes(string);
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
        }
        for (int i = 0; i < byArray.length; i += n) {
            n = Math.min(byArray.length - i, 32000);
            this.msg.write((short)1);
            this.msg.write((short)n);
            this.msg.write(byArray, i, n);
        }
    }

    protected void clearResults() {
        this.warnings = null;
        this.rslt_flags = 0;
        this.rslt_items = 0;
        this.rslt_val_fetch = 0;
        this.rslt_val_rowstat = 0;
        this.rslt_val_rowpos = 0;
        this.rslt_val_rowcnt = 0;
        this.rslt_val_stmt = 0L;
        this.rslt_val_proc = 0;
    }

    protected JdbcRSMD readResults() throws SQLException, XaEx {
        JdbcRSMD jdbcRSMD;
        XaEx xaEx;
        SQLException sQLException;
        block17: {
            sQLException = null;
            xaEx = null;
            jdbcRSMD = null;
            try {
                do {
                    byte by = this.msg.receive();
                    switch (by) {
                        case 6: {
                            jdbcRSMD = this.readDesc();
                            break;
                        }
                        case 7: {
                            if (!this.readData()) break;
                            break block17;
                        }
                        case 11: {
                            this.readInfo();
                            break;
                        }
                        case 8: {
                            SQLException sQLException2 = this.readError();
                            if (sQLException2 == null) break;
                            if (sQLException2 instanceof XaEx) {
                                xaEx = (XaEx)sQLException2;
                                break;
                            }
                            if (sQLException == null) {
                                sQLException = sQLException2;
                                break;
                            }
                            sQLException.setNextException(sQLException2);
                            break;
                        }
                        case 9: {
                            if (!this.readResult()) break;
                            break block17;
                        }
                        default: {
                            if (this.trace.enabled(1)) {
                                this.trace.write(this.tr_id + ": Invalid message ID " + by);
                            }
                            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                        }
                    }
                    if (!this.msg.moreData()) continue;
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": end-of-message not reached");
                    }
                    throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                } while (this.msg.moreMessages());
            }
            catch (SQLException sQLException3) {
                if (sQLException == null) {
                    sQLException = sQLException3;
                }
                sQLException.setNextException(sQLException3);
            }
        }
        if (xaEx != null) {
            throw xaEx;
        }
        if (sQLException != null) {
            throw sQLException;
        }
        return jdbcRSMD;
    }

    protected JdbcRSMD readDesc() throws SQLException {
        if (this.trace.enabled(1)) {
            this.trace.write(this.tr_id + ": unexpected result set");
        }
        throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
    }

    protected boolean readData() throws SQLException {
        if (this.trace.enabled(1)) {
            this.trace.write(this.tr_id + ": unexpected result data.");
        }
        throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
    }

    protected void readInfo() throws SQLException {
        block3: while (this.msg.moreData()) {
            short s = this.msg.readShort();
            short s2 = this.msg.readShort();
            switch (s) {
                case 1: {
                    if (this.trace.enabled() || this.conn.dbms_log.enabled()) {
                        String string = this.msg.readString(s2);
                        this.trace.log("DBMS TRACE: " + string);
                        this.conn.dbms_log.write(string);
                        continue block3;
                    }
                    this.msg.skip(s2);
                    continue block3;
                }
            }
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": Invalid info param ID " + s);
            }
            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
        }
    }

    protected SQLException readError() throws SQLException {
        SQLException sQLException = null;
        int n = this.msg.readInt();
        String string = this.msg.readString(5);
        byte by = this.msg.readByte();
        String string2 = this.msg.readString();
        switch (by) {
            case 2: {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": Received error '" + string + "' 0x" + Integer.toHexString(n) + " -- " + string2);
                }
                sQLException = SqlExFactory.get(string2, string, n);
                break;
            }
            case 1: {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": Received warning '" + string + "' 0x" + Integer.toHexString(n) + " -- " + string2);
                }
                this.setWarning(new SqlWarn(string2, string, n));
                break;
            }
            case 0: {
                if (this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ": Received message '" + string + "' 0x" + Integer.toHexString(n) + " -- " + string2);
                }
                this.setWarning(new SqlWarn(string2, string, n));
                break;
            }
            case 3: {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": Received XA error " + n);
                }
                sQLException = new XaEx(n);
            }
        }
        return sQLException;
    }

    protected boolean readResult() throws SQLException {
        block44: while (this.msg.moreData()) {
            short s = this.msg.readShort();
            short s2 = this.msg.readShort();
            switch (s) {
                case 1: {
                    switch (s2) {
                        case 1: {
                            this.rslt_val_rowcnt = this.msg.readByte();
                            break;
                        }
                        case 2: {
                            this.rslt_val_rowcnt = this.msg.readShort();
                            break;
                        }
                        case 4: {
                            this.rslt_val_rowcnt = this.msg.readInt();
                            break;
                        }
                        default: {
                            if (this.trace.enabled(1)) {
                                this.trace.write(this.tr_id + ": Invalid row count length: " + s2);
                            }
                            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                        }
                    }
                    this.rslt_items |= 8;
                    continue block44;
                }
                case 2: {
                    if (s2 > 0) {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ": Invalid XACT param length: " + s2);
                        }
                        throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                    }
                    this.rslt_flags |= 1;
                    this.conn.endXact();
                    continue block44;
                }
                case 3: {
                    if (s2 != 8) {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ": Invalid stmt ID length: " + s2);
                        }
                        throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                    }
                    this.rslt_val_stmt = (long)this.msg.readInt() << 32 | (long)this.msg.readInt() & 0xFFFFFFFFFFFFFFFFL;
                    this.rslt_items |= 0x10;
                    continue block44;
                }
                case 4: {
                    switch (s2) {
                        case 1: {
                            this.rslt_val_fetch = this.msg.readByte();
                            break;
                        }
                        case 2: {
                            this.rslt_val_fetch = this.msg.readShort();
                            break;
                        }
                        case 4: {
                            this.rslt_val_fetch = this.msg.readInt();
                            break;
                        }
                        default: {
                            if (this.trace.enabled(1)) {
                                this.trace.write(this.tr_id + ": Invalid fetch limit length: " + s2);
                            }
                            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                        }
                    }
                    this.rslt_items |= 1;
                    continue block44;
                }
                case 5: {
                    if (s2 != 0) {
                        this.trace.write(this.tr_id + ": Invalid EOD length: " + s2);
                        throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                    }
                    this.rslt_flags |= 4;
                    continue block44;
                }
                case 6: {
                    switch (s2) {
                        case 1: {
                            this.setProcResult(this.msg.readByte());
                            continue block44;
                        }
                        case 2: {
                            this.setProcResult(this.msg.readShort());
                            continue block44;
                        }
                        case 4: {
                            this.setProcResult(this.msg.readInt());
                            continue block44;
                        }
                    }
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": Invalid proc result length: " + s2);
                    }
                    throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                }
                case 7: {
                    if (s2 != 0) {
                        this.trace.write(this.tr_id + ": Invalid READ_ONLY length: " + s2);
                        throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                    }
                    this.rslt_flags |= 2;
                    continue block44;
                }
                case 8: {
                    if (s2 != 8) {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ": Invalid table key length: " + s2);
                        }
                        throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                    }
                    if (this.rslt_val_tblkey == null) {
                        this.rslt_val_tblkey = new byte[s2];
                    }
                    this.msg.readBytes(this.rslt_val_tblkey, 0, s2);
                    this.rslt_items |= 0x40;
                    continue block44;
                }
                case 9: {
                    if (s2 != 16) {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ": Invalid object key length: " + s2);
                        }
                        throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                    }
                    if (this.rslt_val_objkey == null) {
                        this.rslt_val_objkey = new byte[s2];
                    }
                    this.msg.readBytes(this.rslt_val_objkey, 0, s2);
                    this.rslt_items |= 0x80;
                    continue block44;
                }
                case 10: {
                    int n;
                    switch (s2) {
                        case 1: {
                            n = this.msg.readByte();
                            break;
                        }
                        case 2: {
                            n = this.msg.readShort();
                            break;
                        }
                        case 4: {
                            n = this.msg.readInt();
                            break;
                        }
                        default: {
                            if (this.trace.enabled(1)) {
                                this.trace.write(this.tr_id + ": Invalid result flags length: " + s2);
                            }
                            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                        }
                    }
                    this.rslt_flags |= n;
                    if ((n & 1) == 0) continue block44;
                    this.conn.endXact();
                    continue block44;
                }
                case 11: {
                    switch (s2) {
                        case 1: {
                            this.rslt_val_rowstat = this.msg.readByte();
                            break;
                        }
                        case 2: {
                            this.rslt_val_rowstat = this.msg.readShort();
                            break;
                        }
                        case 4: {
                            this.rslt_val_rowstat = this.msg.readInt();
                            break;
                        }
                        default: {
                            if (this.trace.enabled(1)) {
                                this.trace.write(this.tr_id + ": Invalid row status length: " + s2);
                            }
                            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                        }
                    }
                    this.rslt_items |= 2;
                    continue block44;
                }
                case 12: {
                    switch (s2) {
                        case 1: {
                            this.rslt_val_rowpos = this.msg.readByte();
                            break;
                        }
                        case 2: {
                            this.rslt_val_rowpos = this.msg.readShort();
                            break;
                        }
                        case 4: {
                            this.rslt_val_rowpos = this.msg.readInt();
                            break;
                        }
                        default: {
                            if (this.trace.enabled(1)) {
                                this.trace.write(this.tr_id + ": Invalid row position length: " + s2);
                            }
                            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                        }
                    }
                    this.rslt_items |= 4;
                    continue block44;
                }
            }
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": Invalid result param ID " + s);
            }
            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
        }
        return false;
    }

    protected void setProcResult(int n) throws SQLException {
        this.rslt_val_proc = n;
        this.rslt_items |= 0x20;
    }
}

