/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvObj;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.jdbc.JdbcRslt;
import com.ingres.gcf.jdbc.RsltCurs;
import com.ingres.gcf.jdbc.RsltData;
import com.ingres.gcf.jdbc.RsltScrUpd;
import com.ingres.gcf.jdbc.RsltScroll;
import com.ingres.gcf.jdbc.RsltSlct;
import com.ingres.gcf.jdbc.RsltUpd;
import com.ingres.gcf.jdbc.SqlParse;
import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.SqlByte;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.SqlWarn;
import com.ingres.gcf.util.Timer;
import com.ingres.gcf.util.XaEx;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.LinkedList;

public class JdbcStmt
extends DrvObj
implements Statement,
DbmsConst,
Timer.Callback {
    int rs_fetch_dir = 1000;
    int rs_fetch_size = 0;
    int rs_max_rows = 0;
    int rs_max_len = 0;
    protected static final int QUERY = 1;
    protected static final int UPDATE = 0;
    protected static final int UNKNOWN = -1;
    protected static final String crsr_prefix = "JDBC_CRSR_";
    protected LinkedList batch = null;
    protected JdbcRslt resultSet = null;
    protected String crsr_name = null;
    protected int rs_type;
    protected int rs_concur;
    protected int rs_hold;
    protected boolean parse_escapes = true;
    protected int timeout = 0;
    private static JdbcRSMD rsmdKeys = null;
    private static JdbcRSMD rsmdTblKey = null;
    private static JdbcRSMD rsmdObjKey = null;
    private static JdbcRSMD rsmdEmpty = null;
    private static ResultSet rsEmpty = null;
    private Timer timer = null;
    private boolean timed_out = false;
    private boolean closed = false;

    JdbcStmt(DrvConn drvConn, int n, int n2, int n3) {
        super(drvConn);
        this.rs_type = n;
        this.rs_concur = n2;
        this.rs_hold = n3;
        this.title = this.trace.getTraceName() + "-Statement[" + this.inst_id + "]";
        this.tr_id = "Stmt[" + this.inst_id + "]";
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeQuery('" + string + "')");
        }
        this.exec(string, 1);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeQuery(): " + this.resultSet);
        }
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        int n;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate('" + string + "')");
        }
        this.exec(string, 0);
        int n2 = n = (this.rslt_items & 8) != 0 ? this.rslt_val_rowcnt : 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate(): " + n);
        }
        return n;
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        int n2;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate('" + string + "'," + n + ")");
        }
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        this.exec(string, 0);
        int n3 = n2 = (this.rslt_items & 8) != 0 ? this.rslt_val_rowcnt : 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate(): " + n2);
        }
        return n2;
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        int n;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate('" + string + "'," + (nArray == null ? "null" : "[" + nArray.length + "]") + ")");
        }
        this.exec(string, 0);
        int n2 = n = (this.rslt_items & 8) != 0 ? this.rslt_val_rowcnt : 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate(): " + n);
        }
        return n;
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        int n;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate('" + string + "'," + (stringArray == null ? "null" : "[" + stringArray.length + "]") + ")");
        }
        this.exec(string, 0);
        int n2 = n = (this.rslt_items & 8) != 0 ? this.rslt_val_rowcnt : 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate(): " + n);
        }
        return n;
    }

    @Override
    public boolean execute(String string) throws SQLException {
        boolean bl;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute( '" + string + "' )");
        }
        this.exec(string, -1);
        boolean bl2 = bl = this.resultSet != null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute(): " + bl);
        }
        return bl;
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        boolean bl;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute( '" + string + "'" + n + ")");
        }
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        this.exec(string, -1);
        boolean bl2 = bl = this.resultSet != null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute(): " + bl);
        }
        return bl;
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        boolean bl;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute( '" + string + "'," + (nArray == null ? "null" : "[" + nArray.length + "]") + ")");
        }
        this.exec(string, -1);
        boolean bl2 = bl = this.resultSet != null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute(): " + bl);
        }
        return bl;
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        boolean bl;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute( '" + string + "'," + (stringArray == null ? "null" : "[" + stringArray.length + "]") + ")");
        }
        this.exec(string, -1);
        boolean bl2 = bl = this.resultSet != null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute(): " + bl);
        }
        return bl;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getResultSet(): " + this.resultSet);
        }
        return this.resultSet;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return super.getWarnings();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        int n;
        int n2 = n = this.resultSet != null || (this.rslt_items & 8) == 0 ? -1 : this.rslt_val_rowcnt;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getUpdateCount(): " + n);
        }
        return n;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMoreResults(): " + false);
        }
        this.clearQueryResults(true);
        return false;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMoreResults(" + n + "): " + false);
        }
        switch (n) {
            case 2: {
                this.clearQueryResults(false);
                break;
            }
            case 1: 
            case 3: {
                this.clearQueryResults(true);
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        return false;
    }

    @Override
    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        ResultSet resultSet = rsEmpty;
        if ((this.rslt_items & 0x40) != 0) {
            if ((this.rslt_items & 0x80) != 0) {
                if (rsmdKeys == null) {
                    rsmdKeys = new JdbcRSMD(2, this.trace);
                    rsmdKeys.setColumnInfo("table_key", 1, -2, (short)12, (short)8, (byte)0, (byte)0, false);
                    rsmdKeys.setColumnInfo("object_key", 2, -2, (short)11, (short)16, (byte)0, (byte)0, false);
                }
                SqlData[][] sqlDataArray = new SqlData[][]{new SqlData[2]};
                SqlByte sqlByte = new SqlByte(8);
                sqlByte.put(this.rslt_val_tblkey);
                sqlDataArray[0][0] = sqlByte;
                sqlByte = new SqlByte(16);
                sqlByte.put(this.rslt_val_objkey);
                sqlDataArray[0][1] = sqlByte;
                resultSet = new RsltData(this.conn, rsmdKeys, sqlDataArray);
            } else {
                if (rsmdTblKey == null) {
                    rsmdTblKey = new JdbcRSMD(1, this.trace);
                    rsmdTblKey.setColumnInfo("table_key", 1, -2, (short)12, (short)8, (byte)0, (byte)0, false);
                }
                SqlData[][] sqlDataArray = new SqlData[][]{new SqlData[1]};
                SqlByte sqlByte = new SqlByte(8);
                sqlByte.put(this.rslt_val_tblkey);
                sqlDataArray[0][0] = sqlByte;
                resultSet = new RsltData(this.conn, rsmdTblKey, sqlDataArray);
            }
        } else if ((this.rslt_items & 0x80) != 0) {
            if (rsmdObjKey == null) {
                rsmdObjKey = new JdbcRSMD(1, this.trace);
                rsmdObjKey.setColumnInfo("object_key", 1, -2, (short)11, (short)16, (byte)0, (byte)0, false);
            }
            SqlData[][] sqlDataArray = new SqlData[][]{new SqlData[1]};
            SqlByte sqlByte = new SqlByte(16);
            sqlByte.put(this.rslt_val_objkey);
            sqlDataArray[0][0] = sqlByte;
            resultSet = new RsltData(this.conn, rsmdObjKey, sqlDataArray);
        } else if (rsEmpty == null) {
            if (rsmdEmpty == null) {
                rsmdEmpty = new JdbcRSMD(1, this.trace);
                rsmdEmpty.setColumnInfo("no_key", 1, -2, (short)12, (short)8, (byte)0, (byte)0, false);
            }
            resultSet = rsEmpty = new RsltData(this.conn, rsmdEmpty, null);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getGeneratedKeys: " + resultSet);
        }
        return resultSet;
    }

    @Override
    protected void clearResults() {
        this.clearQueryResults(true);
        super.clearResults();
    }

    protected synchronized void clearQueryResults(boolean bl) {
        if (bl && this.resultSet != null) {
            try {
                this.resultSet.shut();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.resultSet = null;
        }
        this.rslt_items &= 0xFFFFFFF7;
        this.rslt_val_rowcnt = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".addBatch( '" + string + "' )");
        }
        if (this.batch == null) {
            this.newBatch();
        }
        LinkedList linkedList = this.batch;
        synchronized (linkedList) {
            this.batch.addLast(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".clearBatch()");
        }
        if (this.batch != null) {
            LinkedList linkedList = this.batch;
            synchronized (linkedList) {
                this.batch.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeBatch()");
        }
        if (this.batch == null) {
            return BatchExec.noResults;
        }
        if ((this.conn.cnf_flags & 0x20) == 0 || this.conn.db_protocol_level < 6) {
            nArray = this.iterateBatch();
        } else {
            LinkedList linkedList = this.batch;
            synchronized (linkedList) {
                BatchExec batchExec = new BatchExec(this.conn);
                try {
                    nArray = batchExec.execute(this.batch, this.parse_escapes);
                }
                finally {
                    this.batch.clear();
                }
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] iterateBatch() throws SQLException {
        int[] nArray;
        LinkedList linkedList = this.batch;
        synchronized (linkedList) {
            int n = this.batch.size();
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                try {
                    String string = (String)this.batch.pollFirst();
                    if (this.trace.enabled()) {
                        this.trace.log(this.title + ".executeBatch[" + i + "]: '" + string + "'");
                    }
                    this.exec(string, 0);
                    int n2 = nArray[i] = (this.rslt_items & 8) != 0 ? this.rslt_val_rowcnt : -2;
                    if (!this.trace.enabled()) continue;
                    this.trace.log(this.title + ".executeBatch[" + i + "] = " + nArray[i]);
                    continue;
                }
                catch (SQLException sQLException) {
                    int[] nArray2 = new int[i];
                    if (i > 0) {
                        System.arraycopy(nArray, 0, nArray2, 0, i);
                    }
                    BatchUpdateException batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray2);
                    batchUpdateException.setNextException(sQLException.getNextException());
                    this.batch.clear();
                    throw batchUpdateException;
                }
            }
            this.batch.clear();
        }
        return nArray;
    }

    private void exec(String string, int n) throws SQLException {
        block38: {
            SqlParse sqlParse = new SqlParse(string, this.conn);
            int n2 = sqlParse.getQueryType();
            String string2 = null;
            this.clearResults();
            if (n == -1) {
                int n3 = n = n2 == 1 ? 1 : 0;
            }
            if (n2 == 2 || n2 == 3) {
                string2 = sqlParse.getCursorName();
            }
            this.msg.lock();
            try {
                String string3 = sqlParse.parseSQL(this.parse_escapes);
                if (n == 1) {
                    int n4 = this.getConcurrency(sqlParse.getConcurrency());
                    if (this.conn.select_loops && this.crsr_name == null && this.rs_type == 1003 && n4 != 1 && this.conn.msg_protocol_level >= 2) {
                        boolean bl = true;
                        this.msg.begin((byte)4);
                        this.msg.write((short)1);
                        if (this.conn.msg_protocol_level >= 3) {
                            short s = 2;
                            if (this.enableLocators(true)) {
                                s = (short)(s | 0x20);
                            }
                            if (this.rs_fetch_size != 1) {
                                s = (short)(s | 4);
                                bl = false;
                            }
                            this.msg.write((short)6);
                            this.msg.write((short)2);
                            this.msg.write(s);
                        }
                        this.writeQueryText(string3);
                        this.msg.done(true);
                        JdbcRSMD jdbcRSMD = this.readResults(this.timeout, bl);
                        if (jdbcRSMD == null) {
                            throw SqlExFactory.get(ERR_GC4017_NO_RESULT_SET);
                        }
                        this.resultSet = new RsltSlct(this.conn, this, jdbcRSMD, this.rslt_val_stmt, this.getPreFetchSize(), this.msg.moreMessages());
                    } else {
                        short s = 0;
                        boolean bl = true;
                        String string4 = string2 = this.crsr_name != null ? this.crsr_name : this.conn.getUniqueID(crsr_prefix);
                        if (n4 == 0) {
                            if (this.conn.msg_protocol_level < 2) {
                                string3 = string3 + " for readonly";
                            } else {
                                s = (short)(s | 1);
                                if (this.conn.msg_protocol_level >= 3 && this.rs_type == 1003 && this.rs_fetch_size != 1) {
                                    s = (short)(s | 4);
                                    bl = false;
                                }
                            }
                        }
                        if ((this.conn.cnf_flags & 0x10) != 0 && this.rs_type != 1003) {
                            s = (short)(s | 0x40);
                        } else if (this.conn.msg_protocol_level >= 3) {
                            s = (short)(s | 2);
                        }
                        if (this.enableLocators(false)) {
                            s = (short)(s | 0x20);
                        }
                        this.msg.begin((byte)4);
                        this.msg.write((short)2);
                        if (s != 0) {
                            this.msg.write((short)6);
                            this.msg.write((short)2);
                            this.msg.write(s);
                        }
                        this.msg.write((short)2);
                        this.msg.write(string2);
                        this.writeQueryText(string3);
                        this.msg.done(true);
                        JdbcRSMD jdbcRSMD = this.readResults(this.timeout, bl);
                        if (jdbcRSMD == null) {
                            throw SqlExFactory.get(ERR_GC4017_NO_RESULT_SET);
                        }
                        switch (this.rslt_flags & 0x12) {
                            case 0: {
                                if (this.rs_type != 1003 || this.rs_concur != 1) {
                                    this.warnings = SqlWarn.get(ERR_GC4016_RS_CHANGED);
                                }
                                this.resultSet = new RsltUpd(this.conn, this, jdbcRSMD, this.rslt_val_stmt, string2, sqlParse.getTableName());
                                if (!this.msg.moreMessages()) break;
                                this.readResults(this.timeout, true);
                                break;
                            }
                            case 16: {
                                if (this.rs_type != 1005 || this.rs_concur != 1) {
                                    this.warnings = SqlWarn.get(ERR_GC4016_RS_CHANGED);
                                }
                                this.resultSet = new RsltScrUpd(this.conn, this, jdbcRSMD, this.rslt_val_stmt, string2, sqlParse.getTableName());
                                if (!this.msg.moreMessages()) break;
                                this.readResults(this.timeout, true);
                                break;
                            }
                            case 2: {
                                if (this.rs_type != 1003 || this.rs_concur == 1) {
                                    this.warnings = SqlWarn.get(ERR_GC4016_RS_CHANGED);
                                }
                                this.resultSet = new RsltCurs(this.conn, this, jdbcRSMD, this.rslt_val_stmt, this.crsr_name, this.getPreFetchSize(), this.msg.moreMessages());
                                break;
                            }
                            case 18: {
                                if (this.rs_type != 1004 || this.rs_concur == 1) {
                                    this.warnings = SqlWarn.get(ERR_GC4016_RS_CHANGED);
                                }
                                this.resultSet = new RsltScroll(this.conn, this, jdbcRSMD, this.rslt_val_stmt, this.crsr_name, this.getPreFetchSize(), this.msg.moreMessages());
                            }
                        }
                        this.msg.unlock();
                    }
                    break block38;
                }
                if (string2 != null) {
                    this.msg.begin((byte)4);
                    this.msg.write(n2 == 2 ? (short)7 : 8);
                    this.msg.write((short)2);
                    this.msg.write(string2);
                    this.writeQueryText(string3);
                    this.msg.done(true);
                    if (this.readResults(this.timeout, true) != null) {
                        throw SqlExFactory.get(ERR_GC4018_RESULT_SET_NOT_PERMITTED);
                    }
                    this.msg.unlock();
                    break block38;
                }
                this.msg.begin((byte)4);
                this.msg.write((short)1);
                this.writeQueryText(string3);
                this.msg.done(true);
                JdbcRSMD jdbcRSMD = this.readResults(this.timeout, true);
                if (jdbcRSMD == null) {
                    this.msg.unlock();
                    break block38;
                }
                this.resultSet = new RsltSlct(this.conn, this, jdbcRSMD, this.rslt_val_stmt, 1, false);
                try {
                    this.resultSet.shut();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.resultSet = null;
                throw SqlExFactory.get(ERR_GC4018_RESULT_SET_NOT_PERMITTED);
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled()) {
                    this.trace.log(this.title + ".execute(): error executing query");
                }
                if (this.trace.enabled(1)) {
                    SqlExFactory.trace(sQLException, this.trace);
                }
                this.msg.unlock();
                throw sQLException;
            }
        }
    }

    @Override
    public void cancel() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".cancel()");
        }
        this.msg.cancel();
    }

    @Override
    public void close() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".close()");
        }
        this.clearResults();
        this.closed = true;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getConnection(): " + this.conn.jdbc);
        }
        return this.conn.jdbc;
    }

    @Override
    public int getResultSetType() {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getResultSetType(): " + this.rs_type);
        }
        return this.rs_type;
    }

    @Override
    public int getResultSetConcurrency() {
        int n = this.rs_concur == 1 ? 1008 : 1007;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getResultSetConcurrency(): " + n);
        }
        return n;
    }

    @Override
    public int getResultSetHoldability() {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getResultSetHoldability(): " + this.rs_hold);
        }
        return this.rs_hold;
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isClosed(): " + this.closed);
        }
        return this.closed;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setPoolable()");
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isPoolable()");
        }
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isWrapperFor(" + clazz + ")");
        }
        if (clazz != null) {
            return clazz.isInstance(this);
        }
        throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".unwrap(" + clazz + ")");
        }
        if (clazz != null) {
            if (!clazz.isInstance(this)) {
                throw SqlExFactory.get(ERR_GC4023_NO_OBJECT);
            }
            return clazz.cast(this);
        }
        throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setCursorName( '" + string + "' )");
        }
        this.crsr_name = string;
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setEscapeProcessing( " + bl + " )");
        }
        this.parse_escapes = bl;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getFetchDirection(): " + this.rs_fetch_dir);
        }
        return this.rs_fetch_dir;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setFetchDirection( " + n + " )");
        }
        switch (n) {
            case 1000: 
            case 1001: 
            case 1002: {
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        this.rs_fetch_dir = n;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getFetchSize(): " + this.rs_fetch_size);
        }
        return this.rs_fetch_size;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setFetchSize( " + n + " )");
        }
        if (n < 0 || this.rs_max_rows > 0 && n > this.rs_max_rows) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        this.rs_fetch_size = n;
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxRows(): " + this.rs_max_rows);
        }
        return this.rs_max_rows;
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setMaxRows( " + n + " )");
        }
        if (n < 0) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        this.rs_max_rows = n;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxFieldSize(): " + this.rs_max_len);
        }
        return this.rs_max_len;
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setMaxFieldSize( " + n + " )");
        }
        if (n < 0) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        this.rs_max_len = n;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getQueryTimeout(): " + this.timeout);
        }
        return this.timeout;
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setQueryTimeout( " + n + " )");
        }
        if (n < 0) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        this.timeout = n;
    }

    protected synchronized void newBatch() {
        if (this.batch == null) {
            this.batch = new LinkedList();
        }
    }

    protected int getConcurrency(int n) {
        if (n != -1) {
            return n;
        }
        if (this.rs_concur != -1) {
            return this.rs_concur;
        }
        return this.conn.readOnly ? 0 : this.conn.cursor_mode;
    }

    protected int getPreFetchSize() {
        return (this.rslt_items & 1) == 0 ? -1 : (this.rslt_val_fetch < 1 ? 0 : this.rslt_val_fetch);
    }

    protected boolean enableLocators(boolean bl) {
        int n = 1;
        if (this.conn.autoCommit) {
            n |= 2;
        }
        if (bl) {
            n |= 4;
        }
        return (this.conn.cnf_flags & n) == n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JdbcRSMD readResults(int n, boolean bl) throws SQLException {
        JdbcRSMD jdbcRSMD;
        this.enableTimer(n);
        try {
            jdbcRSMD = this.readResults(bl);
        }
        finally {
            this.disableTimer();
            this.timed_out = false;
        }
        return jdbcRSMD;
    }

    protected JdbcRSMD readResults(boolean bl) throws SQLException {
        JdbcRSMD jdbcRSMD = null;
        do {
            JdbcRSMD jdbcRSMD2;
            if ((jdbcRSMD2 = this.readResults()) == null) continue;
            jdbcRSMD = jdbcRSMD2;
        } while (bl && this.msg.moreMessages());
        return jdbcRSMD;
    }

    @Override
    protected JdbcRSMD readDesc() throws SQLException {
        this.disableTimer();
        return JdbcRSMD.load(this.conn);
    }

    protected JdbcRSMD readDesc(JdbcRSMD jdbcRSMD) throws SQLException {
        this.disableTimer();
        if (jdbcRSMD == null) {
            jdbcRSMD = JdbcRSMD.load(this.conn);
        } else {
            jdbcRSMD.reload(this.conn);
        }
        return jdbcRSMD;
    }

    @Override
    protected SQLException readError() throws SQLException {
        this.disableTimer();
        SQLException sQLException = super.readError();
        if (this.timed_out && sQLException != null && sQLException.getErrorCode() == 0xC90009) {
            sQLException = SqlExFactory.get(ERR_GC4006_TIMEOUT);
        }
        return sQLException;
    }

    @Override
    protected boolean readResult() throws SQLException {
        this.disableTimer();
        super.readResult();
        return true;
    }

    private void enableTimer(int n) {
        this.timed_out = false;
        if (n == 0) {
            this.timer = null;
        } else {
            this.timer = new Timer(n, this);
            this.timer.start();
        }
    }

    @Override
    public void timeExpired() {
        if (this.timer != null) {
            this.timed_out = true;
            this.timer = null;
        }
        try {
            this.msg.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void disableTimer() {
        if (this.timer != null) {
            this.timer.interrupt();
            this.timer = null;
        }
    }

    protected static class BatchExec
    extends DrvObj {
        public static final int[] noResults = new int[0];
        private int[] queryResults = noResults;
        private int resultCount = 0;
        private SQLException batchExList = null;
        private SQLException exList = null;

        public BatchExec(DrvConn drvConn) {
            super(drvConn);
            this.title = this.trace.getTraceName() + "-BatchExec[" + this.msg.connID() + "]";
            this.tr_id = "Batch[" + this.msg.connID() + "]";
        }

        public int[] execute(LinkedList linkedList, boolean bl) throws SQLException {
            int n = 0;
            if (linkedList == null || linkedList.peekFirst() == null) {
                return noResults;
            }
            this.clearResults();
            this.msg.lock();
            try {
                String string;
                while ((string = (String)linkedList.pollFirst()) != null) {
                    if (this.trace.enabled()) {
                        this.trace.log(this.title + ".executeBatch[" + n + "]: '" + string + "'");
                    }
                    string = new SqlParse(string, this.conn).parseSQL(bl);
                    ++n;
                    this.msg.begin((byte)12);
                    this.msg.write((short)1);
                    this.writeQueryText(string);
                    this.msg.done(linkedList.peekFirst() == null ? (byte)2 : 4);
                }
                this.readResults(n);
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled()) {
                    this.trace.log(this.title + ".execute(): error executing batch");
                }
                if (this.trace.enabled(1)) {
                    SqlExFactory.trace(sQLException, this.trace);
                }
                throw sQLException;
            }
            finally {
                this.msg.unlock();
            }
            return this.batchResults();
        }

        protected int[] batchResults() throws SQLException {
            int[] nArray;
            if (this.resultCount <= 0) {
                nArray = noResults;
            } else if (this.resultCount >= this.queryResults.length) {
                nArray = this.queryResults;
            } else {
                nArray = new int[this.resultCount];
                System.arraycopy(this.queryResults, 0, nArray, 0, this.resultCount);
            }
            if (this.batchExList != null) {
                BatchUpdateException batchUpdateException = new BatchUpdateException(this.batchExList.getMessage(), this.batchExList.getSQLState(), this.batchExList.getErrorCode(), nArray);
                batchUpdateException.setNextException(this.batchExList.getNextException());
                throw batchUpdateException;
            }
            return nArray;
        }

        protected JdbcRSMD readResults(int n) throws SQLException, XaEx {
            if (n > 0) {
                this.queryResults = new int[n];
            }
            if (this.resultCount < this.queryResults.length) {
                this.queryResults[this.resultCount] = -2;
            }
            JdbcRSMD jdbcRSMD = super.readResults();
            if (this.exList != null) {
                throw this.exList;
            }
            return jdbcRSMD;
        }

        @Override
        protected SQLException readError() throws SQLException {
            SQLException sQLException = super.readError();
            if (sQLException == null || sQLException instanceof XaEx) {
                return sQLException;
            }
            if (this.exList == null) {
                this.exList = sQLException;
            } else {
                this.exList.setNextException(sQLException);
            }
            return null;
        }

        @Override
        protected boolean readResult() throws SQLException {
            boolean bl = super.readResult();
            if (!this.msg.isEndOfBatch()) {
                if (this.msg.moreMessages() && this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ": unexpected RESULT message (not EOG)");
                }
                return bl;
            }
            if (this.resultCount >= this.queryResults.length) {
                if (this.trace.enabled(3)) {
                    if (!this.msg.moreMessages()) {
                        this.trace.write(this.tr_id + ": terminating result marked as batch");
                    } else {
                        this.trace.write(this.tr_id + ": additional batch result received");
                    }
                }
                return bl;
            }
            if (this.exList != null) {
                if (this.batchExList == null) {
                    this.batchExList = this.exList;
                } else {
                    this.batchExList.setNextException(this.exList);
                }
                this.exList = null;
                this.queryResults[this.resultCount] = -3;
            }
            int n = this.getQueryResult();
            if (this.queryResults[this.resultCount] == -2) {
                this.queryResults[this.resultCount] = n;
            }
            if (this.trace.enabled()) {
                switch (this.queryResults[this.resultCount]) {
                    case -2: {
                        this.trace.log(this.title + ".executeBatch[" + this.resultCount + "] = " + "SUCCESS_NO_INFO");
                        break;
                    }
                    case -3: {
                        this.trace.log(this.title + ".executeBatch[" + this.resultCount + "] = " + "EXECUTE_FAILED");
                        break;
                    }
                    default: {
                        this.trace.log(this.title + ".executeBatch[" + this.resultCount + "] = " + this.queryResults[this.resultCount]);
                    }
                }
            }
            if (++this.resultCount < this.queryResults.length) {
                this.queryResults[this.resultCount] = -2;
            }
            if (!this.msg.moreMessages() && this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ": batch result terminates response");
            }
            return bl;
        }

        protected int getQueryResult() {
            if ((this.rslt_items & 8) != 0) {
                this.rslt_items &= 0xFFFFFFF7;
                return this.rslt_val_rowcnt;
            }
            return -2;
        }
    }
}

