/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlExFactory;
import java.math.BigDecimal;
import java.sql.SQLException;

public class SqlDecimal
extends SqlData {
    public static final int PRECISION_MAX_DEFAULT = 31;
    private BigDecimal value = null;
    private boolean truncated = false;
    private int maxPrecision = 31;

    public SqlDecimal() {
        super(true);
    }

    public SqlDecimal(int n) {
        this();
        this.maxPrecision = n;
    }

    public void set(String string) {
        if (string == null) {
            this.setNull();
            this.truncated = false;
        } else if (string.length() > 0) {
            this.value = new BigDecimal(string);
            this.setNotNull();
            this.truncated = false;
        } else {
            this.value = new BigDecimal(0.0);
            this.setNotNull();
            this.truncated = true;
        }
    }

    public void set(SqlDecimal sqlDecimal) {
        if (sqlDecimal == null || sqlDecimal.isNull()) {
            this.setNull();
            this.truncated = false;
        } else {
            this.setNotNull();
            this.value = sqlDecimal.value;
            this.truncated = sqlDecimal.truncated;
        }
    }

    public String get() {
        return this.value.toPlainString();
    }

    @Override
    public boolean isTruncated() {
        return this.truncated;
    }

    @Override
    public void setBoolean(boolean bl) throws SQLException {
        this.setNotNull();
        this.truncated = false;
        this.value = BigDecimal.valueOf(bl ? 1L : 0L);
    }

    @Override
    public void setByte(byte by) throws SQLException {
        this.setNotNull();
        this.truncated = false;
        this.value = BigDecimal.valueOf(by);
    }

    @Override
    public void setShort(short s) throws SQLException {
        this.setNotNull();
        this.truncated = false;
        this.value = BigDecimal.valueOf(s);
    }

    @Override
    public void setInt(int n) throws SQLException {
        this.setNotNull();
        this.truncated = false;
        this.value = BigDecimal.valueOf(n);
    }

    @Override
    public void setLong(long l) throws SQLException {
        this.setNotNull();
        this.truncated = false;
        this.value = BigDecimal.valueOf(l);
    }

    @Override
    public void setFloat(float f) throws SQLException {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(f);
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        this.value = this.checkPrecision(bigDecimal);
        this.setNotNull();
        this.truncated = false;
    }

    @Override
    public void setDouble(double d) throws SQLException {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(d);
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        this.value = this.checkPrecision(bigDecimal);
        this.setNotNull();
        this.truncated = false;
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.value = this.checkPrecision(bigDecimal);
            this.setNotNull();
        }
        this.truncated = false;
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal, int n) throws SQLException {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            bigDecimal = bigDecimal.setScale(n, 4);
            this.value = this.checkPrecision(bigDecimal);
            this.setNotNull();
        }
        this.truncated = false;
    }

    @Override
    protected void setScale(int n) throws SQLException {
        if (this.value != null) {
            this.value = this.value.scale() < n ? this.checkPrecision(this.value.setScale(n, 4)) : this.value.setScale(n, 4);
        }
    }

    @Override
    public void setString(String string) throws SQLException {
        if (string == null) {
            this.setNull();
        } else {
            BigDecimal bigDecimal;
            try {
                bigDecimal = new BigDecimal(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
            this.value = this.checkPrecision(bigDecimal);
            this.setNotNull();
        }
        this.truncated = false;
    }

    @Override
    public boolean getBoolean() throws SQLException {
        return this.value.signum() != 0;
    }

    @Override
    public byte getByte() throws SQLException {
        return this.value.byteValue();
    }

    @Override
    public short getShort() throws SQLException {
        return this.value.shortValue();
    }

    @Override
    public int getInt() throws SQLException {
        return this.value.intValue();
    }

    @Override
    public long getLong() throws SQLException {
        return this.value.longValue();
    }

    @Override
    public float getFloat() throws SQLException {
        return this.value.floatValue();
    }

    @Override
    public double getDouble() throws SQLException {
        return this.value.doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        return this.value;
    }

    @Override
    public String getString() throws SQLException {
        return this.value.toPlainString();
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getBigDecimal();
    }

    private BigDecimal checkPrecision(BigDecimal bigDecimal) throws SQLException {
        int n;
        int n2 = bigDecimal.unscaledValue().toString().length() - (bigDecimal.signum() < 0 ? 1 : 0);
        int n3 = Math.max(n2, n = bigDecimal.scale()) - this.maxPrecision;
        if (n3 > 0) {
            if (n >= n3) {
                bigDecimal = bigDecimal.setScale(n - n3, 4);
            } else {
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
        }
        return bigDecimal;
    }
}

