/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvLOB;
import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.SqlStream;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

class DrvClob
extends DrvLOB
implements Clob,
DbmsConst {
    public DrvClob(DrvConn drvConn, int n) {
        super(drvConn, (short)36, n);
        this.title = this.trace.getTraceName() + "-Clob[" + n + "]";
        this.tr_id = "DrvClob[" + n + "]";
    }

    @Override
    public void free() throws SQLException {
        super.free();
    }

    @Override
    public long length() throws SQLException {
        this.isValid();
        return super.length();
    }

    @Override
    public String getSubString(long l, int n) throws SQLException {
        this.isValid();
        return super.getChars(l, n, n <= this.conn.max_vchr_len);
    }

    @Override
    public long position(String string, long l) throws SQLException {
        if (string == null) {
            throw new NullPointerException();
        }
        this.isValid();
        long l2 = super.position(string, l);
        return l2 >= 1L ? l2 : -1L;
    }

    @Override
    public long position(Clob clob, long l) throws SQLException {
        if (clob == null) {
            throw new NullPointerException();
        }
        long l2 = -1L;
        this.isValid();
        l2 = clob instanceof DrvLOB && this.hasSameDomain((DrvLOB)((Object)clob)) ? this.position((DrvLOB)((Object)clob), l) : super.position(clob.getCharacterStream(), l);
        return l2 >= 1L ? l2 : -1L;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        InputStreamReader inputStreamReader;
        this.isValid();
        boolean bl = (this.conn.cnf_flags & 8) == 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(super.getByteStream(bl), this.conn.cnf_lob_segSize);
        try {
            inputStreamReader = this.msg.getCharSet().getISR(bufferedInputStream);
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
        }
        return SqlStream.getAsciiIS(inputStreamReader);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        InputStreamReader inputStreamReader;
        this.isValid();
        boolean bl = (this.conn.cnf_flags & 8) == 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(super.getByteStream(bl), this.conn.cnf_lob_segSize);
        try {
            inputStreamReader = this.msg.getCharSet().getISR(bufferedInputStream);
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
        }
        return inputStreamReader;
    }

    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        InputStreamReader inputStreamReader;
        this.isValid();
        if (l < 1L || l2 < 0L) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        boolean bl = (this.conn.cnf_flags & 8) == 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(super.getByteStream(bl, l, l2), this.conn.cnf_lob_segSize);
        try {
            inputStreamReader = this.msg.getCharSet().getISR(bufferedInputStream);
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
        }
        return inputStreamReader;
    }

    public Reader get() throws SQLException {
        InputStreamReader inputStreamReader;
        this.isValid();
        try {
            inputStreamReader = this.msg.getCharSet().getISR(super.getByteStream(false));
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
        }
        return inputStreamReader;
    }

    @Override
    public int setString(long l, String string) throws SQLException {
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public int setString(long l, String string, int n, int n2) throws SQLException {
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public OutputStream setAsciiStream(long l) throws SQLException {
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public Writer setCharacterStream(long l) throws SQLException {
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void truncate(long l) throws SQLException {
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }
}

