/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.dam;

import com.ingres.gcf.dam.IoBuff;
import com.ingres.gcf.util.ByteArray;
import com.ingres.gcf.util.CharSet;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.IdMap;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.TraceLog;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.concurrent.Executor;

class InBuff
extends IoBuff
implements GcfErr {
    protected byte[] buffer;
    private byte[] compBuff = null;
    private static final short IEEE754_F4_BIAS = 127;
    private static final short IEEE754_F4_EXP_MIN = 0;
    private static final short IEEE754_F4_EXP_MAX = 255;
    private static final short NTS_F4_BIAS = 16382;
    private static final short NTS_F4_EXP_MIN = 0;
    private static final short NTS_F4_EXP_MAX = Short.MAX_VALUE;
    private static final short IEEE754_F8_BIAS = 1023;
    private static final short IEEE754_F8_EXP_MIN = 0;
    private static final short IEEE754_F8_EXP_MAX = 2047;
    private static final short NTS_F8_BIAS = 16382;
    private static final short NTS_F8_EXP_MIN = 0;
    private static final short NTS_F8_EXP_MAX = Short.MAX_VALUE;

    public InBuff(InputStream inputStream, int n, int n2, TraceLog traceLog) {
        super(inputStream, traceLog);
        this.title = "InBuff[" + n + "]";
        this.setBuffSize(n2);
        this.buffer = ((IoBuff)this).buffer;
    }

    public Executor getTimeoutExecutor() {
        return this.timeoutExecutor;
    }

    public void setTimeoutAction(Executor executor, Runnable runnable) {
        this.timeoutExecutor = executor;
        this.timeoutAction = runnable;
    }

    public short receive() throws SQLException {
        this.next();
        this.buffer = ((IoBuff)this).buffer;
        int n = this.data_ptr;
        int n2 = this.data_end - this.data_ptr;
        int n3 = this.readInt();
        if (this.proto_lvl <= 1 && n3 != 1280590666 || this.proto_lvl >= 2 && n3 != 1280593220) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": invalid TL header ID");
            }
            this.close();
            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
        }
        int n4 = this.readShort();
        if (n4 != 17475) {
            if (this.compress != null && this.trace.enabled(3) && !this.trace.enabled(4)) {
                this.trace.write(this.title + ": uncompressed packet " + n2 + " bytes.");
                this.trace.hexdump(this.buffer, n, n2);
            }
        } else {
            int n5;
            int n6 = this.data_end - this.data_ptr;
            if (this.compress == null) {
                this.close();
                throw SqlExFactory.get(ERR_GC400E_COMPRESS_NOT_ENABLED);
            }
            if (this.compBuff == null) {
                this.compBuff = new byte[this.buffer.length];
            }
            if ((n5 = this.compress.decompress(this.buffer, this.data_ptr, n6, this.compBuff, 0, this.compBuff.length)) <= 0) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": decompression failure: " + n5);
                }
                this.close();
                throw SqlExFactory.get(ERR_GC400F_DECOMPRESS_FAIL);
            }
            if (this.trace.enabled(2)) {
                this.trace.write(this.title + ": decompressed " + n6 + " bytes to " + n5 + " (" + (double)n6 / (double)n5 + ")");
            }
            if (this.trace.enabled(3)) {
                this.trace.hexdump(this.compBuff, 0, n5);
            }
            this.buffer = this.compBuff;
            this.data_ptr = 0;
            this.data_beg = 0;
            this.data_end = n5;
            n4 = 21572;
        }
        if (this.trace.enabled(2)) {
            this.trace.write(this.title + ": received TL packet " + IdMap.map(n4, tlMap) + " (length " + this.avail() + ")");
        }
        return (short)n4;
    }

    public int avail() {
        return this.data_end - this.data_ptr;
    }

    public byte readByte() throws SQLException {
        this.need(1, true);
        return this.buffer[this.data_ptr++];
    }

    public short readShort() throws SQLException {
        this.need(2, true);
        return (short)(this.buffer[this.data_ptr++] & 0xFF | this.buffer[this.data_ptr++] << 8 & 0xFF00);
    }

    public int readInt() throws SQLException {
        this.need(4, true);
        return this.buffer[this.data_ptr++] & 0xFF | this.buffer[this.data_ptr++] << 8 & 0xFF00 | this.buffer[this.data_ptr++] << 16 & 0xFF0000 | this.buffer[this.data_ptr++] << 24 & 0xFF000000;
    }

    public long readLong() throws SQLException {
        this.need(8, true);
        return (long)this.buffer[this.data_ptr++] & 0xFFL | (long)this.buffer[this.data_ptr++] << 8 & 0xFF00L | (long)this.buffer[this.data_ptr++] << 16 & 0xFF0000L | (long)this.buffer[this.data_ptr++] << 24 & 0xFF000000L | (long)this.buffer[this.data_ptr++] << 32 & 0xFF00000000L | (long)this.buffer[this.data_ptr++] << 40 & 0xFF0000000000L | (long)this.buffer[this.data_ptr++] << 48 & 0xFF000000000000L | (long)this.buffer[this.data_ptr++] << 56 & 0xFF00000000000000L;
    }

    public float readFloat() throws SQLException {
        this.need(6, true);
        byte by = (byte)(this.buffer[this.data_ptr + 1] >>> 7 & 1);
        short s = (short)(this.buffer[this.data_ptr + 1] << 8 & 0x7F00 | this.buffer[this.data_ptr + 0] & 0xFF);
        int n = this.buffer[this.data_ptr + 3] << 24 & 0xFF000000 | this.buffer[this.data_ptr + 2] << 16 & 0xFF0000 | this.buffer[this.data_ptr + 5] << 8 & 0xFF00 | this.buffer[this.data_ptr + 4] & 0xFF;
        this.data_ptr += 6;
        int n2 = s - 16383;
        n2 = (short)(n2 + 127);
        if (s == 0) {
            n2 = 0;
        } else if (s == Short.MAX_VALUE) {
            n2 = n == -1 ? 254 : 255;
        } else if (n2 <= 0) {
            n2 = 1;
            n = 0;
        } else if (n2 >= 255) {
            n2 = 254;
            n = -1;
        }
        int n3 = by << 31 & Integer.MIN_VALUE | n2 << 23 & 0x7F800000 | n >>> 9 & 0x7FFFFF;
        return Float.intBitsToFloat(n3);
    }

    public double readDouble() throws SQLException {
        this.need(10, true);
        byte by = (byte)(this.buffer[this.data_ptr + 1] >>> 7 & 1);
        short s = (short)(this.buffer[this.data_ptr + 1] << 8 & 0x7F00 | this.buffer[this.data_ptr + 0] & 0xFF);
        long l = (long)this.buffer[this.data_ptr + 3] << 56 & 0xFF00000000000000L | (long)this.buffer[this.data_ptr + 2] << 48 & 0xFF000000000000L | (long)this.buffer[this.data_ptr + 5] << 40 & 0xFF0000000000L | (long)this.buffer[this.data_ptr + 4] << 32 & 0xFF00000000L | (long)this.buffer[this.data_ptr + 7] << 24 & 0xFF000000L | (long)this.buffer[this.data_ptr + 6] << 16 & 0xFF0000L | (long)this.buffer[this.data_ptr + 9] << 8 & 0xFF00L | (long)this.buffer[this.data_ptr + 8] & 0xFFL;
        this.data_ptr += 10;
        int n = s - 16383;
        n = (short)(n + 1023);
        if (s == 0) {
            n = 0;
        } else if (s == Short.MAX_VALUE) {
            n = l == -1L ? 2046 : 2047;
        } else if (n <= 0) {
            n = 1;
            l = 0L;
        } else if (n >= 2047) {
            n = 2046;
            l = -1L;
        }
        long l2 = (long)by << 63 & Long.MIN_VALUE | (long)n << 52 & 0x7FF0000000000000L | l >>> 12 & 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(l2);
    }

    public int readBytes(byte[] byArray, int n, int n2) throws SQLException {
        this.need(n2, false);
        n2 = Math.min(n2, this.avail());
        System.arraycopy(this.buffer, this.data_ptr, byArray, n, n2);
        this.data_ptr += n2;
        return n2;
    }

    public int readBytes(ByteArray byteArray, int n) throws SQLException {
        this.need(n, false);
        n = Math.min(n, this.avail());
        byteArray.put(this.buffer, this.data_ptr, n);
        this.data_ptr += n;
        return n;
    }

    public String readString(int n, CharSet charSet) throws SQLException {
        String string;
        this.need(n, true);
        try {
            string = charSet.getString(this.buffer, this.data_ptr, n);
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
        }
        this.data_ptr += n;
        return string;
    }

    public int skip(int n) throws SQLException {
        this.need(n, false);
        n = Math.min(n, this.avail());
        this.data_ptr += n;
        return n;
    }

    private void need(int n, boolean bl) throws SQLException {
        int n2;
        while ((n2 = this.avail()) < n) {
            if (n2 > 0) {
                if (!bl) break;
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": atomic value split (" + n2 + "," + n + ")");
                }
                this.close();
                throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
            }
            short s = this.receive();
            if (s == 21572) continue;
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": invalid TL packet ID 0x" + Integer.toHexString(s));
            }
            this.close();
            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
        }
        if (this.trace.enabled(4)) {
            if (n2 < n) {
                this.trace.write(this.title + ": reading " + n2 + " (" + n + " requested)");
            } else {
                this.trace.write(this.title + ": reading " + n);
            }
        }
    }
}

