/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.dam;

import com.ingres.gcf.dam.InBuff;
import com.ingres.gcf.dam.MsgConst;
import com.ingres.gcf.dam.MsgIo;
import com.ingres.gcf.dam.MsgOut;
import com.ingres.gcf.dam.TlConst;
import com.ingres.gcf.util.ByteArray;
import com.ingres.gcf.util.CharArray;
import com.ingres.gcf.util.CharSet;
import com.ingres.gcf.util.Compress;
import com.ingres.gcf.util.Config;
import com.ingres.gcf.util.Crypto;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.IdMap;
import com.ingres.gcf.util.IngresDate;
import com.ingres.gcf.util.SqlBigInt;
import com.ingres.gcf.util.SqlBool;
import com.ingres.gcf.util.SqlByte;
import com.ingres.gcf.util.SqlChar;
import com.ingres.gcf.util.SqlDate;
import com.ingres.gcf.util.SqlDecimal;
import com.ingres.gcf.util.SqlDouble;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.SqlInt;
import com.ingres.gcf.util.SqlLoc;
import com.ingres.gcf.util.SqlLongByte;
import com.ingres.gcf.util.SqlLongByteCache;
import com.ingres.gcf.util.SqlLongChar;
import com.ingres.gcf.util.SqlLongCharCache;
import com.ingres.gcf.util.SqlLongNChar;
import com.ingres.gcf.util.SqlLongNCharCache;
import com.ingres.gcf.util.SqlNChar;
import com.ingres.gcf.util.SqlNVarChar;
import com.ingres.gcf.util.SqlNull;
import com.ingres.gcf.util.SqlReal;
import com.ingres.gcf.util.SqlSmallInt;
import com.ingres.gcf.util.SqlStream;
import com.ingres.gcf.util.SqlTime;
import com.ingres.gcf.util.SqlTimestamp;
import com.ingres.gcf.util.SqlTinyInt;
import com.ingres.gcf.util.SqlVarByte;
import com.ingres.gcf.util.SqlVarChar;
import com.ingres.gcf.util.Trace;
import com.ingres.gcf.util.TraceLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.concurrent.Executor;

class MsgIn
extends MsgOut
implements TlConst,
MsgConst,
GcfErr {
    private InBuff in = null;
    private Runnable timeoutAction = null;
    private static String empty = "";
    private static byte[] no_params = new byte[0];
    private byte in_msg_id = 0;
    private short in_msg_len = 0;
    private byte in_msg_flg = 0;
    private byte pb_msg_id = 0;
    private short pb_msg_len = 0;
    private byte pb_msg_flg = 0;

    protected MsgIn(Config config, TraceLog traceLog) throws SQLException {
        super(config, traceLog);
        this.title = "MsgIn[" + this.connID() + "]";
    }

    @Override
    protected void connect(String string, String string2) throws SQLException {
        super.connect(string, string2);
        try {
            this.in = new InBuff(this.socket.getInputStream(), this.connID(), 1024, this.trace.getTraceLog());
        }
        catch (Exception exception) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": error creating input buffer: " + exception.getMessage());
            }
            this.disconnect();
            throw SqlExFactory.get(ERR_GC4001_CONNECT_ERR, exception);
        }
    }

    protected byte[] recvCC() throws SQLException {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4;
        int n;
        int n2;
        int n3;
        Compress compress;
        block110: {
            String string;
            block109: {
                string = null;
                compress = null;
                int n4 = -1;
                n3 = 10;
                n2 = 0;
                n = 0;
                byArray4 = no_params;
                byArray3 = null;
                byArray2 = null;
                byArray = null;
                int n5 = 0;
                if (this.trace.enabled(3)) {
                    this.trace.write(this.title + ": confirm TL connect");
                }
                try {
                    short s = this.in.receive();
                    switch (s) {
                        case 17219: {
                            break;
                        }
                        case 21060: {
                            this.serverDisconnect();
                            return no_params;
                        }
                        default: {
                            if (this.trace.enabled(1)) {
                                this.trace.write(this.title + ": invalid TL CC packet ID " + s);
                            }
                            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                        }
                    }
                    block61: while (this.in.avail() >= 2) {
                        byte by = this.in.readByte();
                        int n6 = this.in.readByte();
                        if ((n6 &= 0xFF) == 255) {
                            if (this.in.avail() < 2) {
                                throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                            }
                            n6 = this.in.readShort();
                            n6 &= 0xFFFF;
                        }
                        if (this.in.avail() < n6) {
                            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                        }
                        switch (by) {
                            case 1: {
                                switch (n6) {
                                    case 1: {
                                        this.tl_proto_lvl = this.in.readByte();
                                        break;
                                    }
                                    case 2: {
                                        this.tl_proto_lvl = (byte)this.in.readShort();
                                        break;
                                    }
                                    case 4: {
                                        this.tl_proto_lvl = (byte)this.in.readInt();
                                        break;
                                    }
                                    case 8: {
                                        this.tl_proto_lvl = (byte)this.in.readLong();
                                        break;
                                    }
                                    default: {
                                        throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                                    }
                                }
                                if (!this.trace.enabled(3)) continue block61;
                                this.trace.write("    TL protocol level  : " + this.tl_proto_lvl);
                                continue block61;
                            }
                            case 13: {
                                switch (n6) {
                                    case 1: {
                                        n = this.in.readByte();
                                        break;
                                    }
                                    case 2: {
                                        n = this.in.readShort();
                                        break;
                                    }
                                    case 4: {
                                        n = this.in.readInt();
                                        break;
                                    }
                                    case 8: {
                                        n = (int)this.in.readLong();
                                        break;
                                    }
                                    default: {
                                        throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                                    }
                                }
                                if (!this.trace.enabled(3)) continue block61;
                                this.trace.write("    TL connection flags: " + n);
                                continue block61;
                            }
                            case 2: {
                                switch (n6) {
                                    case 1: {
                                        n3 = this.in.readByte();
                                        break;
                                    }
                                    case 2: {
                                        n3 = this.in.readShort();
                                        break;
                                    }
                                    case 4: {
                                        n3 = this.in.readInt();
                                        break;
                                    }
                                    case 8: {
                                        n3 = (int)this.in.readLong();
                                        break;
                                    }
                                    default: {
                                        throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                                    }
                                }
                                if (!this.trace.enabled(3)) continue block61;
                                this.trace.write("    TL buffer size     : " + (1 << n3));
                                continue block61;
                            }
                            case 4: {
                                byte[] byArray5 = new byte[n6];
                                if (this.in.readBytes(byArray5, 0, n6) == n6) {
                                    try {
                                        string = new String(byArray5, "US-ASCII");
                                    }
                                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                                        throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
                                    }
                                } else {
                                    throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                                }
                                if (!this.trace.enabled(3)) continue block61;
                                this.trace.write("    TL character-set   : " + string);
                                continue block61;
                            }
                            case 5: {
                                if (this.tl_proto_lvl < 2) {
                                    throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                                }
                                switch (n6) {
                                    case 1: {
                                        n4 = this.in.readByte();
                                        break;
                                    }
                                    case 2: {
                                        n4 = this.in.readShort();
                                        break;
                                    }
                                    case 4: {
                                        n4 = this.in.readInt();
                                        break;
                                    }
                                    case 8: {
                                        n4 = (int)this.in.readLong();
                                        break;
                                    }
                                    default: {
                                        throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                                    }
                                }
                                if (!this.trace.enabled(3)) continue block61;
                                this.trace.write("    TL character-set ID: " + n4);
                                continue block61;
                            }
                            case 3: {
                                byArray4 = new byte[n6];
                                if (this.in.readBytes(byArray4, 0, n6) != n6) {
                                    throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                                }
                                if (!this.trace.enabled(3)) continue block61;
                                this.trace.write("    MSG connection parm: " + byArray4.length + " bytes");
                                continue block61;
                            }
                            case 6: {
                                if (n6 == 4 && this.in.readInt() == 0x4C4D4D44) continue block61;
                                throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                            }
                            case 12: {
                                switch (n6) {
                                    case 1: {
                                        n5 = this.in.readByte();
                                        break;
                                    }
                                    case 2: {
                                        n5 = (byte)this.in.readShort();
                                        break;
                                    }
                                    case 4: {
                                        n5 = (byte)this.in.readInt();
                                        break;
                                    }
                                    case 8: {
                                        n5 = (byte)this.in.readLong();
                                        break;
                                    }
                                    default: {
                                        throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                                    }
                                }
                                if (!this.trace.enabled(3)) continue block61;
                                this.trace.write("    TL compression mode: " + n5);
                                continue block61;
                            }
                            case 7: {
                                if (this.aesKeySize < 128) {
                                    if (this.in.skip(n6) == n6) continue block61;
                                    throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                                }
                                byArray3 = new byte[n6];
                                if (this.in.readBytes(byArray3, 0, n6) != n6) {
                                    throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                                }
                                if (!this.trace.enabled(3)) continue block61;
                                this.trace.write("    RSA public key     : " + byArray3.length + " bytes");
                                continue block61;
                            }
                            case 10: {
                                if (this.aesKeySize < 256) {
                                    throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                                }
                                n2 = 256;
                                if (n6 > 0) {
                                    byArray2 = new byte[n6];
                                    if (this.in.readBytes(byArray2, 0, n6) != n6) {
                                        throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                                    }
                                    if (!this.trace.enabled(3)) continue block61;
                                    this.trace.write("    AES key (256)      : " + byArray2.length + " bytes");
                                    continue block61;
                                }
                                if (!this.trace.enabled(3)) continue block61;
                                this.trace.write("    AES key size       : " + n2);
                                continue block61;
                            }
                            case 9: {
                                if (this.aesKeySize < 192) {
                                    throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                                }
                                n2 = 192;
                                if (n6 > 0) {
                                    byArray2 = new byte[n6];
                                    if (this.in.readBytes(byArray2, 0, n6) != n6) {
                                        throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                                    }
                                    if (!this.trace.enabled(3)) continue block61;
                                    this.trace.write("    AES key (192)      : " + byArray2.length + " bytes");
                                    continue block61;
                                }
                                if (!this.trace.enabled(3)) continue block61;
                                this.trace.write("    AES key size       : " + n2);
                                continue block61;
                            }
                            case 8: {
                                if (this.aesKeySize < 128) {
                                    throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                                }
                                n2 = 128;
                                if (n6 > 0) {
                                    byArray2 = new byte[n6];
                                    if (this.in.readBytes(byArray2, 0, n6) != n6) {
                                        throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                                    }
                                    if (!this.trace.enabled(3)) continue block61;
                                    this.trace.write("    AES key (128)      : " + byArray2.length + " bytes");
                                    continue block61;
                                }
                                if (!this.trace.enabled(3)) continue block61;
                                this.trace.write("    AES key size       : " + n2);
                                continue block61;
                            }
                            case 11: {
                                byArray = new byte[n6];
                                if (this.in.readBytes(byArray, 0, n6) != n6) {
                                    throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                                }
                                if (!this.trace.enabled(3)) continue block61;
                                this.trace.write("    AES IV             : " + byArray.length + " bytes");
                                continue block61;
                            }
                        }
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.title + ": Bad TL CC param ID: " + by);
                        }
                        throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                    }
                    if (this.in.avail() > 0) {
                        throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                    }
                    if (this.tl_proto_lvl < 1 || this.tl_proto_lvl > 3 || n3 < 10 || n3 > 15) {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.title + ": invalid TL parameter: protocol " + this.tl_proto_lvl + ", size " + n3);
                        }
                        throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                    }
                    if (this.encryptMode == MsgIo.EncryptMode.ON && byArray2 == null) {
                        if (this.trace.enabled(1)) {
                            if (this.tl_proto_lvl < 3) {
                                this.trace.write(this.title + ": server doesn't support encryption");
                            } else {
                                this.trace.write(this.title + ": No TL encryption parameter");
                            }
                        }
                        throw SqlExFactory.get(ERR_GC400A_NO_ENCRYPTION);
                    }
                    switch (n5) {
                        case 0: {
                            if (this.compMode == MsgIo.CompMode.ON) {
                                if (this.trace.enabled(1)) {
                                    this.trace.write(this.title + ": server doesn't support compression");
                                }
                                throw SqlExFactory.get(ERR_GC400D_NO_COMPRESSION);
                            }
                            break;
                        }
                        case 1: {
                            if (this.compMode == MsgIo.CompMode.OFF) {
                                if (this.trace.enabled(1)) {
                                    this.trace.write(this.title + ": server wrongly enabled compression");
                                }
                                throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                            }
                            this.compressed = true;
                            break;
                        }
                        default: {
                            if (this.trace.enabled(1)) {
                                this.trace.write(this.title + ": invalid compression ID: " + n5);
                            }
                            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.title + ": error negotiating parameters");
                    }
                    this.disconnect();
                    throw sQLException;
                }
                if (n4 >= 0) {
                    try {
                        this.char_set = CharSet.getCharSet(n4);
                    }
                    catch (Exception exception) {
                        if (!this.trace.enabled(1)) break block109;
                        this.trace.write(this.title + ": unknown character-set: " + n4);
                    }
                }
            }
            if (this.char_set == null && string != null) {
                try {
                    this.char_set = CharSet.getCharSet(string);
                }
                catch (Exception exception) {
                    if (!this.trace.enabled(1)) break block110;
                    this.trace.write(this.title + ": unknown character-set: " + string);
                }
            }
        }
        if (n3 != 10) {
            this.setBuffSize(1 << n3);
        }
        this.setIoProtoLvl(this.tl_proto_lvl);
        if (this.encryptMode == MsgIo.EncryptMode.ON) {
            Crypto.AESKey aESKey = Crypto.importAESKey(this.rsaKey, byArray2);
            aESKey.setIV(byArray);
            this.aesKeySize = n2;
            this.rsaKey = null;
            this.startEncryption(aESKey);
        } else if (byArray3 != null) {
            this.aesKeySize = n2 > 0 ? n2 : 128;
            this.rsaKey = Crypto.importRSAKey(byArray3);
            this.encryptMode = (n & 1) != 0 ? MsgIo.EncryptMode.SERVER : MsgIo.EncryptMode.ENHANCED;
        }
        if (this.compressed) {
            compress = Compress.getInstance(Compress.CompressionAlgorithm.DEFAULT, 1 << n3);
            this.startCompression(compress);
        }
        if (this.trace.enabled(2)) {
            this.trace.write(this.title + ": TL connection opened");
        }
        if (this.trace.enabled(3)) {
            this.trace.write("    Character encoding : " + this.char_set);
            if (this.compressed) {
                this.trace.write("    Compression enabled: " + compress.getName());
            }
            if (this.encryptMode == MsgIo.EncryptMode.ON) {
                this.trace.write("    Encryption enabled : AES " + this.aesKeySize);
            }
        }
        return byArray4;
    }

    @Override
    protected void disconnect() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.disconnect();
    }

    @Override
    protected void close() {
        block9: {
            super.close();
            try {
                if (this.trace.enabled(3)) {
                    this.trace.write(this.title + ": confirm TL disconnect");
                }
                block6: while (true) {
                    switch (this.in.receive()) {
                        case 17220: {
                            break block6;
                        }
                        case 21060: {
                            this.serverDisconnect();
                        }
                        default: {
                            continue block6;
                        }
                    }
                    break;
                }
                if (this.trace.enabled(2)) {
                    this.trace.write(this.title + ": TL connection closed");
                }
            }
            catch (SQLException sQLException) {
                if (!this.trace.enabled(2)) break block9;
                this.trace.write(this.title + ": TL connection aborted");
            }
        }
    }

    @Override
    protected void setBuffSize(int n) {
        this.in.setBuffSize(n);
        super.setBuffSize(n);
    }

    @Override
    protected void setIoProtoLvl(byte by) {
        this.in.setProtoLvl(by);
        super.setIoProtoLvl(by);
    }

    @Override
    public void startEncryption(Crypto.AESKey aESKey) throws SQLException {
        this.in.setEncryption(Crypto.initAESSession(aESKey, false));
        super.startEncryption(aESKey);
    }

    @Override
    protected void startCompression(Compress compress) throws SQLException {
        this.in.setCompression(compress);
        super.startCompression(compress);
    }

    /*
     * Unable to fully structure code
     */
    private void serverDisconnect() throws SQLException {
        var1_1 = 0;
        var2_2 = null;
        while (this.in.avail() >= 2) {
            var3_3 = this.in.readByte();
            var4_5 = this.in.readByte();
            if ((var4_5 &= 255) == 255) {
                var4_5 = this.in.avail() >= 2 ? (int)this.in.readShort() : 0;
                var4_5 &= 65535;
            }
            if (var4_5 > this.in.avail()) {
                if (!this.trace.enabled(1)) break;
                this.trace.write(this.title + ": param length " + var4_5 + " exceeds data available " + this.in.avail());
                break;
            }
            switch (var3_3) {
                case 1: {
                    if (var4_5 == 4) {
                        var1_1 = this.in.readInt();
                        if (!this.trace.enabled(1)) break;
                        this.trace.write(this.title + ": server error 0x" + Integer.toHexString(var1_1));
                        break;
                    }
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.title + ": invalid error code length " + var4_5);
                    }
                    this.in.skip(var4_5);
                    break;
                }
                case 2: {
                    if (var4_5 <= 0) ** GOTO lbl33
                    try {
                        var2_2 = this.in.readString(var4_5, CharSet.getCharSet("ASCII"));
                    }
                    catch (UnsupportedEncodingException var5_6) {
                        if (!this.trace.enabled(1)) ** GOTO lbl33
                        this.trace.write(this.title + ": can't load ASCII char-set");
                    }
lbl33:
                    // 4 sources

                    if (!this.trace.enabled(1)) break;
                    this.trace.write(this.title + ": server error '" + var2_2 + "'");
                }
            }
        }
        if (var1_1 != 0) {
            if (var2_2 != null) {
                throw new SQLException(var2_2, "50000", var1_1);
            }
            switch (var1_1) {
                case 802824: {
                    throw SqlExFactory.get(MsgIn.ERR_GC4008_SERVER_ABORT);
                }
                case 804878: {
                    throw SqlExFactory.get(MsgIn.ERR_GC480E_CLIENT_MAX);
                }
                case 804895: {
                    throw SqlExFactory.get(MsgIn.ERR_GC481F_SVR_CLOSED);
                }
            }
            var3_4 = SqlExFactory.get(MsgIn.ERR_GC4008_SERVER_ABORT);
            throw new SQLException(var3_4.getMessage(), var3_4.getSQLState(), var1_1);
        }
        if (this.trace.enabled(1)) {
            this.trace.write(this.title + ": server abort");
        }
        throw SqlExFactory.get(MsgIn.ERR_GC4008_SERVER_ABORT);
    }

    public Executor getTimeoutExecutor() {
        return this.in.getTimeoutExecutor();
    }

    public void setNetworkTimeout(Executor executor, int n) {
        if (this.timeoutAction == null) {
            this.timeoutAction = new Runnable(){

                @Override
                public void run() {
                    MsgIn.this.disconnect();
                }
            };
        }
        this.in.setTimeoutAction(executor, this.timeoutAction);
        this.setNetworkTimeout(n);
    }

    public byte receive() throws SQLException {
        if (this.pb_msg_id != 0) {
            this.in_msg_id = this.pb_msg_id;
            this.in_msg_len = this.pb_msg_len;
            this.in_msg_flg = this.pb_msg_flg;
            this.pb_msg_id = 0;
            if (this.trace.enabled(2)) {
                this.trace.write(this.title + ": using message " + IdMap.map(this.in_msg_id, msgMap) + " length " + this.in_msg_len + ((this.in_msg_flg & 1) == 0 ? "" : " EOD") + ((this.in_msg_flg & 4) == 0 ? "" : " EOB") + ((this.in_msg_flg & 2) == 0 ? "" : " EOG"));
            }
            return this.in_msg_id;
        }
        if (this.trace.enabled(3)) {
            this.trace.write(this.title + ": check TL data");
        }
        block6: while (this.in.avail() < 8) {
            try {
                if (this.in.avail() > 0) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.title + ": invalid header length " + this.in.avail() + " bytes");
                    }
                    throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                }
                short s = this.in.receive();
                switch (s) {
                    case 21572: {
                        continue block6;
                    }
                    case 21060: {
                        this.serverDisconnect();
                        continue block6;
                    }
                }
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": invalid TL packet ID 0x" + Integer.toHexString(s));
                }
                throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
            }
            catch (SQLException sQLException) {
                this.disconnect();
                throw sQLException;
            }
        }
        int n = this.in.readInt();
        if (this.msg_proto_lvl < 3 && n != 1128416330 || this.msg_proto_lvl >= 3 && n != 0x4C4D4D44) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": invalid header ID 0x" + Integer.toHexString(n));
            }
            this.disconnect();
            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
        }
        this.in_msg_len = this.in.readShort();
        this.in_msg_id = this.in.readByte();
        this.in_msg_flg = this.in.readByte();
        if (this.trace.enabled(2)) {
            this.trace.write(this.title + ": received message " + IdMap.map(this.in_msg_id, msgMap) + " length " + this.in_msg_len + ((this.in_msg_flg & 1) == 0 ? "" : " EOD") + ((this.in_msg_flg & 4) == 0 ? "" : " EOB") + ((this.in_msg_flg & 2) == 0 ? "" : " EOG"));
        }
        return this.in_msg_id;
    }

    public void pushback() {
        if (this.trace.enabled(2)) {
            this.trace.write(this.title + ": saving current message ");
        }
        this.pb_msg_id = this.in_msg_id;
        this.pb_msg_len = this.in_msg_len;
        this.pb_msg_flg = this.in_msg_flg;
        this.in_msg_id = 0;
        this.in_msg_len = 0;
        this.in_msg_flg = 0;
    }

    public boolean moreData() throws SQLException {
        byte by = this.in_msg_id;
        if (this.pb_msg_id != 0) {
            return false;
        }
        while (this.in_msg_len <= 0 && (this.in_msg_flg & 1) == 0) {
            if (this.receive() == by) continue;
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": invalid message continuation " + by + " to " + this.in_msg_id);
            }
            this.disconnect();
            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
        }
        return this.in_msg_len > 0;
    }

    public boolean isEndOfBatch() {
        return (this.in_msg_flg & 4) != 0;
    }

    public boolean moreMessages() {
        return (this.in_msg_flg & 2) == 0;
    }

    public void skip() throws SQLException {
        if (this.trace.enabled(4)) {
            this.trace.write(this.title + ": skipping remainder of message");
        }
        do {
            this.skip(this.in_msg_len);
        } while (this.moreData());
    }

    public int skip(int n) throws SQLException {
        int n2 = 0;
        if (this.trace.enabled(4)) {
            this.trace.write(this.title + ": skipping " + n + " bytes");
        }
        while (n > 0) {
            this.need(n, false);
            int n3 = Math.min(this.in_msg_len, n);
            n3 = this.in.skip(n3);
            n -= n3;
            this.in_msg_len = (short)(this.in_msg_len - n3);
            n2 += n3;
        }
        return n2;
    }

    public byte readByte() throws SQLException {
        this.need(1, true);
        this.in_msg_len = (short)(this.in_msg_len - 1);
        return this.in.readByte();
    }

    public short readShort() throws SQLException {
        this.need(2, true);
        this.in_msg_len = (short)(this.in_msg_len - 2);
        return this.in.readShort();
    }

    public int readInt() throws SQLException {
        this.need(4, true);
        this.in_msg_len = (short)(this.in_msg_len - 4);
        return this.in.readInt();
    }

    public long readLong() throws SQLException {
        this.need(8, true);
        this.in_msg_len = (short)(this.in_msg_len - 8);
        return this.in.readLong();
    }

    public float readFloat() throws SQLException {
        this.need(6, true);
        this.in_msg_len = (short)(this.in_msg_len - 6);
        return this.in.readFloat();
    }

    public double readDouble() throws SQLException {
        this.need(10, true);
        this.in_msg_len = (short)(this.in_msg_len - 10);
        return this.in.readDouble();
    }

    public byte[] readBytes() throws SQLException {
        return this.readBytes(this.readShort());
    }

    public byte[] readBytes(int n) throws SQLException {
        byte[] byArray = new byte[n];
        this.readBytes(byArray, 0, n);
        return byArray;
    }

    public int readBytes(byte[] byArray, int n, int n2) throws SQLException {
        int n3 = n2;
        while (n2 > 0) {
            this.need(n2, false);
            int n4 = Math.min(this.in_msg_len, n2);
            n4 = this.in.readBytes(byArray, n, n4);
            n += n4;
            n2 -= n4;
            this.in_msg_len = (short)(this.in_msg_len - n4);
        }
        return n3 - n2;
    }

    public int readBytes(ByteArray byteArray, int n) throws SQLException {
        int n2 = n;
        while (n > 0) {
            this.need(n, false);
            int n3 = Math.min(this.in_msg_len, n);
            n3 = this.in.readBytes(byteArray, n3);
            n -= n3;
            this.in_msg_len = (short)(this.in_msg_len - n3);
        }
        return n2 - n;
    }

    public String readString() throws SQLException {
        return this.readString(this.readShort());
    }

    public String readString(int n) throws SQLException {
        String string;
        if (n <= this.in_msg_len) {
            if (n <= 0) {
                string = empty;
            } else {
                string = this.in.readString(n, this.char_set);
                this.in_msg_len = (short)(this.in_msg_len - n);
            }
        } else {
            byte[] byArray = this.readBytes(n);
            try {
                string = this.char_set.getString(byArray);
            }
            catch (Exception exception) {
                throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
            }
        }
        return string;
    }

    public String readUCS2() throws SQLException {
        return this.readUCS2(this.readShort());
    }

    public String readUCS2(short n) throws SQLException {
        if (n < 1) {
            return empty;
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)this.readShort();
        }
        return new String(cArray);
    }

    public int readUCS2(CharArray charArray, int n) throws SQLException {
        for (int i = n; i > 0; --i) {
            charArray.put((char)this.readShort());
        }
        return n;
    }

    public InputStream readByteStream() throws SQLException {
        return new ByteSegIS(this, this.trace, this.in_msg_id);
    }

    public InputStream readByteStream(InputStream inputStream) throws SQLException {
        if (inputStream != null && inputStream instanceof ByteSegIS) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((ByteSegIS)inputStream).begin(this.in_msg_id);
        } else {
            inputStream = new ByteSegIS(this, this.trace, this.in_msg_id);
        }
        return inputStream;
    }

    public Reader readUCS2Reader() throws SQLException {
        return new Ucs2SegRdr(this, this.trace, this.in_msg_id);
    }

    public Reader readUCS2Reader(Reader reader) throws SQLException {
        if (reader != null && reader instanceof Ucs2SegRdr) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((Ucs2SegRdr)reader).begin(this.in_msg_id);
        } else {
            reader = new Ucs2SegRdr(this, this.trace, this.in_msg_id);
        }
        return reader;
    }

    public void readSqlData(SqlNull sqlNull) throws SQLException {
        if (this.readSqlDataIndicator()) {
            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
        }
        sqlNull.setNull();
    }

    public void readSqlData(SqlTinyInt sqlTinyInt) throws SQLException {
        if (this.readSqlDataIndicator()) {
            sqlTinyInt.set(this.readByte());
        } else {
            sqlTinyInt.setNull();
        }
    }

    public void readSqlData(SqlSmallInt sqlSmallInt) throws SQLException {
        if (this.readSqlDataIndicator()) {
            sqlSmallInt.set(this.readShort());
        } else {
            sqlSmallInt.setNull();
        }
    }

    public void readSqlData(SqlInt sqlInt) throws SQLException {
        if (this.readSqlDataIndicator()) {
            sqlInt.set(this.readInt());
        } else {
            sqlInt.setNull();
        }
    }

    public void readSqlData(SqlBigInt sqlBigInt) throws SQLException {
        if (this.readSqlDataIndicator()) {
            sqlBigInt.set(this.readLong());
        } else {
            sqlBigInt.setNull();
        }
    }

    public void readSqlData(SqlReal sqlReal) throws SQLException {
        if (this.readSqlDataIndicator()) {
            sqlReal.set(this.readFloat());
        } else {
            sqlReal.setNull();
        }
    }

    public void readSqlData(SqlDouble sqlDouble) throws SQLException {
        if (this.readSqlDataIndicator()) {
            sqlDouble.set(this.readDouble());
        } else {
            sqlDouble.setNull();
        }
    }

    public void readSqlData(SqlDecimal sqlDecimal) throws SQLException {
        if (this.readSqlDataIndicator()) {
            sqlDecimal.set(this.readString());
        } else {
            sqlDecimal.setNull();
        }
    }

    public void readSqlData(SqlBool sqlBool) throws SQLException {
        if (this.readSqlDataIndicator()) {
            sqlBool.set(this.readByte());
        } else {
            sqlBool.setNull();
        }
    }

    public void readSqlData(SqlDate sqlDate) throws SQLException {
        if (this.readSqlDataIndicator()) {
            sqlDate.set(this.readString());
        } else {
            sqlDate.setNull();
        }
    }

    public void readSqlData(SqlTime sqlTime) throws SQLException {
        if (this.readSqlDataIndicator()) {
            sqlTime.set(this.readString());
        } else {
            sqlTime.setNull();
        }
    }

    public void readSqlData(SqlTimestamp sqlTimestamp) throws SQLException {
        if (this.readSqlDataIndicator()) {
            sqlTimestamp.set(this.readString());
        } else {
            sqlTimestamp.setNull();
        }
    }

    public void readSqlData(IngresDate ingresDate) throws SQLException {
        if (this.readSqlDataIndicator()) {
            ingresDate.set(this.readString());
        } else {
            ingresDate.set((IngresDate)null);
        }
    }

    public void readSqlData(SqlByte sqlByte) throws SQLException {
        if (!this.readSqlDataIndicator()) {
            sqlByte.setNull();
        } else {
            int n = sqlByte.limit();
            sqlByte.clear();
            this.readBytes(sqlByte, n);
        }
    }

    public void readSqlData(SqlVarByte sqlVarByte) throws SQLException {
        if (!this.readSqlDataIndicator()) {
            sqlVarByte.setNull();
        } else {
            short s = this.readShort();
            sqlVarByte.clear();
            sqlVarByte.ensureCapacity(s);
            this.readBytes(sqlVarByte, s);
        }
    }

    public void readSqlData(SqlChar sqlChar) throws SQLException {
        if (!this.readSqlDataIndicator()) {
            sqlChar.setNull();
        } else {
            int n = sqlChar.limit();
            sqlChar.clear();
            this.readBytes(sqlChar, n);
        }
    }

    public void readSqlData(SqlVarChar sqlVarChar) throws SQLException {
        if (!this.readSqlDataIndicator()) {
            sqlVarChar.setNull();
        } else {
            short s = this.readShort();
            sqlVarChar.clear();
            sqlVarChar.ensureCapacity(s);
            this.readBytes(sqlVarChar, s);
        }
    }

    public void readSqlData(SqlNChar sqlNChar) throws SQLException {
        if (!this.readSqlDataIndicator()) {
            sqlNChar.setNull();
        } else {
            int n = sqlNChar.limit();
            sqlNChar.clear();
            this.readUCS2(sqlNChar, n);
        }
    }

    public void readSqlData(SqlNVarChar sqlNVarChar) throws SQLException {
        if (!this.readSqlDataIndicator()) {
            sqlNVarChar.setNull();
        } else {
            short s = this.readShort();
            sqlNVarChar.clear();
            sqlNVarChar.ensureCapacity(s);
            this.readUCS2(sqlNVarChar, s);
        }
    }

    public void readSqlData(SqlLoc sqlLoc) throws SQLException {
        if (this.readSqlDataIndicator()) {
            sqlLoc.set(this.readInt());
        } else {
            sqlLoc.setNull();
        }
    }

    public void readSqlData(SqlLongByte sqlLongByte) throws SQLException {
        if (this.readSqlDataIndicator()) {
            sqlLongByte.set(this.readByteStream());
        } else {
            sqlLongByte.setNull();
        }
    }

    public void readSqlData(SqlLongByteCache sqlLongByteCache) throws SQLException {
        if (this.readSqlDataIndicator()) {
            sqlLongByteCache.set(this.readByteStream());
        } else {
            sqlLongByteCache.setNull();
        }
    }

    public void readSqlData(SqlLongChar sqlLongChar) throws SQLException {
        if (this.readSqlDataIndicator()) {
            sqlLongChar.set(this.readByteStream());
        } else {
            sqlLongChar.setNull();
        }
    }

    public void readSqlData(SqlLongCharCache sqlLongCharCache) throws SQLException {
        if (this.readSqlDataIndicator()) {
            sqlLongCharCache.set(this.readByteStream());
        } else {
            sqlLongCharCache.setNull();
        }
    }

    public void readSqlData(SqlLongNChar sqlLongNChar) throws SQLException {
        if (this.readSqlDataIndicator()) {
            sqlLongNChar.set(this.readUCS2Reader());
        } else {
            sqlLongNChar.setNull();
        }
    }

    public void readSqlData(SqlLongNCharCache sqlLongNCharCache) throws SQLException {
        if (this.readSqlDataIndicator()) {
            sqlLongNCharCache.set(this.readUCS2Reader());
        } else {
            sqlLongNCharCache.setNull();
        }
    }

    private boolean readSqlDataIndicator() throws SQLException {
        return this.readByte() != 0;
    }

    private void need(int n, boolean bl) throws SQLException {
        while (n > this.in_msg_len) {
            if (this.in_msg_len > 0) {
                if (!bl) break;
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": atomic value split (" + this.in_msg_len + "," + n + ")");
                }
                this.disconnect();
                throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
            }
            if (this.moreData()) continue;
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": unexpected end-of-data");
            }
            this.disconnect();
            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
        }
    }

    private static class Ucs2SegRdr
    extends Reader
    implements SqlStream.StreamSource {
        private String title;
        private Trace trace;
        private MsgIn msg_in;
        private byte msg_id = (byte)-1;
        private boolean end_of_data = true;
        private short seg_len = 0;
        private char[] ca = new char[1];
        private SqlStream.StreamListener listener = null;
        private SqlStream stream = null;

        public Ucs2SegRdr(MsgIn msgIn, Trace trace, byte by) {
            this.msg_in = msgIn;
            this.trace = trace;
            this.msg_id = by;
            this.end_of_data = false;
            this.title = "Ucs2SegRdr[" + msgIn.connID() + "]";
            if (trace.enabled(3)) {
                trace.write(this.title + " new CLOB");
            }
        }

        public void begin(byte by) {
            this.msg_id = by;
            this.end_of_data = false;
            this.seg_len = 0;
            this.listener = null;
            this.stream = null;
            if (this.trace.enabled(3)) {
                this.trace.write(this.title + " begin CLOB");
            }
        }

        @Override
        public void addStreamListener(SqlStream.StreamListener streamListener, SqlStream sqlStream) {
            this.listener = streamListener;
            this.stream = sqlStream;
        }

        @Override
        public int read() throws IOException {
            int n = this.read(this.ca, 0, 1);
            return n == 1 ? this.ca[0] & 0xFFFF : -1;
        }

        @Override
        public int read(char[] cArray) throws IOException {
            return this.read(cArray, 0, cArray.length);
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            if (this.trace.enabled(4)) {
                this.trace.write(this.title + ".read(" + n2 + ")");
            }
            try {
                while (n2 > 0 && !this.end_of_data && (this.seg_len > 0 || this.next())) {
                    int n4 = Math.min(n2, this.seg_len);
                    int n5 = n + n4;
                    while (n < n5) {
                        cArray[n] = (char)this.msg_in.readShort();
                        ++n;
                    }
                    if (this.trace.enabled(5)) {
                        this.trace.write(this.title + ": read " + n4 + " UCS2 chars");
                    }
                    this.seg_len = (short)(this.seg_len - (short)n4);
                    n2 -= n4;
                    n3 += n4;
                }
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": error reading data");
                    SqlExFactory.trace(sQLException, this.trace);
                }
                throw new IOException(sQLException.getMessage());
            }
            if (this.trace.enabled(4)) {
                this.trace.write(this.title + ".read: " + n3 + (this.end_of_data ? " [EOD]" : ""));
            }
            return n3 > 0 ? n3 : (this.end_of_data ? -1 : 0);
        }

        @Override
        public long skip(long l) throws IOException {
            long l2 = 0L;
            if (this.trace.enabled(4)) {
                this.trace.write(this.title + ".skip(" + l + ")");
            }
            try {
                while (l > 0L && !this.end_of_data && (this.seg_len > 0 || this.next())) {
                    int n = this.seg_len;
                    if ((long)n > l) {
                        n = (int)l;
                    }
                    n = this.msg_in.skip(n * 2) / 2;
                    if (this.trace.enabled(5)) {
                        this.trace.write(this.title + ": skip " + n + " UCS2 chars");
                    }
                    this.seg_len = (short)(this.seg_len - (short)n);
                    l -= (long)n;
                    l2 += (long)n;
                }
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": error skipping data");
                    SqlExFactory.trace(sQLException, this.trace);
                }
                throw new IOException(sQLException.getMessage());
            }
            if (this.trace.enabled(4)) {
                this.trace.write(this.title + ".skip: " + l2 + (this.end_of_data ? " [EOD]" : ""));
            }
            return l2;
        }

        @Override
        public boolean ready() throws IOException {
            return this.seg_len > 0;
        }

        @Override
        public void close() throws IOException {
            while (!this.end_of_data) {
                this.next();
            }
        }

        private boolean next() throws IOException {
            try {
                while (this.seg_len > 0) {
                    if (this.trace.enabled(4)) {
                        this.trace.write(this.title + ": skipping " + this.seg_len);
                    }
                    this.seg_len = (short)(this.seg_len - (short)this.msg_in.skip(this.seg_len * 2) / 2);
                }
                while (!this.msg_in.moreData()) {
                    if (this.msg_in.receive() == this.msg_id) continue;
                    if (this.trace.enabled(3)) {
                        this.trace.write(this.title + ": truncated!");
                    }
                    this.msg_in.pushback();
                    this.endStream();
                    throw new IOException("CLOB data stream truncated!");
                }
                this.seg_len = this.msg_in.readShort();
                if (this.seg_len == 0) {
                    if (this.trace.enabled(3)) {
                        this.trace.write(this.title + ": end CLOB");
                    }
                    this.endStream();
                } else if (this.trace.enabled(4)) {
                    this.trace.write(this.title + ": CLOB segment length " + this.seg_len);
                }
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": error reading next segment");
                    SqlExFactory.trace(sQLException, this.trace);
                }
                throw new IOException(sQLException.getMessage());
            }
            return !this.end_of_data;
        }

        private void endStream() {
            if (!this.end_of_data) {
                this.end_of_data = true;
                this.seg_len = 0;
                this.msg_id = (byte)-1;
                if (this.listener != null) {
                    if (this.trace.enabled(5)) {
                        this.trace.write(this.title + ": stream closure event notification");
                    }
                    this.listener.streamClosed(this.stream);
                }
            }
        }
    }

    private static class ByteSegIS
    extends InputStream
    implements SqlStream.StreamSource {
        private String title;
        private Trace trace;
        private MsgIn msg_in;
        private byte msg_id = (byte)-1;
        private boolean end_of_data = true;
        private short seg_len = 0;
        private byte[] ba = new byte[1];
        private SqlStream.StreamListener listener = null;
        private SqlStream stream = null;

        public ByteSegIS(MsgIn msgIn, Trace trace, byte by) {
            this.msg_in = msgIn;
            this.trace = trace;
            this.msg_id = by;
            this.end_of_data = false;
            this.title = "ByteSegIS[" + msgIn.connID() + "]";
            if (trace.enabled(3)) {
                trace.write(this.title + ": new BLOB");
            }
        }

        public void begin(byte by) {
            this.msg_id = by;
            this.end_of_data = false;
            this.seg_len = 0;
            this.listener = null;
            this.stream = null;
            if (this.trace.enabled(3)) {
                this.trace.write(this.title + ": begin BLOB");
            }
        }

        @Override
        public void addStreamListener(SqlStream.StreamListener streamListener, SqlStream sqlStream) {
            this.listener = streamListener;
            this.stream = sqlStream;
        }

        @Override
        public int read() throws IOException {
            int n = this.read(this.ba, 0, 1);
            return n == 1 ? this.ba[0] & 0xFF : -1;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            if (this.trace.enabled(4)) {
                this.trace.write(this.title + ".read(" + n2 + ")");
            }
            try {
                while (n2 > 0 && !this.end_of_data && (this.seg_len > 0 || this.next())) {
                    int n4 = Math.min(n2, this.seg_len);
                    n4 = this.msg_in.readBytes(byArray, n, n4);
                    if (this.trace.enabled(5)) {
                        this.trace.write(this.title + ": read " + n4 + " bytes");
                    }
                    n += n4;
                    n2 -= n4;
                    this.seg_len = (short)(this.seg_len - (short)n4);
                    n3 += n4;
                }
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": error reading data");
                    SqlExFactory.trace(sQLException, this.trace);
                }
                throw new IOException(sQLException.getMessage());
            }
            if (this.trace.enabled(4)) {
                this.trace.write(this.title + ".read: " + n3 + (this.end_of_data ? " [EOD]" : ""));
            }
            return n3 > 0 ? n3 : (this.end_of_data ? -1 : 0);
        }

        @Override
        public long skip(long l) throws IOException {
            long l2 = 0L;
            if (this.trace.enabled(4)) {
                this.trace.write(this.title + ".skip(" + l + ")");
            }
            try {
                while (l > 0L && !this.end_of_data && (this.seg_len > 0 || this.next())) {
                    int n = this.seg_len;
                    if ((long)n > l) {
                        n = (int)l;
                    }
                    n = this.msg_in.skip(n);
                    if (this.trace.enabled(5)) {
                        this.trace.write(this.title + ": skip " + n + " bytes");
                    }
                    l -= (long)n;
                    this.seg_len = (short)(this.seg_len - (short)n);
                    l2 += (long)n;
                }
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": error skipping data");
                    SqlExFactory.trace(sQLException, this.trace);
                }
                throw new IOException(sQLException.getMessage());
            }
            if (this.trace.enabled(4)) {
                this.trace.write(this.title + ".skip: " + l2 + (this.end_of_data ? " [EOD]" : ""));
            }
            return l2;
        }

        @Override
        public int available() throws IOException {
            return this.seg_len;
        }

        @Override
        public void close() throws IOException {
            while (!this.end_of_data) {
                this.next();
            }
        }

        private boolean next() throws IOException {
            try {
                while (this.seg_len > 0) {
                    if (this.trace.enabled(4)) {
                        this.trace.write(this.title + ": skipping " + this.seg_len);
                    }
                    this.seg_len = (short)(this.seg_len - (short)this.msg_in.skip(this.seg_len));
                }
                while (!this.msg_in.moreData()) {
                    if (this.msg_in.receive() == this.msg_id) continue;
                    if (this.trace.enabled(3)) {
                        this.trace.write(this.title + ": truncated!");
                    }
                    this.msg_in.pushback();
                    this.endStream();
                    throw new IOException("BLOB data stream truncated!");
                }
                this.seg_len = this.msg_in.readShort();
                if (this.seg_len == 0) {
                    if (this.trace.enabled(3)) {
                        this.trace.write(this.title + ": end BLOB");
                    }
                    this.endStream();
                } else if (this.trace.enabled(4)) {
                    this.trace.write(this.title + ": BLOB segment length " + this.seg_len);
                }
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": error reading next segment");
                    SqlExFactory.trace(sQLException, this.trace);
                }
                throw new IOException(sQLException.getMessage());
            }
            return !this.end_of_data;
        }

        private void endStream() {
            if (!this.end_of_data) {
                this.end_of_data = true;
                this.seg_len = 0;
                this.msg_id = (byte)-1;
                if (this.listener != null) {
                    if (this.trace.enabled(5)) {
                        this.trace.write(this.title + ": stream closure event notification");
                    }
                    this.listener.streamClosed(this.stream);
                }
            }
        }
    }
}

