/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.fim;

import com.ingres.gcf.fim.FedIdentityMgmt;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Logger;

public class FIMHTTPServer
implements Runnable {
    final String response = "HTTP/1.1 200 OK\r\nContent-Type: text/html; charset=UTF-8\r\n\r\n<!DOCTYPE html><html><head><title>Close This Window</title><style>body { background-color: #f6f9fc }p1 { font-family: Red Hat Text,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Oxygen-Sans,Ubuntu,Cantarell,Helvetica Neue,sans-serif;font-size:20spx; font-weight:500; text-align: center; color: #67758D; letter-spacing: 0px;}h2 {font-family: Red Hat Text,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Oxygen-Sans,Ubuntu,Cantarell,Helvetica Neue,sans-serif;font-size:24px; font-weight:500; text-align: center; color: #67758D; letter-spacing: 0px;}</style></head><body><table style=\"border: 0px solid black;margin-left:auto;margin-right:auto;\"><tr><th><img name=logo class=standard_logo id=logo alt=My Actian style=\"horizontal-align:center;vertical-align:middle;margin:10px 0px\" src=\"https://myactian.force.com/servlet/servlet.ImageServer?id=0151H0000087M2x&oid=00D1H000000OyH6\" border=\"0\"></h1></td></tr><tr><td><h2>You're Connected</h2><p1>Your session is now connected. You may close this window.</p1></td></tr></table></body></html>\r\n";
    private volatile boolean exit = false;
    private String message = null;
    private String error = null;
    private int port = 0;
    private ServerSocket server = null;
    private Logger LOGGER = Logger.getLogger(FedIdentityMgmt.class.getName());

    FIMHTTPServer(int n) {
        this.port = n;
    }

    private void listen(int n) {
        Socket socket = null;
        String string = null;
        try {
            this.server = new ServerSocket();
            InetAddress inetAddress = InetAddress.getLoopbackAddress();
            this.server.bind(new InetSocketAddress(inetAddress, n));
            this.server.setReuseAddress(true);
            this.exit = false;
            int n2 = 0;
            while (!this.exit) {
                if (n2++ > 0) {
                    this.LOGGER.info("Listening loop pass #" + n2);
                }
                socket = this.server.accept();
                InputStreamReader inputStreamReader = new InputStreamReader(socket.getInputStream());
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                char[] cArray = new char[1000];
                int n3 = bufferedReader.read(cArray, 0, 1000);
                this.LOGGER.info("Read: " + n3 + " characters, array=" + String.valueOf(cArray));
                if (n3 > -1) {
                    if (cArray.length > 0) {
                        string = String.valueOf(cArray);
                    }
                    if (string != null && string.indexOf("/favicon") > 0) {
                        this.exit = false;
                        string = null;
                        this.LOGGER.info("Found favicon in response from server, discarding...");
                    } else if (string != null) {
                        this.exit = true;
                        this.LOGGER.info("exit=" + this.exit + "; Local web server received the following message: " + string);
                    }
                }
                OutputStream outputStream = socket.getOutputStream();
                PrintWriter printWriter = new PrintWriter(outputStream, true);
                printWriter.println("HTTP/1.1 200 OK\r\nContent-Type: text/html; charset=UTF-8\r\n\r\n<!DOCTYPE html><html><head><title>Close This Window</title><style>body { background-color: #f6f9fc }p1 { font-family: Red Hat Text,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Oxygen-Sans,Ubuntu,Cantarell,Helvetica Neue,sans-serif;font-size:20spx; font-weight:500; text-align: center; color: #67758D; letter-spacing: 0px;}h2 {font-family: Red Hat Text,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Oxygen-Sans,Ubuntu,Cantarell,Helvetica Neue,sans-serif;font-size:24px; font-weight:500; text-align: center; color: #67758D; letter-spacing: 0px;}</style></head><body><table style=\"border: 0px solid black;margin-left:auto;margin-right:auto;\"><tr><th><img name=logo class=standard_logo id=logo alt=My Actian style=\"horizontal-align:center;vertical-align:middle;margin:10px 0px\" src=\"https://myactian.force.com/servlet/servlet.ImageServer?id=0151H0000087M2x&oid=00D1H000000OyH6\" border=\"0\"></h1></td></tr><tr><td><h2>You're Connected</h2><p1>Your session is now connected. You may close this window.</p1></td></tr></table></body></html>\r\n");
                printWriter.close();
                outputStream.close();
                bufferedReader.close();
                inputStreamReader.close();
                socket.close();
                socket = null;
            }
            this.server.close();
            this.server = null;
            this.message = string;
            this.LOGGER.info("Returning message lengths=" + this.getMessage().length() + " and error=" + this.getError());
        }
        catch (IOException iOException) {
            String string2;
            this.error = string2 = "Failure in web server class: " + iOException;
            this.LOGGER.severe(string2);
            try {
                if (socket != null) {
                    socket.close();
                }
                if (this.server != null) {
                    this.server.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw new RuntimeException(string2);
        }
    }

    @Override
    public synchronized void run() {
        this.listen(this.port);
    }

    public void shutdown() {
        try {
            this.server.close();
        }
        catch (IOException iOException) {
            this.LOGGER.severe("Error closing socket: " + iOException);
        }
    }

    public String getError() {
        return this.error;
    }

    public String getMessage() {
        return this.message;
    }
}

