/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.fim;

import com.ingres.gcf.fim.FIMHTTPServer;
import com.ingres.gcf.fim.FIMMsgFormatter;
import com.ingres.gcf.fim.OAuthParamStore;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class FedIdentityMgmt {
    static final int ACTIAN_ID_PORT = 443;
    static final int WEBSRV_PORT = 4200;
    static final String LOG_LEVEL_PROP = "com.ingres.fim.log.level";
    static final String LOG_FILE_PROP = "com.ingres.fim.log.file";
    static final String LOG_PROP_FILE = "fim.properties";
    static final String ACCESS_TOKEN_PREFIX = "access_token=";
    static final String MSG_TEMPLATE = "GET %s HTTP/1.1\r\nHost: %s\r\n%s\r\n";
    static final char C_SPACE = ' ';
    static final char C_SQUOTE = '\'';
    static final char C_AMP = '&';
    static final char C_COMMA = ',';
    static final char C_COLON = ':';
    static final char C_SLASH_F = '/';
    static final char C_SLASh_B = '\\';
    static final char C_BRACE_L = '{';
    static final String EOL = "\r\n";
    static final String HTTPS_PREFIX = "https://";
    static final String HTTP_MSG_PREFIX = "HTTP/";
    static final String CONTENT_LENGTH = "content-length:";
    static final String TRANSFER_ENCODING = "transfer-encoding:";
    static final String CHUNKED = "chunked";
    static final String AUTH_PENDING = "authorization_pending";
    static final String LANDING_PAGE_BASE = "/sso-login";
    static final String LANDING_PAGE_PARM = "/sso-login?redirectUrl=%s&state=%s:actianIdBaseUrlState";
    static final String AUTHFLOW_CONST_1 = "redirect";
    static final String AUTHFLOW_CONST_2 = "Redirect";
    static final String CODE_CONST_1 = "&code=";
    static final String CODE_CONST_2 = "?code=";
    static final String STATE_CONST = "state=";
    static final String HREF_CONST = "href=\"";
    static final String HREF_END = "\">";
    static final String ACTIAN_ID_BASEPATH = "/id/%s/auth/%s";
    static final String ACTIAN_ID_DIRPATH2 = "auth/";
    static final String ACTIAN_ID_DEVICE = "/devicecode";
    static final String ACTIAN_ID_DEVICETOKEN = "/devicetoken?code=";
    static final String ACTIAN_ID_AUTH_CODE = "/code?redirectUrl=%s&state=%s:actianIdBaseUrlState";
    static final String ACTIAN_ID_AUTH_TOKEN = "/token?code=%s&redirectUrl=%s";
    static final String ACTIAN_ID_REFERER = "http://localhost:4200/users/login/callback";
    static final String ACTIAN_ID_USERINFO = "/userinfo";
    static final String ACTIAN_ID_AUTHORIZATION = "Authorization: Bearer ";
    static final String ACTIAN_ID_VERS_V1 = "v1";
    static final String ACTIAN_ID_VERS_V2 = "v2";
    static final String USER_CODE = "user_code";
    static final String DEVICE_CODE = "device_code";
    static final String VERIFY_URI = "verification_uri";
    static final String ACCESS_TOKEN = "access_token";
    static final String ACCESS_USER = "preferred_username";
    static final String ERROR = "error";
    static final String ERR_DESC = "error_description";
    private static ReentrantLock mutex = new ReentrantLock();
    private static OAuthParamStore paramStore = new OAuthParamStore();
    private static Logger LOGGER = null;
    private Socket socket = null;
    private BufferedReader rdr = null;
    private BufferedWriter wtr = null;
    private String access_user = null;

    public FedIdentityMgmt() {
        FedIdentityMgmt.configureLogging();
    }

    private static void configureLogging() {
        if (LOGGER != null) {
            return;
        }
        LOGGER = Logger.getLogger(FedIdentityMgmt.class.getName());
        try {
            String string = null;
            Level level = Level.OFF;
            string = System.getProperty(LOG_LEVEL_PROP);
            if (string != null) {
                level = Level.parse(string);
            }
            LOGGER.setLevel(level);
            if (level != Level.OFF) {
                String string2 = System.getProperty(LOG_FILE_PROP);
                if (string2 == null) {
                    string2 = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "fim%u.log";
                }
                FileHandler fileHandler = new FileHandler(string2);
                LOGGER.setUseParentHandlers(false);
                LOGGER.addHandler(fileHandler);
                fileHandler.setFormatter(new FIMMsgFormatter());
            } else {
                InputStream inputStream = FedIdentityMgmt.class.getResourceAsStream(LOG_PROP_FILE);
                if (inputStream != null) {
                    LogManager.getLogManager().readConfiguration(inputStream);
                }
            }
            LOGGER.severe("Log Level = " + LOGGER.getLevel());
        }
        catch (Exception exception) {
            LOGGER.severe("Failed to setup logger parameters, error " + exception);
        }
    }

    private static boolean mutexLock() {
        boolean bl = false;
        try {
            if (mutex.tryLock() || mutex.tryLock(900L, TimeUnit.SECONDS)) {
                LOGGER.info("Acquired mutex lock: " + mutex.toString());
                bl = true;
            } else {
                LOGGER.severe("Failed to acquire lock.");
            }
        }
        catch (InterruptedException interruptedException) {
            LOGGER.severe("Failed to acquire lock: " + interruptedException);
        }
        return bl;
    }

    private static void mutexUnlock() {
        try {
            mutex.unlock();
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOGGER.info("Released mutex lock: " + mutex.toString());
    }

    private void connect(String string) throws Exception {
        if (this.socket != null) {
            LOGGER.severe("Connection request without disconnect!");
            throw new Exception("Connection request while connection active.");
        }
        try {
            SocketFactory socketFactory = SSLSocketFactory.getDefault();
            LOGGER.info("Connection target: " + string + ":" + 443);
            this.socket = socketFactory.createSocket(string, 443);
            this.socket.setTcpNoDelay(true);
            this.socket.setKeepAlive(true);
            this.socket.setReceiveBufferSize(20000);
            this.wtr = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            this.rdr = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        }
        catch (IOException iOException) {
            LOGGER.severe("Error connecting SSL socket: " + iOException);
            throw iOException;
        }
    }

    private void disconnect() throws Exception {
        if (this.socket == null) {
            return;
        }
        try {
            BufferedWriter bufferedWriter = this.wtr;
            BufferedReader bufferedReader = this.rdr;
            Socket socket = this.socket;
            this.wtr = null;
            this.rdr = null;
            this.socket = null;
            bufferedWriter.close();
            bufferedReader.close();
            socket.close();
        }
        catch (IOException iOException) {
            LOGGER.severe("Error disconnecting the sockets: " + iOException);
            throw iOException;
        }
    }

    private void sendMessage(String string) throws Exception {
        LOGGER.info("Sending message: " + string);
        try {
            this.wtr.write(string);
            this.wtr.flush();
        }
        catch (IOException iOException) {
            LOGGER.severe("Error sending message: " + iOException);
            throw iOException;
        }
    }

    private String receiveResponse() throws Exception {
        return this.receiveResponse(true);
    }

    private String receiveResponse(boolean bl) throws Exception {
        String string = "";
        try {
            String string2 = null;
            int n = 0;
            boolean bl2 = false;
            while ((string2 = this.rdr.readLine()) != null) {
                int n2;
                string = string + string2 + EOL;
                if (string2.isEmpty()) break;
                if ((string2 = string2.toLowerCase()).startsWith(CONTENT_LENGTH)) {
                    n2 = CONTENT_LENGTH.length() + 1;
                    n = Integer.parseInt(string2.substring(n2));
                }
                if (!string2.startsWith(TRANSFER_ENCODING) || !string2.substring(n2 = TRANSFER_ENCODING.length() + 1).equals(CHUNKED)) continue;
                LOGGER.info("Response chunked");
                bl2 = true;
            }
            if ((n > 0 || bl2) && bl) {
                LOGGER.info("Received HTTP headers (stripped): " + string);
                string = "";
            }
            if (n > 0) {
                char[] cArray = new char[n];
                LOGGER.info("Response content-length: " + n);
                this.rdr.read(cArray, 0, cArray.length);
                string = string + new String(cArray, 0, cArray.length);
            }
            while (bl2 && (string2 = this.rdr.readLine()) != null) {
                if (string2.isEmpty()) continue;
                n = Integer.parseInt(string2, 16);
                if (n == 0) {
                    LOGGER.info("Response end-of-chunks");
                    bl2 = false;
                } else {
                    char[] cArray = new char[n];
                    LOGGER.info("Response chunk length: " + n);
                    this.rdr.read(cArray, 0, cArray.length);
                    string = string + new String(cArray, 0, cArray.length);
                }
                if ((string2 = this.rdr.readLine()) == null || string2.isEmpty()) continue;
                LOGGER.info("Unexpected content following chunk: " + string2);
            }
        }
        catch (Exception exception) {
            LOGGER.severe("Error receiving server response: " + exception);
            throw exception;
        }
        LOGGER.info("Received Message: " + string);
        return string.isEmpty() ? null : string;
    }

    private void parseHTTPResponse(String string) throws Exception {
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        if (string == null) {
            return;
        }
        if (string.startsWith(HTTP_MSG_PREFIX)) {
            n = this.extractHttpStatus(string);
        }
        if (!(n != 302 && n != 307 && string.indexOf(AUTHFLOW_CONST_1) < 0 && string.indexOf(AUTHFLOW_CONST_2) < 0 || (n2 = string.indexOf(HREF_CONST)) < 0 && (n2 = string.indexOf(HTTPS_PREFIX)) < 0)) {
            if (string.regionMatches(n2, HREF_CONST, 0, HREF_CONST.length())) {
                n2 += HREF_CONST.length();
            }
            if ((n3 = string.indexOf(HREF_END, n2)) < 0) {
                n3 = string.indexOf(EOL, n2);
            }
            if (n3 > n2) {
                String string2 = string.substring(n2, n3);
                LOGGER.info("Response Parameter: authorization-code-url=" + string2);
                paramStore.setAuthorization_code_url(string2);
            }
        } else {
            n2 = string.indexOf(CODE_CONST_1);
            if (n2 >= 0 || (n2 = string.indexOf(CODE_CONST_2)) >= 0) {
                n3 = string.indexOf(38, n2 += CODE_CONST_1.length());
                String string3 = n3 > n2 ? string.substring(n2, n3) : string.substring(n2);
                LOGGER.info("Response Parameter: authorization-code=" + string3);
                paramStore.setAuthorization_code(string3);
                n2 = string.indexOf(STATE_CONST);
                if (n2 >= 0) {
                    n3 = string.indexOf(38, n2 += STATE_CONST.length());
                    string3 = n3 > n2 ? string.substring(n2, n3) : string.substring(n2);
                    LOGGER.info("Response Parameter: state=" + string3);
                    this.parseStateAndServer(string3);
                }
            } else {
                String string4 = "Unexpected HTTP message returned: " + string;
                LOGGER.severe(string4);
                new Exception(string4);
            }
        }
    }

    private void parseResponse(String string) throws Exception {
        JSONObject jSONObject;
        if (string == null) {
            return;
        }
        try {
            jSONObject = new JSONObject(string);
        }
        catch (JSONException jSONException) {
            LOGGER.severe("Error parsing JSON response: " + jSONException);
            throw jSONException;
        }
        String string2 = this.getJsonString(jSONObject, VERIFY_URI);
        if (string2 != null) {
            paramStore.setVerification_uri(string2);
        }
        if ((string2 = this.getJsonString(jSONObject, USER_CODE)) != null) {
            paramStore.setUser_code(string2);
        }
        if ((string2 = this.getJsonString(jSONObject, DEVICE_CODE)) != null) {
            paramStore.setDevice_code(string2);
        }
        if ((string2 = this.getJsonString(jSONObject, ACCESS_TOKEN)) != null) {
            paramStore.setAccess_token(string2);
        }
        if ((string2 = this.getJsonString(jSONObject, ACCESS_USER)) != null) {
            paramStore.setPreferred_username(string2);
        }
        if ((string2 = this.getJsonString(jSONObject, ERROR)) != null) {
            paramStore.setError(string2);
        }
        if ((string2 = this.getJsonString(jSONObject, ERR_DESC)) != null) {
            paramStore.setError_description(string2);
        }
    }

    private String getJsonString(JSONObject jSONObject, String string) {
        String string2 = null;
        if (jSONObject.has(string)) {
            try {
                string2 = jSONObject.getString(string);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (string2 != null) {
                if (string2.isEmpty()) {
                    string2 = null;
                } else {
                    LOGGER.info("Response Parameter: " + string + "=" + string2);
                }
            }
        }
        return string2;
    }

    private void parseStateAndServer(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = null;
        String string3 = null;
        try {
            string = URLDecoder.decode(string, StandardCharsets.UTF_8.name());
        }
        catch (Exception exception) {
            LOGGER.severe("Unexpected exception: " + exception);
        }
        LOGGER.info("Parsing the following state: " + string);
        n = string.indexOf(58);
        if (n > 0) {
            paramStore.setState(string.substring(0, n));
            LOGGER.info("State=" + paramStore.getState());
        }
        if ((string2 = string.substring(n + 1)).startsWith(HTTPS_PREFIX)) {
            string2 = string2.substring(HTTPS_PREFIX.length());
        }
        if ((n2 = (string3 = (n = string2.indexOf(47)) > 0 ? string2.substring(0, n) : ((n = string2.indexOf(44)) > 0 ? string2.substring(0, n) : string2)).indexOf(58)) > 0) {
            paramStore.setActianid_host(string3.substring(0, n2));
        } else {
            paramStore.setActianid_host(string3);
        }
        LOGGER.info("Actianid Host=" + paramStore.getActianid_host());
        if (n >= 0 && (paramStore.getActianid_dirpath() == null || paramStore.getActianid_dirpath().isEmpty())) {
            if (string2.charAt(n) == '/') {
                if (string2.charAt(string2.length() - 1) != '/') {
                    paramStore.setActianid_dirpath(string2.substring(n) + '/' + ACTIAN_ID_DIRPATH2 + ACTIAN_ID_VERS_V1);
                } else {
                    paramStore.setActianid_dirpath(string2.substring(n) + ACTIAN_ID_DIRPATH2 + ACTIAN_ID_VERS_V1);
                }
            } else if (string2.charAt(n) == ',') {
                String string4 = ACTIAN_ID_VERS_V1;
                if ((n2 = string2.indexOf(44, ++n)) > n) {
                    string3 = string2.substring(n, n2);
                    if (string3.equalsIgnoreCase(ACTIAN_ID_VERS_V1)) {
                        n = n2 + 1;
                    } else if (string3.equalsIgnoreCase(ACTIAN_ID_VERS_V2)) {
                        string4 = ACTIAN_ID_VERS_V2;
                        n = n2 + 1;
                    }
                }
                string3 = String.format(ACTIAN_ID_BASEPATH, string2.substring(n), string4);
                paramStore.setActianid_dirpath(string3);
            }
            LOGGER.info("Actianid dirpath=" + paramStore.getActianid_dirpath());
        }
    }

    private void openDefaultBrowser(String string) {
        if (string == null) {
            return;
        }
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI(string));
            }
            catch (Exception exception) {
                LOGGER.severe("Error openning a browser (desktop): " + exception);
            }
        } else {
            String string2 = System.getProperty("os.name").toLowerCase();
            Runtime runtime = Runtime.getRuntime();
            try {
                if (string2.indexOf("mac") >= 0) {
                    runtime.exec("open " + string);
                } else if (string2.indexOf("nix") >= 0 || string2.indexOf("nux") >= 0) {
                    runtime.exec("xdg-open " + string);
                }
            }
            catch (IOException iOException) {
                LOGGER.severe("Error openning a browser (process): " + iOException);
            }
        }
    }

    private String generateRandomState() {
        float f;
        int n;
        Random random = new Random();
        String string = null;
        int n2 = 3;
        int n3 = 65;
        int n4 = 90;
        int n5 = 7;
        int n6 = 48;
        int n7 = 57;
        StringBuilder stringBuilder = new StringBuilder(n5 + n2);
        for (n = 0; n < n2; ++n) {
            f = random.nextFloat() * (float)(n4 - n3 + 1);
            stringBuilder.append((char)(n3 + (int)f));
        }
        for (n = 0; n < n5; ++n) {
            f = random.nextFloat() * (float)(n7 - n6 + 1);
            stringBuilder.append((char)(n3 + (int)f));
        }
        string = stringBuilder.toString();
        LOGGER.info("StateKey generated: " + string);
        return string;
    }

    private String extractSessionName() {
        String string = Thread.currentThread().getName();
        int n = -1;
        int n2 = -1;
        n = string.indexOf(39);
        if (n >= 0 && (n2 = string.lastIndexOf(39)) >= 0 && n != n2) {
            string = string.substring(n + 1, n2);
        }
        return string;
    }

    private int extractHttpStatus(String string) {
        int n = string.indexOf(32) + 1;
        int n2 = string.indexOf(32, n);
        int n3 = -1;
        if (n > 0 && n2 > n) {
            try {
                n3 = Integer.parseUnsignedInt(string.substring(n, n2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n3;
    }

    private boolean isValidCachedAccessToken(String string) {
        boolean bl = false;
        String string2 = paramStore.getAccess_token();
        String string3 = this.extractSessionName();
        if (string2 == null) {
            LOGGER.info("No access token available.");
            paramStore.clear();
            return false;
        }
        LOGGER.info("*** Compare session information ***\n\tThread Name=" + string3 + "\n\tCached Name=" + paramStore.getSession_name() + "\n\tTarget Server=" + string + "\n\tCached Server=" + paramStore.getAuth_server());
        if (!string3.equals(paramStore.getSession_name()) || paramStore.getAuth_server() == null || !string.equals(paramStore.getAuth_server())) {
            LOGGER.info("Failed to match session and connection parameters to parameter cache.");
            return false;
        }
        LOGGER.info("Access token=" + string2);
        bl = this.isValidToken(string2, string);
        if (!bl) {
            paramStore.clear();
        }
        return bl;
    }

    private boolean isValidToken(String string, String string2) {
        boolean bl = false;
        if (paramStore.getActianid_host() == null && paramStore.getActianid_dirpath() == null) {
            this.parseStateAndServer(string2);
        }
        if (paramStore.getActianid_host() == null || paramStore.getActianid_dirpath() == null) {
            LOGGER.severe("Could not determine endpoint to check access token, invalid format of authenticating server: " + string2);
            return false;
        }
        try {
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            paramStore.setPreferred_username(null);
            this.connect(paramStore.getActianid_host());
            string3 = paramStore.getActianid_dirpath() + ACTIAN_ID_USERINFO;
            string4 = ACTIAN_ID_AUTHORIZATION + string + EOL;
            string5 = String.format(MSG_TEMPLATE, string3, paramStore.getActianid_host(), string4);
            this.sendMessage(string5);
            string6 = this.receiveResponse();
            this.parseResponse(string6);
            if (paramStore.getError() == null && paramStore.getPreferred_username() != null) {
                LOGGER.info("Access token is valid!");
                bl = true;
            } else {
                LOGGER.warning("Access token is invalid! Error=" + paramStore.getError() + " preferred_username=" + paramStore.getPreferred_username());
            }
            this.disconnect();
        }
        catch (Exception exception) {
            try {
                this.disconnect();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            LOGGER.warning("Error validating token: " + exception);
        }
        return bl;
    }

    private boolean isAOPServer() throws Exception {
        boolean bl = false;
        LOGGER.info("Checking for AOP/IdP");
        String string = String.format(MSG_TEMPLATE, LANDING_PAGE_BASE, paramStore.getActianid_host(), "");
        this.sendMessage(string);
        String string2 = this.receiveResponse(false);
        if (string2 != null) {
            int n = this.extractHttpStatus(string2);
            LOGGER.info("AOP/IdP status: " + n);
            if (n != 200) {
                bl = true;
            }
        }
        LOGGER.info("Is AOP/IdP: " + bl);
        return bl;
    }

    private void getAccessTokenUsingCLI(boolean bl) throws Exception {
        Object var2_2 = null;
        if (!bl || paramStore.getActianid_dirpath() == null) {
            String string = "Invalid auth server format for cli auth type.\nThe authenticating server must be an AOP server and must point to a directory within the AOP.";
            LOGGER.severe(string);
            throw new Exception(string);
        }
        String string = paramStore.getActianid_dirpath() + ACTIAN_ID_DEVICE;
        String string2 = String.format(MSG_TEMPLATE, string, paramStore.getActianid_host(), "");
        this.sendMessage(string2);
        String string3 = this.receiveResponse();
        this.parseResponse(string3);
        this.openDefaultBrowser(paramStore.getVerification_uri());
        try {
            String string4 = "Use browser to navigate to " + paramStore.getVerification_uri() + " and enter code " + paramStore.getUser_code();
            while (paramStore.getAccess_token() == null) {
                if (paramStore.getError() != null && paramStore.getError().equals(AUTH_PENDING)) {
                    System.out.println(paramStore.getError_description());
                }
                System.out.println(string4);
                Thread.sleep(5000L);
                string = paramStore.getActianid_dirpath() + ACTIAN_ID_DEVICETOKEN + paramStore.getDevice_code();
                string2 = String.format(MSG_TEMPLATE, string, paramStore.getActianid_host(), "");
                this.sendMessage(string2);
                string3 = this.receiveResponse();
                this.parseResponse(string3);
            }
        }
        catch (InterruptedException interruptedException) {
            LOGGER.severe("Error waiting for user authentication: " + interruptedException);
            throw interruptedException;
        }
        if (paramStore.getAccess_token() != null && paramStore.getError().equals(AUTH_PENDING)) {
            paramStore.setError(null);
            paramStore.setError_description(null);
        }
    }

    private void getAccessTokenUsingBrowser(boolean bl) throws Exception {
        FIMHTTPServer fIMHTTPServer = null;
        Thread thread = null;
        String string = paramStore.getActianid_host();
        String string2 = this.generateRandomState();
        try {
            String string3;
            String string4;
            String string5;
            if (bl) {
                if (paramStore.getActianid_dirpath() == null) {
                    String string6 = "Invalid authenticating server format.  Directory path on AOP server is required when landing page is not used.";
                    LOGGER.severe(string6);
                    throw new Exception(string6);
                }
                string5 = String.format(ACTIAN_ID_AUTH_CODE, ACTIAN_ID_REFERER, string2);
                string5 = paramStore.getActianid_dirpath() + string5;
                string4 = String.format(MSG_TEMPLATE, string5, paramStore.getActianid_host());
                this.sendMessage(string4);
                string3 = this.receiveResponse();
                this.parseHTTPResponse(string3);
            } else {
                string5 = String.format(LANDING_PAGE_PARM, ACTIAN_ID_REFERER, string2);
                string4 = HTTPS_PREFIX + paramStore.getActianid_host() + string5;
                paramStore.setAuthorization_code_url(string4);
                LOGGER.info("Set authorization URL to " + string4);
            }
            if (paramStore.getAuthorization_code_url() == null) {
                String string7 = "Failed to obtain authorization URL";
                LOGGER.severe(string7);
                throw new Exception(string7);
            }
            LOGGER.info("Starting web server on port: 4200");
            try {
                boolean bl2 = true;
                int n = 0;
                while (bl2) {
                    if (++n > 2) {
                        bl2 = false;
                    }
                    LOGGER.info("Local web server loop: " + n);
                    fIMHTTPServer = new FIMHTTPServer(4200);
                    thread = new Thread(fIMHTTPServer);
                    thread.start();
                    LOGGER.info("Launching a browser to authenticate user, url=" + paramStore.getAuthorization_code_url());
                    this.openDefaultBrowser(paramStore.getAuthorization_code_url());
                    LOGGER.info("Waiting for web server to receive auth code");
                    int n2 = 0;
                    while (thread.isAlive()) {
                        Thread.sleep(10L);
                        if (n2 > 10000) {
                            LOGGER.severe("Give up waiting on web server.");
                            fIMHTTPServer.shutdown();
                            break;
                        }
                        if (fIMHTTPServer.getMessage() != null || fIMHTTPServer.getError() != null) break;
                        ++n2;
                    }
                    String string8 = fIMHTTPServer.getMessage();
                    String string9 = fIMHTTPServer.getError();
                    LOGGER.info("During this loop: message=" + string8 + ", error=" + string9 + ", retry=" + bl2 + ", retry_count=" + n);
                    if (!(bl2 || string8 != null && string9 == null)) {
                        LOGGER.severe("Web server failed to receive message or reported an error (no retry): error=" + string9 + ", message=" + string8);
                        if (string9 == null) {
                            string9 = "Failed to retrieve access token!";
                        }
                        throw new Exception(string9);
                    }
                    if (string8 != null) {
                        bl2 = false;
                    } else if (string9 != null) {
                        LOGGER.severe("Web server reported error (retry): " + string9);
                    }
                    while (bl2 && thread.isAlive()) {
                        Thread.sleep(10L);
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.severe("Exception running web server: " + exception);
                if (thread.isAlive()) {
                    fIMHTTPServer.shutdown();
                }
                throw exception;
            }
            this.parseHTTPResponse(fIMHTTPServer.getMessage());
            if (paramStore.getState() != null && !string2.equals(paramStore.getState())) {
                String string10 = "Security check using state parameter failed, this may indicate foul play!\nApplication generated state = " + string2 + ", AOP returned state = " + paramStore.getState();
                LOGGER.severe(string10);
                throw new Exception(string10);
            }
            if (!string.equals(paramStore.getActianid_host())) {
                LOGGER.info("Reconnect needed: " + paramStore.getActianid_host());
                this.disconnect();
                this.connect(paramStore.getActianid_host());
            }
            string5 = URLDecoder.decode(paramStore.getAuthorization_code(), StandardCharsets.UTF_8.name());
            LOGGER.info("decoded authorization code = " + string5);
            string5 = String.format(ACTIAN_ID_AUTH_TOKEN, string5, ACTIAN_ID_REFERER);
            string4 = String.format(MSG_TEMPLATE, paramStore.getActianid_dirpath() + string5, paramStore.getActianid_host(), "");
            this.sendMessage(string4);
            string3 = this.receiveResponse();
            this.parseResponse(string3);
            if (paramStore.getError_description() != null) {
                String string11 = "Error retrieving access token: " + paramStore.getError_description();
                LOGGER.severe(string11);
                throw new Exception(string11);
            }
        }
        catch (Exception exception) {
            LOGGER.severe("Unexpected exception: " + exception);
            throw exception;
        }
    }

    public String getAccessToken(int n, String string) throws Exception {
        AuthType authType = null;
        try {
            authType = AuthType.getAuthType(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.severe("Invalid access token type requested: " + n + ", error: " + illegalArgumentException);
            throw illegalArgumentException;
        }
        return this.getAccessToken(authType, string);
    }

    public String getAccessToken(String string, String string2) throws Exception {
        AuthType authType = null;
        try {
            authType = AuthType.getAuthType(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.severe("Invalid access token type requested: " + string + ", error: " + illegalArgumentException);
            throw illegalArgumentException;
        }
        return this.getAccessToken(authType, string2);
    }

    public String getAccessToken(AuthType authType, String string) throws Exception {
        String string2 = null;
        LOGGER.info("Auth type=" + (Object)((Object)authType) + "Auth server=" + string);
        string = string.toLowerCase();
        switch (authType) {
            case NATIVE: {
                return null;
            }
            case CLI: 
            case BROWSER: {
                break;
            }
            default: {
                LOGGER.warning("Invalid authorization type provided: " + (Object)((Object)authType));
                throw new Exception("Unsupported authorization type.");
            }
        }
        if (!FedIdentityMgmt.mutexLock()) {
            throw new Exception("Failed to lock mutex for authentication access");
        }
        if (this.isValidCachedAccessToken(string)) {
            string2 = paramStore.getAccess_token();
            this.access_user = paramStore.getPreferred_username();
            FedIdentityMgmt.mutexUnlock();
            return ACCESS_TOKEN_PREFIX + string2;
        }
        paramStore.setSession_name(this.extractSessionName());
        paramStore.setAuth_server(string);
        if (string.indexOf(47) >= 0 || string.indexOf(44) >= 0) {
            this.parseStateAndServer(string);
        } else {
            paramStore.setActianid_host(string);
        }
        LOGGER.info("Authentication host=" + paramStore.getActianid_host() + ", dirpath=" + paramStore.getActianid_dirpath());
        try {
            boolean bl = false;
            this.connect(paramStore.getActianid_host());
            bl = this.isAOPServer();
            switch (authType) {
                case CLI: {
                    this.getAccessTokenUsingCLI(bl);
                    break;
                }
                case BROWSER: {
                    this.getAccessTokenUsingBrowser(bl);
                }
            }
            string2 = paramStore.getAccess_token();
            if (string2 == null) {
                String string3 = "Failed to retrieve access token for auth_server=" + string + " and auth_type=" + (Object)((Object)authType);
                throw new Exception(string3);
            }
            LOGGER.info("Access token=" + string2);
            String string4 = paramStore.getActianid_dirpath() + ACTIAN_ID_USERINFO;
            String string5 = ACTIAN_ID_AUTHORIZATION + string2 + EOL;
            String string6 = String.format(MSG_TEMPLATE, string4, paramStore.getActianid_host(), string5);
            this.sendMessage(string6);
            String string7 = this.receiveResponse();
            this.parseResponse(string7);
            this.access_user = paramStore.getPreferred_username();
            this.disconnect();
        }
        catch (Exception exception) {
            try {
                this.disconnect();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            LOGGER.severe("Exception: " + exception);
            throw exception;
        }
        finally {
            FedIdentityMgmt.mutexUnlock();
        }
        return ACCESS_TOKEN_PREFIX + string2;
    }

    public String getAccessTokenUserID() {
        LOGGER.info("Access User ID: " + this.access_user);
        return this.access_user;
    }

    public static enum AuthType {
        NATIVE,
        BROWSER,
        CLI;


        public static AuthType getAuthType(String string) throws IllegalArgumentException {
            return AuthType.valueOf(string.toUpperCase());
        }

        public static AuthType getAuthType(int n) throws IllegalArgumentException {
            return AuthType.values()[n];
        }
    }
}

