/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvObj;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.jdbc.JdbcRslt;
import com.ingres.gcf.jdbc.RsltCurs;
import com.ingres.gcf.jdbc.RsltData;
import com.ingres.gcf.jdbc.RsltScrUpd;
import com.ingres.gcf.jdbc.RsltScroll;
import com.ingres.gcf.jdbc.RsltSlct;
import com.ingres.gcf.jdbc.RsltStrm;
import com.ingres.gcf.jdbc.RsltUpd;
import com.ingres.gcf.jdbc.SqlParse;
import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.SqlBigInt;
import com.ingres.gcf.util.SqlByte;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.SqlWarn;
import com.ingres.gcf.util.Timer;
import com.ingres.gcf.util.XaEx;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import java.util.LinkedList;

public class JdbcStmt
extends DrvObj
implements Statement,
DbmsConst,
Timer.Callback {
    int rs_fetch_dir = 1000;
    int rs_fetch_size = 0;
    long rs_max_rows = 0L;
    int rs_max_len = 0;
    protected static final int QUERY = 1;
    protected static final int UPDATE = 0;
    protected static final int UNKNOWN = -1;
    protected static final String crsr_prefix = "JDBC_CRSR_";
    protected LinkedList batch = null;
    protected JdbcRslt resultSet = null;
    protected String crsr_name = null;
    protected int rs_type;
    protected int rs_concur;
    protected int rs_hold;
    protected boolean parse_escapes = true;
    protected int timeout = 0;
    private static JdbcRSMD rsmdKeys = null;
    private static JdbcRSMD rsmdTblKey = null;
    private static JdbcRSMD rsmdObjKey = null;
    private static JdbcRSMD rsmdIdentity = null;
    private static JdbcRSMD rsmdEmpty = null;
    private QueryIdentity queryIdentity = null;
    private Timer timer = null;
    private boolean timed_out = false;
    private boolean closed = false;
    private boolean closeOnComplete = false;

    JdbcStmt(DrvConn drvConn, int n, int n2, int n3) {
        super(drvConn);
        this.rs_type = n;
        this.rs_concur = n2;
        this.rs_hold = n3;
        this.title = this.trace.getTraceName() + "-Statement[" + this.inst_id + "]";
        this.tr_id = "Stmt[" + this.inst_id + "]";
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeQuery('" + string + "')");
        }
        this.exec(string, 1, false);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeQuery(): " + this.resultSet);
        }
        return this.resultSet;
    }

    @Override
    public long executeLargeUpdate(String string) throws SQLException {
        long l;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate('" + string + "')");
        }
        this.exec(string, 0, false);
        long l2 = l = (this.rslt_items & 8) != 0 ? this.rslt_val_rowcnt : 0L;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate(): " + l);
        }
        return l;
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        long l = this.executeLargeUpdate(string);
        int n = (int)l;
        if (this.trace.enabled(1) && l != (long)n) {
            this.trace.write(this.tr_id + ": truncated update count = " + n);
        }
        return n;
    }

    @Override
    public long executeLargeUpdate(String string, int n) throws SQLException {
        long l;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate('" + string + "'," + n + ")");
        }
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        this.exec(string, 0, n == 1);
        long l2 = l = (this.rslt_items & 8) != 0 ? this.rslt_val_rowcnt : 0L;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate(): " + l);
        }
        return l;
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        long l = this.executeLargeUpdate(string, n);
        int n2 = (int)l;
        if (this.trace.enabled(1) && l != (long)n2) {
            this.trace.write(this.tr_id + ": truncated update count = " + n2);
        }
        return n2;
    }

    @Override
    public long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        long l;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate('" + string + "'," + (nArray == null ? "null" : "[" + nArray.length + "]") + ")");
        }
        this.exec(string, 0, nArray != null && nArray.length > 0);
        long l2 = l = (this.rslt_items & 8) != 0 ? this.rslt_val_rowcnt : 0L;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate(): " + l);
        }
        return l;
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        long l = this.executeLargeUpdate(string, nArray);
        int n = (int)l;
        if (this.trace.enabled(1) && l != (long)n) {
            this.trace.write(this.tr_id + ": truncated update count = " + n);
        }
        return n;
    }

    @Override
    public long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        long l;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate('" + string + "'," + (stringArray == null ? "null" : "[" + stringArray.length + "]") + ")");
        }
        this.exec(string, 0, stringArray != null && stringArray.length > 0);
        long l2 = l = (this.rslt_items & 8) != 0 ? this.rslt_val_rowcnt : 0L;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate(): " + l);
        }
        return l;
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        long l = this.executeLargeUpdate(string, stringArray);
        int n = (int)l;
        if (this.trace.enabled(1) && l != (long)n) {
            this.trace.write(this.tr_id + ": truncated update count = " + n);
        }
        return n;
    }

    @Override
    public boolean execute(String string) throws SQLException {
        boolean bl;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute( '" + string + "' )");
        }
        this.exec(string, -1, false);
        boolean bl2 = bl = this.resultSet != null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute(): " + bl);
        }
        return bl;
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        boolean bl;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute( '" + string + "'" + n + ")");
        }
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        this.exec(string, -1, n == 1);
        boolean bl2 = bl = this.resultSet != null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute(): " + bl);
        }
        return bl;
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        boolean bl;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute( '" + string + "'," + (nArray == null ? "null" : "[" + nArray.length + "]") + ")");
        }
        this.exec(string, -1, nArray != null && nArray.length > 0);
        boolean bl2 = bl = this.resultSet != null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute(): " + bl);
        }
        return bl;
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        boolean bl;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute( '" + string + "'," + (stringArray == null ? "null" : "[" + stringArray.length + "]") + ")");
        }
        this.exec(string, -1, stringArray == null && stringArray.length > 0);
        boolean bl2 = bl = this.resultSet != null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute(): " + bl);
        }
        return bl;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getResultSet(): " + this.resultSet);
        }
        return this.resultSet;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return super.getWarnings();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        long l;
        long l2 = l = this.resultSet != null || (this.rslt_items & 8) == 0 ? -1L : this.rslt_val_rowcnt;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getLargeUpdateCount(): " + l);
        }
        return l;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        long l = this.getLargeUpdateCount();
        int n = (int)l;
        if (this.trace.enabled(1) && l != (long)n) {
            this.trace.write(this.tr_id + ": truncated update count = " + n);
        }
        return n;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMoreResults(): " + false);
        }
        this.clearQueryResults(true);
        return false;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMoreResults(" + n + "): " + false);
        }
        switch (n) {
            case 2: {
                this.clearQueryResults(false);
                break;
            }
            case 1: 
            case 3: {
                this.clearQueryResults(true);
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        return false;
    }

    @Override
    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        RsltData rsltData = null;
        if ((this.rslt_items & 0x40) != 0) {
            if ((this.rslt_items & 0x80) != 0) {
                if (rsmdKeys == null) {
                    rsmdKeys = new JdbcRSMD(2, this.trace);
                    rsmdKeys.setColumnInfo("table_key", 1, -2, (short)12, (short)8, (byte)0, (byte)0, false);
                    rsmdKeys.setColumnInfo("object_key", 2, -2, (short)11, (short)16, (byte)0, (byte)0, false);
                }
                SqlData[][] sqlDataArray = new SqlData[][]{new SqlData[2]};
                SqlByte sqlByte = new SqlByte(8);
                sqlByte.clear();
                sqlByte.put(this.rslt_val_tblkey);
                sqlDataArray[0][0] = sqlByte;
                sqlByte = new SqlByte(16);
                sqlByte.clear();
                sqlByte.put(this.rslt_val_objkey);
                sqlDataArray[0][1] = sqlByte;
                rsltData = new RsltData(this.conn, rsmdKeys, sqlDataArray);
            } else {
                if (rsmdTblKey == null) {
                    rsmdTblKey = new JdbcRSMD(1, this.trace);
                    rsmdTblKey.setColumnInfo("table_key", 1, -2, (short)12, (short)8, (byte)0, (byte)0, false);
                }
                SqlData[][] sqlDataArray = new SqlData[][]{new SqlData[1]};
                SqlByte sqlByte = new SqlByte(8);
                sqlByte.clear();
                sqlByte.put(this.rslt_val_tblkey);
                sqlDataArray[0][0] = sqlByte;
                rsltData = new RsltData(this.conn, rsmdTblKey, sqlDataArray);
            }
        } else if ((this.rslt_items & 0x80) != 0) {
            if (rsmdObjKey == null) {
                rsmdObjKey = new JdbcRSMD(1, this.trace);
                rsmdObjKey.setColumnInfo("object_key", 1, -2, (short)11, (short)16, (byte)0, (byte)0, false);
            }
            SqlData[][] sqlDataArray = new SqlData[][]{new SqlData[1]};
            SqlByte sqlByte = new SqlByte(16);
            sqlByte.clear();
            sqlByte.put(this.rslt_val_objkey);
            sqlDataArray[0][0] = sqlByte;
            rsltData = new RsltData(this.conn, rsmdObjKey, sqlDataArray);
        } else if (this.queryIdentity != null && !this.queryIdentity.isNull()) {
            if (rsmdIdentity == null) {
                rsmdIdentity = new JdbcRSMD(1, this.trace);
                rsmdIdentity.setColumnInfo("identity", 1, -5, (short)30, (short)8, (byte)0, (byte)0, false);
            }
            SqlData[][] sqlDataArray = new SqlData[][]{new SqlData[1]};
            SqlBigInt sqlBigInt = new SqlBigInt();
            sqlBigInt.set(this.queryIdentity.getLong());
            sqlDataArray[0][0] = sqlBigInt;
            rsltData = new RsltData(this.conn, rsmdIdentity, sqlDataArray);
        } else {
            if (rsmdEmpty == null) {
                rsmdEmpty = new JdbcRSMD(1, this.trace);
                rsmdEmpty.setColumnInfo("no_key", 1, -2, (short)12, (short)8, (byte)0, (byte)0, false);
            }
            rsltData = new RsltData(this.conn, rsmdEmpty, null);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getGeneratedKeys: " + rsltData);
        }
        return rsltData;
    }

    @Override
    protected void clearResults() {
        this.clearQueryResults(true);
        if (this.queryIdentity != null) {
            this.queryIdentity.clear();
        }
        this.rslt_items &= 0xFFFFFF3F;
        super.clearResults();
    }

    protected synchronized void clearQueryResults(boolean bl) {
        if (bl && this.resultSet != null) {
            try {
                this.resultSet.shut();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.resultSet = null;
        }
        this.rslt_items &= 0xFFFFFFF7;
        this.rslt_val_rowcnt = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".addBatch( '" + string + "' )");
        }
        if (this.batch == null) {
            this.newBatch();
        }
        LinkedList linkedList = this.batch;
        synchronized (linkedList) {
            this.batch.addLast(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".clearBatch()");
        }
        if (this.batch != null) {
            LinkedList linkedList = this.batch;
            synchronized (linkedList) {
                this.batch.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeBatch()");
        }
        if (this.batch == null) {
            return BatchIntResults.getEmptyResults();
        }
        BatchIntResults batchIntResults = new BatchIntResults();
        LinkedList linkedList = this.batch;
        synchronized (linkedList) {
            try {
                if ((this.conn.cnf_flags & 0x200) == 0 || this.conn.db_protocol_level < 6) {
                    this.iterateBatch(batchIntResults);
                } else {
                    BatchExec batchExec = new BatchExec(this.conn, batchIntResults);
                    batchExec.execute(this.batch, this.parse_escapes);
                }
            }
            finally {
                this.batch.clear();
            }
        }
        return batchIntResults.getResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeBatch()");
        }
        if (this.batch == null) {
            return BatchLongResults.getEmptyResults();
        }
        BatchLongResults batchLongResults = new BatchLongResults();
        LinkedList linkedList = this.batch;
        synchronized (linkedList) {
            try {
                if ((this.conn.cnf_flags & 0x200) == 0 || this.conn.db_protocol_level < 6) {
                    this.iterateBatch(batchLongResults);
                } else {
                    BatchExec batchExec = new BatchExec(this.conn, batchLongResults);
                    batchExec.execute(this.batch, this.parse_escapes);
                }
            }
            finally {
                this.batch.clear();
            }
        }
        return batchLongResults.getResults();
    }

    private BatchResults iterateBatch(BatchResults batchResults) throws SQLException {
        String string;
        batchResults.setBatchSize(0);
        batchResults.setBatchSize(this.batch.size());
        int n = 0;
        while ((string = (String)this.batch.pollFirst()) != null) {
            try {
                if (this.trace.enabled()) {
                    this.trace.log(this.title + ".executeBatch[" + n + "]: '" + string + "'");
                }
                this.exec(string, 0, false);
                long l = (this.rslt_items & 8) != 0 ? this.rslt_val_rowcnt : -2L;
                long l2 = batchResults.addResult(l);
                if (this.trace.enabled()) {
                    this.trace.log(this.title + ".executeBatch[" + n + "] = " + l);
                }
                if (this.trace.enabled(1) && l2 != l) {
                    this.trace.write(this.tr_id + ": truncated update count = " + l2);
                }
            }
            catch (SQLException sQLException) {
                throw batchResults.batchUpdateEx(sQLException);
            }
            ++n;
        }
        return batchResults;
    }

    private void exec(String string, int n, boolean bl) throws SQLException {
        block41: {
            SqlParse sqlParse = new SqlParse(string, this.conn);
            int n2 = sqlParse.getQueryType();
            String string2 = null;
            this.clearResults();
            if (n == -1) {
                int n3 = n = n2 == 1 ? 1 : 0;
            }
            if (n2 == 2 || n2 == 3) {
                string2 = sqlParse.getCursorName();
            }
            this.msg.lock();
            try {
                String string3 = sqlParse.parseSQL(this.parse_escapes);
                if (n == 1) {
                    int n4 = this.getConcurrency(sqlParse.getConcurrency());
                    if ((this.conn.cnf_flags & (0x40 | 0x80)) != 0 && this.crsr_name == null && this.rs_type == 1003 && n4 != 1 && this.conn.msg_protocol_level >= 2) {
                        short s = 0;
                        boolean bl2 = true;
                        this.msg.begin((byte)4);
                        this.msg.write((short)1);
                        if (this.conn.msg_protocol_level >= 3) {
                            s = 2;
                            if (this.enableLocators(true)) {
                                s = (short)(s | 0x20);
                            }
                            if (this.rs_fetch_size != 1 && this.conn.cnf_pre_blocks > 0) {
                                s = (this.conn.cnf_flags & 0x80) != 0 ? (short)(s | 8) : (short)(s | 4);
                                bl2 = false;
                            }
                            this.msg.write((short)6);
                            this.msg.write((short)2);
                            this.msg.write(s);
                        }
                        this.writeQueryText(string3);
                        this.msg.done(true);
                        JdbcRSMD jdbcRSMD = this.readResults(this.timeout, bl2);
                        if (jdbcRSMD == null) {
                            throw SqlExFactory.get(ERR_GC4017_NO_RESULT_SET);
                        }
                        this.resultSet = (s & 8) != 0 ? new RsltStrm(this.conn, this, jdbcRSMD, this.rslt_val_stmt) : new RsltSlct(this.conn, this, jdbcRSMD, this.rslt_val_stmt, this.getPreFetchSize(), this.msg.moreMessages());
                    } else {
                        short s = 0;
                        boolean bl3 = true;
                        String string4 = string2 = this.crsr_name != null ? this.crsr_name : this.conn.getUniqueID(crsr_prefix);
                        if (n4 == 0) {
                            if (this.conn.msg_protocol_level < 2) {
                                string3 = string3 + " for readonly";
                            } else {
                                s = (short)(s | 1);
                                if (this.conn.msg_protocol_level >= 3 && this.rs_type == 1003 && this.rs_fetch_size != 1 && this.conn.cnf_pre_blocks > 0) {
                                    s = (short)(s | 4);
                                    bl3 = false;
                                }
                            }
                        }
                        if ((this.conn.cnf_flags & 0x100) != 0 && this.rs_type != 1003) {
                            s = (short)(s | 0x40);
                        } else if (this.conn.msg_protocol_level >= 3) {
                            s = (short)(s | 2);
                        }
                        if (this.enableLocators(false)) {
                            s = (short)(s | 0x20);
                        }
                        this.msg.begin((byte)4);
                        this.msg.write((short)2);
                        if (s != 0) {
                            this.msg.write((short)6);
                            this.msg.write((short)2);
                            this.msg.write(s);
                        }
                        this.msg.write((short)2);
                        this.msg.write(string2);
                        this.writeQueryText(string3);
                        this.msg.done(true);
                        JdbcRSMD jdbcRSMD = this.readResults(this.timeout, bl3);
                        if (jdbcRSMD == null) {
                            throw SqlExFactory.get(ERR_GC4017_NO_RESULT_SET);
                        }
                        switch (this.rslt_flags & 0x12) {
                            case 0: {
                                if (this.rs_type != 1003 || this.rs_concur != 1) {
                                    this.warnings = SqlWarn.get(ERR_GC4016_RS_CHANGED);
                                }
                                this.resultSet = new RsltUpd(this.conn, this, jdbcRSMD, this.rslt_val_stmt, string2, sqlParse.getTableName());
                                if (!this.msg.moreMessages()) break;
                                this.readResults(this.timeout, true);
                                break;
                            }
                            case 16: {
                                if (this.rs_type != 1005 || this.rs_concur != 1) {
                                    this.warnings = SqlWarn.get(ERR_GC4016_RS_CHANGED);
                                }
                                this.resultSet = new RsltScrUpd(this.conn, this, jdbcRSMD, this.rslt_val_stmt, string2, sqlParse.getTableName());
                                if (!this.msg.moreMessages()) break;
                                this.readResults(this.timeout, true);
                                break;
                            }
                            case 2: {
                                if (this.rs_type != 1003 || this.rs_concur == 1) {
                                    this.warnings = SqlWarn.get(ERR_GC4016_RS_CHANGED);
                                }
                                this.resultSet = new RsltCurs(this.conn, this, jdbcRSMD, this.rslt_val_stmt, this.crsr_name, this.getPreFetchSize(), this.msg.moreMessages());
                                break;
                            }
                            case 18: {
                                if (this.rs_type != 1004 || this.rs_concur == 1) {
                                    this.warnings = SqlWarn.get(ERR_GC4016_RS_CHANGED);
                                }
                                this.resultSet = new RsltScroll(this.conn, this, jdbcRSMD, this.rslt_val_stmt, this.crsr_name, this.getPreFetchSize(), this.msg.moreMessages());
                            }
                        }
                        this.msg.unlock();
                    }
                    break block41;
                }
                if (string2 != null) {
                    this.msg.begin((byte)4);
                    this.msg.write(n2 == 2 ? (short)7 : 8);
                    this.msg.write((short)2);
                    this.msg.write(string2);
                    this.writeQueryText(string3);
                    this.msg.done(true);
                    if (this.readResults(this.timeout, true) != null) {
                        throw SqlExFactory.get(ERR_GC4018_RESULT_SET_NOT_PERMITTED);
                    }
                    this.msg.unlock();
                    break block41;
                }
                this.msg.begin((byte)4);
                this.msg.write((short)1);
                this.writeQueryText(string3);
                this.msg.done(true);
                JdbcRSMD jdbcRSMD = this.readResults(this.timeout, true);
                if (jdbcRSMD == null) {
                    boolean bl4 = true;
                    if (bl) {
                        this.loadGeneratedKeys();
                        bl4 = this.msg.isLocked(false);
                    }
                    if (bl4) {
                        this.msg.unlock();
                    }
                    break block41;
                }
                this.resultSet = new RsltSlct(this.conn, null, jdbcRSMD, this.rslt_val_stmt, 1, false);
                try {
                    this.resultSet.shut();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.resultSet = null;
                throw SqlExFactory.get(ERR_GC4018_RESULT_SET_NOT_PERMITTED);
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled()) {
                    this.trace.log(this.title + ".execute(): error executing query");
                }
                if (this.trace.enabled(1)) {
                    SqlExFactory.trace(sQLException, this.trace);
                }
                this.msg.unlock();
                throw sQLException;
            }
            catch (RuntimeException runtimeException) {
                this.msg.unlock();
                throw runtimeException;
            }
        }
    }

    @Override
    public void cancel() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".cancel()");
        }
        this.msg.cancel();
    }

    @Override
    public void close() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".close()");
        }
        this.shut();
    }

    void resultComplete() {
        if (this.closeOnComplete) {
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ": closing due to ResultSet completion");
            }
            this.shut();
        }
    }

    protected void shut() {
        this.closeOnComplete = false;
        this.clearResults();
        this.closed = true;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getConnection(): " + this.conn.jdbc);
        }
        return this.conn.jdbc;
    }

    @Override
    public int getResultSetType() {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getResultSetType(): " + this.rs_type);
        }
        return this.rs_type;
    }

    @Override
    public int getResultSetConcurrency() {
        int n = this.rs_concur == 1 ? 1008 : 1007;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getResultSetConcurrency(): " + n);
        }
        return n;
    }

    @Override
    public int getResultSetHoldability() {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getResultSetHoldability(): " + this.rs_hold);
        }
        return this.rs_hold;
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isClosed(): " + this.closed);
        }
        return this.closed;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setPoolable()");
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isPoolable()");
        }
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isWrapperFor(" + clazz + ")");
        }
        if (clazz != null) {
            return clazz.isInstance(this);
        }
        throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".unwrap(" + clazz + ")");
        }
        if (clazz != null) {
            if (!clazz.isInstance(this)) {
                throw SqlExFactory.get(ERR_GC4023_NO_OBJECT);
            }
            return clazz.cast(this);
        }
        throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setCursorName( '" + string + "' )");
        }
        this.crsr_name = string;
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setEscapeProcessing( " + bl + " )");
        }
        this.parse_escapes = bl;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getFetchDirection(): " + this.rs_fetch_dir);
        }
        return this.rs_fetch_dir;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setFetchDirection( " + n + " )");
        }
        switch (n) {
            case 1000: 
            case 1001: 
            case 1002: {
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        this.rs_fetch_dir = n;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getFetchSize(): " + this.rs_fetch_size);
        }
        return this.rs_fetch_size;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setFetchSize( " + n + " )");
        }
        if (n < 0 || this.rs_max_rows > 0L && (long)n > this.rs_max_rows) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        this.rs_fetch_size = n;
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxRows(): " + this.rs_max_rows);
        }
        return this.rs_max_rows;
    }

    @Override
    public int getMaxRows() throws SQLException {
        long l = this.getLargeMaxRows();
        int n = (int)l;
        if (this.trace.enabled(1) && l != (long)n) {
            this.trace.write(this.tr_id + ": truncated max rows = " + n);
        }
        return n;
    }

    @Override
    public void setLargeMaxRows(long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setMaxRows( " + l + " )");
        }
        if (l < 0L) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        this.rs_max_rows = l;
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this.setLargeMaxRows(n);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxFieldSize(): " + this.rs_max_len);
        }
        return this.rs_max_len;
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setMaxFieldSize( " + n + " )");
        }
        if (n < 0) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        this.rs_max_len = n;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getQueryTimeout(): " + this.timeout);
        }
        return this.timeout;
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setQueryTimeout( " + n + " )");
        }
        if (n < 0) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        this.timeout = n;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnComplete;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.closeOnComplete = true;
    }

    protected synchronized void newBatch() {
        if (this.batch == null) {
            this.batch = new LinkedList();
        }
    }

    protected int getConcurrency(int n) {
        if (n != -1) {
            return n;
        }
        if (this.rs_concur != -1) {
            return this.rs_concur;
        }
        return this.conn.readOnly ? 0 : this.conn.cursor_mode;
    }

    protected int getPreFetchSize() {
        return (this.rslt_items & 1) == 0 ? -1 : (this.rslt_val_fetch < 1 ? 0 : this.rslt_val_fetch);
    }

    protected boolean enableLocators(boolean bl) {
        int n = 1;
        if (this.conn.autoCommit) {
            n |= 2;
        }
        if (bl) {
            n |= 4;
        }
        return (this.conn.cnf_flags & n) == n;
    }

    protected void loadGeneratedKeys() {
        if (this.conn.db_protocol_level >= 6) {
            if ((this.conn.cnf_flags & 0x1000) != 0 && (this.rslt_items & 0xC0) == 0) {
                if (this.queryIdentity == null) {
                    this.queryIdentity = new QueryIdentity(this.conn);
                }
                this.queryIdentity.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JdbcRSMD readResults(int n, boolean bl) throws SQLException {
        JdbcRSMD jdbcRSMD;
        this.enableTimer(n);
        try {
            jdbcRSMD = this.readResults(bl);
        }
        finally {
            this.disableTimer();
            this.timed_out = false;
        }
        return jdbcRSMD;
    }

    protected JdbcRSMD readResults(boolean bl) throws SQLException {
        JdbcRSMD jdbcRSMD = null;
        do {
            JdbcRSMD jdbcRSMD2;
            if ((jdbcRSMD2 = this.readResults()) == null) continue;
            jdbcRSMD = jdbcRSMD2;
        } while (bl && this.msg.moreMessages());
        return jdbcRSMD;
    }

    @Override
    protected JdbcRSMD readDesc() throws SQLException {
        this.disableTimer();
        return JdbcRSMD.load(this.conn);
    }

    protected JdbcRSMD readDesc(JdbcRSMD jdbcRSMD) throws SQLException {
        this.disableTimer();
        if (jdbcRSMD == null) {
            jdbcRSMD = JdbcRSMD.load(this.conn);
        } else {
            jdbcRSMD.reload(this.conn);
        }
        return jdbcRSMD;
    }

    @Override
    protected SQLException readError() throws SQLException {
        this.disableTimer();
        SQLException sQLException = super.readError();
        if (this.timed_out && sQLException != null && sQLException.getErrorCode() == 0xC90009) {
            sQLException = SqlExFactory.get(ERR_GC4006_TIMEOUT);
        }
        return sQLException;
    }

    @Override
    protected boolean readResult() throws SQLException {
        this.disableTimer();
        super.readResult();
        return true;
    }

    private void enableTimer(int n) {
        this.timed_out = false;
        if (n == 0) {
            this.timer = null;
        } else {
            this.timer = new Timer(n, this);
            this.timer.start();
        }
    }

    @Override
    public void timeExpired() {
        if (this.timer != null) {
            this.timed_out = true;
            this.timer = null;
        }
        try {
            this.msg.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void disableTimer() {
        if (this.timer != null) {
            this.timer.interrupt();
            this.timer = null;
        }
    }

    protected static class QueryIdentity
    extends DrvObj {
        private boolean isNull = true;
        private long value = 0L;

        public QueryIdentity(DrvConn drvConn) {
            super(drvConn);
            this.title = this.trace.getTraceName() + "-QueryIdentity[" + this.msg.connID() + "]";
            this.tr_id = "Identity[" + this.msg.connID() + "]";
        }

        public void execute() {
            block4: {
                this.clear();
                try {
                    this.msg.begin((byte)4);
                    this.msg.write((short)1);
                    this.msg.write((short)6);
                    this.msg.write((short)2);
                    this.msg.write((short)10);
                    this.writeQueryText("select last_identity()");
                    this.msg.done(true);
                    JdbcRSMD jdbcRSMD = this.readResults();
                    if (jdbcRSMD != null) {
                        RsltSlct rsltSlct = new RsltSlct(this.conn, null, jdbcRSMD, this.rslt_val_stmt, 2, this.msg.moreMessages());
                        if (rsltSlct.next()) {
                            this.value = rsltSlct.getLong(1);
                            this.isNull = rsltSlct.wasNull();
                        }
                        rsltSlct.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!this.trace.enabled(1)) break block4;
                    this.trace.write(this.tr_id + ": error retrieving identity value");
                    SqlExFactory.trace(sQLException, this.trace);
                }
            }
        }

        public void clear() {
            this.isNull = true;
            this.value = 0L;
        }

        public boolean isNull() {
            return this.isNull;
        }

        public long getLong() {
            return this.value;
        }

        @Override
        protected JdbcRSMD readDesc() throws SQLException {
            return JdbcRSMD.load(this.conn);
        }

        @Override
        protected boolean readResult() throws SQLException {
            super.readResult();
            return true;
        }
    }

    protected static class BatchLongResults
    implements BatchResults {
        private static final long[] noResults = new long[0];
        private long[] results = noResults;
        private int length = 0;

        protected BatchLongResults() {
        }

        public static long[] getEmptyResults() {
            return noResults;
        }

        public long[] getResults() {
            long[] lArray = this.length <= 0 ? noResults : (this.length < this.results.length ? Arrays.copyOf(this.results, this.length) : this.results);
            return lArray;
        }

        @Override
        public int batchSize() {
            return this.results.length;
        }

        @Override
        public void setBatchSize(int n) {
            if (n < 0) {
                throw new NegativeArraySizeException();
            }
            if (n == 0) {
                this.results = noResults;
            } else if (n != this.results.length) {
                this.results = Arrays.copyOf(this.results, n);
            }
            if (this.length > n) {
                this.length = n;
            }
        }

        @Override
        public int resultCount() {
            return this.length;
        }

        @Override
        public long addResult(long l) {
            if (this.length >= this.results.length) {
                throw new IndexOutOfBoundsException();
            }
            this.results[this.length] = l;
            long l2 = this.results[this.length];
            ++this.length;
            return l2;
        }

        @Override
        public SQLException batchUpdateEx(SQLException sQLException) {
            long[] lArray = this.getResults();
            BatchUpdateException batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), lArray, null);
            batchUpdateException.setNextException(sQLException.getNextException());
            return batchUpdateException;
        }
    }

    protected static class BatchIntResults
    implements BatchResults {
        private static final int[] noResults = new int[0];
        private int[] results = noResults;
        private int length = 0;

        protected BatchIntResults() {
        }

        public static int[] getEmptyResults() {
            return noResults;
        }

        public int[] getResults() {
            int[] nArray = this.length <= 0 ? noResults : (this.length < this.results.length ? Arrays.copyOf(this.results, this.length) : this.results);
            return nArray;
        }

        @Override
        public int batchSize() {
            return this.results.length;
        }

        @Override
        public void setBatchSize(int n) {
            if (n < 0) {
                throw new NegativeArraySizeException();
            }
            if (n == 0) {
                this.results = noResults;
            } else if (n != this.results.length) {
                this.results = Arrays.copyOf(this.results, n);
            }
            if (this.length > n) {
                this.length = n;
            }
        }

        @Override
        public int resultCount() {
            return this.length;
        }

        @Override
        public long addResult(long l) {
            if (this.length >= this.results.length) {
                throw new IndexOutOfBoundsException();
            }
            this.results[this.length] = (int)l;
            long l2 = this.results[this.length];
            ++this.length;
            return l2;
        }

        @Override
        public SQLException batchUpdateEx(SQLException sQLException) {
            int[] nArray = this.getResults();
            BatchUpdateException batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray);
            batchUpdateException.setNextException(sQLException.getNextException());
            return batchUpdateException;
        }
    }

    protected static interface BatchResults {
        public int batchSize();

        public void setBatchSize(int var1);

        public int resultCount();

        public long addResult(long var1);

        public SQLException batchUpdateEx(SQLException var1);
    }

    protected static class BatchExec
    extends DrvObj {
        protected BatchResults batchResults = null;
        protected SQLException batchExList = null;
        protected SQLException exList = null;

        public BatchExec(DrvConn drvConn, BatchResults batchResults) {
            super(drvConn);
            this.title = this.trace.getTraceName() + "-BatchExec[" + this.msg.connID() + "]";
            this.tr_id = "Batch[" + this.msg.connID() + "]";
            this.batchResults = batchResults;
        }

        public BatchResults execute(LinkedList linkedList, boolean bl) throws SQLException {
            this.batchResults.setBatchSize(0);
            this.batchResults.setBatchSize(linkedList.size());
            this.batchExList = null;
            this.exList = null;
            if (linkedList == null || linkedList.peekFirst() == null) {
                return this.batchResults;
            }
            this.clearResults();
            this.msg.lock();
            try {
                String string;
                int n = 0;
                while ((string = (String)linkedList.pollFirst()) != null) {
                    if (this.trace.enabled()) {
                        this.trace.log(this.title + ".executeBatch[" + n + "]: '" + string + "'");
                    }
                    string = new SqlParse(string, this.conn).parseSQL(bl);
                    this.msg.begin((byte)12);
                    this.msg.write((short)1);
                    this.writeQueryText(string);
                    this.msg.done(linkedList.peekFirst() == null ? (byte)2 : 4);
                    ++n;
                }
                this.readResults();
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled()) {
                    this.trace.log(this.title + ".execute(): error executing batch");
                }
                if (this.trace.enabled(1)) {
                    SqlExFactory.trace(sQLException, this.trace);
                }
                throw sQLException;
            }
            finally {
                this.msg.unlock();
            }
            if (this.batchExList != null) {
                throw this.batchResults.batchUpdateEx(this.batchExList);
            }
            return this.batchResults;
        }

        @Override
        protected JdbcRSMD readResults() throws SQLException, XaEx {
            JdbcRSMD jdbcRSMD = super.readResults();
            if (this.exList != null) {
                throw this.exList;
            }
            return jdbcRSMD;
        }

        @Override
        protected SQLException readError() throws SQLException {
            SQLException sQLException = super.readError();
            if (sQLException == null || sQLException instanceof XaEx) {
                return sQLException;
            }
            if (this.exList == null) {
                this.exList = sQLException;
            } else {
                this.exList.setNextException(sQLException);
            }
            return null;
        }

        @Override
        protected boolean readResult() throws SQLException {
            boolean bl = super.readResult();
            if (!this.msg.isEndOfBatch()) {
                if (this.msg.moreMessages() && this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ": unexpected RESULT message (not EOG)");
                }
                return bl;
            }
            if (this.batchResults.resultCount() >= this.batchResults.batchSize()) {
                if (this.trace.enabled(3)) {
                    if (!this.msg.moreMessages()) {
                        this.trace.write(this.tr_id + ": terminating result marked as batch");
                    } else {
                        this.trace.write(this.tr_id + ": additional batch result received");
                    }
                }
                return bl;
            }
            long l = this.getQueryResult();
            if (this.exList != null) {
                if (this.batchExList == null) {
                    this.batchExList = this.exList;
                } else {
                    this.batchExList.setNextException(this.exList);
                }
                this.exList = null;
                l = -3L;
            }
            long l2 = this.batchResults.addResult(l);
            if (this.trace.enabled()) {
                int n = this.batchResults.resultCount() - 1;
                switch ((int)l) {
                    case -2: {
                        this.trace.log(this.title + ".executeBatch[" + n + "] = SUCCESS_NO_INFO");
                        break;
                    }
                    case -3: {
                        this.trace.log(this.title + ".executeBatch[" + n + "] = EXECUTE_FAILED");
                        break;
                    }
                    default: {
                        this.trace.log(this.title + ".executeBatch[" + n + "] = " + l);
                    }
                }
            }
            if (this.trace.enabled(1) && l2 != l) {
                this.trace.write(this.tr_id + ": truncated update count = " + l2);
            }
            if (!this.msg.moreMessages() && this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ": batch result terminates response");
            }
            return bl;
        }

        protected long getQueryResult() {
            if ((this.rslt_items & 8) != 0) {
                this.rslt_items &= 0xFFFFFFF7;
                return this.rslt_val_rowcnt;
            }
            return -2L;
        }
    }
}

