/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.dam.MsgConst;
import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.jdbc.JdbcRslt;
import com.ingres.gcf.jdbc.JdbcStmt;
import com.ingres.gcf.jdbc.RsltFtch;
import com.ingres.gcf.util.SqlWarn;
import java.sql.SQLException;

public class RsltStrm
extends RsltFtch
implements MsgConst {
    private boolean locked = true;
    private boolean flushing = false;
    private boolean rowComplete = false;

    RsltStrm(DrvConn drvConn, JdbcStmt jdbcStmt, JdbcRSMD jdbcRSMD, long l) throws SQLException {
        super(drvConn, jdbcStmt, jdbcRSMD, l, 1, 0);
        this.tr_id = "Strm[" + this.inst_id + "]";
    }

    @Override
    protected void fetch(int n, int n2, int n3) throws SQLException {
        if (!this.msg.moreData() || !this.readData()) {
            this.readResults();
        }
    }

    @Override
    protected boolean readColumns(JdbcRSMD jdbcRSMD, JdbcRslt.Row row) throws SQLException {
        boolean bl = super.readColumns(jdbcRSMD, row);
        if (row.count >= jdbcRSMD.count) {
            if (!bl) {
                bl = true;
            } else {
                this.rowComplete = true;
            }
        }
        return bl;
    }

    @Override
    protected boolean readData() throws SQLException {
        if (this.flushing) {
            this.msg.skip();
            return false;
        }
        return super.readData();
    }

    @Override
    protected SQLException readError() throws SQLException {
        SQLException sQLException = super.readError();
        if (sQLException.getErrorCode() == 0xC90009) {
            this.setWarning(SqlWarn.get(sQLException));
            sQLException = null;
        }
        return sQLException;
    }

    @Override
    protected void resume() throws SQLException {
        if (this.rowComplete) {
            if (this.trace.enabled(5)) {
                this.trace.write(this.tr_id + ".resume: row is complete");
            }
            this.rowComplete = false;
        } else {
            if (this.trace.enabled(5)) {
                this.trace.write(this.tr_id + ".resume: continue processing row");
            }
            super.resume();
        }
    }

    @Override
    boolean shut() throws SQLException {
        if (this.locked) {
            this.flushing = true;
            if (this.trace.enabled(5)) {
                this.trace.write(this.tr_id + ".shut: cancel select-loop");
            }
            try {
                this.msg.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.trace.enabled(5)) {
                this.trace.write(this.tr_id + ".shut: flushing data stream");
            }
            this.flush();
            if (this.msg.moreData()) {
                this.readData();
            }
            if (this.msg.moreMessages()) {
                this.readResults();
                this.checkResults(false);
            }
        }
        return super.shut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeCursor() throws SQLException {
        try {
            super.closeCursor();
        }
        finally {
            RsltStrm rsltStrm = this;
            synchronized (rsltStrm) {
                if (this.locked) {
                    this.locked = false;
                    this.msg.unlock();
                }
            }
        }
    }
}

