/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.jdbc.JdbcRslt;
import com.ingres.gcf.util.SqlBigInt;
import com.ingres.gcf.util.SqlBool;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDecimal;
import com.ingres.gcf.util.SqlDouble;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.SqlInt;
import com.ingres.gcf.util.SqlReal;
import com.ingres.gcf.util.SqlSmallInt;
import com.ingres.gcf.util.SqlString;
import com.ingres.gcf.util.SqlTinyInt;
import java.sql.SQLException;

public class RsltXlat
extends JdbcRslt {
    protected JdbcRslt dbmsRS = null;

    RsltXlat(DrvConn drvConn, JdbcRSMD jdbcRSMD, JdbcRslt jdbcRslt) throws SQLException {
        super(drvConn, jdbcRSMD);
        this.dbmsRS = jdbcRslt;
        this.tr_id = "Xlat[" + this.inst_id + "]";
    }

    @Override
    protected void load() throws SQLException {
        switch (this.posStatus) {
            case 1: {
                if (!this.dbmsRS.next()) {
                    this.posStatus = 2;
                    this.rowCount = 0;
                    break;
                }
                this.currentRow = new JdbcRslt.Row();
                this.currentRow.id = 1;
                this.currentRow.columns = this.allocateRowBuffer(this.rsmd);
                this.currentRow.count = 0;
                if (!this.dbmsRS.isLast()) {
                    this.currentRow.status = 1;
                } else {
                    this.currentRow.status = 3;
                    this.rowCount = this.currentRow.id;
                }
                this.load_data();
                this.posStatus = 3;
                break;
            }
            case 3: {
                if (!this.dbmsRS.next()) {
                    this.posStatus = 2;
                    this.rowCount = this.currentRow.id;
                    break;
                }
                ++this.currentRow.id;
                this.currentRow.count = 0;
                if (!this.dbmsRS.isLast()) {
                    this.currentRow.status = 0;
                } else {
                    this.currentRow.status = 2;
                    this.rowCount = this.currentRow.id;
                }
                this.load_data();
                this.posStatus = 3;
            }
        }
    }

    @Override
    boolean shut() throws SQLException {
        boolean bl = super.shut();
        if (bl) {
            this.dbmsRS.close();
        }
        return bl;
    }

    protected void load_data() throws SQLException {
        for (int i = 0; i < this.rsmd.count; ++i) {
            this.convert(i, i + 1);
        }
    }

    protected void setNull(int n) throws SQLException {
        this.currentRow.columns[n].setNull();
        this.markColumnAvailable(n);
    }

    protected void setBoolean(int n, boolean bl) throws SQLException {
        ((SqlBool)this.currentRow.columns[n]).set(bl);
        this.markColumnAvailable(n);
    }

    protected void setShort(int n, short s) throws SQLException {
        ((SqlSmallInt)this.currentRow.columns[n]).set(s);
        this.markColumnAvailable(n);
    }

    protected void setInt(int n, int n2) throws SQLException {
        ((SqlInt)this.currentRow.columns[n]).set(n2);
        this.markColumnAvailable(n);
    }

    protected void setLong(int n, long l) throws SQLException {
        ((SqlBigInt)this.currentRow.columns[n]).set(l);
        this.markColumnAvailable(n);
    }

    protected void setString(int n, String string) throws SQLException {
        ((SqlString)this.currentRow.columns[n]).set(string);
        this.markColumnAvailable(n);
    }

    protected void convert(int n, int n2) throws SQLException {
        switch (this.rsmd.desc[n].sql_type) {
            case 5: {
                short s = this.dbmsRS.getShort(n2);
                if (!this.dbmsRS.wasNull()) {
                    ((SqlSmallInt)this.currentRow.columns[n]).set(s);
                    break;
                }
                this.currentRow.columns[n].setNull();
                break;
            }
            case 4: {
                int n3 = this.dbmsRS.getInt(n2);
                if (!this.dbmsRS.wasNull()) {
                    ((SqlInt)this.currentRow.columns[n]).set(n3);
                    break;
                }
                this.currentRow.columns[n].setNull();
                break;
            }
            case 12: {
                String string = this.dbmsRS.getString(n2);
                if (string != null) {
                    ((SqlString)this.currentRow.columns[n]).set(string.trim());
                    break;
                }
                this.currentRow.columns[n].setNull();
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
        }
        this.markColumnAvailable(n);
    }

    private void markColumnAvailable(int n) {
        this.currentRow.count = Math.max(n + 1, this.currentRow.count);
    }

    private SqlData[] allocateRowBuffer(JdbcRSMD jdbcRSMD) throws SQLException {
        SqlData[] sqlDataArray = new SqlData[jdbcRSMD.count];
        block11: for (int i = 0; i < jdbcRSMD.count; ++i) {
            switch (jdbcRSMD.desc[i].sql_type) {
                case 16: {
                    sqlDataArray[i] = new SqlBool();
                    continue block11;
                }
                case -6: {
                    sqlDataArray[i] = new SqlTinyInt();
                    continue block11;
                }
                case 5: {
                    sqlDataArray[i] = new SqlSmallInt();
                    continue block11;
                }
                case 4: {
                    sqlDataArray[i] = new SqlInt();
                    continue block11;
                }
                case -5: {
                    sqlDataArray[i] = new SqlBigInt();
                    continue block11;
                }
                case 7: {
                    sqlDataArray[i] = new SqlReal();
                    continue block11;
                }
                case 8: {
                    sqlDataArray[i] = new SqlDouble();
                    continue block11;
                }
                case 12: {
                    sqlDataArray[i] = new SqlString();
                    continue block11;
                }
                case 3: {
                    sqlDataArray[i] = new SqlDecimal(this.conn.max_dec_prec);
                    continue block11;
                }
                default: {
                    throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
                }
            }
        }
        return sqlDataArray;
    }
}

