/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class CharSet {
    private String enc;
    private boolean multi_byte;
    private byte space = 0;
    private char[] xlit = null;
    private static String def_enc = null;
    private static final Hashtable csMap = new Hashtable();
    private static final Object[][] csInfo = new Object[][]{{"ISO88591", "ISO-8859-1", Boolean.FALSE, null}, {"ISO88592", "ISO8859_2", Boolean.FALSE, null}, {"ISO88595", "ISO8859_5", Boolean.FALSE, null}, {"ISO88599", "ISO8859_9", Boolean.FALSE, null}, {"IS885915", "ISO8859_15", Boolean.FALSE, null}, {"IBMPC_ASCII_INT", "Cp850", Boolean.FALSE, null}, {"IBMPC_ASCII", "Cp850", Boolean.FALSE, null}, {"IBMPC437", "Cp437", Boolean.FALSE, null}, {"ELOT437", "Cp737", Boolean.FALSE, null}, {"SLAV852", "Cp852", Boolean.FALSE, null}, {"IBMPC850", "Cp850", Boolean.FALSE, null}, {"CW", "Cp1251", Boolean.FALSE, null}, {"ALT", "Cp855", Boolean.FALSE, null}, {"PC857", "Cp857", Boolean.FALSE, null}, {"WIN1250", "Cp1250", Boolean.FALSE, null}, {"KOI8", "KOI8_R", Boolean.FALSE, null}, {"IBMPC866", "Cp866", Boolean.FALSE, null}, {"WIN1252", "Cp1252", Boolean.FALSE, null}, {"ASCII", "US-ASCII", Boolean.FALSE, null}, {"DECMULTI", "ISO-8859-1", Boolean.FALSE, null}, {"HEBREW", "ISO8859_8", Boolean.FALSE, null}, {"THAI", "Cp874", Boolean.FALSE, null}, {"GREEK", "Cp875", Boolean.FALSE, null}, {"HPROMAN8", "ISO-8859-1", Boolean.FALSE, null}, {"ARABIC", "Cp420", Boolean.FALSE, null}, {"WHEBREW", "Cp1255", Boolean.FALSE, null}, {"PCHEBREW", "Cp862", Boolean.FALSE, null}, {"WARABIC", "Cp1256", Boolean.FALSE, null}, {"DOSASMO", "Cp864", Boolean.FALSE, null}, {"WTHAI", "Cp874", Boolean.FALSE, null}, {"EBCDIC_C", "Cp500", Boolean.FALSE, null}, {"EBCDIC_ICL", "Cp500", Boolean.FALSE, null}, {"EBCDIC_USA", "Cp037", Boolean.FALSE, null}, {"EBCDIC", "Cp500", Boolean.FALSE, null}, {"CHINESES", "Cp1383", Boolean.TRUE, null}, {"KOREAN", "Cp949", Boolean.TRUE, null}, {"KANJIEUC", "EUC_JP", Boolean.TRUE, null}, {"SHIFTJIS", "SJIS", Boolean.TRUE, null}, {"CHTBIG5", "Big5", Boolean.TRUE, null}, {"CHTEUC", "EUC_TW", Boolean.TRUE, null}, {"CHTHP", "EUC_TW", Boolean.TRUE, null}, {"CSGBK", "GBK", Boolean.TRUE, null}, {"CSGB2312", "EUC_CN", Boolean.TRUE, null}, {"UTF8", "UTF-8", Boolean.TRUE, null}};
    private static final int[] csId = new int[]{1, 2, 5, 9, 15, 16, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 27, 28, 32, 48, 49, 50, 51, 64, 80, 96, 97, 98, 99, 100, 256, 257, 258, 258, 512, 513, 514, 515, 517, 518, 519, 520, 521, 785};

    public static CharSet getCharSet(int n) throws UnsupportedEncodingException {
        for (int i = 0; i < csId.length; ++i) {
            if (csId[i] != n) continue;
            return CharSet.addCharSet(i);
        }
        throw new UnsupportedEncodingException();
    }

    public static CharSet getCharSet(String string) throws UnsupportedEncodingException {
        Integer n = (Integer)csMap.get(string);
        if (n == null) {
            throw new UnsupportedEncodingException();
        }
        return CharSet.addCharSet(n);
    }

    private static CharSet addCharSet(int n) throws UnsupportedEncodingException {
        if (csInfo[n][3] == null) {
            String string = CharSet.checkEncoding((String)csInfo[n][1]);
            if (string == null) {
                throw new UnsupportedEncodingException();
            }
            if (string.equals(def_enc)) {
                string = null;
            }
            CharSet.csInfo[n][3] = new CharSet(string, (Boolean)csInfo[n][2]);
        }
        return (CharSet)csInfo[n][3];
    }

    private static String checkEncoding(String string) {
        try {
            byte[] byArray = new byte[]{0};
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            InputStreamReader inputStreamReader = string == null ? new InputStreamReader(byteArrayInputStream) : new InputStreamReader((InputStream)byteArrayInputStream, string);
            string = inputStreamReader.getEncoding();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = null;
        }
        return string;
    }

    public CharSet() {
        this.enc = null;
        this.multi_byte = true;
    }

    public CharSet(String string) throws UnsupportedEncodingException {
        string = CharSet.checkEncoding(string);
        if (string == null) {
            throw new UnsupportedEncodingException();
        }
        this.enc = string;
        this.multi_byte = true;
    }

    private CharSet(String string, boolean bl) {
        this.enc = string;
        this.multi_byte = bl;
        if (!bl) {
            byte[] byArray = new byte[256];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)i;
            }
            try {
                String string2 = string == null ? new String(byArray) : new String(byArray, string);
                if (string2.length() == byArray.length) {
                    this.xlit = string2.toCharArray();
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this.enc == null ? "<default>" : this.enc;
    }

    public boolean isSingleByte() {
        return !this.multi_byte;
    }

    public byte getSpaceChar() throws UnsupportedEncodingException {
        if (this.space == 0) {
            byte[] byArray = this.getBytes(" ");
            if (byArray.length != 1) {
                throw new UnsupportedEncodingException("Invalid space character");
            }
            this.space = byArray[0];
        }
        return this.space;
    }

    public int getByteLength(char[] cArray) {
        return this.multi_byte ? this.getByteLength(new String(cArray)) : cArray.length;
    }

    public int getByteLength(String string) {
        int n;
        if (!this.multi_byte) {
            n = string.length();
        } else {
            try {
                byte[] byArray = this.enc == null ? string.getBytes() : string.getBytes(this.enc);
                n = byArray.length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                n = string.length();
            }
        }
        return n;
    }

    public byte[] getBytes(char[] cArray) throws UnsupportedEncodingException {
        return this.getBytes(new String(cArray));
    }

    public byte[] getBytes(char[] cArray, int n, int n2) throws UnsupportedEncodingException {
        return this.getBytes(new String(cArray, n, n2));
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        byte[] byArray = this.enc == null ? string.getBytes() : string.getBytes(this.enc);
        return byArray;
    }

    public String getString(byte[] byArray) throws UnsupportedEncodingException {
        return this.getString(byArray, 0, byArray.length, null);
    }

    public String getString(byte[] byArray, char[] cArray) throws UnsupportedEncodingException {
        return this.getString(byArray, 0, byArray.length, cArray);
    }

    public String getString(byte[] byArray, int n, int n2) throws UnsupportedEncodingException {
        return this.getString(byArray, n, n2, null);
    }

    public String getString(byte[] byArray, int n, int n2, char[] cArray) throws UnsupportedEncodingException {
        String string;
        if (this.xlit != null) {
            if (cArray == null || cArray.length < n2) {
                cArray = new char[n2];
            }
            int n3 = 0;
            while (n3 < n2) {
                cArray[n3] = this.xlit[byArray[n] & 0xFF];
                ++n3;
                ++n;
            }
            string = new String(cArray, 0, n2);
        } else {
            string = this.enc == null ? new String(byArray, n, n2) : new String(byArray, n, n2, this.enc);
        }
        return string;
    }

    public InputStreamReader getISR(InputStream inputStream) throws UnsupportedEncodingException {
        InputStreamReader inputStreamReader = this.enc == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, this.enc);
        return inputStreamReader;
    }

    public OutputStreamWriter getOSW(OutputStream outputStream) throws UnsupportedEncodingException {
        OutputStreamWriter outputStreamWriter = this.enc == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, this.enc);
        return outputStreamWriter;
    }

    static {
        def_enc = CharSet.checkEncoding(null);
        for (int i = 0; i < csInfo.length; ++i) {
            csMap.put(csInfo[i][0], i);
        }
    }
}

