/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.Compress;
import java.util.Arrays;

public class CompSnpy
implements Compress {
    private static final String SNPY_ALG_NAME = "Snappy";
    private static final int SNPY_BLOCK_MAX = 65536;
    private static final int SNPY_SKIP_SIZE = 5;
    private static final byte SNPY_SYM_MASK = 3;
    private static final byte SNPY_SYM_LITERAL = 0;
    private static final byte SNPY_SYM_COPY1 = 1;
    private static final byte SNPY_SYM_COPY2 = 2;
    private static final byte SNPY_SYM_RLE = 3;
    private static final byte SNPY_SYM_LIT1 = -8;
    private static final byte SNPY_SYM_LIT2 = -4;
    private static final byte SNPY_SYM_CPY3 = -6;
    private static final byte SNPY_SYM_CPY4 = -2;
    private static final byte SNPY_SYM_RLE1 = -5;
    private static final byte SNPY_SYM_RLE2 = -1;
    private static final int SNPY_SYM_IS_LIT0_LENGTH = 62;
    private static final int SNPY_SYM_IS_LIT1_LENGTH = 256;
    private static final int SNPY_SYM_IS_CPY1_LENGTH = 12;
    private static final int SNPY_SYM_IS_CPY1_OFFSET = 2048;
    private static final int SNPY_SYM_IS_CPY2_LENGTH = 62;
    private static final int SNPY_SYM_IS_CPY3_LENGTH = 256;
    private static final int SNPY_SYM_IS_RLE0_LENGTH = 62;
    private static final int SNPY_SYM_IS_RLE1_LENGTH = 256;
    private static final short SNPY_SYM_TBL_LEN_MASK = 255;
    private static final short SNPY_SYM_TBL_OFF_MASK = 1792;
    private static final short SNPY_SYM_TBL_BYT_MASK = 28672;
    private static final short SNPY_SYM_TBL_CPY2_BYTES = 8192;
    private static final short[] symTable = new short[]{1, 4100, 8193, 1, 2, 4101, 8194, 2, 3, 4102, 8195, 3, 4, 4103, 8196, 4, 5, 4104, 8197, 5, 6, 4105, 8198, 6, 7, 4106, 8199, 7, 8, 4107, 8200, 8, 9, 4356, 8201, 9, 10, 4357, 8202, 10, 11, 4358, 8203, 11, 12, 4359, 8204, 12, 13, 4360, 8205, 13, 14, 4361, 8206, 14, 15, 4362, 8207, 15, 16, 4363, 8208, 16, 17, 4612, 8209, 17, 18, 4613, 8210, 18, 19, 4614, 8211, 19, 20, 4615, 8212, 20, 21, 4616, 8213, 21, 22, 4617, 8214, 22, 23, 4618, 8215, 23, 24, 4619, 8216, 24, 25, 4868, 8217, 25, 26, 4869, 8218, 26, 27, 4870, 8219, 27, 28, 4871, 8220, 28, 29, 4872, 8221, 29, 30, 4873, 8222, 30, 31, 4874, 8223, 31, 32, 4875, 8224, 32, 33, 5124, 8225, 33, 34, 5125, 8226, 34, 35, 5126, 8227, 35, 36, 5127, 8228, 36, 37, 5128, 8229, 37, 38, 5129, 8230, 38, 39, 5130, 8231, 39, 40, 5131, 8232, 40, 41, 5380, 8233, 41, 42, 5381, 8234, 42, 43, 5382, 8235, 43, 44, 5383, 8236, 44, 45, 5384, 8237, 45, 46, 5385, 8238, 46, 47, 5386, 8239, 47, 48, 5387, 8240, 48, 49, 5636, 8241, 49, 50, 5637, 8242, 50, 51, 5638, 8243, 51, 52, 5639, 8244, 52, 53, 5640, 8245, 53, 54, 5641, 8246, 54, 55, 5642, 8247, 55, 56, 5643, 8248, 56, 57, 5892, 8249, 57, 58, 5893, 8250, 58, 59, 5894, 8251, 59, 60, 5895, 8252, 60, 61, 5896, 8253, 61, 62, 5897, 8254, 62, 4159, 5898, 12351, 4159, 8256, 5899, 16448, 8256};
    private static final int SNPY_HM_MAP_MIN = 256;
    private static final int SNPY_HM_MAP_MAX = 16384;
    private static final int SNPY_HM_SHIFT_MIN = 24;
    private static final int SNPY_HASH_FACTOR = 506832829;
    private int hashShift;
    private int[] hashMap;

    public CompSnpy() {
        this(0);
    }

    public CompSnpy(int n) {
        if (n <= 0) {
            n = 65536;
        }
        int n2 = 256;
        this.hashShift = 24;
        while (n2 < 16384 && n2 < n) {
            n2 <<= 1;
            --this.hashShift;
        }
        this.hashMap = new int[n2];
    }

    @Override
    public Compress.CompressionAlgorithm getAlgorithm() {
        return Compress.CompressionAlgorithm.SNAPPY;
    }

    @Override
    public String getName() {
        return SNPY_ALG_NAME;
    }

    @Override
    public int compress(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        int n5;
        int n6 = n3;
        int n7 = n3 + n4;
        if (n2 < 5 || n4 < 5) {
            return 0;
        }
        for (n5 = n2; n5 >= 128; n5 >>>= 7) {
            byArray2[n3++] = (byte)(n5 | 0x80);
        }
        byArray2[n3++] = (byte)n5;
        while (n2 > 0) {
            int n8;
            if (n2 <= 65536) {
                n8 = n2;
            } else {
                n8 = n2 >>> 1;
                if (n8 > 65536) {
                    n8 = 65536;
                }
            }
            int n9 = this.compressFragment(byArray, n, n + n8, byArray2, n3, n7);
            if (n9 <= 0) {
                return n9;
            }
            n += n8;
            n2 -= n8;
            n3 += n9;
        }
        return n3 - n6;
    }

    @Override
    public int decompress(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        int n5;
        int n6 = n + n2;
        int n7 = n3;
        int n8 = 0;
        for (n5 = 0; n5 < 32; n5 += 7) {
            n8 |= (byArray[n] & 0x7F) << n5;
            if ((byArray[n++] & 0x80) == 0) break;
        }
        if (n5 >= 32) {
            return -1;
        }
        if (n8 > n4) {
            return 0;
        }
        int n9 = n3 + n8;
        while (n < n6) {
            byte by = byArray[n++];
            short s = symTable[by & 0xFF];
            switch (by & 3) {
                case 0: {
                    int n10;
                    if ((s & 0x7000) == 0) {
                        n10 = s & 0xFF;
                    } else if (by == -8) {
                        if (n >= n6) {
                            return -1;
                        }
                        n10 = (byArray[n++] & 0xFF) + 1;
                    } else {
                        if (n + 2 > n6) {
                            return -1;
                        }
                        n10 = (byArray[n++] & 0xFF) + 1;
                        n10 += (byArray[n++] & 0xFF) << 8;
                    }
                    if (n + n10 > n6 || n3 + n10 > n9) {
                        return -1;
                    }
                    System.arraycopy(byArray, n, byArray2, n3, n10);
                    n += n10;
                    n3 += n10;
                    break;
                }
                case 1: {
                    if (n >= n6) {
                        return -1;
                    }
                    int n11 = s & 0x700 | byArray[n++] & 0xFF;
                    int n10 = s & 0xFF;
                    if (n3 + n10 > n9) {
                        return -1;
                    }
                    if (n10 <= n11) {
                        System.arraycopy(byArray2, n3 - n11, byArray2, n3, n10);
                        n3 += n10;
                        break;
                    }
                    n11 = n3 - n11;
                    n10 = n3 + n10;
                    while (n3 < n10) {
                        byArray2[n3++] = byArray2[n11++];
                    }
                    break;
                }
                case 2: {
                    int n10;
                    if ((s & 0x7000) == 8192) {
                        if (n + 2 > n6) {
                            return -1;
                        }
                        n10 = s & 0xFF;
                    } else if (by == -6) {
                        if (n + 3 > n6) {
                            return -1;
                        }
                        n10 = (byArray[n++] & 0xFF) + 1;
                    } else {
                        if (n + 4 > n6) {
                            return -1;
                        }
                        n10 = (byArray[n++] & 0xFF) + 1;
                        n10 += (byArray[n++] & 0xFF) << 8;
                    }
                    int n11 = byArray[n++] & 0xFF;
                    n11 |= (byArray[n++] & 0xFF) << 8;
                    if (n3 + n10 > n9) {
                        return -1;
                    }
                    if (n10 <= n11) {
                        System.arraycopy(byArray2, n3 - n11, byArray2, n3, n10);
                        n3 += n10;
                        break;
                    }
                    n11 = n3 - n11;
                    n10 = n3 + n10;
                    while (n3 < n10) {
                        byArray2[n3++] = byArray2[n11++];
                    }
                    break;
                }
                case 3: {
                    int n10;
                    if ((s & 0x7000) == 0) {
                        n10 = s & 0xFF;
                    } else if (by == -5) {
                        if (n >= n6) {
                            return -1;
                        }
                        n10 = (byArray[n++] & 0xFF) + 1;
                    } else {
                        if (n + 2 > n6) {
                            return -1;
                        }
                        n10 = (byArray[n++] & 0xFF) + 1;
                        n10 += (byArray[n++] & 0xFF) << 8;
                    }
                    if (n3 + n10 > n9) {
                        return -1;
                    }
                    Arrays.fill(byArray2, n3, n3 + n10, byArray2[n3 - 1]);
                    n3 += n10;
                }
            }
        }
        return n3 - n7;
    }

    private int compressFragment(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = n;
        int n6 = n3;
        int n7 = n;
        int n8 = n2 - 3;
        int n9 = (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        this.hashMap[n9 * 506832829 >>> this.hashShift] = 0;
        int n10 = 32;
        ++n;
        while (n < n8) {
            n9 = (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
            int n11 = n9 * 506832829 >>> this.hashShift;
            int n12 = n5 + this.hashMap[n11];
            this.hashMap[n11] = n - n5;
            if (n12 < n5 || n12 >= n) {
                ++n10;
            } else {
                int n13 = (byArray[n12] & 0xFF) << 24 | (byArray[n12 + 1] & 0xFF) << 16 | (byArray[n12 + 2] & 0xFF) << 8 | byArray[n12 + 3] & 0xFF;
                if (n9 != n13) {
                    ++n10;
                } else {
                    int n14;
                    int n15;
                    if (n7 < n) {
                        if ((n3 = this.emitLiteral(byArray, n7, n - n7, byArray2, n3, n4)) <= 0) {
                            return n3;
                        }
                        n10 = 32;
                    }
                    int n16 = n12 + 4;
                    for (n15 = n + 4; n15 < n2 && byArray[n16] == byArray[n15]; ++n15) {
                        ++n16;
                    }
                    int n17 = n15 - n;
                    int n18 = n - n12;
                    if (n18 == 1) {
                        if (n17 <= 62) {
                            if (n3 >= n4) {
                                return 0;
                            }
                            byArray2[n3++] = (byte)(n17 - 1 << 2 | 3);
                        } else if (n17 <= 256) {
                            if (n3 + 2 > n4) {
                                return 0;
                            }
                            byArray2[n3++] = -5;
                            byArray2[n3++] = (byte)(n17 - 1);
                        } else {
                            n14 = n17 - 1;
                            if (n3 + 3 > n4) {
                                return 0;
                            }
                            byArray2[n3++] = -1;
                            byArray2[n3++] = (byte)n14;
                            byArray2[n3++] = (byte)(n14 >> 8);
                        }
                    } else if (n17 < 12 && n18 < 2048) {
                        if (n3 + 2 > n4) {
                            return 0;
                        }
                        byArray2[n3++] = (byte)(n18 >> 3 & 0xE0 | n17 - 4 << 2 | 1);
                        byArray2[n3++] = (byte)n18;
                    } else if (n17 <= 62) {
                        if (n3 + 3 > n4) {
                            return 0;
                        }
                        byArray2[n3++] = (byte)(n17 - 1 << 2 | 2);
                        byArray2[n3++] = (byte)n18;
                        byArray2[n3++] = (byte)(n18 >> 8);
                    } else if (n17 <= 256) {
                        if (n3 + 4 > n4) {
                            return 0;
                        }
                        byArray2[n3++] = -6;
                        byArray2[n3++] = (byte)(n17 - 1);
                        byArray2[n3++] = (byte)n18;
                        byArray2[n3++] = (byte)(n18 >> 8);
                    } else {
                        n14 = n17 - 1;
                        if (n3 + 5 > n4) {
                            return 0;
                        }
                        byArray2[n3++] = -2;
                        byArray2[n3++] = (byte)n14;
                        byArray2[n3++] = (byte)(n14 >> 8);
                        byArray2[n3++] = (byte)n18;
                        byArray2[n3++] = (byte)(n18 >> 8);
                    }
                    n7 = n + n17;
                    n = n7 - 1;
                    if (n >= n8) break;
                    n9 = (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
                    this.hashMap[n9 * 506832829 >>> this.hashShift] = n - n5;
                }
            }
            n += n10 >> 5;
        }
        if (n7 < n2 && (n3 = this.emitLiteral(byArray, n7, n2 - n7, byArray2, n3, n4)) <= 0) {
            return n3;
        }
        return n3 - n6;
    }

    private int emitLiteral(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n2 <= 62) {
            if (n3 + n2 >= n4) {
                return 0;
            }
            byArray2[n3++] = (byte)(n2 - 1 << 2);
        } else if (n2 <= 256) {
            if (n3 + n2 + 2 > n4) {
                return 0;
            }
            byArray2[n3++] = -8;
            byArray2[n3++] = (byte)(n2 - 1);
        } else {
            int n5 = n2 - 1;
            if (n3 + n2 + 3 > n4) {
                return 0;
            }
            byArray2[n3++] = -4;
            byArray2[n3++] = (byte)n5;
            byArray2[n3++] = (byte)(n5 >> 8);
        }
        System.arraycopy(byArray, n, byArray2, n3, n2);
        return n3 + n2;
    }
}

