/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.CompSnpy;

public interface Compress {
    public static final int COMPRESSION_THRESHOLD = 256;

    public static CompressionAlgorithm findAlgorithm(String string) {
        switch (string.toLowerCase()) {
            case "off": 
            case "none": {
                return CompressionAlgorithm.NONE;
            }
            case "on": 
            case "default": {
                return CompressionAlgorithm.DEFAULT;
            }
            case "snappy": {
                return CompressionAlgorithm.SNAPPY;
            }
        }
        return null;
    }

    public static Compress getInstance(CompressionAlgorithm compressionAlgorithm) {
        switch (compressionAlgorithm) {
            case DEFAULT: 
            case SNAPPY: {
                return new CompSnpy();
            }
        }
        return null;
    }

    public static Compress getInstance(CompressionAlgorithm compressionAlgorithm, int n) {
        switch (compressionAlgorithm) {
            case DEFAULT: 
            case SNAPPY: {
                return new CompSnpy(n);
            }
        }
        return null;
    }

    public CompressionAlgorithm getAlgorithm();

    public String getName();

    public int compress(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);

    public int decompress(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);

    public static enum CompressionAlgorithm {
        NONE,
        DEFAULT,
        SNAPPY;

    }
}

