/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;

public class ConfigFile
implements Config {
    private static final String TITLE_FILE = "Property File: ";
    private static final String TITLE_RSRC = "Property Resource: ";
    private Properties properties = null;
    private Config config = null;
    private String title = null;

    public ConfigFile(File file) throws IOException, IllegalArgumentException, NullPointerException, FileNotFoundException, SecurityException {
        this(file, (Config)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigFile(File file, Config config) throws IOException, IllegalArgumentException, NullPointerException, FileNotFoundException, SecurityException {
        if (file == null) {
            throw new NullPointerException();
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        this.title = TITLE_FILE + file.getCanonicalPath();
        try {
            this.initialize(fileInputStream, config);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public ConfigFile(String string) throws IOException, IllegalArgumentException, NullPointerException, FileNotFoundException, SecurityException {
        this(string, (Config)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigFile(String string, Config config) throws IOException, IllegalArgumentException, NullPointerException, FileNotFoundException, SecurityException {
        Serializable serializable;
        InputStream inputStream = null;
        FileNotFoundException fileNotFoundException = null;
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            serializable = new File(string);
            inputStream = new FileInputStream((File)serializable);
            this.title = TITLE_FILE + ((File)serializable).getCanonicalPath();
        }
        catch (FileNotFoundException fileNotFoundException2) {
            fileNotFoundException = fileNotFoundException2;
        }
        if (inputStream == null) {
            serializable = ConfigFile.class.getClassLoader().getResource(string);
            if (serializable == null) {
                if (fileNotFoundException != null) {
                    throw fileNotFoundException;
                }
                throw new FileNotFoundException();
            }
            inputStream = ((URL)serializable).openStream();
            this.title = TITLE_RSRC + ((URL)serializable).toExternalForm();
        }
        try {
            this.initialize(inputStream, config);
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    @Override
    public String get(String string) {
        String string2 = this.properties.getProperty(string);
        if (string2 == null && this.config != null) {
            string2 = this.config.get(string);
        }
        return string2;
    }

    @Override
    public String getKey() {
        return this.config != null ? this.config.getKey() : "";
    }

    @Override
    public String getKey(String string) {
        return this.config != null ? this.config.getKey(string) : string;
    }

    @Override
    public void print(PrintStream printStream) {
        Config.print(printStream, this.title, this.properties, null);
        if (this.config != null) {
            this.config.print(printStream);
        }
    }

    @Override
    public void print(PrintStream printStream, String string) {
        Config.print(printStream, this.title, this.properties, string);
        if (this.config != null) {
            this.config.print(printStream, string);
        }
    }

    private void initialize(InputStream inputStream, Config config) throws IOException, IllegalArgumentException {
        this.config = config;
        this.properties = new Properties();
        this.properties.load(inputStream);
    }
}

