/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.SqlData;
import java.math.BigDecimal;
import java.sql.SQLException;

public class SqlBool
extends SqlData {
    private boolean value = false;

    public SqlBool() {
        super(true);
    }

    public SqlBool(boolean bl) {
        super(false);
        this.value = bl;
    }

    public void set(boolean bl) {
        this.setNotNull();
        this.value = bl;
    }

    public void set(byte by) {
        this.setNotNull();
        this.value = (by & 1) == 1;
    }

    public void set(SqlBool sqlBool) {
        if (sqlBool == null || sqlBool.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = sqlBool.value;
        }
    }

    public boolean get() {
        return this.value;
    }

    @Override
    public void setBoolean(boolean bl) throws SQLException {
        this.setNotNull();
        this.value = bl;
    }

    @Override
    public void setByte(byte by) throws SQLException {
        this.setNotNull();
        this.value = by != 0;
    }

    @Override
    public void setShort(short s) throws SQLException {
        this.setNotNull();
        this.value = s != 0;
    }

    @Override
    public void setInt(int n) throws SQLException {
        this.setNotNull();
        this.value = n != 0;
    }

    @Override
    public void setLong(long l) throws SQLException {
        this.setNotNull();
        this.value = l != 0L;
    }

    @Override
    public void setFloat(float f) throws SQLException {
        this.setNotNull();
        this.value = f != 0.0f;
    }

    @Override
    public void setDouble(double d) throws SQLException {
        this.setNotNull();
        this.value = d != 0.0;
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = bigDecimal.signum() != 0;
        }
    }

    @Override
    public void setString(String string) throws SQLException {
        if (string == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = Boolean.valueOf(string.trim());
        }
    }

    @Override
    public boolean getBoolean() throws SQLException {
        return this.value;
    }

    @Override
    public byte getByte() throws SQLException {
        return (byte)(this.value ? 1 : 0);
    }

    @Override
    public short getShort() throws SQLException {
        return (short)(this.value ? 1 : 0);
    }

    @Override
    public int getInt() throws SQLException {
        return this.value ? 1 : 0;
    }

    @Override
    public long getLong() throws SQLException {
        return this.value ? 1L : 0L;
    }

    @Override
    public float getFloat() throws SQLException {
        return this.value ? 1.0f : 0.0f;
    }

    @Override
    public double getDouble() throws SQLException {
        return this.value ? 1.0 : 0.0;
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        return BigDecimal.valueOf(this.value ? 1L : 0L);
    }

    @Override
    public String getString() throws SQLException {
        return Boolean.toString(this.value);
    }

    @Override
    public Object getObject() throws SQLException {
        return this.value;
    }
}

