/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlExFactory;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.TimeZone;

public class SqlData
implements GcfErr {
    private boolean is_null = true;

    public static int getSqlType(Object object) throws SQLException {
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            return 12;
        }
        if (object instanceof Boolean) {
            return 16;
        }
        if (object instanceof Byte) {
            return -6;
        }
        if (object instanceof Short) {
            return 5;
        }
        if (object instanceof Integer) {
            return 4;
        }
        if (object instanceof Long) {
            return -5;
        }
        if (object instanceof BigInteger) {
            return -5;
        }
        if (object instanceof BigDecimal) {
            return 3;
        }
        if (object instanceof Float) {
            return 7;
        }
        if (object instanceof Double) {
            return 8;
        }
        if (object instanceof Reader) {
            return -1;
        }
        if (object instanceof InputStream) {
            return -4;
        }
        if (object instanceof Blob) {
            return 2004;
        }
        if (object instanceof Clob) {
            return 2005;
        }
        if (object instanceof Date) {
            return 91;
        }
        if (object instanceof Time) {
            return 92;
        }
        if (object instanceof Timestamp) {
            return 93;
        }
        if (object instanceof java.util.Date) {
            return 93;
        }
        if (object instanceof Calendar) {
            return 93;
        }
        if (object instanceof LocalDate) {
            return 91;
        }
        if (object instanceof LocalTime) {
            return 92;
        }
        if (object instanceof LocalDateTime) {
            return 93;
        }
        if (object instanceof OffsetTime) {
            return 92;
        }
        if (object instanceof OffsetDateTime) {
            return 93;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            if (clazz.getComponentType() == Character.TYPE) {
                return 1;
            }
            if (clazz.getComponentType() == Byte.TYPE) {
                return -3;
            }
        }
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public static InputStream getBinary(byte[] byArray, int n, int n2) throws SQLException {
        return new ByteArrayInputStream(byArray, n, n2);
    }

    public static InputStream getAscii(String string) throws SQLException {
        byte[] byArray;
        try {
            byArray = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
        }
        return new ByteArrayInputStream(byArray);
    }

    public static InputStream getUnicode(String string) throws SQLException {
        byte[] byArray;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
        }
        return new ByteArrayInputStream(byArray);
    }

    public static Reader getCharacter(char[] cArray, int n, int n2) throws SQLException {
        return new CharArrayReader(cArray, n, n2);
    }

    public static Reader getCharacter(String string) throws SQLException {
        return new StringReader(string);
    }

    public static Reader cnvtAscii(InputStream inputStream) throws SQLException {
        try {
            return new InputStreamReader(inputStream, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
        }
    }

    public static Reader cnvtUnicode(InputStream inputStream) throws SQLException {
        try {
            return new InputStreamReader(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
        }
    }

    protected SqlData(boolean bl) {
        this.is_null = bl;
    }

    public String toString() {
        String string;
        try {
            string = this.getString();
        }
        catch (SQLException sQLException) {
            string = super.toString();
        }
        return string;
    }

    public boolean isNull() {
        return this.is_null;
    }

    public void setNull() {
        this.is_null = true;
    }

    protected void setNotNull() {
        this.is_null = false;
    }

    public boolean isTruncated() {
        return false;
    }

    public int getDataSize() {
        return -1;
    }

    public int getTruncSize() {
        return 0;
    }

    protected void setScale(int n) throws SQLException {
    }

    private void setObject(Object object, boolean bl, int n) throws SQLException {
        switch (SqlData.getSqlType(object)) {
            case 0: {
                this.setNull();
                break;
            }
            case 16: {
                this.setBoolean((Boolean)object);
                break;
            }
            case -6: {
                this.setByte((Byte)object);
                break;
            }
            case 5: {
                this.setShort((Short)object);
                break;
            }
            case 4: {
                this.setInt((Integer)object);
                break;
            }
            case 7: {
                this.setFloat(((Float)object).floatValue());
                break;
            }
            case 8: {
                this.setDouble((Double)object);
                break;
            }
            case -3: 
            case -2: {
                this.setBytes((byte[])object);
                break;
            }
            case -4: {
                this.setBinaryStream((InputStream)object);
                break;
            }
            case 2004: {
                this.setBlob((Blob)object);
                break;
            }
            case 1: {
                this.setString(new String((char[])object));
                break;
            }
            case 12: {
                this.setString((String)object);
                break;
            }
            case -1: {
                this.setCharacterStream((Reader)object);
                break;
            }
            case 2005: {
                this.setClob((Clob)object);
                break;
            }
            case -5: {
                if (object instanceof Long) {
                    this.setLong((Long)object);
                    break;
                }
                if (object instanceof BigInteger) {
                    this.setBigInteger((BigInteger)object);
                    break;
                }
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
            case 3: {
                if (!bl) {
                    this.setBigDecimal((BigDecimal)object);
                    break;
                }
                this.setBigDecimal((BigDecimal)object, n);
                bl = false;
                break;
            }
            case 91: {
                if (object instanceof Date) {
                    this.setDate((Date)object, null);
                    break;
                }
                if (object instanceof LocalDate) {
                    this.setDate((LocalDate)object);
                    break;
                }
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
            case 92: {
                if (object instanceof Time) {
                    this.setTime((Time)object, null);
                    break;
                }
                if (object instanceof LocalTime) {
                    this.setTime((LocalTime)object);
                    break;
                }
                if (object instanceof OffsetTime) {
                    this.setTime((OffsetTime)object);
                    break;
                }
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
            case 93: {
                if (object instanceof Timestamp) {
                    this.setTimestamp((Timestamp)object, null);
                    break;
                }
                if (object instanceof java.util.Date) {
                    this.setTimestamp((java.util.Date)object);
                    break;
                }
                if (object instanceof Calendar) {
                    this.setTimestamp((Calendar)object);
                    break;
                }
                if (object instanceof LocalDateTime) {
                    this.setTimestamp((LocalDateTime)object);
                    break;
                }
                if (object instanceof OffsetDateTime) {
                    this.setTimestamp((OffsetDateTime)object);
                    break;
                }
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
            default: {
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
        }
        if (bl) {
            this.setScale(n);
        }
    }

    public <T> T getObject(Class<T> clazz) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        if (clazz.isPrimitive()) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        if (clazz.isArray()) {
            if (clazz.getComponentType().equals(Character.TYPE)) {
                return clazz.cast(this.getString().toCharArray());
            }
            if (clazz.getComponentType().equals(Byte.TYPE)) {
                return clazz.cast(this.getBytes());
            }
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        if (clazz.equals(Boolean.class)) {
            return clazz.cast(new Boolean(this.getBoolean()));
        }
        if (clazz.equals(Byte.class)) {
            return clazz.cast(new Byte(this.getByte()));
        }
        if (clazz.equals(Short.class)) {
            return clazz.cast(new Short(this.getShort()));
        }
        if (clazz.equals(Integer.class)) {
            return clazz.cast(new Integer(this.getInt()));
        }
        if (clazz.equals(Long.class)) {
            return clazz.cast(new Long(this.getLong()));
        }
        if (clazz.equals(BigInteger.class)) {
            return clazz.cast(this.getBigInteger());
        }
        if (clazz.equals(BigDecimal.class)) {
            return clazz.cast(this.getBigDecimal());
        }
        if (clazz.equals(Float.class)) {
            return clazz.cast(new Float(this.getFloat()));
        }
        if (clazz.equals(Double.class)) {
            return clazz.cast(new Double(this.getDouble()));
        }
        if (clazz.equals(String.class)) {
            return clazz.cast(this.getString());
        }
        if (clazz.equals(Date.class)) {
            return clazz.cast(this.getDate(null));
        }
        if (clazz.equals(Time.class)) {
            return clazz.cast(this.getTime(null));
        }
        if (clazz.equals(Timestamp.class)) {
            return clazz.cast(this.getTimestamp(null));
        }
        if (clazz.equals(InputStream.class)) {
            return clazz.cast(this.getBinaryStream());
        }
        if (clazz.equals(Reader.class)) {
            return clazz.cast(this.getCharacterStream());
        }
        if (clazz.equals(Blob.class)) {
            return clazz.cast(this.getBlob());
        }
        if (clazz.equals(Clob.class)) {
            return clazz.cast(this.getClob());
        }
        if (clazz.equals(NClob.class)) {
            return clazz.cast(this.getNlob());
        }
        if (clazz.equals(java.util.Date.class)) {
            return clazz.cast(this.getJavaDate());
        }
        if (clazz.equals(Calendar.class)) {
            return clazz.cast(this.getCalendar());
        }
        if (clazz.equals(LocalDate.class)) {
            return clazz.cast(this.getLocalDate());
        }
        if (clazz.equals(LocalTime.class)) {
            return clazz.cast(this.getLocalTime());
        }
        if (clazz.equals(OffsetTime.class)) {
            return clazz.cast(this.getOffsetTime());
        }
        if (clazz.equals(LocalDateTime.class)) {
            return clazz.cast(this.getLocalDateTime());
        }
        if (clazz.equals(OffsetDateTime.class)) {
            return clazz.cast(this.getOffsetDateTime());
        }
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setBoolean(boolean bl) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setByte(byte by) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setShort(short s) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setInt(int n) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setLong(long l) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setFloat(float f) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setDouble(double d) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setString(String string) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setBytes(byte[] byArray) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setDate(Date date, TimeZone timeZone) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setTime(Time time, TimeZone timeZone) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setTimestamp(Timestamp timestamp, TimeZone timeZone) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setBinaryStream(InputStream inputStream) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setAsciiStream(InputStream inputStream) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setUnicodeStream(InputStream inputStream) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setCharacterStream(Reader reader) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setBlob(Blob blob) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setClob(Clob clob) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public boolean getBoolean() throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public byte getByte() throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public short getShort() throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public int getInt() throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public long getLong() throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public float getFloat() throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public double getDouble() throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public BigDecimal getBigDecimal() throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public String getString() throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public byte[] getBytes() throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public Date getDate(TimeZone timeZone) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public Time getTime(TimeZone timeZone) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public Timestamp getTimestamp(TimeZone timeZone) throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public InputStream getBinaryStream() throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public InputStream getAsciiStream() throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public InputStream getUnicodeStream() throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public Reader getCharacterStream() throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public Blob getBlob() throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public Clob getClob() throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public NClob getNlob() throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public Object getObject() throws SQLException {
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void setBigInteger(BigInteger bigInteger) throws SQLException {
        try {
            this.setLong(bigInteger.longValueExact());
        }
        catch (ArithmeticException arithmeticException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
    }

    public void setBigDecimal(BigDecimal bigDecimal, int n) throws SQLException {
        this.setBigDecimal(bigDecimal);
    }

    public void setDate(LocalDate localDate) throws SQLException {
        this.setDate(Date.valueOf(localDate), null);
    }

    public void setTime(LocalTime localTime) throws SQLException {
        this.setTime(Time.valueOf(localTime), null);
    }

    public void setTime(OffsetTime offsetTime) throws SQLException {
        this.setTime(offsetTime.withOffsetSameInstant(OffsetTime.now().getOffset()).toLocalTime());
    }

    public void setTimestamp(java.util.Date date) throws SQLException {
        this.setTimestamp(new Timestamp(date.getTime()), null);
    }

    public void setTimestamp(Calendar calendar) throws SQLException {
        this.setTimestamp(new Timestamp(calendar.getTimeInMillis()), null);
    }

    public void setTimestamp(LocalDateTime localDateTime) throws SQLException {
        this.setTimestamp(Timestamp.valueOf(localDateTime), null);
    }

    public void setTimestamp(OffsetDateTime offsetDateTime) throws SQLException {
        LocalDateTime localDateTime = offsetDateTime.toLocalDateTime();
        ZoneOffset zoneOffset = ZoneId.systemDefault().getRules().getOffset(localDateTime);
        this.setTimestamp(offsetDateTime.withOffsetSameInstant(zoneOffset).toLocalDateTime());
    }

    public void setObject(Object object) throws SQLException {
        this.setObject(object, false, 0);
    }

    public void setObject(Object object, int n) throws SQLException {
        this.setObject(object, true, n);
    }

    public BigInteger getBigInteger() throws SQLException {
        return BigInteger.valueOf(this.getLong());
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal();
        return bigDecimal == null ? null : bigDecimal.setScale(n, 4);
    }

    public String getString(int n) throws SQLException {
        return this.getString();
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.getBytes();
    }

    public LocalDate getLocalDate() throws SQLException {
        return this.getDate(null).toLocalDate();
    }

    public LocalTime getLocalTime() throws SQLException {
        return this.getTime(null).toLocalTime();
    }

    public OffsetTime getOffsetTime() throws SQLException {
        return OffsetTime.of(this.getLocalTime(), OffsetTime.now().getOffset());
    }

    public java.util.Date getJavaDate() throws SQLException {
        Timestamp timestamp = this.getTimestamp(null);
        return new java.util.Date(timestamp.getTime());
    }

    public Calendar getCalendar() throws SQLException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.getTimestamp(null).getTime());
        return calendar;
    }

    public LocalDateTime getLocalDateTime() throws SQLException {
        return this.getTimestamp(null).toLocalDateTime();
    }

    public OffsetDateTime getOffsetDateTime() throws SQLException {
        LocalDateTime localDateTime = this.getLocalDateTime();
        ZoneOffset zoneOffset = ZoneId.systemDefault().getRules().getOffset(localDateTime);
        return OffsetDateTime.of(localDateTime, zoneOffset);
    }

    public Object getObject(int n) throws SQLException {
        return this.getObject();
    }
}

