/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlExFactory;
import java.math.BigDecimal;
import java.sql.SQLException;

public class SqlInt
extends SqlData {
    private int value = 0;

    public SqlInt() {
        super(true);
    }

    public SqlInt(int n) {
        super(false);
        this.value = n;
    }

    public void set(int n) {
        this.setNotNull();
        this.value = n;
    }

    public void set(SqlInt sqlInt) {
        if (sqlInt == null || sqlInt.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = sqlInt.value;
        }
    }

    public int get() {
        return this.value;
    }

    @Override
    public void setBoolean(boolean bl) throws SQLException {
        this.setNotNull();
        this.value = bl ? 1 : 0;
    }

    @Override
    public void setByte(byte by) throws SQLException {
        this.setNotNull();
        this.value = by;
    }

    @Override
    public void setShort(short s) throws SQLException {
        this.setNotNull();
        this.value = s;
    }

    @Override
    public void setInt(int n) throws SQLException {
        this.setNotNull();
        this.value = n;
    }

    @Override
    public void setLong(long l) throws SQLException {
        this.setNotNull();
        this.value = (int)l;
    }

    @Override
    public void setFloat(float f) throws SQLException {
        this.setNotNull();
        this.value = (int)f;
    }

    @Override
    public void setDouble(double d) throws SQLException {
        this.setNotNull();
        this.value = (int)d;
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = bigDecimal.intValue();
        }
    }

    @Override
    public void setString(String string) throws SQLException {
        if (string == null) {
            this.setNull();
        } else {
            this.setNotNull();
            try {
                this.value = Integer.parseInt(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
        }
    }

    @Override
    public boolean getBoolean() throws SQLException {
        return this.value != 0;
    }

    @Override
    public byte getByte() throws SQLException {
        return (byte)this.value;
    }

    @Override
    public short getShort() throws SQLException {
        return (short)this.value;
    }

    @Override
    public int getInt() throws SQLException {
        return this.value;
    }

    @Override
    public long getLong() throws SQLException {
        return this.value;
    }

    @Override
    public float getFloat() throws SQLException {
        return this.value;
    }

    @Override
    public double getDouble() throws SQLException {
        return this.value;
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public String getString() throws SQLException {
        return Integer.toString(this.value);
    }

    @Override
    public Object getObject() throws SQLException {
        return this.value;
    }
}

