/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.BufferedClob;
import com.ingres.gcf.util.BufferedNlob;
import com.ingres.gcf.util.SqlDates;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.SqlNChar;
import com.ingres.gcf.util.SqlNVarChar;
import com.ingres.gcf.util.SqlStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.TimeZone;

public class SqlLongNChar
extends SqlStream {
    public SqlLongNChar() {
    }

    public SqlLongNChar(SqlStream.StreamListener streamListener) {
        super(streamListener);
    }

    public void set(Reader reader) throws SQLException {
        this.setStream(reader);
    }

    public void set(SqlNChar sqlNChar) throws SQLException {
        if (sqlNChar == null || sqlNChar.isNull()) {
            this.setNull();
        } else {
            sqlNChar.extend();
            this.setStream(SqlLongNChar.getCharacter(sqlNChar.value, 0, sqlNChar.length));
        }
    }

    public void set(SqlNVarChar sqlNVarChar) throws SQLException {
        if (sqlNVarChar == null || sqlNVarChar.isNull()) {
            this.setNull();
        } else {
            this.setStream(SqlLongNChar.getCharacter(sqlNVarChar.value, 0, sqlNVarChar.length));
        }
    }

    public Reader get() throws SQLException {
        return (Reader)this.getStream();
    }

    public void get(Writer writer) throws SQLException {
        SqlLongNChar.copyRdr2Wtr((Reader)this.getStream(), writer);
    }

    @Override
    public void setBoolean(boolean bl) throws SQLException {
        this.setString(Boolean.toString(bl));
    }

    @Override
    public void setByte(byte by) throws SQLException {
        this.setString(Byte.toString(by));
    }

    @Override
    public void setShort(short s) throws SQLException {
        this.setString(Short.toString(s));
    }

    @Override
    public void setInt(int n) throws SQLException {
        this.setString(Integer.toString(n));
    }

    @Override
    public void setLong(long l) throws SQLException {
        this.setString(Long.toString(l));
    }

    @Override
    public void setBigInteger(BigInteger bigInteger) throws SQLException {
        if (bigInteger == null) {
            this.setNull();
        } else {
            this.setString(bigInteger.toString());
        }
    }

    @Override
    public void setFloat(float f) throws SQLException {
        this.setString(Float.toString(f));
    }

    @Override
    public void setDouble(double d) throws SQLException {
        this.setString(Double.toString(d));
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.setString(bigDecimal.toString());
        }
    }

    @Override
    public void setString(String string) throws SQLException {
        if (string == null) {
            this.setNull();
        } else {
            this.setStream(SqlLongNChar.getCharacter(string));
        }
    }

    @Override
    public void setDate(Date date, TimeZone timeZone) throws SQLException {
        if (date == null) {
            this.setNull();
        } else {
            SqlDates sqlDates = SqlDates.getDefaultInstance();
            if (timeZone != null) {
                this.setString(sqlDates.formatDate((java.util.Date)date, timeZone));
            } else {
                this.setString(sqlDates.formatDate((java.util.Date)date, false));
            }
        }
    }

    @Override
    public void setDate(LocalDate localDate) throws SQLException {
        if (localDate == null) {
            this.setNull();
        } else {
            this.setString(localDate.format(DateTimeFormatter.ISO_LOCAL_DATE));
        }
    }

    @Override
    public void setTime(Time time, TimeZone timeZone) throws SQLException {
        if (time == null) {
            this.setNull();
        } else {
            SqlDates sqlDates = SqlDates.getDefaultInstance();
            if (timeZone != null) {
                this.setString(sqlDates.formatTime((java.util.Date)time, timeZone));
            } else {
                this.setString(sqlDates.formatTime((java.util.Date)time, false));
            }
        }
    }

    @Override
    public void setTime(LocalTime localTime) throws SQLException {
        if (localTime == null) {
            this.setNull();
        } else {
            this.setString(localTime.format(DateTimeFormatter.ISO_LOCAL_TIME));
        }
    }

    @Override
    public void setTime(OffsetTime offsetTime) throws SQLException {
        if (offsetTime == null) {
            this.setNull();
        } else {
            this.setString(offsetTime.format(DateTimeFormatter.ISO_OFFSET_TIME));
        }
    }

    @Override
    public void setTimestamp(Timestamp timestamp, TimeZone timeZone) throws SQLException {
        if (timestamp == null) {
            this.setNull();
        } else {
            SqlDates sqlDates = SqlDates.getDefaultInstance();
            if (timeZone != null) {
                this.setString(sqlDates.formatTimestamp((java.util.Date)timestamp, timeZone));
            } else {
                this.setString(sqlDates.formatTimestamp((java.util.Date)timestamp, false));
            }
        }
    }

    @Override
    public void setTimestamp(java.util.Date date) throws SQLException {
        if (date == null) {
            this.setNull();
        } else {
            this.setString(date.toString());
        }
    }

    @Override
    public void setTimestamp(Calendar calendar) throws SQLException {
        if (calendar == null) {
            this.setNull();
        } else {
            this.setString(calendar.getTime().toString());
        }
    }

    @Override
    public void setTimestamp(LocalDateTime localDateTime) throws SQLException {
        if (localDateTime == null) {
            this.setNull();
        } else {
            this.setString(localDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        }
    }

    @Override
    public void setTimestamp(OffsetDateTime offsetDateTime) throws SQLException {
        if (offsetDateTime == null) {
            this.setNull();
        } else {
            this.setString(offsetDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
    }

    @Override
    public void setAsciiStream(InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setNull();
        } else {
            this.setStream(SqlLongNChar.cnvtAscii(inputStream));
        }
    }

    @Override
    public void setUnicodeStream(InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setNull();
        } else {
            this.setStream(SqlLongNChar.cnvtUnicode(inputStream));
        }
    }

    @Override
    public void setCharacterStream(Reader reader) throws SQLException {
        this.setStream(reader);
    }

    @Override
    public boolean getBoolean() throws SQLException {
        String string = this.getString().trim();
        return string.equals("1") ? true : Boolean.valueOf(string);
    }

    @Override
    public byte getByte() throws SQLException {
        byte by;
        try {
            by = Byte.parseByte(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return by;
    }

    @Override
    public short getShort() throws SQLException {
        short s;
        try {
            s = Short.parseShort(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return s;
    }

    @Override
    public int getInt() throws SQLException {
        int n;
        try {
            n = Integer.parseInt(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return n;
    }

    @Override
    public long getLong() throws SQLException {
        long l;
        try {
            l = Long.parseLong(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return l;
    }

    @Override
    public BigInteger getBigInteger() throws SQLException {
        BigInteger bigInteger;
        try {
            bigInteger = new BigInteger(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return bigInteger;
    }

    @Override
    public float getFloat() throws SQLException {
        float f;
        try {
            f = Float.parseFloat(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return f;
    }

    @Override
    public double getDouble() throws SQLException {
        double d;
        try {
            d = Double.parseDouble(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return d;
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return bigDecimal;
    }

    @Override
    public String getString() throws SQLException {
        return SqlLongNChar.strm2str(this.getCharacter());
    }

    @Override
    public String getString(int n) throws SQLException {
        return SqlLongNChar.strm2str(this.getCharacter(), n);
    }

    @Override
    public Date getDate(TimeZone timeZone) throws SQLException {
        SqlDates sqlDates = SqlDates.getDefaultInstance();
        String string = this.getString().trim();
        return timeZone == null ? sqlDates.parseDate(string, false) : sqlDates.parseDate(string, timeZone);
    }

    @Override
    public LocalDate getLocalDate() throws SQLException {
        LocalDate localDate = null;
        try {
            localDate = LocalDate.parse(this.getString().trim(), DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return localDate;
    }

    @Override
    public Time getTime(TimeZone timeZone) throws SQLException {
        SqlDates sqlDates = SqlDates.getDefaultInstance();
        String string = this.getString().trim();
        return timeZone == null ? sqlDates.parseTime(string, false) : sqlDates.parseTime(string, timeZone);
    }

    @Override
    public LocalTime getLocalTime() throws SQLException {
        LocalTime localTime = null;
        try {
            localTime = LocalTime.parse(this.getString().trim(), DateTimeFormatter.ISO_LOCAL_TIME);
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return localTime;
    }

    @Override
    public OffsetTime getOffsetTime() throws SQLException {
        OffsetTime offsetTime = null;
        try {
            offsetTime = OffsetTime.parse(this.getString().trim(), DateTimeFormatter.ISO_OFFSET_TIME);
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return offsetTime;
    }

    @Override
    public Timestamp getTimestamp(TimeZone timeZone) throws SQLException {
        SqlDates sqlDates = SqlDates.getDefaultInstance();
        String string = this.getString().trim();
        return timeZone == null ? sqlDates.parseTimestamp(string, false) : sqlDates.parseTimestamp(string, timeZone);
    }

    @Override
    public java.util.Date getJavaDate() throws SQLException {
        java.util.Date date;
        try {
            date = new java.util.Date(this.getString().trim());
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return date;
    }

    @Override
    public Calendar getCalendar() throws SQLException {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(new java.util.Date(this.getString().trim()));
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return calendar;
    }

    @Override
    public LocalDateTime getLocalDateTime() throws SQLException {
        LocalDateTime localDateTime = null;
        try {
            localDateTime = LocalDateTime.parse(this.getString().trim(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return localDateTime;
    }

    @Override
    public OffsetDateTime getOffsetDateTime() throws SQLException {
        OffsetDateTime offsetDateTime = null;
        try {
            offsetDateTime = OffsetDateTime.parse(this.getString().trim(), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return offsetDateTime;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return this.getAscii();
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        return this.getUnicode();
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return this.getCharacter();
    }

    @Override
    public Clob getClob() throws SQLException {
        return new BufferedClob(this.getCharacter());
    }

    @Override
    public NClob getNlob() throws SQLException {
        return new BufferedNlob(this.getCharacter());
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getString();
    }

    @Override
    public Object getObject(int n) throws SQLException {
        return this.getString(n);
    }

    @Override
    protected Reader cnvtIS2Rdr(InputStream inputStream) throws SQLException {
        return null;
    }

    public static String strm2str(Reader reader) throws SQLException {
        char[] cArray = new char[8192];
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            while ((n = reader.read(cArray, 0, cArray.length)) >= 0) {
                if (n <= 0) continue;
                stringBuffer.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw SqlExFactory.get(ERR_GC4007_BLOB_IO);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return stringBuffer.toString();
    }

    public static String strm2str(Reader reader, int n) throws SQLException {
        char[] cArray = new char[8192];
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n2;
            while (stringBuffer.length() < n && (n2 = reader.read(cArray, 0, cArray.length)) >= 0) {
                if ((n2 = Math.min(n2, n - stringBuffer.length())) <= 0) continue;
                stringBuffer.append(cArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            throw SqlExFactory.get(ERR_GC4007_BLOB_IO);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return stringBuffer.toString();
    }
}

