/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDates;
import com.ingres.gcf.util.SqlExFactory;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;

public class SqlTime
extends SqlData
implements DbmsConst {
    private String value = null;
    private int nanos = 0;
    private String timezone = null;
    private short dbms_type = (short)8;
    private SqlDates dates;
    private static Date now = new Date();

    public SqlTime(short s) throws SQLException {
        super(true);
        switch (s) {
            case 6: 
            case 7: 
            case 8: {
                this.dbms_type = s;
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
            }
        }
        this.dates = SqlDates.getDefaultInstance();
    }

    public SqlTime(SqlDates sqlDates, short s) throws SQLException {
        super(true);
        switch (s) {
            case 6: 
            case 7: 
            case 8: {
                this.dbms_type = s;
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
            }
        }
        this.dates = sqlDates;
    }

    public void set(String string) throws SQLException {
        if (string == null) {
            this.setNull();
            return;
        }
        if (this.dbms_type != 7) {
            this.timezone = null;
        } else {
            if (string.length() < "HH:mm:ss".length() + "+HH:mm".length()) {
                throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
            }
            int n = string.length() - "+HH:mm".length();
            this.timezone = string.substring(n);
            string = string.substring(0, n);
        }
        if (string.length() <= "HH:mm:ss".length()) {
            this.nanos = 0;
        } else {
            this.nanos = this.dates.parseFrac(string, "HH:mm:ss".length());
            string = string.substring(0, "HH:mm:ss".length());
        }
        this.setNotNull();
        this.value = string;
    }

    public void set(SqlTime sqlTime) {
        if (sqlTime == null || sqlTime.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = sqlTime.value;
            this.nanos = sqlTime.nanos;
            this.timezone = sqlTime.timezone;
            this.dbms_type = sqlTime.dbms_type;
        }
    }

    public String get() {
        String string = this.value;
        if (this.nanos > 0) {
            string = string + this.dates.formatFrac(this.nanos);
        }
        if (this.dbms_type == 7) {
            string = string + this.timezone;
        }
        return string;
    }

    @Override
    public void setString(String string) throws SQLException {
        if (string == null) {
            this.setNull();
        } else {
            Time time;
            int n = 0;
            int n2 = string.indexOf(".");
            if (n2 >= 0) {
                n = this.dates.parseFrac(string, n2);
                string = string.substring(0, n2);
            }
            try {
                time = Time.valueOf(string);
            }
            catch (Exception exception) {
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
            this.setTime(time, null);
            this.nanos = n;
        }
    }

    @Override
    public void setTime(Time time, TimeZone timeZone) throws SQLException {
        this.set(time, timeZone);
    }

    @Override
    public void setTime(LocalTime localTime) throws SQLException {
        this.setTime(Time.valueOf(localTime), null);
        if (localTime != null) {
            this.nanos = localTime.getNano();
        }
    }

    @Override
    public void setTime(OffsetTime offsetTime) throws SQLException {
        if (offsetTime == null) {
            this.setNull();
            return;
        }
        this.setNotNull();
        this.value = offsetTime.format(DateTimeFormatter.ISO_LOCAL_TIME);
        this.nanos = offsetTime.getNano();
        this.timezone = null;
        if (this.value.length() > 8) {
            this.value = this.value.substring(0, 8);
        }
        if (this.value.length() != 8 || this.value.charAt(2) != ':' || this.value.charAt(5) != ':') {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        switch (this.dbms_type) {
            case 8: {
                this.value = this.dates.formatTime((Date)this.dates.parseTime(this.value, this.dates.getTZ(offsetTime.getOffset().getId())), true);
                if (this.value.length() == 8 && this.value.charAt(2) == ':' && this.value.charAt(5) == ':') break;
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
            case 7: {
                this.timezone = offsetTime.getOffset().getId();
                if (this.timezone.length() == 6 && this.timezone.charAt(3) == ':' && (this.timezone.charAt(0) == '+' || this.timezone.charAt(0) == '-')) break;
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
        }
    }

    @Override
    public void setTimestamp(Timestamp timestamp, TimeZone timeZone) throws SQLException {
        this.set(timestamp, timeZone);
        if (timestamp != null) {
            this.nanos = timestamp.getNanos();
        }
    }

    @Override
    public void setTimestamp(LocalDateTime localDateTime) throws SQLException {
        if (localDateTime == null) {
            this.setNull();
        } else {
            this.setTime(localDateTime.toLocalTime());
        }
    }

    @Override
    public void setTimestamp(OffsetDateTime offsetDateTime) throws SQLException {
        if (offsetDateTime == null) {
            this.setNull();
        } else {
            this.setTime(offsetDateTime.toOffsetTime());
        }
    }

    private void set(Date date, TimeZone timeZone) throws SQLException {
        if (date == null) {
            this.setNull();
            return;
        }
        this.setNotNull();
        this.nanos = 0;
        this.timezone = null;
        switch (this.dbms_type) {
            case 8: {
                this.value = this.dates.formatTime(date, true);
                break;
            }
            case 6: {
                this.value = timeZone != null ? this.dates.formatTime(date, timeZone) : this.dates.formatTime(date, false);
                break;
            }
            case 7: {
                this.value = timeZone != null ? this.dates.formatTime(date, timeZone) : this.dates.formatTime(date, false);
                long l = System.currentTimeMillis();
                String string = this.timezone = timeZone != null ? this.dates.formatTZ(timeZone, l) : this.dates.formatTZ(l);
                if (this.timezone.length() == 6 && this.timezone.charAt(3) == ':' && (this.timezone.charAt(0) == '+' || this.timezone.charAt(0) == '-')) break;
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
        }
        if (this.value.length() != 8 || this.value.charAt(2) != ':' || this.value.charAt(5) != ':') {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
    }

    @Override
    public String getString() throws SQLException {
        String string = this.dates.formatTime((Date)this.get(null), false);
        if (this.nanos > 0) {
            string = string + this.dates.formatFrac(this.nanos);
        }
        return string;
    }

    @Override
    public Time getTime(TimeZone timeZone) throws SQLException {
        return this.get(timeZone);
    }

    @Override
    public LocalTime getLocalTime() throws SQLException {
        LocalTime localTime = this.get(null).toLocalTime();
        if (this.nanos > 0) {
            localTime = localTime.withNano(this.nanos);
        }
        return localTime;
    }

    @Override
    public OffsetTime getOffsetTime() throws SQLException {
        Time time = null;
        int n = 0;
        switch (this.dbms_type) {
            case 8: {
                time = this.get(null);
                n = this.dates.getOffset(System.currentTimeMillis());
                break;
            }
            case 6: {
                time = this.dates.parseTime(this.value, false);
                n = this.dates.getOffset(System.currentTimeMillis());
                break;
            }
            case 7: {
                time = this.dates.parseTime(this.value, false);
                n = this.dates.parseOffset(this.timezone);
            }
        }
        LocalTime localTime = time.toLocalTime();
        if (this.nanos > 0) {
            localTime = localTime.withNano(this.nanos);
        }
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(n * 60);
        return OffsetTime.of(localTime, zoneOffset);
    }

    @Override
    public Timestamp getTimestamp(TimeZone timeZone) throws SQLException {
        Timestamp timestamp = new Timestamp(this.get(timeZone).getTime());
        if (this.nanos > 0) {
            timestamp.setNanos(this.nanos);
        }
        return timestamp;
    }

    @Override
    public LocalDateTime getLocalDateTime() throws SQLException {
        LocalDateTime localDateTime = null;
        switch (this.dbms_type) {
            case 6: {
                Time time = this.dates.parseTime(this.value, false);
                LocalTime localTime = time.toLocalTime();
                if (this.nanos > 0) {
                    localTime = localTime.withNano(this.nanos);
                }
                localDateTime = LocalDateTime.of(LocalDate.now(), localTime);
                break;
            }
            case 7: 
            case 8: {
                localDateTime = this.getOffsetDateTime().toLocalDateTime();
            }
        }
        return localDateTime;
    }

    @Override
    public OffsetDateTime getOffsetDateTime() throws SQLException {
        Time time = null;
        int n = 0;
        boolean bl = false;
        switch (this.dbms_type) {
            case 8: {
                time = this.get(null);
                n = this.dates.getOffset(System.currentTimeMillis());
                bl = true;
                break;
            }
            case 6: {
                time = this.dates.parseTime(this.value, false);
                n = this.dates.getOffset(System.currentTimeMillis());
                bl = false;
                break;
            }
            case 7: {
                time = this.dates.parseTime(this.value, false);
                n = this.dates.parseOffset(this.timezone);
                bl = true;
            }
        }
        LocalTime localTime = time.toLocalTime();
        if (this.nanos > 0) {
            localTime = localTime.withNano(this.nanos);
        }
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(n * 60);
        OffsetTime offsetTime = OffsetTime.of(localTime, zoneOffset);
        if (bl) {
            offsetTime = offsetTime.withOffsetSameInstant(ZoneOffset.ofTotalSeconds(0));
        }
        OffsetDateTime offsetDateTime = OffsetDateTime.of(LocalDate.now(), offsetTime.toLocalTime(), offsetTime.getOffset());
        if (bl) {
            offsetDateTime = offsetDateTime.withOffsetSameInstant(zoneOffset);
        }
        return offsetDateTime;
    }

    @Override
    public Object getObject() throws SQLException {
        return this.get(null);
    }

    private Time get(TimeZone timeZone) throws SQLException {
        Time time = null;
        switch (this.dbms_type) {
            case 8: {
                if (timeZone == null) {
                    timeZone = TimeZone.getDefault();
                }
                now.setTime(System.currentTimeMillis());
                if (!timeZone.useDaylightTime() || !timeZone.inDaylightTime(now)) {
                    time = this.dates.parseTime(this.value, true);
                } else {
                    int n = timeZone.getDSTSavings() / 60000;
                    time = this.dates.parseTime(this.value, this.dates.getTZ(-n));
                }
                this.adjustToEpoch(time, timeZone);
                break;
            }
            case 6: {
                time = timeZone != null ? this.dates.parseTime(this.value, timeZone) : this.dates.parseTime(this.value, false);
                break;
            }
            case 7: {
                if (timeZone == null) {
                    timeZone = TimeZone.getDefault();
                }
                TimeZone timeZone2 = this.dates.getTZ(this.timezone);
                now.setTime(System.currentTimeMillis());
                if (!timeZone.useDaylightTime() || !timeZone.inDaylightTime(now)) {
                    time = this.dates.parseTime(this.value, timeZone2);
                } else {
                    int n = (timeZone2.getRawOffset() - timeZone.getDSTSavings()) / 60000;
                    time = this.dates.parseTime(this.value, this.dates.getTZ(n));
                }
                this.adjustToEpoch(time, timeZone);
            }
        }
        return time;
    }

    public int getNanos() {
        return this.nanos;
    }

    private void adjustToEpoch(Time time, TimeZone timeZone) {
        long l = time.getTime();
        int n = timeZone.getOffset(0L);
        long l2 = 86400000L;
        while (l + (long)n < 0L) {
            l += l2;
        }
        while (l + (long)n >= l2) {
            l -= l2;
        }
        time.setTime(l);
    }
}

