/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDates;
import com.ingres.gcf.util.SqlExFactory;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;

public class SqlTimestamp
extends SqlData
implements DbmsConst {
    private String value = null;
    private int nanos = 0;
    private String timezone = null;
    private short dbms_type = (short)19;
    private SqlDates dates;

    public SqlTimestamp(short s) throws SQLException {
        super(true);
        switch (s) {
            case 9: 
            case 18: 
            case 19: {
                this.dbms_type = s;
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
            }
        }
        this.dates = SqlDates.getDefaultInstance();
    }

    public SqlTimestamp(SqlDates sqlDates, short s) throws SQLException {
        super(true);
        switch (s) {
            case 9: 
            case 18: 
            case 19: {
                this.dbms_type = s;
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
            }
        }
        this.dates = sqlDates;
    }

    public void set(String string) throws SQLException {
        if (string == null) {
            this.setNull();
            return;
        }
        if (this.dbms_type != 18) {
            this.timezone = null;
        } else {
            if (string.length() < "yyyy-MM-dd HH:mm:ss".length() + "+HH:mm".length()) {
                throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
            }
            int n = string.length() - "+HH:mm".length();
            this.timezone = string.substring(n);
            string = string.substring(0, n);
        }
        if (string.length() <= "yyyy-MM-dd HH:mm:ss".length()) {
            this.nanos = 0;
        } else {
            this.nanos = this.dates.parseFrac(string, "yyyy-MM-dd HH:mm:ss".length());
            string = string.substring(0, "yyyy-MM-dd HH:mm:ss".length());
        }
        this.setNotNull();
        this.value = string;
    }

    public void set(SqlTimestamp sqlTimestamp) {
        if (sqlTimestamp == null || sqlTimestamp.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = sqlTimestamp.value;
            this.nanos = sqlTimestamp.nanos;
            this.timezone = sqlTimestamp.timezone;
            this.dbms_type = sqlTimestamp.dbms_type;
        }
    }

    public String get() {
        String string = this.value;
        if (this.nanos > 0) {
            string = string + this.dates.formatFrac(this.nanos);
        }
        if (this.dbms_type == 18) {
            string = string + this.timezone;
        }
        return string;
    }

    @Override
    public void setString(String string) throws SQLException {
        if (string == null) {
            this.setNull();
        } else {
            Timestamp timestamp;
            try {
                timestamp = Timestamp.valueOf(string);
            }
            catch (Exception exception) {
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
            this.setTimestamp(timestamp, null);
        }
    }

    @Override
    public void setDate(java.sql.Date date, TimeZone timeZone) throws SQLException {
        this.set(date, timeZone);
    }

    @Override
    public void setTime(Time time, TimeZone timeZone) throws SQLException {
        this.set(time, timeZone);
    }

    @Override
    public void setTimestamp(Timestamp timestamp, TimeZone timeZone) throws SQLException {
        this.set(timestamp, timeZone);
        if (timestamp != null) {
            this.nanos = timestamp.getNanos();
        }
    }

    @Override
    public void setTimestamp(OffsetDateTime offsetDateTime) throws SQLException {
        if (offsetDateTime == null) {
            this.setNull();
            return;
        }
        char[] cArray = offsetDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME).toCharArray();
        if (cArray.length < 19 || cArray[10] != 'T' || cArray[4] != '-' || cArray[7] != '-' || cArray[13] != ':' || cArray[16] != ':') {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        cArray[10] = 32;
        this.value = new String(cArray, 0, 19);
        this.nanos = offsetDateTime.getNano();
        this.timezone = null;
        this.setNotNull();
        switch (this.dbms_type) {
            case 19: {
                this.value = this.dates.formatTimestamp((Date)this.dates.parseTimestamp(this.value, this.dates.getTZ(offsetDateTime.getOffset().getId())), true);
                if (this.value.length() == 19 && this.value.charAt(10) == ' ' && this.value.charAt(4) == '-' && this.value.charAt(7) == '-' && this.value.charAt(13) == ':' && this.value.charAt(16) == ':') break;
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
            case 18: {
                this.timezone = offsetDateTime.getOffset().getId();
                if (this.timezone.length() == 6 && this.timezone.charAt(3) == ':' && (this.timezone.charAt(0) == '+' || this.timezone.charAt(0) == '-')) break;
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
        }
    }

    private void set(Date date, TimeZone timeZone) throws SQLException {
        if (date == null) {
            this.setNull();
            return;
        }
        this.setNotNull();
        this.nanos = 0;
        this.timezone = null;
        switch (this.dbms_type) {
            case 19: {
                this.value = this.dates.formatTimestamp(date, true);
                break;
            }
            case 9: {
                this.value = timeZone != null ? this.dates.formatTimestamp(date, timeZone) : this.dates.formatTimestamp(date, false);
                break;
            }
            case 18: {
                this.value = timeZone != null ? this.dates.formatTimestamp(date, timeZone) : this.dates.formatTimestamp(date, false);
                String string = this.timezone = timeZone != null ? this.dates.formatTZ(timeZone, date) : this.dates.formatTZ(date);
                if (this.timezone.length() == 6 && this.timezone.charAt(3) == ':' && (this.timezone.charAt(0) == '+' || this.timezone.charAt(0) == '-')) break;
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
        }
        if (this.value.length() != 19 || this.value.charAt(10) != ' ' || this.value.charAt(4) != '-' || this.value.charAt(7) != '-' || this.value.charAt(13) != ':' || this.value.charAt(16) != ':') {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
    }

    @Override
    public String getString() throws SQLException {
        String string = this.dates.formatTimestamp((Date)this.get(null), false);
        if (this.nanos > 0) {
            string = string + this.dates.formatFrac(this.nanos);
        }
        return string;
    }

    @Override
    public java.sql.Date getDate(TimeZone timeZone) throws SQLException {
        return this.dates.parseDate(this.dates.formatDate((Date)this.get(timeZone), false), false);
    }

    @Override
    public Time getTime(TimeZone timeZone) throws SQLException {
        return this.dates.parseTime(this.dates.formatTime((Date)this.get(timeZone), false), false);
    }

    @Override
    public Timestamp getTimestamp(TimeZone timeZone) throws SQLException {
        return this.get(timeZone);
    }

    @Override
    public OffsetDateTime getOffsetDateTime() throws SQLException {
        Timestamp timestamp = null;
        int n = 0;
        switch (this.dbms_type) {
            case 19: {
                timestamp = this.dates.parseTimestamp(this.value, true);
                n = this.dates.getOffset(timestamp);
                break;
            }
            case 9: {
                timestamp = this.dates.parseTimestamp(this.value, false);
                n = this.dates.getOffset(timestamp);
                break;
            }
            case 18: {
                timestamp = this.dates.parseTimestamp(this.value, false);
                n = this.dates.parseOffset(this.timezone);
            }
        }
        timestamp.setNanos(this.nanos);
        return OffsetDateTime.of(timestamp.toLocalDateTime(), ZoneOffset.ofTotalSeconds(n * 60));
    }

    @Override
    public Object getObject() throws SQLException {
        return this.get(null);
    }

    private Timestamp get(TimeZone timeZone) throws SQLException {
        Timestamp timestamp = null;
        switch (this.dbms_type) {
            case 19: {
                timestamp = this.dates.parseTimestamp(this.value, true);
                break;
            }
            case 9: {
                timestamp = timeZone != null ? this.dates.parseTimestamp(this.value, timeZone) : this.dates.parseTimestamp(this.value, false);
                break;
            }
            case 18: {
                timestamp = this.dates.parseTimestamp(this.value, this.dates.getTZ(this.timezone));
            }
        }
        timestamp.setNanos(this.nanos);
        return timestamp;
    }

    public int getNanos() {
        return this.nanos;
    }
}

