/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.jdbc;

import com.ingres.gcf.dam.MsgConn;
import com.ingres.gcf.util.ConfigEmpty;
import com.ingres.gcf.util.TraceLog;
import com.ingres.jdbc.IngConfig;
import com.ingres.jdbc.IngConst;
import com.ingres.jdbc.IngresDriver;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;

public final class IngresMain
implements IngConst {
    public static void main(String[] stringArray) {
        if (stringArray.length > 0 && stringArray[0].length() > 0 && stringArray[0].charAt(0) == '-') {
            if (stringArray.length != 1) {
                IngresMain.usage("Invalid additional arguments");
                return;
            }
            switch (stringArray[0]) {
                case "-h": 
                case "-help": {
                    System.out.println();
                    System.out.println("-h[elp]         This help text");
                    System.out.println("-p[roperties]   Display driver properties");
                    System.out.println("-P[roperties]   Display all properties");
                    System.out.println("<url>           Test DBMS connection");
                    System.out.println("<host> <port>   Test server connection");
                    System.out.println();
                    System.out.println("URL Format: ");
                    for (int i = 0; i < ing_proto_ids.length; ++i) {
                        System.out.println("    jdbc:" + ing_proto_ids[i] + "://host:port/dbname");
                    }
                    System.out.println();
                    System.out.println("Note: to utilize application classpath,");
                    System.out.println("use 'java com.ingres.jdbc.IngresMain [args]'");
                    System.out.println("rather than 'java -jar <jarfile> [args]'.");
                    System.out.println();
                    break;
                }
                case "-p": 
                case "-properties": {
                    IngConfig.getConfig().print(System.out, null);
                    break;
                }
                case "-P": 
                case "-Properties": {
                    IngConfig.getConfig(true).print(System.out);
                    break;
                }
                default: {
                    IngresMain.usage("Invalid switch: " + stringArray[0]);
                }
            }
            return;
        }
        switch (stringArray.length) {
            case 0: {
                IngresDriver ingresDriver = new IngresDriver();
                System.out.println(ingresDriver.toString() + " [" + ingresDriver.getMajorVersion() + "." + ingresDriver.getMinorVersion() + "." + ingresDriver.getPatchVersion() + "]");
                break;
            }
            case 1: {
                IngresMain.dbmsConnect(stringArray[0]);
                break;
            }
            case 2: {
                IngresMain.serverConnect(stringArray[0], stringArray[1]);
                break;
            }
            default: {
                IngresMain.usage("Invalid number of arguments");
            }
        }
    }

    private static void usage(String string) {
        if (string != null) {
            System.out.println(string);
        }
        System.out.println("usage: [-h|p] | <url> | <host> <port>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dbmsConnect(String string) {
        Connection connection;
        IngresDriver ingresDriver = new IngresDriver();
        try {
            connection = ingresDriver.connect(string, new Properties());
            if (connection == null) {
                System.out.println("This driver does not service the URL provided");
                System.out.println("URL Format: ");
                for (int i = 0; i < ing_proto_ids.length; ++i) {
                    System.out.println("    jdbc:" + ing_proto_ids[i] + "://host:port/dbname");
                }
                return;
            }
        }
        catch (SQLException sQLException) {
            System.out.println("Error connecting to '" + string + "':");
            IngresMain.printSQLException(sQLException);
            return;
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            System.out.println(databaseMetaData.getDriverName() + " [" + databaseMetaData.getDriverVersion() + "]: JDBC " + databaseMetaData.getJDBCMajorVersion() + "." + databaseMetaData.getJDBCMinorVersion());
            System.out.println(databaseMetaData.getDatabaseProductName() + " [" + databaseMetaData.getDatabaseMajorVersion() + "." + databaseMetaData.getDatabaseMinorVersion() + "]: " + databaseMetaData.getDatabaseProductVersion());
        }
        catch (SQLException sQLException) {
            System.out.println("Error accessing DBMS information:");
            IngresMain.printSQLException(sQLException);
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void serverConnect(String string, String string2) {
        String string3 = string + ":" + string2;
        try {
            ConfigEmpty configEmpty = new ConfigEmpty();
            TraceLog traceLog = TraceLog.getTraceLog(configEmpty);
            MsgConn msgConn = new MsgConn(configEmpty, traceLog);
            byte[] byArray = new byte[]{1, 1, 1};
            byArray = msgConn.connect(string3, byArray);
            msgConn.close();
            System.out.println("Connected successfully to '" + string3 + "'");
        }
        catch (SQLException sQLException) {
            System.out.println("Error connecting to '" + string3 + "':");
            IngresMain.printSQLException(sQLException);
        }
    }

    private static void printSQLException(SQLException sQLException) {
        do {
            System.out.print("SQLException: ");
            System.out.print("'" + sQLException.getSQLState() + "' ");
            System.out.print("0x" + Integer.toHexString(sQLException.getErrorCode()));
            System.out.println(" -- " + sQLException.getMessage());
            for (Throwable throwable = sQLException.getCause(); throwable != null; throwable = throwable.getCause()) {
                System.out.println("  caused by: " + throwable.getMessage());
            }
        } while ((sQLException = sQLException.getNextException()) != null);
    }
}

