/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.commons.core.configs;

import android.graphics.Color;
import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.inmobi.commons.core.configs.Config;
import com.inmobi.commons.utils.json.Constructor;
import com.inmobi.media.h4;
import com.inmobi.media.h7;
import com.inmobi.media.l2;
import com.inmobi.media.o6;
import com.inmobi.media.ob;
import com.inmobi.unification.sdk.model.Initialization.TimeoutConfigurations;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u001d\b\u0007\u0018\u0000 m2\u00020\u0001:\u0014nopqrstuvwxyz{|}~\u007f\u0080\u0001B\u0011\u0012\b\u0010k\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\bl\u0010\u001bJ\b\u0010\u0003\u001a\u00020\u0002H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0002J\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0012\u001a\u00020\u0011J\u0006\u0010\u0013\u001a\u00020\u0006R\u0016\u0010\u0014\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\"\u0010\u0016\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u001c\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u0015\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\"\u0010!\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\u0015\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u0016\u0010$\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R$\u0010'\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00068\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b'\u0010%\u001a\u0004\b(\u0010)R\"\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b0*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0016\u0010-\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\"\u00100\u001a\u00020/8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b0\u00101\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0016\u00106\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R\"\u00109\u001a\u0002088\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\"\u0010@\u001a\u00020?8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b@\u0010A\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\"\u0010G\u001a\u00020F8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bG\u0010H\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\"\u0010N\u001a\u00020M8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bN\u0010O\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010SR\"\u0010U\u001a\u00020T8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bU\u0010V\u001a\u0004\bW\u0010X\"\u0004\bY\u0010ZR\"\u0010\\\u001a\u00020[8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\\\u0010]\u001a\u0004\b^\u0010_\"\u0004\b`\u0010aR\u0016\u0010b\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bb\u0010cR\"\u0010e\u001a\u00020d8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\be\u0010f\u001a\u0004\bg\u0010h\"\u0004\bi\u0010j\u00a8\u0006\u0081\u0001"}, d2={"Lcom/inmobi/commons/core/configs/AdConfig;", "Lcom/inmobi/commons/core/configs/Config;", "", "getType", "Lorg/json/JSONObject;", "toJson", "", "isValid", "", "getMaxPoolSize", "adType", "Lcom/inmobi/commons/core/configs/AdConfig$CacheConfig;", "getCacheConfig", "Lcom/inmobi/commons/core/configs/AdConfig$ImaiConfig;", "getImaiConfig", "Lcom/inmobi/commons/core/configs/AdConfig$MraidConfig;", "getMraidConfig", "Lcom/inmobi/commons/core/configs/AdConfig$AssetCacheConfig;", "getAssetCacheConfig", "isCCTEnabled", "maxPoolSize", "I", "url", "Ljava/lang/String;", "getUrl", "()Ljava/lang/String;", "setUrl", "(Ljava/lang/String;)V", "minimumRefreshInterval", "getMinimumRefreshInterval", "()I", "setMinimumRefreshInterval", "(I)V", "defaultRefreshInterval", "getDefaultRefreshInterval", "setDefaultRefreshInterval", "cctEnabled", "Z", "<set-?>", "watermarkEnabled", "getWatermarkEnabled", "()Z", "", "cache", "Ljava/util/Map;", "imai", "Lcom/inmobi/commons/core/configs/AdConfig$ImaiConfig;", "Lcom/inmobi/commons/core/configs/AdConfig$RenderingConfig;", "rendering", "Lcom/inmobi/commons/core/configs/AdConfig$RenderingConfig;", "getRendering", "()Lcom/inmobi/commons/core/configs/AdConfig$RenderingConfig;", "setRendering", "(Lcom/inmobi/commons/core/configs/AdConfig$RenderingConfig;)V", "mraid", "Lcom/inmobi/commons/core/configs/AdConfig$MraidConfig;", "Lcom/inmobi/commons/core/configs/AdConfig$ViewabilityConfig;", "viewability", "Lcom/inmobi/commons/core/configs/AdConfig$ViewabilityConfig;", "getViewability", "()Lcom/inmobi/commons/core/configs/AdConfig$ViewabilityConfig;", "setViewability", "(Lcom/inmobi/commons/core/configs/AdConfig$ViewabilityConfig;)V", "Lcom/inmobi/commons/core/configs/AdConfig$ContextualDataConfig;", "contextualData", "Lcom/inmobi/commons/core/configs/AdConfig$ContextualDataConfig;", "getContextualData", "()Lcom/inmobi/commons/core/configs/AdConfig$ContextualDataConfig;", "setContextualData", "(Lcom/inmobi/commons/core/configs/AdConfig$ContextualDataConfig;)V", "Lcom/inmobi/commons/core/configs/AdConfig$AdQualityConfig;", "adQuality", "Lcom/inmobi/commons/core/configs/AdConfig$AdQualityConfig;", "getAdQuality", "()Lcom/inmobi/commons/core/configs/AdConfig$AdQualityConfig;", "setAdQuality", "(Lcom/inmobi/commons/core/configs/AdConfig$AdQualityConfig;)V", "Lcom/inmobi/commons/core/configs/AdConfig$AdReportConfig;", "adReport", "Lcom/inmobi/commons/core/configs/AdConfig$AdReportConfig;", "getAdReport", "()Lcom/inmobi/commons/core/configs/AdConfig$AdReportConfig;", "setAdReport", "(Lcom/inmobi/commons/core/configs/AdConfig$AdReportConfig;)V", "Lcom/inmobi/commons/core/configs/AdConfig$AudioConfig;", "audio", "Lcom/inmobi/commons/core/configs/AdConfig$AudioConfig;", "getAudio", "()Lcom/inmobi/commons/core/configs/AdConfig$AudioConfig;", "setAudio", "(Lcom/inmobi/commons/core/configs/AdConfig$AudioConfig;)V", "Lcom/inmobi/commons/core/configs/AdConfig$VastVideoConfig;", "vastVideo", "Lcom/inmobi/commons/core/configs/AdConfig$VastVideoConfig;", "getVastVideo", "()Lcom/inmobi/commons/core/configs/AdConfig$VastVideoConfig;", "setVastVideo", "(Lcom/inmobi/commons/core/configs/AdConfig$VastVideoConfig;)V", "assetCache", "Lcom/inmobi/commons/core/configs/AdConfig$AssetCacheConfig;", "Lcom/inmobi/unification/sdk/model/Initialization/TimeoutConfigurations;", "timeouts", "Lcom/inmobi/unification/sdk/model/Initialization/TimeoutConfigurations;", "getTimeouts", "()Lcom/inmobi/unification/sdk/model/Initialization/TimeoutConfigurations;", "setTimeouts", "(Lcom/inmobi/unification/sdk/model/Initialization/TimeoutConfigurations;)V", "accountId", "<init>", "Companion", "AdQualityConfig", "AdReportConfig", "AssetCacheConfig", "AudioConfig", "AudioViewabilityConfig", "BannerImpressionTypeConfig", "BitRateConfig", "CacheConfig", "a", "ContextualDataConfig", "ImaiConfig", "InterstitialImpressionTypeConfig", "MraidConfig", "OmidConfig", "RenderingConfig", "VastVideoConfig", "VideoViewabilityConfig", "ViewabilityConfig", "WebViewabilityConfig", "media_release"})
@Keep
public final class AdConfig
extends Config {
    @NotNull
    public static final a Companion = new a();
    public static final int DEFAULT_MAX_POOL_SIZE = 10;
    @NotNull
    public static final String DEFAULT_AD_SERVER_URL = "https://ads.inmobi.com/sdk";
    public static final int DEFAULT_MINIMUM_REFRESH_INTERVAL = 20;
    public static final int DEFAULT_REFRESH_INTERVAL = 60;
    public static final boolean DEFAULT_CCT_ENABLED = false;
    public static final int DEFAULT_MIN_VOLUME_AUDIO_REQUEST = 30;
    public static final int DEFAULT_MINIMUM_AUDIO_REFRESH_INTERVAL = 20;
    @NotNull
    private static final String ALLOWED_CONTENT_TYPE = "allowedContentType";
    @NotNull
    private static final String GESTURE_LIST = "gestures";
    @NotNull
    private static final String SKIP_FIELDS = "skipFields";
    public static final int MIN_VISIBILITY_THROTTLE_INTERVAL_MILLIS = 50;
    public static final int MIN_IMPRESSION_POLL_INTERVAL_MILLIS = 50;
    public static final int DEFAULT_TOUCH_RESET_TIME = 4;
    public static final short DEFAULT_NETWORK_LOAD_LIMIT = 50;
    public static final byte NETWORK_LOAD_LIMIT_DISABLED = -1;
    public static final int DEFAULT_CONTEXTUAL_DATA_MAX_RECORDS = 1;
    @NotNull
    private static final List<String> DEFAULT_CONTEXTUAL_DATA_SKIP_FIELDS = CollectionsKt.emptyList();
    public static final int DEFAULT_CONTEXTUAL_DATA_EXPIRY_TIME = 86400;
    public static final boolean DEFAULT_AD_QUALITY_KILL_SWITCH = true;
    public static final int DEFAULT_AD_QUALITY_MAX_RETRIES = 3;
    public static final int DEFAULT_AD_QUALITY_MAX_IMAGE_SIZE = 153600;
    public static final int DEFAULT_AD_QUALITY_RESIZE_PERCENTAGE = 100;
    public static final int DEFAULT_AD_QUALITY_RETRY_INTERVAL = 5000;
    public static final boolean DEFAULT_WATERMARK_KILL_SWITCH = true;
    public static final long DEFAULT_AD_LOAD_RETRY_INTERVAL = 1000L;
    public static final boolean DEFAULT_AD_REPORT_KILL_SWITCH = true;
    public static final int DEFAULT_AD_REPORT_LIST_SIZE = 10;
    private int maxPoolSize = 10;
    @NotNull
    private String url = "https://ads.inmobi.com/sdk";
    private int minimumRefreshInterval = 20;
    private int defaultRefreshInterval = 60;
    private boolean cctEnabled;
    private boolean watermarkEnabled = true;
    @NotNull
    private Map<String, CacheConfig> cache;
    @NotNull
    private ImaiConfig imai;
    @NotNull
    private RenderingConfig rendering;
    @NotNull
    private MraidConfig mraid;
    @NotNull
    private ViewabilityConfig viewability;
    @NotNull
    private ContextualDataConfig contextualData;
    @NotNull
    private AdQualityConfig adQuality;
    @NotNull
    private AdReportConfig adReport;
    @NotNull
    private AudioConfig audio;
    @NotNull
    private VastVideoConfig vastVideo;
    @NotNull
    private AssetCacheConfig assetCache;
    @NotNull
    private TimeoutConfigurations timeouts = TimeoutConfigurations.Companion.a();

    public AdConfig(@Nullable String string) {
        super(string);
        CacheConfig cacheConfig;
        CacheConfig cacheConfig2;
        CacheConfig cacheConfig3;
        CacheConfig cacheConfig4;
        CacheConfig cacheConfig5;
        ((AdConfig)object).imai = new ImaiConfig();
        ((AdConfig)object).rendering = new RenderingConfig();
        ((AdConfig)object).mraid = new MraidConfig();
        ((AdConfig)object).viewability = new ViewabilityConfig();
        ((AdConfig)object).vastVideo = new VastVideoConfig();
        ((AdConfig)object).assetCache = new AssetCacheConfig();
        ((AdConfig)object).contextualData = new ContextualDataConfig();
        ((AdConfig)object).adQuality = new AdQualityConfig();
        ((AdConfig)object).adReport = new AdReportConfig();
        ((AdConfig)object).audio = new AudioConfig();
        Pair[] pairArray = new Pair[5];
        Object object = cacheConfig5;
        cacheConfig5 = new CacheConfig();
        pairArray[0] = TuplesKt.to((Object)"base", (Object)object);
        object = cacheConfig4;
        cacheConfig4 = new CacheConfig();
        pairArray[1] = TuplesKt.to((Object)"banner", (Object)object);
        object = cacheConfig3;
        cacheConfig3 = new CacheConfig();
        pairArray[2] = TuplesKt.to((Object)"audio", (Object)object);
        object = cacheConfig2;
        cacheConfig2 = new CacheConfig();
        pairArray[3] = TuplesKt.to((Object)"int", (Object)object);
        object = cacheConfig;
        cacheConfig = new CacheConfig();
        pairArray[4] = TuplesKt.to((Object)"native", (Object)object);
        v6.cache = MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.url = string;
    }

    public final int getMinimumRefreshInterval() {
        return this.minimumRefreshInterval;
    }

    public final void setMinimumRefreshInterval(int n10) {
        this.minimumRefreshInterval = n10;
    }

    public final int getDefaultRefreshInterval() {
        return this.defaultRefreshInterval;
    }

    public final void setDefaultRefreshInterval(int n10) {
        this.defaultRefreshInterval = n10;
    }

    public final boolean getWatermarkEnabled() {
        return this.watermarkEnabled;
    }

    @NotNull
    public final RenderingConfig getRendering() {
        return this.rendering;
    }

    public final void setRendering(@NotNull RenderingConfig renderingConfig) {
        Intrinsics.checkNotNullParameter((Object)renderingConfig, (String)"<set-?>");
        this.rendering = renderingConfig;
    }

    @NotNull
    public final ViewabilityConfig getViewability() {
        return this.viewability;
    }

    public final void setViewability(@NotNull ViewabilityConfig viewabilityConfig) {
        Intrinsics.checkNotNullParameter((Object)viewabilityConfig, (String)"<set-?>");
        this.viewability = viewabilityConfig;
    }

    @NotNull
    public final ContextualDataConfig getContextualData() {
        return this.contextualData;
    }

    public final void setContextualData(@NotNull ContextualDataConfig contextualDataConfig) {
        Intrinsics.checkNotNullParameter((Object)contextualDataConfig, (String)"<set-?>");
        this.contextualData = contextualDataConfig;
    }

    @NotNull
    public final AdQualityConfig getAdQuality() {
        return this.adQuality;
    }

    public final void setAdQuality(@NotNull AdQualityConfig adQualityConfig) {
        Intrinsics.checkNotNullParameter((Object)adQualityConfig, (String)"<set-?>");
        this.adQuality = adQualityConfig;
    }

    @NotNull
    public final AdReportConfig getAdReport() {
        return this.adReport;
    }

    public final void setAdReport(@NotNull AdReportConfig adReportConfig) {
        Intrinsics.checkNotNullParameter((Object)adReportConfig, (String)"<set-?>");
        this.adReport = adReportConfig;
    }

    @NotNull
    public final AudioConfig getAudio() {
        return this.audio;
    }

    public final void setAudio(@NotNull AudioConfig audioConfig) {
        Intrinsics.checkNotNullParameter((Object)audioConfig, (String)"<set-?>");
        this.audio = audioConfig;
    }

    @NotNull
    public final VastVideoConfig getVastVideo() {
        return this.vastVideo;
    }

    public final void setVastVideo(@NotNull VastVideoConfig vastVideoConfig) {
        Intrinsics.checkNotNullParameter((Object)vastVideoConfig, (String)"<set-?>");
        this.vastVideo = vastVideoConfig;
    }

    @NotNull
    public final TimeoutConfigurations getTimeouts() {
        return this.timeouts;
    }

    public final void setTimeouts(@NotNull TimeoutConfigurations timeoutConfigurations) {
        Intrinsics.checkNotNullParameter((Object)timeoutConfigurations, (String)"<set-?>");
        this.timeouts = timeoutConfigurations;
    }

    @Override
    @NotNull
    public String getType() {
        return "ads";
    }

    @Override
    @NotNull
    public JSONObject toJson() {
        AdConfig adConfig = Companion.a().a(adConfig);
        if (adConfig == null) {
            Intrinsics.checkNotNullExpressionValue((Object)"AdConfig", (String)"TAG");
            return new JSONObject();
        }
        return adConfig;
    }

    @Override
    public boolean isValid() {
        if (this.maxPoolSize > 0 && !h4.a(this.url)) {
            int n10;
            int n11 = this.minimumRefreshInterval;
            if (n11 >= 0 && (n10 = this.defaultRefreshInterval) >= 0 && n11 <= n10) {
                Iterator<Map.Entry<String, CacheConfig>> iterator = this.cache.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().getValue().isValid()) continue;
                    return false;
                }
                AdConfig adConfig = this;
                adConfig.timeouts.a0();
                if (!adConfig.contextualData.isValid()) {
                    return false;
                }
                if (!this.adQuality.isValid()) {
                    return false;
                }
                return this.imai.isValid() && this.mraid.isValid() && this.timeouts.Z() && this.rendering.isValid() && this.vastVideo.isValid() && this.assetCache.isValid() && this.viewability.isValid() && this.audio.isValid();
            }
            return false;
        }
        return false;
    }

    public final int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    @NotNull
    public final CacheConfig getCacheConfig(@NotNull String object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"adType");
        object = this.cache.get(object);
        if (object == null && (object = this.cache.get("base")) == null) {
            CacheConfig cacheConfig;
            object = cacheConfig;
            cacheConfig = new CacheConfig();
        }
        return object;
    }

    @NotNull
    public final ImaiConfig getImaiConfig() {
        return this.imai;
    }

    @NotNull
    public final MraidConfig getMraidConfig() {
        return this.mraid;
    }

    @NotNull
    public final AssetCacheConfig getAssetCacheConfig() {
        return this.assetCache;
    }

    public final boolean isCCTEnabled() {
        return this.cctEnabled;
    }

    public static final class a {
        @NotNull
        public final List<String> b() {
            return DEFAULT_CONTEXTUAL_DATA_SKIP_FIELDS;
        }

        @NonNull
        @NotNull
        public final com.inmobi.commons.utils.json.a<AdConfig> a() {
            return new com.inmobi.commons.utils.json.a().a(new ob("cache", AdConfig.class), new h7<String, CacheConfig>(new Constructor<Map<String, ? extends CacheConfig>>(){

                @Override
                public Object construct() {
                    return new LinkedHashMap();
                }
            }, CacheConfig.class)).a(new ob(AdConfig.ALLOWED_CONTENT_TYPE, VastVideoConfig.class), new o6<String>(new Constructor<List<? extends String>>(){

                @Override
                public Object construct() {
                    return new ArrayList();
                }
            }, String.class)).a(new ob(AdConfig.GESTURE_LIST, RenderingConfig.class), new o6<Integer>(new Constructor<List<? extends Integer>>(){

                @Override
                public Object construct() {
                    return new ArrayList();
                }
            }, Integer.TYPE)).a(new ob(AdConfig.SKIP_FIELDS, ContextualDataConfig.class), new o6<String>(new Constructor<List<? extends String>>(){

                @Override
                public Object construct() {
                    return new ArrayList();
                }
            }, String.class));
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0003\u001a\u00020\u0002R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/inmobi/commons/core/configs/AdConfig$CacheConfig;", "", "", "isValid", "", "timeToLive", "J", "getTimeToLive", "()J", "setTimeToLive", "(J)V", "<init>", "()V", "media_release"})
    @Keep
    public static final class CacheConfig {
        private long timeToLive = 3300L;

        public final long getTimeToLive() {
            return this.timeToLive;
        }

        public final void setTimeToLive(long l10) {
            this.timeToLive = l10;
        }

        public final boolean isValid() {
            return this.timeToLive >= 0L;
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0003\u001a\u00020\u0002J\u0006\u0010\u0005\u001a\u00020\u0004R\u0016\u0010\u0006\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/inmobi/commons/core/configs/AdConfig$BitRateConfig;", "", "", "isBitRateMandatory", "", "getHeaderTimeout", "bitrate_mandatory", "Z", "headerTimeout", "I", "<init>", "()V", "media_release"})
    @Keep
    public static final class BitRateConfig {
        private boolean bitrate_mandatory;
        private int headerTimeout = 2000;

        public final boolean isBitRateMandatory() {
            return this.bitrate_mandatory;
        }

        public final int getHeaderTimeout() {
            return this.headerTimeout;
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0006\u0010\u0003\u001a\u00020\u0002J\u0006\u0010\u0004\u001a\u00020\u0002J\u0006\u0010\u0005\u001a\u00020\u0002J\u0006\u0010\u0006\u001a\u00020\u0002J\u0006\u0010\u0007\u001a\u00020\u0002J\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\u000b\u001a\u00020\nR\u0016\u0010\f\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\rR\u0016\u0010\u000f\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\rR\u0016\u0010\u0010\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\rR\u0016\u0010\u0011\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\rR\u0016\u0010\u0012\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/inmobi/commons/core/configs/AdConfig$ImaiConfig;", "", "", "getMaxRetries", "getPingInterval", "getPingTimeout", "getMaxDbEvents", "getMaxEventBatch", "", "getPingCacheExpiry", "", "isValid", "maxRetries", "I", "pingInterval", "pingTimeout", "maxDbEvents", "maxEventBatch", "pingCacheExpiry", "J", "<init>", "()V", "media_release"})
    @Keep
    public static final class ImaiConfig {
        private int maxRetries = 3;
        private int pingInterval = 60;
        private int pingTimeout = 120;
        private int maxDbEvents = 500;
        private int maxEventBatch = 10;
        private long pingCacheExpiry = 10800L;

        public final int getMaxRetries() {
            return this.maxRetries;
        }

        public final int getPingInterval() {
            return this.pingInterval;
        }

        public final int getPingTimeout() {
            return this.pingTimeout;
        }

        public final int getMaxDbEvents() {
            return this.maxDbEvents;
        }

        public final int getMaxEventBatch() {
            return this.maxEventBatch;
        }

        public final long getPingCacheExpiry() {
            return this.pingCacheExpiry;
        }

        public final boolean isValid() {
            return this.getMaxDbEvents() >= 0 && this.getMaxEventBatch() >= 0 && this.getMaxRetries() >= 0 && this.getPingInterval() >= 0 && this.getPingTimeout() > 0 && this.getPingCacheExpiry() > 0L;
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010!\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b$\u0010%J\u0006\u0010\u0003\u001a\u00020\u0002J\u0006\u0010\u0004\u001a\u00020\u0002J\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\u0005J\u0006\u0010\n\u001a\u00020\u0002J\u0006\u0010\u000b\u001a\u00020\u0002J\u0006\u0010\f\u001a\u00020\u0002J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\rJ\u0006\u0010\u000f\u001a\u00020\u0005R\u0016\u0010\u0011\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0016\u0010\t\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0014R$\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00058\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0014\u001a\u0004\b\u0019\u0010\u001aR$\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00058\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0014\u001a\u0004\b\u001c\u0010\u001aR\u0016\u0010\u001d\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001eR\u0016\u0010 \u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010\u001eR\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Lcom/inmobi/commons/core/configs/AdConfig$RenderingConfig;", "", "", "parseColor", "getWebviewBackgroundColor", "", "getAutoRedirectionEnforcement", "", "getUserTouchResetTime", "shouldRenderPopup", "getBannerNetworkLoadsLimit", "getAudioNetworkLoadsLimit", "getOtherNetworkLoadsLimit", "", "getSupportedGestures", "isValid", "", "webviewBackground", "Ljava/lang/String;", "autoRedirectionEnforcement", "Z", "userTouchResetTime", "J", "<set-?>", "enablePubMuteControl", "getEnablePubMuteControl", "()Z", "enableDomStorage", "getEnableDomStorage", "bannerNetworkLoadsLimit", "I", "audioNetworkLoadsLimit", "otherNetworkLoadsLimit", "", "gestures", "Ljava/util/List;", "<init>", "()V", "media_release"})
    @Keep
    public static final class RenderingConfig {
        @NotNull
        private String webviewBackground = "#00000000";
        private boolean autoRedirectionEnforcement = true;
        private long userTouchResetTime = 4L;
        private boolean shouldRenderPopup;
        private boolean enablePubMuteControl;
        private boolean enableDomStorage;
        private int bannerNetworkLoadsLimit = 50;
        private int audioNetworkLoadsLimit = 50;
        private int otherNetworkLoadsLimit = -1;
        @NotNull
        private List<Integer> gestures = CollectionsKt.mutableListOf((Object[])new Integer[]{0, 1, 2, 3, 4, 5});

        public final boolean getEnablePubMuteControl() {
            return this.enablePubMuteControl;
        }

        public final boolean getEnableDomStorage() {
            return this.enableDomStorage;
        }

        public final int parseColor() throws IllegalArgumentException {
            return Color.parseColor((String)this.webviewBackground);
        }

        public final int getWebviewBackgroundColor() {
            int n10;
            try {
                n10 = this.parseColor();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                n10 = Color.parseColor((String)"#00000000");
            }
            return n10;
        }

        public final boolean getAutoRedirectionEnforcement() {
            return this.autoRedirectionEnforcement;
        }

        public final long getUserTouchResetTime() {
            return this.userTouchResetTime * (long)1000;
        }

        public final boolean shouldRenderPopup() {
            return this.shouldRenderPopup;
        }

        public final int getBannerNetworkLoadsLimit() {
            return this.bannerNetworkLoadsLimit;
        }

        public final int getAudioNetworkLoadsLimit() {
            return this.audioNetworkLoadsLimit;
        }

        public final int getOtherNetworkLoadsLimit() {
            return this.otherNetworkLoadsLimit;
        }

        @NotNull
        public final List<Integer> getSupportedGestures() {
            return this.gestures;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final boolean isValid() {
            String string = this.webviewBackground;
            if (string == null) return false;
            if (string != null && (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) != null && string.length() == 0) return false;
            if (this.getUserTouchResetTime() < 0L) return false;
            if (this.getSupportedGestures().isEmpty()) {
                return false;
            }
            try {
                this.parseColor();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            return true;
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0006\u0010\u0003\u001a\u00020\u0002R*\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00028\u0006@GX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR*\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\n8\u0006@GX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R*\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\n8\u0006@GX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/inmobi/commons/core/configs/AdConfig$AudioConfig;", "", "", "isValid", "<set-?>", "isAudioEnabled", "Z", "()Z", "setAudioEnabled", "(Z)V", "", "minDeviceVolume", "I", "getMinDeviceVolume", "()I", "setMinDeviceVolume", "(I)V", "minRefreshInterval", "getMinRefreshInterval", "setMinRefreshInterval", "<init>", "()V", "media_release"})
    @Keep
    public static final class AudioConfig {
        private boolean isAudioEnabled = true;
        private int minDeviceVolume = 30;
        private int minRefreshInterval = 20;

        public final boolean isAudioEnabled() {
            return this.isAudioEnabled;
        }

        @VisibleForTesting(otherwise=2)
        public final void setAudioEnabled(boolean bl) {
            this.isAudioEnabled = bl;
        }

        public final int getMinDeviceVolume() {
            return this.minDeviceVolume;
        }

        @VisibleForTesting(otherwise=2)
        public final void setMinDeviceVolume(int n10) {
            this.minDeviceVolume = n10;
        }

        public final int getMinRefreshInterval() {
            return this.minRefreshInterval;
        }

        @VisibleForTesting(otherwise=2)
        public final void setMinRefreshInterval(int n10) {
            this.minRefreshInterval = n10;
        }

        public final boolean isValid() {
            return this.minDeviceVolume > 0 && this.minRefreshInterval > 0;
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0006\u0010\u0003\u001a\u00020\u0002J\u0006\u0010\u0005\u001a\u00020\u0004J\u0006\u0010\u0006\u001a\u00020\u0004J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\n\u001a\u00020\tR\u0016\u0010\u000b\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u000eR\u0016\u0010\u0010\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lcom/inmobi/commons/core/configs/AdConfig$MraidConfig;", "", "", "getExpiry", "", "getMaxRetries", "getRetryInterval", "", "getUrl", "", "isValid", "expiry", "J", "maxRetries", "I", "retryInterval", "url", "Ljava/lang/String;", "<init>", "()V", "media_release"})
    @Keep
    public static final class MraidConfig {
        private long expiry = 432000L;
        private int maxRetries = 3;
        private int retryInterval = 60;
        @NotNull
        private String url = "https://supply.inmobicdn.net/sdk/sdk/1058/android/mraid.js";

        public final long getExpiry() {
            return this.expiry;
        }

        public final int getMaxRetries() {
            return this.maxRetries;
        }

        public final int getRetryInterval() {
            return this.retryInterval;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public final boolean isValid() {
            return this.getExpiry() >= 0L && this.getRetryInterval() >= 0 && this.getMaxRetries() >= 0 && !h4.a(this.url);
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0015\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0006\u0010\u0003\u001a\u00020\u0002J\u0006\u0010\u0005\u001a\u00020\u0004J\u0006\u0010\u0007\u001a\u00020\u0006J\u0006\u0010\b\u001a\u00020\u0006J\b\u0010\t\u001a\u0004\u0018\u00010\u0002J\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\u0004J\u0006\u0010\r\u001a\u00020\nR\u0016\u0010\u000e\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0011R\u0016\u0010\u0013\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0014R\"\u0010\u0016\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/inmobi/commons/core/configs/AdConfig$OmidConfig;", "", "", "getPartnerKey", "", "getExpiry", "", "getMaxRetries", "getRetryInterval", "getUrl", "", "isOmidEnabled", "getWebViewRetainTime", "isValid", "expiry", "J", "maxRetries", "I", "retryInterval", "partnerKey", "Ljava/lang/String;", "url", "omidEnabled", "Z", "getOmidEnabled", "()Z", "setOmidEnabled", "(Z)V", "webViewRetainTime", "<init>", "()V", "media_release"})
    @Keep
    public static final class OmidConfig {
        private long expiry = 432000L;
        private int maxRetries = 3;
        private int retryInterval = 60;
        @NotNull
        private String partnerKey = "Inmobi";
        @NotNull
        private String url = "https://i.l.inmobicdn.net/sdk/sdk/OMID/omsdk-v1.3.17.js";
        private boolean omidEnabled = true;
        private long webViewRetainTime = 1000L;

        public final boolean getOmidEnabled() {
            return this.omidEnabled;
        }

        public final void setOmidEnabled(boolean bl) {
            this.omidEnabled = bl;
        }

        @NotNull
        public final String getPartnerKey() {
            return this.partnerKey;
        }

        public final long getExpiry() {
            return this.expiry;
        }

        public final int getMaxRetries() {
            return this.maxRetries;
        }

        public final int getRetryInterval() {
            return this.retryInterval;
        }

        @Nullable
        public final String getUrl() {
            return this.url;
        }

        public final boolean isOmidEnabled() {
            return this.omidEnabled;
        }

        public final long getWebViewRetainTime() {
            return this.webViewRetainTime;
        }

        /*
         * Enabled aggressive block sorting
         */
        public final boolean isValid() {
            if (this.getMaxRetries() < 0) return false;
            if (this.getRetryInterval() < 0) return false;
            String string = this.getUrl();
            if (string == null) return false;
            if ((string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
                return false;
            }
            if (!l2.a(string)) return false;
            boolean bl = true;
            if (!bl) return false;
            if (TextUtils.isEmpty((CharSequence)this.getPartnerKey())) return false;
            return true;
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u000f\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\u0004\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\"\u0010\f\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\u0004\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/inmobi/commons/core/configs/AdConfig$VideoViewabilityConfig;", "", "", "impressionMinPercentageViewed", "I", "getImpressionMinPercentageViewed", "()I", "setImpressionMinPercentageViewed", "(I)V", "impressionMinTimeViewed", "getImpressionMinTimeViewed", "setImpressionMinTimeViewed", "videoMinPercentagePlay", "getVideoMinPercentagePlay", "setVideoMinPercentagePlay", "<init>", "()V", "media_release"})
    @Keep
    public static final class VideoViewabilityConfig {
        private int impressionMinPercentageViewed = 50;
        private int impressionMinTimeViewed = 2000;
        private int videoMinPercentagePlay = 50;

        public final int getImpressionMinPercentageViewed() {
            return this.impressionMinPercentageViewed;
        }

        public final void setImpressionMinPercentageViewed(int n10) {
            this.impressionMinPercentageViewed = n10;
        }

        public final int getImpressionMinTimeViewed() {
            return this.impressionMinTimeViewed;
        }

        public final void setImpressionMinTimeViewed(int n10) {
            this.impressionMinTimeViewed = n10;
        }

        public final int getVideoMinPercentagePlay() {
            return this.videoMinPercentagePlay;
        }

        public final void setVideoMinPercentagePlay(int n10) {
            this.videoMinPercentagePlay = n10;
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\n\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\"\u0010\u0010\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/inmobi/commons/core/configs/AdConfig$AudioViewabilityConfig;", "", "", "impressionType", "B", "getImpressionType", "()B", "setImpressionType", "(B)V", "", "impressionMinPercentageViewed", "I", "getImpressionMinPercentageViewed", "()I", "setImpressionMinPercentageViewed", "(I)V", "impressionMinTimeViewed", "getImpressionMinTimeViewed", "setImpressionMinTimeViewed", "<init>", "()V", "media_release"})
    @Keep
    public static final class AudioViewabilityConfig {
        private byte impressionType = 1;
        private int impressionMinPercentageViewed = 90;
        private int impressionMinTimeViewed = 2000;

        public final byte getImpressionType() {
            return this.impressionType;
        }

        public final void setImpressionType(byte by) {
            this.impressionType = by;
        }

        public final int getImpressionMinPercentageViewed() {
            return this.impressionMinPercentageViewed;
        }

        public final void setImpressionMinPercentageViewed(int n10) {
            this.impressionMinPercentageViewed = n10;
        }

        public final int getImpressionMinTimeViewed() {
            return this.impressionMinTimeViewed;
        }

        public final void setImpressionMinTimeViewed(int n10) {
            this.impressionMinTimeViewed = n10;
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u000f\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\u0004\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\"\u0010\f\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\u0004\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/inmobi/commons/core/configs/AdConfig$WebViewabilityConfig;", "", "", "impressionMinPercentageViewed", "I", "getImpressionMinPercentageViewed", "()I", "setImpressionMinPercentageViewed", "(I)V", "impressionMinTimeViewed", "getImpressionMinTimeViewed", "setImpressionMinTimeViewed", "impressionPollIntervalMillis", "getImpressionPollIntervalMillis", "setImpressionPollIntervalMillis", "<init>", "()V", "media_release"})
    @Keep
    public static final class WebViewabilityConfig {
        private int impressionMinPercentageViewed = 50;
        private int impressionMinTimeViewed = 1000;
        private int impressionPollIntervalMillis = 1000;

        public final int getImpressionMinPercentageViewed() {
            return this.impressionMinPercentageViewed;
        }

        public final void setImpressionMinPercentageViewed(int n10) {
            this.impressionMinPercentageViewed = n10;
        }

        public final int getImpressionMinTimeViewed() {
            return this.impressionMinTimeViewed;
        }

        public final void setImpressionMinTimeViewed(int n10) {
            this.impressionMinTimeViewed = n10;
        }

        public final int getImpressionPollIntervalMillis() {
            return this.impressionPollIntervalMillis;
        }

        public final void setImpressionPollIntervalMillis(int n10) {
            this.impressionPollIntervalMillis = n10;
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0005\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\t\u0010\nR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/inmobi/commons/core/configs/AdConfig$BannerImpressionTypeConfig;", "", "", "impressionType", "B", "getImpressionType", "()B", "setImpressionType", "(B)V", "<init>", "()V", "media_release"})
    @Keep
    public static final class BannerImpressionTypeConfig {
        private byte impressionType;

        public final byte getImpressionType() {
            return this.impressionType;
        }

        public final void setImpressionType(byte by) {
            this.impressionType = by;
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0005\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\t\u0010\nR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/inmobi/commons/core/configs/AdConfig$InterstitialImpressionTypeConfig;", "", "", "impressionType", "B", "getImpressionType", "()B", "setImpressionType", "(B)V", "<init>", "()V", "media_release"})
    @Keep
    public static final class InterstitialImpressionTypeConfig {
        private byte impressionType = 1;

        public final byte getImpressionType() {
            return this.impressionType;
        }

        public final void setImpressionType(byte by) {
            this.impressionType = by;
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0006\u0010\u0003\u001a\u00020\u0002R$\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR0\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0007\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/inmobi/commons/core/configs/AdConfig$ContextualDataConfig;", "", "", "isValid", "", "<set-?>", "maxAdRecords", "I", "getMaxAdRecords", "()I", "", "", "skipFields", "Ljava/util/List;", "getSkipFields", "()Ljava/util/List;", "expiryTime", "getExpiryTime", "<init>", "()V", "media_release"})
    @Keep
    public static final class ContextualDataConfig {
        private int maxAdRecords = 1;
        @NotNull
        private List<String> skipFields = Companion.b();
        private int expiryTime = 86400;

        public final int getMaxAdRecords() {
            return this.maxAdRecords;
        }

        @NotNull
        public final List<String> getSkipFields() {
            return this.skipFields;
        }

        public final int getExpiryTime() {
            return this.expiryTime;
        }

        public final boolean isValid() {
            return this.maxAdRecords >= 0 && this.expiryTime >= 0;
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0006\u0010\u0003\u001a\u00020\u0002J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0002H\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0007R$\u0010\u000b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00028\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR$\u0010\u000f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00078\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00078\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0014\u0010\u0012R$\u0010\u0015\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00078\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0016\u0010\u0012R\u001c\u0010\u0017\u001a\u00020\u00078\u0006@\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0010\u001a\u0004\b\u0018\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/inmobi/commons/core/configs/AdConfig$AdQualityConfig;", "", "", "isValid", "enable", "", "setEnableAdQuality", "", "size", "setMaxImageSize", "<set-?>", "enabled", "Z", "getEnabled", "()Z", "maxRetries", "I", "getMaxRetries", "()I", "retryInterval", "getRetryInterval", "maxImageSize", "getMaxImageSize", "resizedPercentage", "getResizedPercentage", "<init>", "()V", "media_release"})
    @Keep
    public static final class AdQualityConfig {
        private boolean enabled = true;
        private int maxRetries = 3;
        private int retryInterval = 5000;
        private int maxImageSize = 153600;
        private final int resizedPercentage;

        public AdQualityConfig() {
            this.resizedPercentage = 100;
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        public final int getMaxRetries() {
            return this.maxRetries;
        }

        public final int getRetryInterval() {
            return this.retryInterval;
        }

        public final int getMaxImageSize() {
            return this.maxImageSize;
        }

        public final int getResizedPercentage() {
            return this.resizedPercentage;
        }

        public final boolean isValid() {
            return this.maxRetries >= 0 && this.retryInterval >= 0 && this.maxImageSize >= 1 && this.resizedPercentage <= 100;
        }

        @VisibleForTesting(otherwise=2)
        public final void setEnableAdQuality(boolean bl) {
            this.enabled = bl;
        }

        @VisibleForTesting(otherwise=2)
        public final void setMaxImageSize(int n10) {
            this.maxImageSize = n10;
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\n\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/inmobi/commons/core/configs/AdConfig$AdReportConfig;", "", "", "enabled", "Z", "getEnabled", "()Z", "setEnabled", "(Z)V", "", "cridls", "I", "getCridls", "()I", "setCridls", "(I)V", "<init>", "()V", "media_release"})
    @Keep
    public static final class AdReportConfig {
        private boolean enabled = true;
        private int cridls = 10;

        public final boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public final int getCridls() {
            return this.cridls;
        }

        public final void setCridls(int n10) {
            this.cridls = n10;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b5\u00106J\u0006\u0010\u0003\u001a\u00020\u0002J\u0006\u0010\u0004\u001a\u00020\u0002J\u0006\u0010\u0005\u001a\u00020\u0002J\u0006\u0010\u0006\u001a\u00020\u0002J\u0006\u0010\u0007\u001a\u00020\u0002J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0002J\u0006\u0010\u000b\u001a\u00020\u0002J\u0006\u0010\f\u001a\u00020\u0002J\u0006\u0010\r\u001a\u00020\u0002J\u0006\u0010\u000e\u001a\u00020\u0002J\u0006\u0010\u000f\u001a\u00020\u0002J\u0006\u0010\u0010\u001a\u00020\u0002J\u0006\u0010\u0011\u001a\u00020\u0002J\u0006\u0010\u0012\u001a\u00020\u0002J\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0013J\u0006\u0010\u0016\u001a\u00020\u0013J\u0006\u0010\u0018\u001a\u00020\u0017R\u0016\u0010\u0019\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001aR\u0016\u0010\u001c\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001aR\u0016\u0010\u001d\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001aR\u0016\u0010\u001e\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001aR\u0016\u0010 \u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010#\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010&\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\"\u0010)\u001a\u00020(8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0016\u00100\u001a\u00020/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0016\u00103\u001a\u0002028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104\u00a8\u00067"}, d2={"Lcom/inmobi/commons/core/configs/AdConfig$ViewabilityConfig;", "", "", "getImpressionMinPercentageViewed", "getImpressionMinTimeViewed", "getDisplayMinPercentageAnimate", "getVideoImpressionMinPercentageViewed", "getVideoImpressionMinTimeViewed", "videoImpressionMinTimeViewed", "", "setVideoImpressionMinTimeViewed", "getVideoMinPercentagePlay", "getVisibilityThrottleMillis", "getImpressionPollIntervalMillis", "getWebImpressionMinPercentageViewed", "getWebImpressionMinTimeViewed", "getWebVisibilityThrottleMillis", "getAudioImpressionMinPercentageViewed", "getAudioImpressionMinTimeViewed", "", "getBannerImpressionType", "getAudioImpressionType", "getInterstitialImpressionType", "", "isValid", "impressionMinPercentageViewed", "I", "impressionMinTimeViewed", "visibilityThrottleMillis", "impressionPollIntervalMillis", "displayMinPercentageAnimate", "Lcom/inmobi/commons/core/configs/AdConfig$VideoViewabilityConfig;", "video", "Lcom/inmobi/commons/core/configs/AdConfig$VideoViewabilityConfig;", "Lcom/inmobi/commons/core/configs/AdConfig$AudioViewabilityConfig;", "audio", "Lcom/inmobi/commons/core/configs/AdConfig$AudioViewabilityConfig;", "Lcom/inmobi/commons/core/configs/AdConfig$WebViewabilityConfig;", "web", "Lcom/inmobi/commons/core/configs/AdConfig$WebViewabilityConfig;", "Lcom/inmobi/commons/core/configs/AdConfig$OmidConfig;", "omidConfig", "Lcom/inmobi/commons/core/configs/AdConfig$OmidConfig;", "getOmidConfig", "()Lcom/inmobi/commons/core/configs/AdConfig$OmidConfig;", "setOmidConfig", "(Lcom/inmobi/commons/core/configs/AdConfig$OmidConfig;)V", "Lcom/inmobi/commons/core/configs/AdConfig$BannerImpressionTypeConfig;", "banner", "Lcom/inmobi/commons/core/configs/AdConfig$BannerImpressionTypeConfig;", "Lcom/inmobi/commons/core/configs/AdConfig$InterstitialImpressionTypeConfig;", "int", "Lcom/inmobi/commons/core/configs/AdConfig$InterstitialImpressionTypeConfig;", "<init>", "()V", "media_release"})
    @Keep
    public static final class ViewabilityConfig {
        private int impressionMinPercentageViewed = 50;
        private int impressionMinTimeViewed = 1000;
        private int visibilityThrottleMillis = 100;
        private int impressionPollIntervalMillis = 250;
        private int displayMinPercentageAnimate = 67;
        @NotNull
        private VideoViewabilityConfig video;
        @NotNull
        private AudioViewabilityConfig audio;
        @NotNull
        private WebViewabilityConfig web;
        @NotNull
        private OmidConfig omidConfig;
        @NotNull
        private BannerImpressionTypeConfig banner;
        @NotNull
        private InterstitialImpressionTypeConfig int;

        public ViewabilityConfig() {
            InterstitialImpressionTypeConfig interstitialImpressionTypeConfig;
            BannerImpressionTypeConfig bannerImpressionTypeConfig;
            OmidConfig omidConfig;
            WebViewabilityConfig webViewabilityConfig;
            AudioViewabilityConfig audioViewabilityConfig;
            VideoViewabilityConfig videoViewabilityConfig;
            Object object = videoViewabilityConfig;
            videoViewabilityConfig = new VideoViewabilityConfig();
            v1.video = object;
            object = audioViewabilityConfig;
            audioViewabilityConfig = new AudioViewabilityConfig();
            v1.audio = object;
            object = webViewabilityConfig;
            webViewabilityConfig = new WebViewabilityConfig();
            v1.web = object;
            object = omidConfig;
            omidConfig = new OmidConfig();
            v1.omidConfig = object;
            object = bannerImpressionTypeConfig;
            bannerImpressionTypeConfig = new BannerImpressionTypeConfig();
            v1.banner = object;
            object = interstitialImpressionTypeConfig;
            interstitialImpressionTypeConfig = new InterstitialImpressionTypeConfig();
            v1.int = object;
        }

        @NotNull
        public final OmidConfig getOmidConfig() {
            return this.omidConfig;
        }

        public final void setOmidConfig(@NotNull OmidConfig omidConfig) {
            Intrinsics.checkNotNullParameter((Object)omidConfig, (String)"<set-?>");
            this.omidConfig = omidConfig;
        }

        public final int getImpressionMinPercentageViewed() {
            return this.impressionMinPercentageViewed;
        }

        public final int getImpressionMinTimeViewed() {
            return this.impressionMinTimeViewed;
        }

        public final int getDisplayMinPercentageAnimate() {
            return this.displayMinPercentageAnimate;
        }

        public final int getVideoImpressionMinPercentageViewed() {
            return this.video.getImpressionMinPercentageViewed();
        }

        public final int getVideoImpressionMinTimeViewed() {
            return this.video.getImpressionMinTimeViewed();
        }

        public final void setVideoImpressionMinTimeViewed(int n10) {
            this.video.setImpressionMinTimeViewed(n10);
        }

        public final int getVideoMinPercentagePlay() {
            return this.video.getVideoMinPercentagePlay();
        }

        public final int getVisibilityThrottleMillis() {
            return this.visibilityThrottleMillis;
        }

        public final int getImpressionPollIntervalMillis() {
            return this.impressionPollIntervalMillis;
        }

        public final int getWebImpressionMinPercentageViewed() {
            return this.web.getImpressionMinPercentageViewed();
        }

        public final int getWebImpressionMinTimeViewed() {
            return this.web.getImpressionMinTimeViewed();
        }

        public final int getWebVisibilityThrottleMillis() {
            return this.web.getImpressionPollIntervalMillis();
        }

        public final int getAudioImpressionMinPercentageViewed() {
            return this.audio.getImpressionMinPercentageViewed();
        }

        public final int getAudioImpressionMinTimeViewed() {
            return this.audio.getImpressionMinTimeViewed();
        }

        public final byte getBannerImpressionType() {
            return this.banner.getImpressionType();
        }

        public final byte getAudioImpressionType() {
            return this.audio.getImpressionType();
        }

        public final byte getInterstitialImpressionType() {
            return this.int.getImpressionType();
        }

        public final boolean isValid() {
            return this.getImpressionMinPercentageViewed() > 0 && this.getImpressionMinPercentageViewed() <= 100 && this.getImpressionMinTimeViewed() >= 0 && this.getDisplayMinPercentageAnimate() > 0 && this.getDisplayMinPercentageAnimate() <= 100 && this.getVideoImpressionMinPercentageViewed() > 0 && this.getVideoImpressionMinPercentageViewed() <= 100 && this.getWebImpressionMinPercentageViewed() > 0 && this.getWebImpressionMinPercentageViewed() <= 100 && this.getWebVisibilityThrottleMillis() > 0 && this.getWebImpressionMinTimeViewed() >= 0 && this.getVideoImpressionMinTimeViewed() >= 0 && this.getVideoMinPercentagePlay() > 0 && this.getVideoMinPercentagePlay() <= 100 && this.getVisibilityThrottleMillis() >= 50 && this.getVisibilityThrottleMillis() * 5 <= this.getImpressionMinTimeViewed() && this.getImpressionPollIntervalMillis() >= 50 && this.getImpressionPollIntervalMillis() * 4 <= this.getImpressionMinTimeViewed() && this.omidConfig.isValid();
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0006\u0010\u0003\u001a\u00020\u0002J\u0006\u0010\u0005\u001a\u00020\u0004J\u0006\u0010\u0006\u001a\u00020\u0004J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\fR\u0016\u0010\u000e\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0011R\u0016\u0010\u0013\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lcom/inmobi/commons/core/configs/AdConfig$VastVideoConfig;", "", "", "getMaxWrapperLimit", "", "getOptimalVastVideoSize", "getVastMaxAssetSize", "", "", "getAllowedContentType", "Lcom/inmobi/commons/core/configs/AdConfig$BitRateConfig;", "getBitRate", "", "isValid", "maxWrapperLimit", "I", "optimalVastVideoSize", "J", "vastMaxAssetSize", "bitRate", "Lcom/inmobi/commons/core/configs/AdConfig$BitRateConfig;", "allowedContentType", "Ljava/util/List;", "<init>", "()V", "media_release"})
    @Keep
    public static final class VastVideoConfig {
        private int maxWrapperLimit = 3;
        private long optimalVastVideoSize = 0x300000L;
        private long vastMaxAssetSize = 0x1E00000L;
        @NotNull
        private BitRateConfig bitRate = new BitRateConfig();
        @NotNull
        private List<String> allowedContentType = CollectionsKt.mutableListOf((Object[])new String[]{"video/mp4", "image/jpeg", "image/jpg", "image/gif", "image/png"});

        public final int getMaxWrapperLimit() {
            return this.maxWrapperLimit;
        }

        public final long getOptimalVastVideoSize() {
            return this.optimalVastVideoSize;
        }

        public final long getVastMaxAssetSize() {
            return this.vastMaxAssetSize;
        }

        @NotNull
        public final List<String> getAllowedContentType() {
            return this.allowedContentType;
        }

        @NotNull
        public final BitRateConfig getBitRate() {
            return this.bitRate;
        }

        public final boolean isValid() {
            return this.getOptimalVastVideoSize() <= 0x1E00000L && this.getOptimalVastVideoSize() > 0L && this.getMaxWrapperLimit() >= 0 && this.getVastMaxAssetSize() > 0L && this.getVastMaxAssetSize() <= 0x1E00000L;
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0006\u0010\u0003\u001a\u00020\u0002J\u0006\u0010\u0004\u001a\u00020\u0002J\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010\u0007\u001a\u00020\u0005J\u0006\u0010\t\u001a\u00020\bR\u0016\u0010\n\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010\u000bR\u0016\u0010\r\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/inmobi/commons/core/configs/AdConfig$AssetCacheConfig;", "", "", "getMaxRetries", "getRetryInterval", "", "getTimeToLive", "getMaxCacheSize", "", "isValid", "maxRetries", "I", "retryInterval", "maxCacheSize", "J", "timeToLive", "<init>", "()V", "media_release"})
    @Keep
    public static final class AssetCacheConfig {
        private int maxRetries = 3;
        private int retryInterval = 1;
        private long maxCacheSize = 0x6400000L;
        private long timeToLive = 259200L;

        public final int getMaxRetries() {
            return this.maxRetries;
        }

        public final int getRetryInterval() {
            return this.retryInterval;
        }

        public final long getTimeToLive() {
            return this.timeToLive;
        }

        public final long getMaxCacheSize() {
            return this.maxCacheSize;
        }

        public final boolean isValid() {
            return this.getRetryInterval() >= 0 && this.getTimeToLive() >= 0L && this.getMaxCacheSize() >= 0L && this.getMaxRetries() >= 0;
        }
    }
}

