/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.commons.core.configs;

import android.graphics.Color;
import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.inmobi.commons.utils.json.Constructor;
import com.inmobi.media.fz;
import com.inmobi.media.jc;
import com.inmobi.media.jd;
import com.inmobi.media.je;
import com.inmobi.media.jf;
import com.inmobi.media.jh;
import com.inmobi.media.km;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

@jd
public final class AdConfig
extends fz {
    private static final String TAG = AdConfig.class.getSimpleName();
    private static final int DEFAULT_MAX_POOL_SIZE = 10;
    private static final String DEFAULT_AD_SERVER_URL = "https://ads.inmobi.com/sdk";
    private static final int DEFAULT_MINIMUM_REFRESH_INTERVAL = 20;
    private static final int DEFAULT_REFRESH_INTERVAL = 60;
    private static final int DEFAULT_FETCH_TIMEOUT = 60;
    private static final boolean DEFAULT_CCT_ENABLED = false;
    public static final int DEFAULT_CONTEXTUAL_DATA_MAX_RECORDS = 1;
    public static final List<String> DEFAULT_CONTEXTUAL_DATA_SKIP_FIELDS = Collections.emptyList();
    public static final int DEFAULT_CONTEXTUAL_DATA_EXPIRY_TIME = 86400;
    private static final String ALLOWED_CONTENT_TYPE = "allowedContentType";
    private static final String GESTURE_LIST = "gestures";
    private static final String SKIP_FIELDS = "skipFields";
    public ContextualDataConfig contextualData;
    public int maxPoolSize = 10;
    public String url = "https://ads.inmobi.com/sdk";
    public int minimumRefreshInterval = 20;
    public int defaultRefreshInterval = 60;
    public int fetchTimeout = 60;
    public boolean cctEnabled = false;
    private Map<String, d> cache;
    public e imai;
    public i rendering;
    public g mraid;
    public m viewability;
    public k vastVideo;
    public a assetCache;
    public km timeouts = km.a();

    @NonNull
    public static jc<AdConfig> a() {
        return new jc().a(new jh("cache", AdConfig.class), new jf<String, d>(new Constructor<Map<String, d>>(){

            @Override
            @NonNull
            public final /* synthetic */ Object construct() {
                return new HashMap();
            }
        }, d.class)).a(new jh(ALLOWED_CONTENT_TYPE, j.class), new je<String>(new Constructor<List<String>>(){

            @Override
            @NonNull
            public final /* synthetic */ Object construct() {
                return new ArrayList();
            }
        }, String.class)).a(new jh(ALLOWED_CONTENT_TYPE, k.class), new je<String>(new Constructor<List<String>>(){

            @Override
            @NonNull
            public final /* synthetic */ Object construct() {
                return new ArrayList();
            }
        }, String.class)).a(new jh(GESTURE_LIST, i.class), new je<Integer>(new Constructor<List<Integer>>(){

            @Override
            @NonNull
            public final /* synthetic */ Object construct() {
                return new ArrayList();
            }
        }, Integer.class)).a(new jh(SKIP_FIELDS, ContextualDataConfig.class), new je<String>(new Constructor<List<String>>(){

            @Override
            @NonNull
            public final /* synthetic */ Object construct() {
                return new ArrayList();
            }
        }, String.class));
    }

    public AdConfig(@Nullable String object) {
        super((String)object);
        this.imai = new e();
        this.rendering = new i();
        this.mraid = new g();
        this.viewability = new m();
        this.vastVideo = new k();
        this.assetCache = new a();
        this.contextualData = new ContextualDataConfig();
        object = this;
        this.cache = new HashMap<String, d>();
        ((AdConfig)object).cache.put("base", new d());
        ((AdConfig)object).cache.put("banner", new d());
        ((AdConfig)object).cache.put("int", new d());
        ((AdConfig)object).cache.put("native", new d());
    }

    @Override
    public final String b() {
        return "ads";
    }

    @Override
    @Nullable
    public final JSONObject c() {
        return AdConfig.a().a(this);
    }

    @Override
    public final boolean d() {
        if (this.maxPoolSize <= 0) {
            return false;
        }
        this.timeouts.j();
        if (!this.url.startsWith("http://") && !this.url.startsWith("https://") || this.minimumRefreshInterval < 0 || this.defaultRefreshInterval < 0 || this.minimumRefreshInterval > this.defaultRefreshInterval || this.fetchTimeout <= 0) {
            return false;
        }
        Object object = this.cache.entrySet().iterator();
        while (object.hasNext()) {
            if (object.next().getValue().timeToLive >= 0L) continue;
            return false;
        }
        if (this.imai.maxDbEvents < 0 || this.imai.maxEventBatch < 0 || this.imai.maxRetries < 0 || this.imai.pingInterval < 0 || this.imai.pingTimeout <= 0 || this.imai.pingCacheExpiry <= 0L) {
            return false;
        }
        if (this.mraid.expiry < 0L || this.mraid.retryInterval < 0 || this.mraid.maxRetries < 0 || !this.mraid.url.startsWith("http://") && !this.mraid.url.startsWith("https://")) {
            return false;
        }
        if (this.timeouts.h() < 0 || this.timeouts.b() < 0 || this.timeouts.c() < 0 || this.timeouts.d() < 0 || this.timeouts.e() < 0 || this.timeouts.f() < 0 || this.timeouts.g() < 0 || this.timeouts.i() < 0) {
            return false;
        }
        if (this.rendering.picHeight < 0 || this.rendering.picWidth < 0 || this.rendering.picQuality < 0 || this.rendering.maxVibrationDuration < 0 || this.rendering.maxVibrationPatternLength < 0 || this.rendering.savecontent.maxSaveSize < 0L || this.rendering.webviewBackground == null || this.rendering.webviewBackground.trim().length() == 0 || this.rendering.delayedRedirection <= 0L || this.rendering.userTouchResetTime < 0L || this.rendering.gestures.isEmpty()) {
            return false;
        }
        try {
            Color.parseColor((String)this.rendering.webviewBackground);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        if (this.mraid.maxRetries < 0 || this.mraid.retryInterval < 0 || this.mraid.url == null || this.mraid.url.trim().length() == 0) {
            return false;
        }
        object = this;
        if (((AdConfig)object).viewability.impressionMinPercentageViewed <= 0 || ((AdConfig)object).viewability.impressionMinPercentageViewed > 100 || ((AdConfig)object).viewability.impressionMinTimeViewed < 0 || ((AdConfig)object).viewability.displayMinPercentageAnimate <= 0 || ((AdConfig)object).viewability.displayMinPercentageAnimate > 100 || ((AdConfig)object).viewability.video.impressionMinPercentageViewed <= 0 || ((AdConfig)object).viewability.video.impressionMinPercentageViewed > 100 || ((AdConfig)object).viewability.web.impressionMinPercentageViewed <= 0 || ((AdConfig)object).viewability.web.impressionMinPercentageViewed > 100 || ((AdConfig)object).viewability.web.impressionPollIntervalMillis <= 0 || ((AdConfig)object).viewability.web.impressionMinTimeViewed < 0 || ((AdConfig)object).viewability.video.impressionMinTimeViewed < 0 || ((AdConfig)object).viewability.video.videoMinPercentagePlay <= 0 || ((AdConfig)object).viewability.video.videoMinPercentagePlay > 100 || ((AdConfig)object).viewability.visibilityThrottleMillis < 50 || ((AdConfig)object).viewability.visibilityThrottleMillis * 5 > ((AdConfig)object).viewability.impressionMinTimeViewed || ((AdConfig)object).viewability.impressionPollIntervalMillis < 50 || ((AdConfig)object).viewability.impressionPollIntervalMillis * 4 > ((AdConfig)object).viewability.impressionMinTimeViewed || (object = ((AdConfig)object).viewability.omidConfig) == null || ((h)object).maxRetries < 0 || ((h)object).retryInterval < 0 || ((h)object).url == null || ((h)object).url.trim().length() == 0 || TextUtils.isEmpty((CharSequence)((h)object).partnerKey)) {
            return false;
        }
        if (this.vastVideo.optimalVastVideoSize > 0x1E00000L || this.vastVideo.optimalVastVideoSize <= 0L || this.vastVideo.maxWrapperLimit < 0 || this.vastVideo.vastMaxAssetSize <= 0L || this.vastVideo.vastMaxAssetSize > 0x1E00000L) {
            return false;
        }
        if (!this.contextualData.isValid()) {
            return false;
        }
        return this.assetCache.retryInterval >= 0 && this.assetCache.maxCachedAssets <= 20 && this.assetCache.maxCachedAssets >= 0 && this.assetCache.timeToLive >= 0L && this.assetCache.maxCacheSize >= 0L && this.assetCache.maxRetries >= 0;
    }

    public final d a(String object) {
        if ((object = this.cache.get(object)) == null && (object = this.cache.get("base")) == null) {
            object = new d();
        }
        return object;
    }

    @jd
    public static final class a {
        public int maxRetries = 3;
        public int retryInterval = 1;
        int maxCachedAssets = 10;
        public long maxCacheSize = 0x6400000L;
        public long timeToLive = 259200L;
    }

    @jd
    public static final class k {
        public int maxWrapperLimit = 3;
        public long optimalVastVideoSize = 0x300000L;
        public long vastMaxAssetSize = 0x1E00000L;
        public c bitRate = new c();
        public List<String> allowedContentType = new ArrayList<String>(Arrays.asList("video/mp4", "image/jpeg", "image/jpg", "image/gif", "image/png"));
    }

    @jd
    public static final class m {
        static final int MIN_VISIBILITY_THROTTLE_INTERVAL_MILLIS = 50;
        static final int MIN_IMPRESSION_POLL_INTERVAL_MILLIS = 50;
        public int impressionMinPercentageViewed = 50;
        public int impressionMinTimeViewed = 1000;
        public int visibilityThrottleMillis = 100;
        public int impressionPollIntervalMillis = 250;
        public int displayMinPercentageAnimate = 67;
        public l video = new l();
        public n web = new n();
        public h omidConfig = new h();
        public b banner = new b();
        public f interstitial = new f();
        private boolean moatEnabled = true;

        public final String toString() {
            return "ViewabilityConfig{impressionMinPercentageViewed=" + this.impressionMinPercentageViewed + ", impressionMinTimeViewed=" + this.impressionMinTimeViewed + ", visibilityThrottleMillis=" + this.visibilityThrottleMillis + ", impressionPollIntervalMillis=" + this.impressionPollIntervalMillis + ", displayMinPercentageAnimate=" + this.displayMinPercentageAnimate + ", video=" + this.video + ", web=" + this.web + ", omidConfig=" + this.omidConfig + ", banner=" + this.banner + ", interstitial=" + this.interstitial + ", moatEnabled=" + this.moatEnabled + '}';
        }
    }

    @jd
    public static final class f {
        public byte impressionType = 1;
    }

    @jd
    public static final class b {
        public byte impressionType = 0;
    }

    @jd
    public static final class n {
        public int impressionMinPercentageViewed = 50;
        public int impressionMinTimeViewed = 1000;
        public int impressionPollIntervalMillis = 1000;
    }

    @jd
    public static final class l {
        public int impressionMinPercentageViewed = 50;
        public int impressionMinTimeViewed = 2000;
        public int videoMinPercentagePlay = 50;
    }

    @jd
    public static final class h {
        public long expiry = 432000L;
        public int maxRetries = 3;
        public int retryInterval = 60;
        public String partnerKey = "Inmobi";
        public String url = "https://i.l.inmobicdn.net/sdk/sdk/OMID/omsdk-v1.3.17.js";
        public boolean omidEnabled = true;
        public long webViewRetainTime = 1000L;
    }

    @jd
    public static final class g {
        public long expiry = 432000L;
        public int maxRetries = 3;
        public int retryInterval = 60;
        public String url = "https://i.l.inmobicdn.net/sdk/sdk/1014/android/mraid.js";
    }

    @jd
    public static final class i {
        public static final int DEFAULT_TOUCH_RESET_TIME = 4;
        static final short DEFAULT_NETWORK_LOAD_LIMIT = 50;
        public static final byte NETWORK_LOAD_LIMIT_DISABLED = -1;
        int picWidth = 320;
        int picHeight = 480;
        int picQuality = 100;
        String webviewBackground = "#00000000";
        public boolean autoRedirectionEnforcement = true;
        private long userTouchResetTime = 4L;
        int maxVibrationDuration = 5;
        int maxVibrationPatternLength = 20;
        private long delayedRedirection = 5L;
        j savecontent = new j();
        public boolean shouldRenderPopup = false;
        public boolean enablePubMuteControl = false;
        public int bannerNetworkLoadsLimit = 50;
        public int otherNetworkLoadsLimit = -1;
        public List<Integer> gestures = new ArrayList<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5));

        public final int a() {
            try {
                return Color.parseColor((String)this.webviewBackground);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                TAG;
                return Color.parseColor((String)"#00000000");
            }
        }

        public final long b() {
            return this.userTouchResetTime * 1000L;
        }
    }

    @jd
    public static final class j {
        long maxSaveSize = 0x500000L;
        List<String> allowedContentType = new ArrayList<String>(Collections.singletonList("video/mp4"));
    }

    @jd
    public static final class e {
        public int maxRetries = 3;
        public int pingInterval = 60;
        public int pingTimeout = 120;
        public int maxDbEvents = 500;
        public int maxEventBatch = 10;
        public long pingCacheExpiry = 10800L;
    }

    @jd
    public static final class c {
        public boolean bitrate_mandatory = false;
        public int headerTimeout = 2000;
    }

    @jd
    public static final class d {
        public long timeToLive = 3300L;

        d() {
        }
    }

    @Keep
    public static final class ContextualDataConfig {
        private int maxAdRecords = 1;
        private List<String> skipFields = DEFAULT_CONTEXTUAL_DATA_SKIP_FIELDS;
        private int expiryTime = 86400;

        private ContextualDataConfig() {
        }

        public final int getMaxAdRecords() {
            return this.maxAdRecords;
        }

        public final List<String> getSkipFields() {
            return this.skipFields;
        }

        public final int getExpiryTime() {
            return this.expiryTime;
        }

        public final boolean isValid() {
            return this.maxAdRecords >= 0 && this.expiryTime >= 0;
        }
    }
}

