/*
 * Decompiled with CFR 0.152.
 */
package com.innoventsolutions.birt.entity;

import com.innoventsolutions.birt.entity.ExecuteRequest;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class RunResponse {
    private static final Logger log = LoggerFactory.getLogger(RunResponse.class);
    private String outFileName;
    private Date submitTime;
    private Date finish;
    private StatusEnum status;
    private HttpStatus httpStatus;
    private String httpStatusMessage;
    private ExecuteRequest request;

    public RunResponse(ExecuteRequest request) {
        this.request = request;
        this.submitTime = new Date();
        this.outFileName = request.getOutputName() + "." + request.getFormat();
        this.status = StatusEnum.INIT;
        this.httpStatus = HttpStatus.OK;
        log.info("Create response for: " + this.outFileName);
    }

    public String getOutFileName() {
        return this.outFileName;
    }

    public Date getSubmitTime() {
        return this.submitTime;
    }

    public Date getFinish() {
        return this.finish;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public String getHttpStatusMessage() {
        return this.httpStatusMessage;
    }

    public ExecuteRequest getRequest() {
        return this.request;
    }

    public void setOutFileName(String outFileName) {
        this.outFileName = outFileName;
    }

    public void setSubmitTime(Date submitTime) {
        this.submitTime = submitTime;
    }

    public void setFinish(Date finish) {
        this.finish = finish;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public void setHttpStatus(HttpStatus httpStatus) {
        this.httpStatus = httpStatus;
    }

    public void setHttpStatusMessage(String httpStatusMessage) {
        this.httpStatusMessage = httpStatusMessage;
    }

    public void setRequest(ExecuteRequest request) {
        this.request = request;
    }

    public static enum StatusEnum {
        INIT,
        RUNANDRENDER,
        COMPLETE,
        CANCELLED,
        EXCEPTION,
        UNKNOWN;

    }
}

