/*
 * Decompiled with CFR 0.152.
 */
package com.innoventsolutions.birt.entity;

import com.innoventsolutions.birt.entity.ExecuteRequest;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class SubmitResponse {
    private static final Logger log = LoggerFactory.getLogger(SubmitResponse.class);
    protected String jobid;
    protected String rptDocName;
    protected String outFileName;
    protected Date submitTime;
    protected Date runBegin;
    protected Date runFinish;
    protected Date renderBegin;
    protected Date renderFinish;
    protected StatusEnum status;
    protected ExecuteRequest request;
    protected HttpStatus httpStatus;
    protected String httpStatusMessage;

    public SubmitResponse(ExecuteRequest request) {
        this.request = request;
        this.submitTime = new Date();
        long id = this.submitTime.getTime();
        this.jobid = request.getOutputName() + "_" + String.valueOf(id);
        this.rptDocName = this.jobid + ".rptdocument";
        this.outFileName = this.jobid + "." + request.getFormat();
        this.status = StatusEnum.INIT;
        this.httpStatus = HttpStatus.OK;
        log.info("Create response for: " + this.rptDocName);
    }

    public String getJobid() {
        return this.jobid;
    }

    public String getRptDocName() {
        return this.rptDocName;
    }

    public String getOutFileName() {
        return this.outFileName;
    }

    public Date getSubmitTime() {
        return this.submitTime;
    }

    public Date getRunBegin() {
        return this.runBegin;
    }

    public Date getRunFinish() {
        return this.runFinish;
    }

    public Date getRenderBegin() {
        return this.renderBegin;
    }

    public Date getRenderFinish() {
        return this.renderFinish;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public ExecuteRequest getRequest() {
        return this.request;
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public String getHttpStatusMessage() {
        return this.httpStatusMessage;
    }

    public void setJobid(String jobid) {
        this.jobid = jobid;
    }

    public void setRptDocName(String rptDocName) {
        this.rptDocName = rptDocName;
    }

    public void setOutFileName(String outFileName) {
        this.outFileName = outFileName;
    }

    public void setSubmitTime(Date submitTime) {
        this.submitTime = submitTime;
    }

    public void setRunBegin(Date runBegin) {
        this.runBegin = runBegin;
    }

    public void setRunFinish(Date runFinish) {
        this.runFinish = runFinish;
    }

    public void setRenderBegin(Date renderBegin) {
        this.renderBegin = renderBegin;
    }

    public void setRenderFinish(Date renderFinish) {
        this.renderFinish = renderFinish;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public void setRequest(ExecuteRequest request) {
        this.request = request;
    }

    public void setHttpStatus(HttpStatus httpStatus) {
        this.httpStatus = httpStatus;
    }

    public void setHttpStatusMessage(String httpStatusMessage) {
        this.httpStatusMessage = httpStatusMessage;
    }

    public static enum StatusEnum {
        INIT,
        RUN,
        RENDER,
        COMPLETE,
        CANCELLED,
        EXCEPTION,
        UNKNOWN;

    }
}

