/*
 * Decompiled with CFR 0.152.
 */
package com.innoventsolutions.birt.error;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.innoventsolutions.birt.error.ApiSubError;
import com.innoventsolutions.birt.error.ApiValidationError;
import com.innoventsolutions.birt.util.LowerCaseClassNameResolver;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.springframework.http.HttpStatus;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.CUSTOM, property="error", visible=true)
@JsonTypeIdResolver(value=LowerCaseClassNameResolver.class)
public class ApiError {
    private HttpStatus status;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd@HH:mm:ss.SSSZ")
    private Date timestamp = new Date();
    private String message;
    private String debugMessage;
    private List<ApiSubError> subErrors;

    private ApiError() {
    }

    public ApiError(HttpStatus status) {
        this();
        this.status = status;
    }

    public ApiError(HttpStatus status, Throwable ex) {
        this();
        this.status = status;
        this.message = "Unexpected error";
        this.debugMessage = ExceptionUtils.getStackTrace((Throwable)ex);
    }

    public ApiError(HttpStatus status, String message, Throwable ex) {
        this();
        this.status = status;
        this.message = message;
        this.debugMessage = ExceptionUtils.getStackTrace((Throwable)ex);
    }

    public ApiError(HttpStatus status, String message) {
        this();
        this.status = status;
        this.message = message;
        this.debugMessage = message;
    }

    private void addSubError(ApiSubError subError) {
        if (this.subErrors == null) {
            this.subErrors = new ArrayList<ApiSubError>();
        }
        this.subErrors.add(subError);
    }

    private void addValidationError(String object, String field, Object rejectedValue, String message) {
        this.addSubError(new ApiValidationError(object, field, rejectedValue, message));
    }

    private void addValidationError(String object, String message) {
        this.addSubError(new ApiValidationError(object, message));
    }

    private void addValidationError(FieldError fieldError) {
        this.addValidationError(fieldError.getObjectName(), fieldError.getField(), fieldError.getRejectedValue(), fieldError.getDefaultMessage());
    }

    public void addValidationErrors(List<FieldError> fieldErrors) {
        fieldErrors.forEach(this::addValidationError);
    }

    private void addValidationError(ObjectError objectError) {
        this.addValidationError(objectError.getObjectName(), objectError.getDefaultMessage());
    }

    public void addValidationError(List<ObjectError> globalErrors) {
        globalErrors.forEach(this::addValidationError);
    }

    private void addValidationError(ConstraintViolation<?> cv) {
        this.addValidationError(cv.getRootBeanClass().getSimpleName(), ((PathImpl)cv.getPropertyPath()).getLeafNode().asString(), cv.getInvalidValue(), cv.getMessage());
    }

    public void addValidationErrors(Set<ConstraintViolation<?>> constraintViolations) {
        constraintViolations.forEach(this::addValidationError);
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDebugMessage() {
        return this.debugMessage;
    }

    public List<ApiSubError> getSubErrors() {
        return this.subErrors;
    }

    public void setStatus(HttpStatus status) {
        this.status = status;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setDebugMessage(String debugMessage) {
        this.debugMessage = debugMessage;
    }

    public void setSubErrors(List<ApiSubError> subErrors) {
        this.subErrors = subErrors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiError)) {
            return false;
        }
        ApiError other = (ApiError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpStatus this$status = this.getStatus();
        HttpStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Date this$timestamp = this.getTimestamp();
        Date other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$debugMessage = this.getDebugMessage();
        String other$debugMessage = other.getDebugMessage();
        if (this$debugMessage == null ? other$debugMessage != null : !this$debugMessage.equals(other$debugMessage)) {
            return false;
        }
        List<ApiSubError> this$subErrors = this.getSubErrors();
        List<ApiSubError> other$subErrors = other.getSubErrors();
        return !(this$subErrors == null ? other$subErrors != null : !((Object)this$subErrors).equals(other$subErrors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Date $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $debugMessage = this.getDebugMessage();
        result = result * 59 + ($debugMessage == null ? 43 : $debugMessage.hashCode());
        List<ApiSubError> $subErrors = this.getSubErrors();
        result = result * 59 + ($subErrors == null ? 43 : ((Object)$subErrors).hashCode());
        return result;
    }

    public String toString() {
        return "ApiError(status=" + this.getStatus() + ", timestamp=" + this.getTimestamp() + ", message=" + this.getMessage() + ", debugMessage=" + this.getDebugMessage() + ", subErrors=" + this.getSubErrors() + ")";
    }
}

