/*
 * Decompiled with CFR 0.152.
 */
package com.innoventsolutions.birt.exception;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.engine.api.EngineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class BirtStarterException
extends RuntimeException {
    private static final Logger log = LoggerFactory.getLogger(BirtStarterException.class);
    private static final long serialVersionUID = 1L;
    private BirtErrorCode errorCode;
    private final List<Exception> exceptions = new ArrayList<Exception>();

    public BirtStarterException(BirtErrorCode errorCode, String message) {
        super(message);
        if (errorCode == null) {
            throw new IllegalArgumentException("errorCode may not be null, message = " + message);
        }
        this.errorCode = errorCode;
        log.error(this.getErrorMessage(), (Throwable)this);
    }

    public BirtStarterException(BirtErrorCode errorCode, String message, Throwable cause) {
        super(message, cause);
        if (errorCode == null) {
            throw new IllegalArgumentException("errorCode may not be null, message = " + message + ", cause = " + cause);
        }
        this.errorCode = errorCode;
        log.error(this.getErrorMessage(), (Throwable)this);
    }

    public BirtStarterException(BirtErrorCode errorCode, Throwable cause) {
        super(cause);
        if (errorCode == null) {
            throw new IllegalArgumentException("errorCode may not be null, cause = " + cause);
        }
        this.errorCode = errorCode;
        log.error(this.getErrorMessage(), (Throwable)this);
    }

    public BirtStarterException(BirtErrorCode errorCode, List<EngineException> errors) {
        super("Engine Exception");
        if (errorCode == null) {
            throw new IllegalArgumentException("errorCode may not be null, errors = " + errors);
        }
        for (EngineException exception : errors) {
            log.error("BIRT error", (Throwable)exception);
            this.exceptions.add((Exception)exception);
        }
    }

    private String getErrorMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append("BirtStarterException: ").append((Object)this.errorCode).append(":").append(this.getMessage());
        if (this.exceptions.size() > 0) {
            for (Exception exception : this.exceptions) {
                sb.append(exception.getMessage());
            }
        }
        return sb.toString();
    }

    public String getErrorCode() {
        return this.errorCode.toString();
    }

    public HttpStatus getHttpCode() {
        return this.errorCode.getHttpStatus();
    }

    public static enum BirtErrorCode {
        PLATFORM_START(HttpStatus.INTERNAL_SERVER_ERROR),
        BAD_REQUEST(HttpStatus.BAD_REQUEST),
        UNKNOWN_PARAMETER(HttpStatus.BAD_REQUEST),
        PARAMETER_VALIDATION(HttpStatus.BAD_REQUEST),
        BAD_FORMAT(HttpStatus.UNSUPPORTED_MEDIA_TYPE),
        DESIGN_FILE_LOCATION(HttpStatus.NOT_FOUND),
        RUNANDRENDER_TASK(HttpStatus.INTERNAL_SERVER_ERROR),
        RUN_TASK(HttpStatus.INTERNAL_SERVER_ERROR),
        RENDER_TASK(HttpStatus.INTERNAL_SERVER_ERROR);

        private final HttpStatus httpStatus;

        private BirtErrorCode(HttpStatus httpStatus) {
            this.httpStatus = httpStatus;
        }

        public HttpStatus getHttpStatus() {
            return this.httpStatus;
        }
    }
}

