/*
 * Decompiled with CFR 0.152.
 */
package com.innoventsolutions.birt.service;

import com.innoventsolutions.birt.entity.ExecuteRequest;
import com.innoventsolutions.birt.exception.BirtStarterException;
import com.innoventsolutions.birt.service.BirtEngineService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.sql.Date;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLActionHandler;
import org.eclipse.birt.report.engine.api.HTMLCompleteImageHandler;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseReportService {
    private static final Logger log = LoggerFactory.getLogger(BaseReportService.class);
    private static final SimpleDateFormat PARAM_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    protected final BirtEngineService engineService;

    public BaseReportService(BirtEngineService engineService) {
        this.engineService = engineService;
    }

    protected static Object getFieldObject(String fieldString) {
        if ("true".equalsIgnoreCase(fieldString)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(fieldString)) {
            return Boolean.FALSE;
        }
        String trimmedFieldString = fieldString.trim();
        if (trimmedFieldString.startsWith("\"") && trimmedFieldString.endsWith("\"")) {
            return trimmedFieldString.substring(1, trimmedFieldString.length() - 1);
        }
        try {
            int intValue = Integer.parseInt(fieldString);
            return new Integer(intValue);
        }
        catch (NumberFormatException intValue) {
            try {
                double dblValue = Double.parseDouble(fieldString);
                return new Double(dblValue);
            }
            catch (NumberFormatException dblValue) {
                try {
                    java.util.Date valDate = PARAM_DATE_FORMAT.parse(fieldString);
                    return new Date(valDate.getTime());
                }
                catch (ParseException parseException) {
                    return fieldString;
                }
            }
        }
    }

    protected RenderOption configureRenderOptions(String format) {
        PDFRenderOption options = null;
        if (format.equalsIgnoreCase("html")) {
            HTMLRenderOption htmlOption = new HTMLRenderOption();
            htmlOption.setOutputFormat("html");
            htmlOption.setActionHandler((IHTMLActionHandler)new HTMLActionHandler());
            htmlOption.setImageHandler((IHTMLImageHandler)new HTMLCompleteImageHandler());
            htmlOption.setBaseImageURL(this.engineService.getBaseImageURL());
            htmlOption.setImageDirectory("images");
            options = htmlOption;
        }
        if (format.equalsIgnoreCase("pdf")) {
            options = new PDFRenderOption();
            options.setOutputFormat("pdf");
        } else {
            options = new RenderOption();
            options.setOutputFormat(format.toLowerCase());
        }
        return options;
    }

    protected IReportRunnable getRunnableReportDesign(ExecuteRequest execRequest) throws BirtStarterException {
        IReportRunnable design;
        String fileName = execRequest.getDesignFile();
        if (fileName.equalsIgnoreCase("TEST")) {
            fileName = "test.rptdesign";
        }
        try {
            File designFile = new File(fileName);
            if (!designFile.exists()) {
                designFile = new File(this.engineService.getDesignDir(), fileName);
            }
            if (!designFile.exists()) {
                StringBuffer sb = new StringBuffer();
                sb.append("Design file does not exist: filename: ").append(fileName).append("\n");
                sb.append("Searched as absolute path and in design folder :").append(this.engineService.getDesignDir().getAbsolutePath());
                log.error(sb.toString());
            }
            log.debug("Design File: " + designFile.getAbsolutePath());
            FileInputStream fis = new FileInputStream(designFile);
            design = this.engineService.getEngine().openReportDesign((InputStream)fis);
        }
        catch (FileNotFoundException e) {
            throw new BirtStarterException(BirtStarterException.BirtErrorCode.DESIGN_FILE_LOCATION, "Design file not found " + fileName, e);
        }
        catch (EngineException e) {
            throw new BirtStarterException(BirtStarterException.BirtErrorCode.DESIGN_FILE_LOCATION, "Failed to open design file " + fileName, e);
        }
        return design;
    }

    protected void configureParameters(ExecuteRequest execRequest, IReportRunnable design, IEngineTask task) throws BirtStarterException {
        log.debug("configure parameters");
        if (execRequest.getParameters() == null) {
            execRequest.setParameters(new HashMap<String, Object>());
        }
        IGetParameterDefinitionTask pdTask = this.engineService.getEngine().createGetParameterDefinitionTask(design);
        for (String key : execRequest.getParameters().keySet()) {
            Object[] values;
            Object paramValue = execRequest.getParameters().get(key);
            IParameterDefnBase defn = pdTask.getParameterDefn(key);
            if (defn == null) {
                throw new BirtStarterException(BirtStarterException.BirtErrorCode.UNKNOWN_PARAMETER, "Parameter " + key + " not found in report");
            }
            ParameterHandle handle = (ParameterHandle)defn.getHandle();
            Object dataType = handle.getProperty("dataType");
            log.debug(" param " + key + " = " + paramValue + ", type = " + dataType + " " + defn.getTypeName());
            if (paramValue instanceof List) {
                List list = (List)paramValue;
                values = list.toArray(new Object[0]);
            } else {
                values = paramValue instanceof Object[] ? (Object[])paramValue : null;
            }
            if (values != null) {
                log.debug(" param " + key + " " + values.length);
                for (int i = 0; i < values.length; ++i) {
                    Object value = values[i];
                    log.debug("   value " + i + " " + value + " " + value.getClass().getName());
                    values[i] = this.convertParameterValue(key + "(" + i + ")", value, dataType);
                }
                task.setParameterValue(key, values);
                continue;
            }
            task.setParameterValue(key, this.convertParameterValue(key, paramValue, dataType));
        }
        log.debug("validating parameters");
        try {
            task.validateParameters();
        }
        catch (Exception e) {
            throw new BirtStarterException(BirtStarterException.BirtErrorCode.PARAMETER_VALIDATION, "Failure to validate parameters", e);
        }
    }

    protected Object convertParameterValue(String name, Object paramValue, Object dataType) throws BirtStarterException {
        if (paramValue instanceof String) {
            String stringValue = (String)paramValue;
            if ("integer".equals(dataType)) {
                try {
                    return Integer.valueOf(stringValue);
                }
                catch (NumberFormatException e) {
                    throw new BirtStarterException(BirtStarterException.BirtErrorCode.PARAMETER_VALIDATION, "Parameter " + name + " isn't a valid integer", e);
                }
            }
            if ("boolean".equals(dataType)) {
                return Boolean.valueOf(stringValue);
            }
            if ("decimal".equals(dataType)) {
                try {
                    return Double.valueOf(stringValue);
                }
                catch (NumberFormatException e) {
                    throw new BirtStarterException(BirtStarterException.BirtErrorCode.PARAMETER_VALIDATION, "Parameter " + name + " isn't a valid decimal", e);
                }
            }
            if ("float".equals(dataType)) {
                try {
                    return Double.valueOf(stringValue);
                }
                catch (NumberFormatException e) {
                    throw new BirtStarterException(BirtStarterException.BirtErrorCode.PARAMETER_VALIDATION, "Parameter " + name + " isn't a valid float", e);
                }
            }
            if ("date".equals(dataType)) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    return new Date(df.parse(stringValue).getTime());
                }
                catch (ParseException e) {
                    throw new BirtStarterException(BirtStarterException.BirtErrorCode.PARAMETER_VALIDATION, "Parameter " + name + " isn't a valid date", e);
                }
            }
            if ("dateTime".equals(dataType)) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:dd");
                try {
                    return new Date(df.parse(stringValue).getTime());
                }
                catch (ParseException e) {
                    throw new BirtStarterException(BirtStarterException.BirtErrorCode.PARAMETER_VALIDATION, "Parameter " + name + " isn't a valid dateTime", e);
                }
            }
            if ("time".equals(dataType)) {
                SimpleDateFormat df = new SimpleDateFormat("HH:mm:dd");
                try {
                    return new Time(df.parse(stringValue).getTime());
                }
                catch (ParseException e) {
                    throw new BirtStarterException(BirtStarterException.BirtErrorCode.PARAMETER_VALIDATION, "Parameter " + name + " isn't a valid time", e);
                }
            }
        }
        return paramValue;
    }

    protected static List<File> getPropFiles(File baseDir) {
        ArrayList<File> files = new ArrayList<File>();
        if (!baseDir.isDirectory()) {
            files.add(baseDir);
        } else {
            File[] dirFile = baseDir.listFiles(new PropFilter());
            for (int i = 0; i < dirFile.length; ++i) {
                files.add(dirFile[i]);
            }
        }
        return files;
    }

    public Map<String, Object> fixParameterTypes(Map<String, Object> parameters) throws BirtStarterException {
        if (parameters == null) {
            return null;
        }
        HashMap<String, Object> fixedParameters = new HashMap<String, Object>();
        for (String paramName : parameters.keySet()) {
            Object paramValue = parameters.get(paramName);
            if (paramValue instanceof Object[]) {
                Object[] valueArray = (Object[])paramValue;
                for (int i = 0; i < valueArray.length; ++i) {
                    valueArray[i] = this.fixParameterType(paramName, valueArray[i]);
                }
            }
            paramValue = this.fixParameterType(paramName, paramValue);
            fixedParameters.put(paramName, paramValue);
        }
        return fixedParameters;
    }

    private Object fixParameterType(Object name, Object value) throws BirtStarterException {
        if (!(value instanceof Map)) {
            return value;
        }
        Map map = (Map)value;
        Object type = map.get("type");
        if (type == null) {
            throw new BirtStarterException(BirtStarterException.BirtErrorCode.PARAMETER_VALIDATION, "Parameter " + name + " is an object but the type field is missing");
        }
        Object subValue = map.get("value");
        if (!(subValue instanceof String)) {
            log.error("parameter sub-value is not a string");
            throw new BirtStarterException(BirtStarterException.BirtErrorCode.PARAMETER_VALIDATION, "Parameter " + name + " is an object but the value field is missing or isn't a string");
        }
        if ("date".equals(type)) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                java.util.Date date = df.parse((String)subValue);
                return new Date(date.getTime());
            }
            catch (ParseException e) {
                log.error("parameter date sub-value is malformed");
                throw new BirtStarterException(BirtStarterException.BirtErrorCode.PARAMETER_VALIDATION, "Parameter " + name + " is an object and the type is date but the value isn't a valid date");
            }
        }
        if ("datetime".equals(type)) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                java.util.Date date = df.parse((String)subValue);
                return new Date(date.getTime());
            }
            catch (ParseException e) {
                log.error("parameter date sub-value is malformed");
                throw new BirtStarterException(BirtStarterException.BirtErrorCode.PARAMETER_VALIDATION, "Parameter " + name + " is an object and the type is datetime but the value isn't a valid datetime");
            }
        }
        if ("time".equals(type)) {
            SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
            try {
                java.util.Date date = df.parse((String)subValue);
                return new Time(date.getTime());
            }
            catch (ParseException e) {
                log.error("parameter date sub-value is malformed");
                throw new BirtStarterException(BirtStarterException.BirtErrorCode.PARAMETER_VALIDATION, "Parameter " + name + " is an object and the type is time but the value isn't a valid time");
            }
        }
        log.error("unrecognized parameter value type: " + type);
        throw new BirtStarterException(BirtStarterException.BirtErrorCode.PARAMETER_VALIDATION, "Parameter " + name + " is an object and the type field is present but is not recognized");
    }

    protected static final class PropFilter
    implements FilenameFilter {
        private final String extension = ".properties";

        protected PropFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".properties");
        }
    }
}

