/*
 * Decompiled with CFR 0.152.
 */
package com.innoventsolutions.birt.service;

import com.innoventsolutions.birt.config.BirtConfig;
import com.innoventsolutions.birt.exception.BirtStarterException;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.annotation.PostConstruct;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BirtEngineService {
    private static final Logger log = LoggerFactory.getLogger(BirtEngineService.class);
    private final BirtConfig birtProperties;
    private IReportEngine engine = null;

    public BirtEngineService(BirtConfig birtProperties) {
        this.birtProperties = birtProperties;
    }

    @PostConstruct
    public IReportEngine getEngine() throws BirtStarterException {
        if (this.engine == null) {
            log.info("Instantiate Report Engine");
            this.engine = this.getReportEngine();
        }
        return this.engine;
    }

    public String getBaseImageURL() {
        return this.birtProperties.getBaseImageURL();
    }

    public File getOutputDir() {
        return this.birtProperties.getOutputDir();
    }

    public File getWorkspace() {
        return this.birtProperties.getWorkspace();
    }

    public File getDesignDir() {
        return this.birtProperties.getDesignDir();
    }

    private IReportEngine getReportEngine() throws BirtStarterException {
        String scriptlibFileNames;
        log.info("getReportEngine");
        EngineConfig config = new EngineConfig();
        log.info(this.birtProperties.toString());
        if (this.birtProperties.getBirtRuntimeHome() != null) {
            String birtHome = this.birtProperties.getBirtRuntimeHome().getAbsolutePath();
            if (this.birtProperties.isActuate()) {
                config.setBIRTHome(birtHome);
            } else {
                config.setEngineHome(birtHome);
            }
        }
        if (this.birtProperties.getResourceDir() != null) {
            config.setResourcePath(this.birtProperties.getResourceDir().getAbsolutePath());
        }
        if ((scriptlibFileNames = this.getScriptLibFileNames()) != null) {
            config.setProperty("webapplication.projectclasspath", (Object)scriptlibFileNames);
        }
        this.configureLogging(config);
        IReportEngine birtEngine = this.birtProperties.isActuate() ? BirtEngineService.getActuateReportEngine(config) : BirtEngineService.getReportEngine(config);
        return birtEngine;
    }

    private void configureLogging(EngineConfig config) throws BirtStarterException {
        File loggingDirFile;
        File file = loggingDirFile = this.birtProperties.getLoggingDir() == null ? new File("./log") : this.birtProperties.getLoggingDir();
        if (!loggingDirFile.exists()) {
            loggingDirFile.mkdirs();
        }
        config.setLogConfig(loggingDirFile.getAbsolutePath(), Level.WARNING);
    }

    private static IReportEngine getReportEngine(EngineConfig config) throws BirtStarterException {
        log.info("before Platform startup");
        try {
            Platform.startup((PlatformConfig)config);
        }
        catch (BirtException e) {
            throw new BirtStarterException(BirtStarterException.BirtErrorCode.PLATFORM_START, "Failed to start platform", e);
        }
        log.info("after Platform startup");
        IReportEngineFactory factory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
        if (factory == null) {
            log.error("Could not create report engine factory");
            throw new BirtStarterException(BirtStarterException.BirtErrorCode.PLATFORM_START, "Failed to create Factory");
        }
        IReportEngine engine = factory.createReportEngine(config);
        if (engine == null) {
            log.error("Could not create report engine");
            throw new BirtStarterException(BirtStarterException.BirtErrorCode.PLATFORM_START, "Failed to create Engine");
        }
        return engine;
    }

    private static IReportEngine getActuateReportEngine(EngineConfig config) throws BirtStarterException {
        try {
            Platform.startup((PlatformConfig)config);
        }
        catch (BirtException e) {
            throw new BirtStarterException(BirtStarterException.BirtErrorCode.PLATFORM_START, "Failed to start platform", e);
        }
        Object factoryObjectForReflection = Platform.createFactoryObject((String)"com.actuate.birt.report.engine.ActuateReportEngineFactory");
        Class<?> factoryClass = factoryObjectForReflection.getClass();
        Method[] methods = factoryClass.getDeclaredMethods();
        IReportEngine reportEngine = null;
        for (Method m : methods) {
            String name = m.getName();
            m.setAccessible(true);
            if (!name.equals("createReportEngine")) continue;
            try {
                reportEngine = (IReportEngine)m.invoke(factoryObjectForReflection, config);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new BirtStarterException(BirtStarterException.BirtErrorCode.PLATFORM_START, "Failed to create report engine", e);
            }
        }
        return reportEngine;
    }

    private String getScriptLibFileNames() {
        if (this.birtProperties.getScriptLibDir() == null) {
            return null;
        }
        if (!this.birtProperties.getScriptLibDir().exists()) {
            this.birtProperties.getScriptLibDir().mkdirs();
        }
        File[] files = this.birtProperties.getScriptLibDir().listFiles(new JarFilter());
        StringBuilder sb = new StringBuilder();
        String sep = "";
        String fileSeparatorString = new String(new char[]{File.pathSeparatorChar});
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                sb.append(sep);
                sep = fileSeparatorString;
                sb.append(files[i].getAbsolutePath());
            }
        }
        return sb.toString();
    }

    public void shutdown() {
        log.info("engine shutdown");
        this.engine.shutdown();
    }

    private static class JarFilter
    implements FilenameFilter {
        private final String extension = ".jar";

        private JarFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".jar");
        }
    }
}

