/*
 * Decompiled with CFR 0.152.
 */
package com.innoventsolutions.birt.service;

import com.innoventsolutions.birt.entity.ExecuteRequest;
import com.innoventsolutions.birt.exception.BirtStarterException;
import com.innoventsolutions.birt.service.BaseReportService;
import com.innoventsolutions.birt.service.BirtEngineService;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportRunService
extends BaseReportService {
    private static final Logger log = LoggerFactory.getLogger(ReportRunService.class);

    public ReportRunService(BirtEngineService engineService) {
        super(engineService);
        log.info("Start RunService");
    }

    public void execute(ExecuteRequest request, OutputStream outputStream) throws BirtStarterException {
        log.info("runReport reportRun = " + request);
        try (IRunAndRenderTask rrTask = null;){
            IReportRunnable design = this.getRunnableReportDesign(request);
            rrTask = this.engineService.getEngine().createRunAndRenderTask(design);
            Map appContext = rrTask.getAppContext();
            rrTask.setAppContext(appContext);
            this.configureParameters(request, design, (IEngineTask)rrTask);
            log.info("getRenderOptions");
            String format = request.getFormat();
            RenderOption options = this.configureRenderOptions(format);
            options.setOutputStream(outputStream);
            rrTask.setRenderOption((IRenderOption)options);
            log.info("run-and-render report");
            rrTask.run();
            List errors = rrTask.getErrors();
            if (errors != null && errors.size() > 0) {
                throw new BirtStarterException(BirtStarterException.BirtErrorCode.RUNANDRENDER_TASK, errors);
            }
            rrTask.close();
        }
    }
}

