/*
 * Decompiled with CFR 0.152.
 */
package com.innoventsolutions.birt.service;

import com.innoventsolutions.birt.entity.ExecuteRequest;
import com.innoventsolutions.birt.entity.SubmitResponse;
import com.innoventsolutions.birt.exception.BirtStarterException;
import com.innoventsolutions.birt.service.BaseReportService;
import com.innoventsolutions.birt.service.BirtEngineService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.api.UnsupportedFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class SubmitJobService
extends BaseReportService {
    private static final Logger log = LoggerFactory.getLogger(SubmitJobService.class);
    private final Executor submitPool;

    public SubmitJobService(BirtEngineService engineService, Executor submitPool) {
        super(engineService);
        this.submitPool = submitPool;
        log.info("Start RunService");
    }

    public CompletableFuture<SubmitResponse> executeRunThenRender(SubmitResponse submitResponse) {
        log.info("RunThenRender: " + submitResponse.getRequest().getOutputName());
        CompletionStage runThenRender = ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.executeRun(submitResponse), this.submitPool).thenApply(l -> this.executeRender(submitResponse))).exceptionally(err -> {
            if (err != null) {
                log.info("Completed exceptionally: " + err.getMessage() + " " + err.getClass().toString());
                if (err instanceof CompletionException) {
                    CompletionException completionException = (CompletionException)err;
                    Throwable cause = completionException.getCause();
                    log.info("cause = " + cause.getClass().toString());
                    if (cause instanceof BirtStarterException) {
                        BirtStarterException birtStarterException = (BirtStarterException)cause;
                        submitResponse.setHttpStatus(birtStarterException.getHttpCode());
                        submitResponse.setHttpStatusMessage(birtStarterException.getMessage());
                    } else {
                        submitResponse.setHttpStatus(HttpStatus.INTERNAL_SERVER_ERROR);
                        submitResponse.setHttpStatusMessage(err.getMessage());
                    }
                } else {
                    submitResponse.setHttpStatus(HttpStatus.INTERNAL_SERVER_ERROR);
                    submitResponse.setHttpStatusMessage(err.getMessage());
                }
            } else {
                log.info("Completed exceptionally: err is null");
                submitResponse.setHttpStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            }
            submitResponse.setStatus(SubmitResponse.StatusEnum.EXCEPTION);
            return submitResponse;
        });
        return runThenRender;
    }

    public FileInputStream getReport(SubmitResponse job) throws FileNotFoundException {
        File f = new File(this.engineService.getOutputDir(), job.getOutFileName());
        return new FileInputStream(f);
    }

    public SubmitResponse executeRender(SubmitResponse submitResponse) {
        if (SubmitResponse.StatusEnum.EXCEPTION.equals((Object)submitResponse.getStatus())) {
            log.info("render skipped because run failed");
            return submitResponse;
        }
        submitResponse.setStatus(SubmitResponse.StatusEnum.RENDER);
        submitResponse.setRenderBegin(new Date());
        log.info("SubmitJobService.executeRender = " + submitResponse.getRequest() + "[" + submitResponse.getJobid() + "]");
        log.info("SubmitJobService.executeRender current status = " + (Object)((Object)submitResponse.getStatus()) + " thread: " + Thread.currentThread().getName());
        ExecuteRequest request = submitResponse.getRequest();
        IReportDocument rptdoc = null;
        IRenderTask renderTask = null;
        try {
            IReportEngine engine = this.engineService.getEngine();
            File rptDocFile = new File(this.engineService.getOutputDir(), submitResponse.getRptDocName());
            File outputFile = new File(this.engineService.getOutputDir(), submitResponse.getOutFileName());
            rptdoc = engine.openReportDocument(rptDocFile.getAbsolutePath());
            renderTask = engine.createRenderTask(rptdoc);
            log.info("Rendering doc: " + request.getOutputName() + " to " + request.getFormat());
            String format = request.getFormat();
            RenderOption options = this.configureRenderOptions(format);
            outputFile.getParentFile().mkdirs();
            options.setOutputFileName(outputFile.getAbsolutePath());
            options.setOutputFormat(format == null || format.length() == 0 ? "HTML" : format);
            options.setOutputFileName(outputFile.getAbsolutePath());
            renderTask.setRenderOption((IRenderOption)options);
            try {
                renderTask.render();
            }
            catch (UnsupportedFormatException e) {
                throw new BirtStarterException(BirtStarterException.BirtErrorCode.BAD_FORMAT, "Unsupported output format: '" + format + "'");
            }
            catch (Exception e) {
                throw new BirtStarterException(BirtStarterException.BirtErrorCode.RENDER_TASK, "Run Task failed", e);
            }
            List errors = renderTask.getErrors();
            if (errors != null && errors.size() > 0) {
                throw new BirtStarterException(BirtStarterException.BirtErrorCode.RENDER_TASK, errors);
            }
            rptdoc.close();
            renderTask.close();
        }
        catch (EngineException e1) {
            log.error("Failed to render report", (Throwable)e1);
            throw new RuntimeException("Failed to render report", e1);
        }
        finally {
            if (rptdoc != null) {
                rptdoc.close();
            }
            if (renderTask != null) {
                renderTask.close();
            }
        }
        submitResponse.setHttpStatus(HttpStatus.OK);
        submitResponse.setRenderFinish(new Date());
        submitResponse.setStatus(SubmitResponse.StatusEnum.COMPLETE);
        log.info("SubmitJobService.executeRender finished");
        return submitResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubmitResponse executeRun(SubmitResponse submitResponse) {
        submitResponse.setStatus(SubmitResponse.StatusEnum.RUN);
        submitResponse.setRunBegin(new Date());
        log.info("SubmitJobService.executeRun started, thread = " + Thread.currentThread() + ", request = " + submitResponse.getRequest());
        try (IRunTask rTask = null;){
            IReportRunnable design = this.getRunnableReportDesign(submitResponse.getRequest());
            rTask = this.engineService.getEngine().createRunTask(design);
            this.configureParameters(submitResponse.getRequest(), design, (IEngineTask)rTask);
            File rptDocFile = new File(this.engineService.getOutputDir(), submitResponse.getRptDocName());
            String rptDoc = rptDocFile.getAbsolutePath();
            log.info("Creating rpt doc: " + rptDoc);
            rTask.setReportDocument(rptDoc);
            try {
                rTask.run();
            }
            catch (UnsupportedFormatException e) {
                throw new BirtStarterException(BirtStarterException.BirtErrorCode.RUN_TASK, "Unsupported output format");
            }
            catch (Exception e) {
                throw new BirtStarterException(BirtStarterException.BirtErrorCode.RUN_TASK, "Run Task failed", e);
            }
            List errors = rTask.getErrors();
            if (errors != null && errors.size() > 0) {
                throw new BirtStarterException(BirtStarterException.BirtErrorCode.RUN_TASK, errors);
            }
            rTask.close();
        }
        submitResponse.setHttpStatus(HttpStatus.OK);
        submitResponse.setRunFinish(new Date());
        log.info("SubmitJobService.executeRun finished");
        return submitResponse;
    }
}

