/*
 * Decompiled with CFR 0.152.
 */
package com.inomera.adapter.config.bridge;

import com.inomera.adapter.config.bridge.exception.AdapterConfigException;
import com.inomera.adapter.config.bridge.util.AdapterConfigMerger;
import com.inomera.integration.auth.AuthType;
import com.inomera.integration.config.AdapterConfigDataSupplier;
import com.inomera.integration.config.model.AdapterConfig;
import com.inomera.integration.config.model.AdapterProperties;
import com.inomera.integration.config.model.Auth;
import com.inomera.integration.config.model.AuthHeadersCredentials;
import com.inomera.integration.config.model.BasicAuthCredentials;
import com.inomera.integration.config.model.BearerTokenCredentials;
import com.inomera.telco.commons.config.ConfigurationHolder;
import com.inomera.telco.commons.lang.Assert;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicAdapterConfigDataBridgeSupplierHandler
implements AdapterConfigDataSupplier {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicAdapterConfigDataBridgeSupplierHandler.class);
    private static final String COMMON_CONFIG_V1_KEY = "config.adapter.common.v1";
    private final ConcurrentHashMap<String, String> configReloadMap = new ConcurrentHashMap();
    private final ConfigurationHolder configurationHolder;

    public AdapterConfig getConfigV1(String key) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        try {
            Map adapterPropertiesMap = this.getConfig(key, Map.class);
            if (adapterPropertiesMap == null) {
                throw new AdapterConfigException("Adapter config for key '" + key + "' is not found");
            }
            Auth authCredentials = this.extractAuthCredentials(adapterPropertiesMap);
            AdapterProperties adapterProperties = this.getConfig(key, AdapterProperties.class);
            adapterProperties.setAuth(authCredentials);
            AdapterConfig adapterConfig = new AdapterConfig(key, adapterProperties);
            AdapterConfig mergedAdapterConfig = this.mergeWithCommonConfigIfNotSetInAdapterConfig(adapterConfig);
            this.handleConfigReload(key, mergedAdapterConfig);
            return mergedAdapterConfig;
        }
        catch (Exception e) {
            LOG.error("Key: {}, Config deserialization error occurred", (Object)key, (Object)e);
            throw new AdapterConfigException("Adapter Config Exception", e);
        }
    }

    public <T> T getConfig(String key, Class<T> classToDeserialize) {
        Object result = switch (classToDeserialize.getSimpleName()) {
            case "String" -> this.resolveProperty(key, arg_0 -> ((ConfigurationHolder)this.configurationHolder).getStringProperty(arg_0));
            case "Long" -> this.resolveProperty(key, arg_0 -> ((ConfigurationHolder)this.configurationHolder).getLongProperty(arg_0));
            case "Integer" -> this.resolveProperty(key, arg_0 -> ((ConfigurationHolder)this.configurationHolder).getIntegerProperty(arg_0));
            case "Boolean" -> this.resolveProperty(key, arg_0 -> ((ConfigurationHolder)this.configurationHolder).getBooleanProperty(arg_0));
            case "Double" -> this.resolveProperty(key, arg_0 -> ((ConfigurationHolder)this.configurationHolder).getDoubleProperty(arg_0));
            case "Float" -> this.resolveProperty(key, arg_0 -> ((ConfigurationHolder)this.configurationHolder).getFloatProperty(arg_0));
            case "Set" -> this.resolveProperty(key, arg_0 -> ((ConfigurationHolder)this.configurationHolder).getStringSetProperty(arg_0));
            default -> this.configurationHolder.getJsonObjectProperty(key, classToDeserialize);
        };
        return classToDeserialize.cast(result);
    }

    public <T> T getConfig(String key, Class<T> classToDeserialize, T defaultValue) {
        Object result = switch (classToDeserialize.getSimpleName()) {
            case "String" -> this.resolveProperty(key, defaultValue, arg_0 -> ((ConfigurationHolder)this.configurationHolder).getStringProperty(arg_0));
            case "Long" -> this.resolveProperty(key, defaultValue, arg_0 -> ((ConfigurationHolder)this.configurationHolder).getLongProperty(arg_0));
            case "Integer" -> this.resolveProperty(key, defaultValue, arg_0 -> ((ConfigurationHolder)this.configurationHolder).getIntegerProperty(arg_0));
            case "Boolean" -> this.resolveProperty(key, defaultValue, arg_0 -> ((ConfigurationHolder)this.configurationHolder).getBooleanProperty(arg_0));
            case "Double" -> this.resolveProperty(key, defaultValue, arg_0 -> ((ConfigurationHolder)this.configurationHolder).getDoubleProperty(arg_0));
            case "Float" -> this.resolveProperty(key, defaultValue, arg_0 -> ((ConfigurationHolder)this.configurationHolder).getFloatProperty(arg_0));
            case "Set" -> this.resolveProperty(key, defaultValue, arg_0 -> ((ConfigurationHolder)this.configurationHolder).getStringSetProperty(arg_0));
            default -> this.configurationHolder.getJsonObjectProperty(key, classToDeserialize, defaultValue);
        };
        return classToDeserialize.cast(result);
    }

    public <T> List<T> getConfigs(String key, Class<T> classToDeserialize) {
        return switch (classToDeserialize.getSimpleName()) {
            case "Enum" -> List.of(classToDeserialize.cast(this.configurationHolder.getEnumList(key, classToDeserialize)));
            default -> this.configurationHolder.getJsonListProperty(key, classToDeserialize);
        };
    }

    public <T> List<T> getConfigs(String key, Class<T> classToDeserialize, List<T> defaultValue) {
        return switch (classToDeserialize.getSimpleName()) {
            case "Enum" -> List.of(classToDeserialize.cast(this.configurationHolder.getEnumList(key, classToDeserialize, defaultValue)));
            default -> this.configurationHolder.getJsonListProperty(key, classToDeserialize, defaultValue);
        };
    }

    private Auth extractAuthCredentials(Map<String, Object> adapterPropertiesMap) {
        Map authMap = (Map)adapterPropertiesMap.get("auth");
        if (authMap == null) {
            throw new AdapterConfigException("'auth' section is missing in adapter properties");
        }
        return this.getAuthCredentials(authMap);
    }

    private void handleConfigReload(String key, AdapterConfig mergedAdapterConfig) {
        String currentHash = this.configReloadMap.get(key);
        if (StringUtils.isBlank((CharSequence)currentHash)) {
            this.configReloadMap.put(key, mergedAdapterConfig.hashConfig());
            mergedAdapterConfig.setRefresh(true);
        } else if (currentHash.equals(mergedAdapterConfig.hashConfig())) {
            mergedAdapterConfig.setRefresh(false);
        } else {
            this.configReloadMap.put(key, mergedAdapterConfig.hashConfig());
            mergedAdapterConfig.setRefresh(true);
        }
    }

    private Auth getAuthCredentials(Map<String, Object> authMap) {
        String authType = (String)authMap.get("type");
        switch (AuthType.valueOf((String)authType)) {
            case BASIC: {
                return new BasicAuthCredentials((String)authMap.get("username"), (String)authMap.get("password"));
            }
            case HEADER: {
                return new AuthHeadersCredentials((Map)authMap.get("headers"));
            }
            case BEARER: {
                return new BearerTokenCredentials.Builder().url((String)authMap.get("url")).scope((String)authMap.get("scope")).username((String)authMap.get("username")).password((String)authMap.get("password")).clientId((String)authMap.get("clientId")).clientSecret((String)authMap.get("clientSecret")).grantType((String)authMap.get("grantType")).ttl(Long.parseLong(authMap.get("ttl").toString())).contentType((String)authMap.get("contentType")).accept((String)authMap.get("accept")).tokenJsonPath((String)authMap.get("tokenJsonPath")).build();
            }
        }
        return new Auth.NoneAuth();
    }

    private AdapterConfig mergeWithCommonConfigIfNotSetInAdapterConfig(AdapterConfig adapterConfig) {
        AdapterProperties commonAdapterProperties = this.getConfig(COMMON_CONFIG_V1_KEY, AdapterProperties.class);
        if (commonAdapterProperties == null) {
            LOG.warn("common config key :: {} is not found, please check it!!", (Object)COMMON_CONFIG_V1_KEY);
            return adapterConfig;
        }
        AdapterConfig commonConfig = new AdapterConfig(COMMON_CONFIG_V1_KEY, commonAdapterProperties);
        return AdapterConfigMerger.mergeIfNotExistAdapterConfig(adapterConfig, commonConfig);
    }

    private <T> Object resolveProperty(String key, FunctionWithDefault<T> resolver) {
        return resolver.apply(key);
    }

    private <T> Object resolveProperty(String key, T defaultValue, FunctionWithDefault<T> resolver) {
        return defaultValue == null ? resolver.apply(key) : resolver.apply(key, defaultValue);
    }

    public DynamicAdapterConfigDataBridgeSupplierHandler(ConfigurationHolder configurationHolder) {
        this.configurationHolder = configurationHolder;
    }

    @FunctionalInterface
    private static interface FunctionWithDefault<T> {
        public Object apply(String var1);

        default public Object apply(String key, T defaultValue) {
            return this.apply(key);
        }
    }
}

