/*
 * Decompiled with CFR 0.152.
 */
package com.inrupt.commons.rdf4j.impl;

import com.inrupt.commons.rdf4j.RDF4J;
import com.inrupt.commons.rdf4j.RDF4JGraphLike;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.rdf.api.TripleLike;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;

abstract class AbstractRepositoryGraphLike<T extends TripleLike>
implements RDF4JGraphLike<T> {
    protected final Repository repository;
    protected final boolean includeInferred;
    protected final boolean handleInitAndShutdown;
    protected final RDF4J rdf4jTermFactory;
    protected final UUID salt;

    AbstractRepositoryGraphLike(Repository repository, UUID salt, boolean handleInitAndShutdown, boolean includeInferred) {
        this.repository = repository;
        this.salt = salt;
        this.includeInferred = includeInferred;
        this.handleInitAndShutdown = handleInitAndShutdown;
        if (handleInitAndShutdown && !repository.isInitialized()) {
            repository.init();
        }
        this.rdf4jTermFactory = new RDF4J(repository.getValueFactory(), salt);
    }

    @Override
    public void close() throws Exception {
        if (this.handleInitAndShutdown) {
            this.repository.shutDown();
        }
    }

    protected abstract T asTripleLike(Statement var1);

    protected RepositoryConnection getRepositoryConnection() {
        return this.repository.getConnection();
    }

    @Override
    public Optional<Repository> asRepository() {
        return Optional.of(this.repository);
    }

    @Override
    public Optional<Model> asModel() {
        return Optional.empty();
    }
}

