/*
 * Decompiled with CFR 0.152.
 */
package com.inrupt.commons.rdf4j.impl;

import com.inrupt.commons.rdf4j.ClosableIterable;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryResult;

final class ConvertedStatements<T>
implements ClosableIterable<T> {
    private final RepositoryConnection conn;
    final RepositoryResult<Statement> results;
    final Function<Statement, T> statementAdapter;

    ConvertedStatements(Supplier<RepositoryConnection> repositoryConnector, Function<Statement, T> statementAdapter, Resource subj, IRI pred, Value obj, Resource ... contexts) {
        this.statementAdapter = statementAdapter;
        this.conn = repositoryConnector.get();
        this.results = this.conn.getStatements(subj, pred, obj, contexts);
    }

    @Override
    public Iterator<T> iterator() {
        return new ConvertedIterator();
    }

    @Override
    public void close() {
        this.results.close();
        this.conn.close();
    }

    private final class ConvertedIterator
    implements Iterator<T> {
        private ConvertedIterator() {
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = ConvertedStatements.this.results.hasNext();
            if (!hasNext) {
                ConvertedStatements.this.close();
            }
            return hasNext;
        }

        @Override
        public T next() {
            return ConvertedStatements.this.statementAdapter.apply((Statement)ConvertedStatements.this.results.next());
        }
    }
}

