/*
 * Decompiled with CFR 0.152.
 */
package com.inrupt.commons.rdf4j.impl;

import com.inrupt.commons.rdf4j.ClosableIterable;
import com.inrupt.commons.rdf4j.RDF4JDataset;
import com.inrupt.commons.rdf4j.RDF4JQuad;
import com.inrupt.commons.rdf4j.impl.AbstractRepositoryGraphLike;
import com.inrupt.commons.rdf4j.impl.ConvertedStatements;
import com.inrupt.commons.rdf4j.impl.RepositoryGraphImpl;
import java.util.ConcurrentModificationException;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.TripleLike;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryResult;

class RepositoryDatasetImpl
extends AbstractRepositoryGraphLike<Quad>
implements RDF4JDataset {
    RepositoryDatasetImpl(Repository repository, UUID salt, boolean handleInitAndShutdown, boolean includeInferred) {
        super(repository, salt, handleInitAndShutdown, includeInferred);
    }

    public void add(Quad tripleLike) {
        Statement statement = this.rdf4jTermFactory.asStatement((TripleLike)tripleLike);
        try (RepositoryConnection conn = this.getRepositoryConnection();){
            conn.add(statement, new Resource[0]);
            conn.commit();
        }
    }

    public boolean contains(Quad tripleLike) {
        Statement statement = this.rdf4jTermFactory.asStatement((TripleLike)tripleLike);
        try (RepositoryConnection conn = this.getRepositoryConnection();){
            boolean bl = conn.hasStatement(statement, this.includeInferred, new Resource[0]);
            return bl;
        }
    }

    public void remove(Quad tripleLike) {
        Statement statement = this.rdf4jTermFactory.asStatement((TripleLike)tripleLike);
        try (RepositoryConnection conn = this.getRepositoryConnection();){
            conn.remove(statement, new Resource[0]);
            conn.commit();
        }
    }

    public void clear() {
        try (RepositoryConnection conn = this.getRepositoryConnection();){
            conn.clear(new Resource[0]);
            conn.commit();
        }
    }

    public long size() {
        if (this.includeInferred) {
            return this.stream().count();
        }
        try (RepositoryConnection conn = this.getRepositoryConnection();){
            long l = conn.size(new Resource[0]);
            return l;
        }
    }

    public void add(BlankNodeOrIRI graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        Resource context = (Resource)this.rdf4jTermFactory.asValue((RDFTerm)graphName);
        Resource subj = (Resource)this.rdf4jTermFactory.asValue((RDFTerm)subject);
        org.eclipse.rdf4j.model.IRI pred = (org.eclipse.rdf4j.model.IRI)this.rdf4jTermFactory.asValue((RDFTerm)predicate);
        Value obj = this.rdf4jTermFactory.asValue(object);
        try (RepositoryConnection conn = this.getRepositoryConnection();){
            conn.add(subj, pred, obj, new Resource[]{context});
            conn.commit();
        }
    }

    public boolean contains(Optional<BlankNodeOrIRI> graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        Resource subj = (Resource)this.rdf4jTermFactory.asValue((RDFTerm)subject);
        org.eclipse.rdf4j.model.IRI pred = (org.eclipse.rdf4j.model.IRI)this.rdf4jTermFactory.asValue((RDFTerm)predicate);
        Value obj = this.rdf4jTermFactory.asValue(object);
        Resource[] contexts = this.asContexts(graphName);
        try (RepositoryConnection conn = this.getRepositoryConnection();){
            boolean bl = conn.hasStatement(subj, pred, obj, this.includeInferred, contexts);
            return bl;
        }
    }

    private Resource[] asContexts(Optional<BlankNodeOrIRI> graphName) {
        Resource[] contexts;
        if (graphName == null) {
            contexts = new Resource[]{};
        } else {
            BlankNodeOrIRI g = graphName.orElse(null);
            Resource context = (Resource)this.rdf4jTermFactory.asValue((RDFTerm)g);
            contexts = new Resource[]{context};
        }
        return contexts;
    }

    public void remove(Optional<BlankNodeOrIRI> graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        Resource subj = (Resource)this.rdf4jTermFactory.asValue((RDFTerm)subject);
        org.eclipse.rdf4j.model.IRI pred = (org.eclipse.rdf4j.model.IRI)this.rdf4jTermFactory.asValue((RDFTerm)predicate);
        Value obj = this.rdf4jTermFactory.asValue(object);
        Resource[] contexts = this.asContexts(graphName);
        try (RepositoryConnection conn = this.getRepositoryConnection();){
            conn.remove(subj, pred, obj, contexts);
            conn.commit();
        }
    }

    @Override
    public Stream<RDF4JQuad> stream() {
        return this.stream(null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<RDF4JQuad> stream(Optional<BlankNodeOrIRI> graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        Resource subj = (Resource)this.rdf4jTermFactory.asValue((RDFTerm)subject);
        org.eclipse.rdf4j.model.IRI pred = (org.eclipse.rdf4j.model.IRI)this.rdf4jTermFactory.asValue((RDFTerm)predicate);
        Value obj = this.rdf4jTermFactory.asValue(object);
        Resource[] contexts = this.asContexts(graphName);
        RepositoryConnection conn = this.getRepositoryConnection();
        Stream stream = null;
        try {
            RepositoryResult statements = conn.getStatements(subj, pred, obj, this.includeInferred, contexts);
            stream = (Stream)StreamSupport.stream(statements.spliterator(), false).map(this.rdf4jTermFactory::asQuad).onClose(() -> ((RepositoryResult)statements).close());
        }
        finally {
            if (stream == null) {
                conn.close();
            }
        }
        return stream == null ? null : (Stream)stream.onClose(() -> ((RepositoryConnection)conn).close());
    }

    @Override
    public ClosableIterable<Quad> iterate() throws ConcurrentModificationException, IllegalStateException {
        return this.iterate((Optional)null, (BlankNodeOrIRI)null, (IRI)null, (RDFTerm)null);
    }

    @Override
    public ClosableIterable<Quad> iterate(Optional<BlankNodeOrIRI> graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) throws ConcurrentModificationException, IllegalStateException {
        Resource[] contexts = this.asContexts(graphName);
        Resource subj = (Resource)this.rdf4jTermFactory.asValue((RDFTerm)subject);
        org.eclipse.rdf4j.model.IRI pred = (org.eclipse.rdf4j.model.IRI)this.rdf4jTermFactory.asValue((RDFTerm)predicate);
        Value obj = this.rdf4jTermFactory.asValue(object);
        return new ConvertedStatements<Quad>(this::getRepositoryConnection, this.rdf4jTermFactory::asQuad, subj, pred, obj, contexts);
    }

    @Override
    protected RDF4JQuad asTripleLike(Statement s) {
        return this.rdf4jTermFactory.asQuad(s);
    }

    public Graph getGraph() {
        return new RepositoryGraphImpl(this.repository, this.salt, false, this.includeInferred, new Resource[]{null});
    }

    public Optional<Graph> getGraph(BlankNodeOrIRI graphName) {
        Resource context = (Resource)this.rdf4jTermFactory.asValue((RDFTerm)graphName);
        return Optional.of(new RepositoryGraphImpl(this.repository, this.salt, false, this.includeInferred, context));
    }

    @Override
    public Stream<BlankNodeOrIRI> getGraphNames() {
        RepositoryConnection conn = this.getRepositoryConnection();
        RepositoryResult contexts = conn.getContextIDs();
        return (Stream)StreamSupport.stream(contexts.spliterator(), false).map(g -> this.rdf4jTermFactory.asRDFTerm((Resource)g)).onClose(() -> ((RepositoryConnection)conn).close());
    }
}

