/*
 * Decompiled with CFR 0.152.
 */
package com.inrupt.commons.rdf4j.impl;

import com.inrupt.commons.rdf4j.RDF4J;
import com.inrupt.commons.rdf4j.RDF4JTriple;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;

final class TripleImpl
implements RDF4JTriple {
    private final UUID salt;
    private final Statement statement;

    TripleImpl(Statement statement, UUID salt) {
        this.statement = statement;
        this.salt = salt;
    }

    @Override
    public Statement asStatement() {
        return this.statement;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Triple) {
            Triple triple = (Triple)obj;
            return this.getSubject().equals(triple.getSubject()) && this.getPredicate().equals((Object)triple.getPredicate()) && this.getObject().equals((Object)triple.getObject());
        }
        return false;
    }

    public RDFTerm getObject() {
        return RDF4J.asRDFTerm(this.statement.getObject(), this.salt);
    }

    public IRI getPredicate() {
        return (IRI)RDF4J.asRDFTerm((Value)this.statement.getPredicate(), null);
    }

    public BlankNodeOrIRI getSubject() {
        return (BlankNodeOrIRI)RDF4J.asRDFTerm((Value)this.statement.getSubject(), this.salt);
    }

    public int hashCode() {
        return Objects.hash(this.getSubject(), this.getPredicate(), this.getObject());
    }

    public String toString() {
        return this.statement.toString();
    }
}

