/*
 * Decompiled with CFR 0.152.
 */
package com.inrupt.rdf.wrapping.commons;

import com.inrupt.rdf.wrapping.commons.TermMapping;
import com.inrupt.rdf.wrapping.commons.ValueMapping;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;

public class ObjectSet<T>
extends AbstractSet<T> {
    private static final BinaryOperator<Boolean> EITHER = (a, b) -> a != false || b != false;
    private static final BinaryOperator<Boolean> BOTH = (a, b) -> a != false && b != false;
    protected final BlankNodeOrIRI subject;
    protected final IRI predicate;
    protected final Graph graph;
    protected final TermMapping<T> termMapping;
    protected final ValueMapping<T> valueMapping;

    public ObjectSet(BlankNodeOrIRI subject, IRI predicate, Graph graph, TermMapping<T> termMapping, ValueMapping<T> valueMapping) {
        Objects.requireNonNull(subject, "Subject is required");
        Objects.requireNonNull(predicate, "Predicate is required");
        Objects.requireNonNull(graph, "Graph is required");
        Objects.requireNonNull(termMapping, "Term mapping is required");
        Objects.requireNonNull(valueMapping, "Value mapping is required");
        this.subject = subject;
        this.predicate = predicate;
        this.graph = graph;
        this.termMapping = termMapping;
        this.valueMapping = valueMapping;
    }

    @Override
    public int size() {
        long size = this.statements().count();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    @Override
    public boolean isEmpty() {
        return !this.graph.contains(this.subject, this.predicate, null);
    }

    @Override
    public boolean contains(Object o) {
        Objects.requireNonNull(o);
        RDFTerm object = this.termMapping.apply(o, this.graph);
        return this.graph.contains(this.subject, this.predicate, object);
    }

    @Override
    public Iterator<T> iterator() {
        return this.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.values().toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return new ArrayList(this).toArray(a);
    }

    @Override
    public boolean add(T e) {
        Objects.requireNonNull(e);
        if (this.contains(e)) {
            return false;
        }
        this.graph.add(this.subject, this.predicate, this.termMapping.apply(e, this.graph));
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Objects.requireNonNull(o);
        if (!this.contains(o)) {
            return false;
        }
        RDFTerm object = this.termMapping.apply(o, this.graph);
        this.graph.remove(this.subject, this.predicate, object);
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return c.stream().map(this::contains).reduce(true, BOTH);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        Objects.requireNonNull(c);
        return c.stream().map(this::add).reduce(false, EITHER);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.values().collect(Collectors.toList()).stream().map(value -> this.removeUnlessContains(c, value)).reduce(false, EITHER);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return c.stream().map(this::remove).reduce(false, EITHER);
    }

    @Override
    public void clear() {
        this.graph.remove(this.subject, this.predicate, null);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private Stream<? extends Triple> statements() {
        return this.graph.stream(this.subject, this.predicate, null);
    }

    private Stream<RDFTerm> objects() {
        return this.statements().map(Triple::getObject);
    }

    private Stream<T> values() {
        return this.objects().map(node -> this.valueMapping.apply((RDFTerm)node, this.graph));
    }

    private boolean removeUnlessContains(Collection<?> c, T value) {
        if (c.contains(value)) {
            return false;
        }
        return this.remove(value);
    }
}

